/****************************************************************************
**
** Copyright (C) 2016 The Qt Company Ltd.
** Contact: https://www.qt.io/licensing/
**
** This file is part of Qt Creator.
**
** Commercial License Usage
** Licensees holding valid commercial Qt licenses may use this file in
** accordance with the commercial license agreement provided with the
** Software or, alternatively, in accordance with the terms contained in
** a written agreement between you and The Qt Company. For licensing terms
** and conditions see https://www.qt.io/terms-conditions. For further
** information use the contact form at https://www.qt.io/contact-us.
**
** GNU General Public License Usage
** Alternatively, this file may be used under the terms of the GNU
** General Public License version 3 as published by the Free Software
** Foundation with exceptions as appearing in the file LICENSE.GPL3-EXCEPT
** included in the packaging of this file. Please review the following
** information to ensure the GNU General Public License requirements will
** be met: https://www.gnu.org/licenses/gpl-3.0.html.
**
****************************************************************************/

#pragma once

#include "icon.h"
#include "utils_global.h"

namespace Utils {
namespace Icons {

QTCREATOR_UTILS_EXPORT extern const Icon HOME;
QTCREATOR_UTILS_EXPORT extern const Icon HOME_TOOLBAR;
QTCREATOR_UTILS_EXPORT extern const Icon EDIT_CLEAR;
QTCREATOR_UTILS_EXPORT extern const Icon EDIT_CLEAR_TOOLBAR;
QTCREATOR_UTILS_EXPORT extern const Icon LOCKED_TOOLBAR;
QTCREATOR_UTILS_EXPORT extern const Icon LOCKED;
QTCREATOR_UTILS_EXPORT extern const Icon UNLOCKED_TOOLBAR;
QTCREATOR_UTILS_EXPORT extern const Icon NEXT;
QTCREATOR_UTILS_EXPORT extern const Icon NEXT_TOOLBAR;
QTCREATOR_UTILS_EXPORT extern const Icon PREV;
QTCREATOR_UTILS_EXPORT extern const Icon PREV_TOOLBAR;
QTCREATOR_UTILS_EXPORT extern const Icon PROJECT;
QTCREATOR_UTILS_EXPORT extern const Icon ZOOM;
QTCREATOR_UTILS_EXPORT extern const Icon ZOOM_TOOLBAR;
QTCREATOR_UTILS_EXPORT extern const Icon ZOOMIN_TOOLBAR;
QTCREATOR_UTILS_EXPORT extern const Icon ZOOMOUT_TOOLBAR;
QTCREATOR_UTILS_EXPORT extern const Icon FITTOVIEW_TOOLBAR;
QTCREATOR_UTILS_EXPORT extern const Icon OK;
QTCREATOR_UTILS_EXPORT extern const Icon NOTLOADED;
QTCREATOR_UTILS_EXPORT extern const Icon BROKEN;
QTCREATOR_UTILS_EXPORT extern const Icon BOOKMARK;
QTCREATOR_UTILS_EXPORT extern const Icon BOOKMARK_TOOLBAR;
QTCREATOR_UTILS_EXPORT extern const Icon BOOKMARK_TEXTEDITOR;
QTCREATOR_UTILS_EXPORT extern const Icon SNAPSHOT_TOOLBAR;
QTCREATOR_UTILS_EXPORT extern const Icon NEWSEARCH_TOOLBAR;

QTCREATOR_UTILS_EXPORT extern const Icon NEWFILE;
QTCREATOR_UTILS_EXPORT extern const Icon OPENFILE;
QTCREATOR_UTILS_EXPORT extern const Icon OPENFILE_TOOLBAR;
QTCREATOR_UTILS_EXPORT extern const Icon SAVEFILE;
QTCREATOR_UTILS_EXPORT extern const Icon SAVEFILE_TOOLBAR;

QTCREATOR_UTILS_EXPORT extern const Icon EXPORTFILE_TOOLBAR;
QTCREATOR_UTILS_EXPORT extern const Icon MULTIEXPORTFILE_TOOLBAR;

QTCREATOR_UTILS_EXPORT extern const Icon UNDO;
QTCREATOR_UTILS_EXPORT extern const Icon UNDO_TOOLBAR;
QTCREATOR_UTILS_EXPORT extern const Icon REDO;
QTCREATOR_UTILS_EXPORT extern const Icon REDO_TOOLBAR;
QTCREATOR_UTILS_EXPORT extern const Icon COPY;
QTCREATOR_UTILS_EXPORT extern const Icon COPY_TOOLBAR;
QTCREATOR_UTILS_EXPORT extern const Icon PASTE;
QTCREATOR_UTILS_EXPORT extern const Icon PASTE_TOOLBAR;
QTCREATOR_UTILS_EXPORT extern const Icon CUT;
QTCREATOR_UTILS_EXPORT extern const Icon CUT_TOOLBAR;
QTCREATOR_UTILS_EXPORT extern const Icon RESET;
QTCREATOR_UTILS_EXPORT extern const Icon RESET_TOOLBAR;

QTCREATOR_UTILS_EXPORT extern const Icon ARROW_UP;
QTCREATOR_UTILS_EXPORT extern const Icon ARROW_DOWN;
QTCREATOR_UTILS_EXPORT extern const Icon MINUS;
QTCREATOR_UTILS_EXPORT extern const Icon PLUS_TOOLBAR;
QTCREATOR_UTILS_EXPORT extern const Icon PLUS;
QTCREATOR_UTILS_EXPORT extern const Icon MAGNIFIER;
QTCREATOR_UTILS_EXPORT extern const Icon CLEAN;
QTCREATOR_UTILS_EXPORT extern const Icon CLEAN_TOOLBAR;
QTCREATOR_UTILS_EXPORT extern const Icon RELOAD;
QTCREATOR_UTILS_EXPORT extern const Icon TOGGLE_LEFT_SIDEBAR;
QTCREATOR_UTILS_EXPORT extern const Icon TOGGLE_LEFT_SIDEBAR_TOOLBAR;
QTCREATOR_UTILS_EXPORT extern const Icon TOGGLE_RIGHT_SIDEBAR;
QTCREATOR_UTILS_EXPORT extern const Icon TOGGLE_RIGHT_SIDEBAR_TOOLBAR;
QTCREATOR_UTILS_EXPORT extern const Icon CLOSE_TOOLBAR;
QTCREATOR_UTILS_EXPORT extern const Icon CLOSE_FOREGROUND;
QTCREATOR_UTILS_EXPORT extern const Icon CLOSE_BACKGROUND;
QTCREATOR_UTILS_EXPORT extern const Icon SPLIT_HORIZONTAL;
QTCREATOR_UTILS_EXPORT extern const Icon SPLIT_HORIZONTAL_TOOLBAR;
QTCREATOR_UTILS_EXPORT extern const Icon SPLIT_VERTICAL;
QTCREATOR_UTILS_EXPORT extern const Icon SPLIT_VERTICAL_TOOLBAR;
QTCREATOR_UTILS_EXPORT extern const Icon CLOSE_SPLIT_TOP;
QTCREATOR_UTILS_EXPORT extern const Icon CLOSE_SPLIT_BOTTOM;
QTCREATOR_UTILS_EXPORT extern const Icon CLOSE_SPLIT_LEFT;
QTCREATOR_UTILS_EXPORT extern const Icon CLOSE_SPLIT_RIGHT;
QTCREATOR_UTILS_EXPORT extern const Icon FILTER;
QTCREATOR_UTILS_EXPORT extern const Icon LINK;
QTCREATOR_UTILS_EXPORT extern const Icon LINK_TOOLBAR;

QTCREATOR_UTILS_EXPORT extern const Icon INFO;
QTCREATOR_UTILS_EXPORT extern const Icon INFO_TOOLBAR;
QTCREATOR_UTILS_EXPORT extern const Icon WARNING;
QTCREATOR_UTILS_EXPORT extern const Icon WARNING_TOOLBAR;
QTCREATOR_UTILS_EXPORT extern const Icon CRITICAL;
QTCREATOR_UTILS_EXPORT extern const Icon CRITICAL_TOOLBAR;

QTCREATOR_UTILS_EXPORT extern const Icon ERROR_TASKBAR;
QTCREATOR_UTILS_EXPORT extern const Icon EXPAND_ALL_TOOLBAR;
QTCREATOR_UTILS_EXPORT extern const Icon TOOLBAR_EXTENSION;
QTCREATOR_UTILS_EXPORT extern const Icon RUN_SMALL;
QTCREATOR_UTILS_EXPORT extern const Icon RUN_SMALL_TOOLBAR;
QTCREATOR_UTILS_EXPORT extern const Icon STOP_SMALL;
QTCREATOR_UTILS_EXPORT extern const Icon STOP_SMALL_TOOLBAR;
QTCREATOR_UTILS_EXPORT extern const Icon INTERRUPT_SMALL;
QTCREATOR_UTILS_EXPORT extern const Icon INTERRUPT_SMALL_TOOLBAR;
QTCREATOR_UTILS_EXPORT extern const Icon BOUNDING_RECT;
QTCREATOR_UTILS_EXPORT extern const Icon EYE_OPEN_TOOLBAR;
QTCREATOR_UTILS_EXPORT extern const Icon EYE_CLOSED_TOOLBAR;
QTCREATOR_UTILS_EXPORT extern const Icon REPLACE;
QTCREATOR_UTILS_EXPORT extern const Icon EXPAND;
QTCREATOR_UTILS_EXPORT extern const Icon EXPAND_TOOLBAR;
QTCREATOR_UTILS_EXPORT extern const Icon COLLAPSE;
QTCREATOR_UTILS_EXPORT extern const Icon COLLAPSE_TOOLBAR;
QTCREATOR_UTILS_EXPORT extern const Icon PAN_TOOLBAR;
QTCREATOR_UTILS_EXPORT extern const Icon EMPTY14;
QTCREATOR_UTILS_EXPORT extern const Icon EMPTY16;
QTCREATOR_UTILS_EXPORT extern const Icon OVERLAY_ADD;
QTCREATOR_UTILS_EXPORT extern const Icon OVERLAY_WARNING;
QTCREATOR_UTILS_EXPORT extern const Icon OVERLAY_ERROR;

QTCREATOR_UTILS_EXPORT extern const Icon CODEMODEL_ERROR;
QTCREATOR_UTILS_EXPORT extern const Icon CODEMODEL_WARNING;
QTCREATOR_UTILS_EXPORT extern const Icon CODEMODEL_DISABLED_ERROR;
QTCREATOR_UTILS_EXPORT extern const Icon CODEMODEL_DISABLED_WARNING;
QTCREATOR_UTILS_EXPORT extern const Icon CODEMODEL_FIXIT;

} // namespace Icons

namespace CodeModelIcon {

enum Type {
    Class = 0,
    Struct,
    Enum,
    Enumerator,
    FuncPublic,
    FuncProtected,
    FuncPrivate,
    FuncPublicStatic,
    FuncProtectedStatic,
    FuncPrivateStatic,
    Namespace,
    VarPublic,
    VarProtected,
    VarPrivate,
    VarPublicStatic,
    VarProtectedStatic,
    VarPrivateStatic,
    Signal,
    SlotPublic,
    SlotProtected,
    SlotPrivate,
    Keyword,
    Macro,
    Property,
    Unknown
};

QTCREATOR_UTILS_EXPORT QIcon iconForType(Type type);

} // namespace CodeModel
} // namespace Utils
