% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/auxil.R
\name{adegenetWeb}
\alias{adegenetWeb}
\alias{adegenetTutorial}
\alias{adegenetIssues}
\title{Functions to access online resources for adegenet}
\usage{
adegenetWeb()

adegenetTutorial(which = c("basics", "spca", "dapc", "genomics", "strata",
  "snapclust"))

adegenetIssues()
}
\arguments{
\item{which}{a character string indicating which tutorial to open (see details)}
}
\description{
These functions simply open websites or documents
available online providing resources for adegenet.
}
\details{
\itemize{
\item adegenetWeb opens adegenet's website
\item adegenetTutorial opens adegenet tutorials
\item adegenetIssues opens the issue page on github;
this is used to report a bug or post a feature request.
}



Available tutorials are:
\itemize{
\item 'basics': general introduction to adegenet; covers basic data structures, import/export, handling, and a number of population genetics methods
\item 'spca': spatial genetic structures using the spatial Principal Component Analysis
\item 'dapc': population structure using the Discriminant Analysis of Principal Components
\item 'genomics': handling large genome-wide SNP data using adegenet
\item 'strata': introduction to hierarchical population structure in adegenet
\item 'snapclust': introduction to fast maximum-likelihood genetic clustering using snapclust
}
}
