// Range v3 library
//
//  Copyright Eric Niebler 2014-present
//
//  Use, modification and distribution is subject to the
//  Boost Software License, Version 1.0. (See accompanying
//  file LICENSE_1_0.txt or copy at
//  http://www.boost.org/LICENSE_1_0.txt)
//
// Project home: https://github.com/ericniebler/range-v3
//
//  Copyright 2005 - 2007 Adobe Systems Incorporated
//  Distributed under the MIT License(see accompanying file LICENSE_1_0_0.txt
//  or a copy at http://stlab.adobe.com/licenses.html)

//===----------------------------------------------------------------------===//
//
//                     The LLVM Compiler Infrastructure
//
// This file is dual licensed under the MIT and the University of Illinois Open
// Source Licenses. See LICENSE.TXT for details.
//
//===----------------------------------------------------------------------===//

// Implementation based on the code in libc++
//   http://http://libcxx.llvm.org/

#include <range/v3/core.hpp>
#include <range/v3/algorithm/heap_algorithm.hpp>
#include "../simple_test.hpp"
#include "../test_utils.hpp"
#include "../test_iterators.hpp"

void test()
{
#ifdef IS_HEAP_UNTIL_1
    auto is_heap_until = make_testable_1(ranges::is_heap_until);
    int i1[] = {0, 0};
    is_heap_until(i1, i1).check([&](int*r){CHECK(r == i1);});

    is_heap_until(i1, i1).check([&](int *r){ CHECK(r == i1); });
    is_heap_until(i1, i1+1).check([&](int *r){ CHECK(r == i1+1); });
    int i2[] = {0, 1};
    int i3[] = {1, 0};
    is_heap_until(i1, i1+2).check([&](int *r){ CHECK(r == i1+2); });
    is_heap_until(i2, i2+2).check([&](int *r){ CHECK(r == i2+1); });
    is_heap_until(i3, i3+2).check([&](int *r){ CHECK(r == i3+2); });
    int i4[] = {0, 0, 0};
    int i5[] = {0, 0, 1};
    int i6[] = {0, 1, 0};
    int i7[] = {0, 1, 1};
    int i8[] = {1, 0, 0};
    int i9[] = {1, 0, 1};
    int i10[] = {1, 1, 0};
    is_heap_until(i4, i4+3).check([&](int *r){ CHECK(r == i4+3); });
    is_heap_until(i5, i5+3).check([&](int *r){ CHECK(r == i5+2); });
    is_heap_until(i6, i6+3).check([&](int *r){ CHECK(r == i6+1); });
    is_heap_until(i7, i7+3).check([&](int *r){ CHECK(r == i7+1); });
    is_heap_until(i8, i8+3).check([&](int *r){ CHECK(r == i8+3); });
    is_heap_until(i9, i9+3).check([&](int *r){ CHECK(r == i9+3); });
    is_heap_until(i10, i10+3).check([&](int *r){ CHECK(r == i10+3); });
    int i11[] = {0, 0, 0, 0};
    int i12[] = {0, 0, 0, 1};
    int i13[] = {0, 0, 1, 0};
    int i14[] = {0, 0, 1, 1};
    int i15[] = {0, 1, 0, 0};
    int i16[] = {0, 1, 0, 1};
    int i17[] = {0, 1, 1, 0};
    int i18[] = {0, 1, 1, 1};
    int i19[] = {1, 0, 0, 0};
    int i20[] = {1, 0, 0, 1};
    int i21[] = {1, 0, 1, 0};
    int i22[] = {1, 0, 1, 1};
    int i23[] = {1, 1, 0, 0};
    int i24[] = {1, 1, 0, 1};
    int i25[] = {1, 1, 1, 0};
    is_heap_until(i11, i11+4).check([&](int *r){ CHECK(r == i11+4); });
    is_heap_until(i12, i12+4).check([&](int *r){ CHECK(r == i12+3); });
    is_heap_until(i13, i13+4).check([&](int *r){ CHECK(r == i13+2); });
    is_heap_until(i14, i14+4).check([&](int *r){ CHECK(r == i14+2); });
    is_heap_until(i15, i15+4).check([&](int *r){ CHECK(r == i15+1); });
    is_heap_until(i16, i16+4).check([&](int *r){ CHECK(r == i16+1); });
    is_heap_until(i17, i17+4).check([&](int *r){ CHECK(r == i17+1); });
    is_heap_until(i18, i18+4).check([&](int *r){ CHECK(r == i18+1); });
    is_heap_until(i19, i19+4).check([&](int *r){ CHECK(r == i19+4); });
    is_heap_until(i20, i20+4).check([&](int *r){ CHECK(r == i20+3); });
    is_heap_until(i21, i21+4).check([&](int *r){ CHECK(r == i21+4); });
    is_heap_until(i22, i22+4).check([&](int *r){ CHECK(r == i22+3); });
    is_heap_until(i23, i23+4).check([&](int *r){ CHECK(r == i23+4); });
    is_heap_until(i24, i24+4).check([&](int *r){ CHECK(r == i24+4); });
    is_heap_until(i25, i25+4).check([&](int *r){ CHECK(r == i25+4); });
    int i26[] = {0, 0, 0, 0, 0};
    int i27[] = {0, 0, 0, 0, 1};
    int i28[] = {0, 0, 0, 1, 0};
    int i29[] = {0, 0, 0, 1, 1};
    int i30[] = {0, 0, 1, 0, 0};
    int i31[] = {0, 0, 1, 0, 1};
    int i32[] = {0, 0, 1, 1, 0};
    int i33[] = {0, 0, 1, 1, 1};
    int i34[] = {0, 1, 0, 0, 0};
    int i35[] = {0, 1, 0, 0, 1};
    int i36[] = {0, 1, 0, 1, 0};
    int i37[] = {0, 1, 0, 1, 1};
    int i38[] = {0, 1, 1, 0, 0};
    int i39[] = {0, 1, 1, 0, 1};
    int i40[] = {0, 1, 1, 1, 0};
    int i41[] = {0, 1, 1, 1, 1};
    int i42[] = {1, 0, 0, 0, 0};
    int i43[] = {1, 0, 0, 0, 1};
    int i44[] = {1, 0, 0, 1, 0};
    int i45[] = {1, 0, 0, 1, 1};
    int i46[] = {1, 0, 1, 0, 0};
    int i47[] = {1, 0, 1, 0, 1};
    int i48[] = {1, 0, 1, 1, 0};
    int i49[] = {1, 0, 1, 1, 1};
    int i50[] = {1, 1, 0, 0, 0};
    int i51[] = {1, 1, 0, 0, 1};
    int i52[] = {1, 1, 0, 1, 0};
    int i53[] = {1, 1, 0, 1, 1};
    int i54[] = {1, 1, 1, 0, 0};
    int i55[] = {1, 1, 1, 0, 1};
    int i56[] = {1, 1, 1, 1, 0};
    is_heap_until(i26, i26+5).check([&](int *r){ CHECK(r == i26+5); });
    is_heap_until(i27, i27+5).check([&](int *r){ CHECK(r == i27+4); });
    is_heap_until(i28, i28+5).check([&](int *r){ CHECK(r == i28+3); });
    is_heap_until(i29, i29+5).check([&](int *r){ CHECK(r == i29+3); });
    is_heap_until(i30, i30+5).check([&](int *r){ CHECK(r == i30+2); });
    is_heap_until(i31, i31+5).check([&](int *r){ CHECK(r == i31+2); });
    is_heap_until(i32, i32+5).check([&](int *r){ CHECK(r == i32+2); });
    is_heap_until(i33, i33+5).check([&](int *r){ CHECK(r == i33+2); });
    is_heap_until(i34, i34+5).check([&](int *r){ CHECK(r == i34+1); });
    is_heap_until(i35, i35+5).check([&](int *r){ CHECK(r == i35+1); });
    is_heap_until(i36, i36+5).check([&](int *r){ CHECK(r == i36+1); });
    is_heap_until(i37, i37+5).check([&](int *r){ CHECK(r == i37+1); });
    is_heap_until(i38, i38+5).check([&](int *r){ CHECK(r == i38+1); });
    is_heap_until(i39, i39+5).check([&](int *r){ CHECK(r == i39+1); });
    is_heap_until(i40, i40+5).check([&](int *r){ CHECK(r == i40+1); });
    is_heap_until(i41, i41+5).check([&](int *r){ CHECK(r == i41+1); });
    is_heap_until(i42, i42+5).check([&](int *r){ CHECK(r == i42+5); });
    is_heap_until(i43, i43+5).check([&](int *r){ CHECK(r == i43+4); });
    is_heap_until(i44, i44+5).check([&](int *r){ CHECK(r == i44+3); });
    is_heap_until(i45, i45+5).check([&](int *r){ CHECK(r == i45+3); });
    is_heap_until(i46, i46+5).check([&](int *r){ CHECK(r == i46+5); });
    is_heap_until(i47, i47+5).check([&](int *r){ CHECK(r == i47+4); });
    is_heap_until(i48, i48+5).check([&](int *r){ CHECK(r == i48+3); });
    is_heap_until(i49, i49+5).check([&](int *r){ CHECK(r == i49+3); });
    is_heap_until(i50, i50+5).check([&](int *r){ CHECK(r == i50+5); });
    is_heap_until(i51, i51+5).check([&](int *r){ CHECK(r == i51+5); });
    is_heap_until(i52, i52+5).check([&](int *r){ CHECK(r == i52+5); });
    is_heap_until(i53, i53+5).check([&](int *r){ CHECK(r == i53+5); });
    is_heap_until(i54, i54+5).check([&](int *r){ CHECK(r == i54+5); });
    is_heap_until(i55, i55+5).check([&](int *r){ CHECK(r == i55+5); });
    is_heap_until(i56, i56+5).check([&](int *r){ CHECK(r == i56+5); });
    int i57[] = {0, 0, 0, 0, 0, 0};
    int i58[] = {0, 0, 0, 0, 0, 1};
    int i59[] = {0, 0, 0, 0, 1, 0};
    int i60[] = {0, 0, 0, 0, 1, 1};
    int i61[] = {0, 0, 0, 1, 0, 0};
    int i62[] = {0, 0, 0, 1, 0, 1};
    int i63[] = {0, 0, 0, 1, 1, 0};
    int i64[] = {0, 0, 0, 1, 1, 1};
    int i65[] = {0, 0, 1, 0, 0, 0};
    int i66[] = {0, 0, 1, 0, 0, 1};
    int i67[] = {0, 0, 1, 0, 1, 0};
    int i68[] = {0, 0, 1, 0, 1, 1};
    int i69[] = {0, 0, 1, 1, 0, 0};
    int i70[] = {0, 0, 1, 1, 0, 1};
    int i71[] = {0, 0, 1, 1, 1, 0};
    int i72[] = {0, 0, 1, 1, 1, 1};
    int i73[] = {0, 1, 0, 0, 0, 0};
    int i74[] = {0, 1, 0, 0, 0, 1};
    int i75[] = {0, 1, 0, 0, 1, 0};
    int i76[] = {0, 1, 0, 0, 1, 1};
    int i77[] = {0, 1, 0, 1, 0, 0};
    int i78[] = {0, 1, 0, 1, 0, 1};
    int i79[] = {0, 1, 0, 1, 1, 0};
    int i80[] = {0, 1, 0, 1, 1, 1};
    int i81[] = {0, 1, 1, 0, 0, 0};
    int i82[] = {0, 1, 1, 0, 0, 1};
    int i83[] = {0, 1, 1, 0, 1, 0};
    int i84[] = {0, 1, 1, 0, 1, 1};
    int i85[] = {0, 1, 1, 1, 0, 0};
    int i86[] = {0, 1, 1, 1, 0, 1};
    int i87[] = {0, 1, 1, 1, 1, 0};
    int i88[] = {0, 1, 1, 1, 1, 1};
    int i89[] = {1, 0, 0, 0, 0, 0};
    int i90[] = {1, 0, 0, 0, 0, 1};
    int i91[] = {1, 0, 0, 0, 1, 0};
    int i92[] = {1, 0, 0, 0, 1, 1};
    int i93[] = {1, 0, 0, 1, 0, 0};
    int i94[] = {1, 0, 0, 1, 0, 1};
    int i95[] = {1, 0, 0, 1, 1, 0};
    int i96[] = {1, 0, 0, 1, 1, 1};
    int i97[] = {1, 0, 1, 0, 0, 0};
    int i98[] = {1, 0, 1, 0, 0, 1};
    int i99[] = {1, 0, 1, 0, 1, 0};
    int i100[] = {1, 0, 1, 0, 1, 1};
    int i101[] = {1, 0, 1, 1, 0, 0};
    int i102[] = {1, 0, 1, 1, 0, 1};
    int i103[] = {1, 0, 1, 1, 1, 0};
    int i104[] = {1, 0, 1, 1, 1, 1};
    int i105[] = {1, 1, 0, 0, 0, 0};
    int i106[] = {1, 1, 0, 0, 0, 1};
    int i107[] = {1, 1, 0, 0, 1, 0};
    int i108[] = {1, 1, 0, 0, 1, 1};
    int i109[] = {1, 1, 0, 1, 0, 0};
    int i110[] = {1, 1, 0, 1, 0, 1};
    int i111[] = {1, 1, 0, 1, 1, 0};
    int i112[] = {1, 1, 0, 1, 1, 1};
    int i113[] = {1, 1, 1, 0, 0, 0};
    int i114[] = {1, 1, 1, 0, 0, 1};
    int i115[] = {1, 1, 1, 0, 1, 0};
    int i116[] = {1, 1, 1, 0, 1, 1};
    int i117[] = {1, 1, 1, 1, 0, 0};
    int i118[] = {1, 1, 1, 1, 0, 1};
    int i119[] = {1, 1, 1, 1, 1, 0};
    is_heap_until(i57, i57+6).check([&](int *r){ CHECK(r == i57+6); });
    is_heap_until(i58, i58+6).check([&](int *r){ CHECK(r == i58+5); });
    is_heap_until(i59, i59+6).check([&](int *r){ CHECK(r == i59+4); });
    is_heap_until(i60, i60+6).check([&](int *r){ CHECK(r == i60+4); });
    is_heap_until(i61, i61+6).check([&](int *r){ CHECK(r == i61+3); });
    is_heap_until(i62, i62+6).check([&](int *r){ CHECK(r == i62+3); });
    is_heap_until(i63, i63+6).check([&](int *r){ CHECK(r == i63+3); });
    is_heap_until(i64, i64+6).check([&](int *r){ CHECK(r == i64+3); });
    is_heap_until(i65, i65+6).check([&](int *r){ CHECK(r == i65+2); });
    is_heap_until(i66, i66+6).check([&](int *r){ CHECK(r == i66+2); });
    is_heap_until(i67, i67+6).check([&](int *r){ CHECK(r == i67+2); });
    is_heap_until(i68, i68+6).check([&](int *r){ CHECK(r == i68+2); });
    is_heap_until(i69, i69+6).check([&](int *r){ CHECK(r == i69+2); });
    is_heap_until(i70, i70+6).check([&](int *r){ CHECK(r == i70+2); });
    is_heap_until(i71, i71+6).check([&](int *r){ CHECK(r == i71+2); });
    is_heap_until(i72, i72+6).check([&](int *r){ CHECK(r == i72+2); });
    is_heap_until(i73, i73+6).check([&](int *r){ CHECK(r == i73+1); });
    is_heap_until(i74, i74+6).check([&](int *r){ CHECK(r == i74+1); });
    is_heap_until(i75, i75+6).check([&](int *r){ CHECK(r == i75+1); });
    is_heap_until(i76, i76+6).check([&](int *r){ CHECK(r == i76+1); });
    is_heap_until(i77, i77+6).check([&](int *r){ CHECK(r == i77+1); });
    is_heap_until(i78, i78+6).check([&](int *r){ CHECK(r == i78+1); });
    is_heap_until(i79, i79+6).check([&](int *r){ CHECK(r == i79+1); });
    is_heap_until(i80, i80+6).check([&](int *r){ CHECK(r == i80+1); });
    is_heap_until(i81, i81+6).check([&](int *r){ CHECK(r == i81+1); });
    is_heap_until(i82, i82+6).check([&](int *r){ CHECK(r == i82+1); });
    is_heap_until(i83, i83+6).check([&](int *r){ CHECK(r == i83+1); });
    is_heap_until(i84, i84+6).check([&](int *r){ CHECK(r == i84+1); });
    is_heap_until(i85, i85+6).check([&](int *r){ CHECK(r == i85+1); });
    is_heap_until(i86, i86+6).check([&](int *r){ CHECK(r == i86+1); });
    is_heap_until(i87, i87+6).check([&](int *r){ CHECK(r == i87+1); });
    is_heap_until(i88, i88+6).check([&](int *r){ CHECK(r == i88+1); });
    is_heap_until(i89, i89+6).check([&](int *r){ CHECK(r == i89+6); });
    is_heap_until(i90, i90+6).check([&](int *r){ CHECK(r == i90+5); });
    is_heap_until(i91, i91+6).check([&](int *r){ CHECK(r == i91+4); });
    is_heap_until(i92, i92+6).check([&](int *r){ CHECK(r == i92+4); });
    is_heap_until(i93, i93+6).check([&](int *r){ CHECK(r == i93+3); });
    is_heap_until(i94, i94+6).check([&](int *r){ CHECK(r == i94+3); });
    is_heap_until(i95, i95+6).check([&](int *r){ CHECK(r == i95+3); });
    is_heap_until(i96, i96+6).check([&](int *r){ CHECK(r == i96+3); });
    is_heap_until(i97, i97+6).check([&](int *r){ CHECK(r == i97+6); });
    is_heap_until(i98, i98+6).check([&](int *r){ CHECK(r == i98+6); });
    is_heap_until(i99, i99+6).check([&](int *r){ CHECK(r == i99+4); });
    is_heap_until(i100, i100+6).check([&](int *r){ CHECK(r == i100+4); });
    is_heap_until(i101, i101+6).check([&](int *r){ CHECK(r == i101+3); });
    is_heap_until(i102, i102+6).check([&](int *r){ CHECK(r == i102+3); });
    is_heap_until(i103, i103+6).check([&](int *r){ CHECK(r == i103+3); });
    is_heap_until(i104, i104+6).check([&](int *r){ CHECK(r == i104+3); });
    is_heap_until(i105, i105+6).check([&](int *r){ CHECK(r == i105+6); });
    is_heap_until(i106, i106+6).check([&](int *r){ CHECK(r == i106+5); });
    is_heap_until(i107, i107+6).check([&](int *r){ CHECK(r == i107+6); });
    is_heap_until(i108, i108+6).check([&](int *r){ CHECK(r == i108+5); });
    is_heap_until(i109, i109+6).check([&](int *r){ CHECK(r == i109+6); });
    is_heap_until(i110, i110+6).check([&](int *r){ CHECK(r == i110+5); });
    is_heap_until(i111, i111+6).check([&](int *r){ CHECK(r == i111+6); });
    is_heap_until(i112, i112+6).check([&](int *r){ CHECK(r == i112+5); });
    is_heap_until(i113, i113+6).check([&](int *r){ CHECK(r == i113+6); });
    is_heap_until(i114, i114+6).check([&](int *r){ CHECK(r == i114+6); });
    is_heap_until(i115, i115+6).check([&](int *r){ CHECK(r == i115+6); });
    is_heap_until(i116, i116+6).check([&](int *r){ CHECK(r == i116+6); });
    is_heap_until(i117, i117+6).check([&](int *r){ CHECK(r == i117+6); });
    is_heap_until(i118, i118+6).check([&](int *r){ CHECK(r == i118+6); });
    is_heap_until(i119, i119+6).check([&](int *r){ CHECK(r == i119+6); });
#endif
#ifdef IS_HEAP_UNTIL_2
    auto is_heap_until = make_testable_1(ranges::is_heap_until);
    int i120[] = {0, 0, 0, 0, 0, 0, 0};
    int i121[] = {0, 0, 0, 0, 0, 0, 1};
    int i122[] = {0, 0, 0, 0, 0, 1, 0};
    int i123[] = {0, 0, 0, 0, 0, 1, 1};
    int i124[] = {0, 0, 0, 0, 1, 0, 0};
    int i125[] = {0, 0, 0, 0, 1, 0, 1};
    int i126[] = {0, 0, 0, 0, 1, 1, 0};
    int i127[] = {0, 0, 0, 0, 1, 1, 1};
    int i128[] = {0, 0, 0, 1, 0, 0, 0};
    int i129[] = {0, 0, 0, 1, 0, 0, 1};
    int i130[] = {0, 0, 0, 1, 0, 1, 0};
    int i131[] = {0, 0, 0, 1, 0, 1, 1};
    int i132[] = {0, 0, 0, 1, 1, 0, 0};
    int i133[] = {0, 0, 0, 1, 1, 0, 1};
    int i134[] = {0, 0, 0, 1, 1, 1, 0};
    int i135[] = {0, 0, 0, 1, 1, 1, 1};
    int i136[] = {0, 0, 1, 0, 0, 0, 0};
    int i137[] = {0, 0, 1, 0, 0, 0, 1};
    int i138[] = {0, 0, 1, 0, 0, 1, 0};
    int i139[] = {0, 0, 1, 0, 0, 1, 1};
    int i140[] = {0, 0, 1, 0, 1, 0, 0};
    int i141[] = {0, 0, 1, 0, 1, 0, 1};
    int i142[] = {0, 0, 1, 0, 1, 1, 0};
    int i143[] = {0, 0, 1, 0, 1, 1, 1};
    int i144[] = {0, 0, 1, 1, 0, 0, 0};
    int i145[] = {0, 0, 1, 1, 0, 0, 1};
    int i146[] = {0, 0, 1, 1, 0, 1, 0};
    int i147[] = {0, 0, 1, 1, 0, 1, 1};
    int i148[] = {0, 0, 1, 1, 1, 0, 0};
    int i149[] = {0, 0, 1, 1, 1, 0, 1};
    int i150[] = {0, 0, 1, 1, 1, 1, 0};
    int i151[] = {0, 0, 1, 1, 1, 1, 1};
    int i152[] = {0, 1, 0, 0, 0, 0, 0};
    int i153[] = {0, 1, 0, 0, 0, 0, 1};
    int i154[] = {0, 1, 0, 0, 0, 1, 0};
    int i155[] = {0, 1, 0, 0, 0, 1, 1};
    int i156[] = {0, 1, 0, 0, 1, 0, 0};
    int i157[] = {0, 1, 0, 0, 1, 0, 1};
    int i158[] = {0, 1, 0, 0, 1, 1, 0};
    int i159[] = {0, 1, 0, 0, 1, 1, 1};
    int i160[] = {0, 1, 0, 1, 0, 0, 0};
    int i161[] = {0, 1, 0, 1, 0, 0, 1};
    int i162[] = {0, 1, 0, 1, 0, 1, 0};
    int i163[] = {0, 1, 0, 1, 0, 1, 1};
    int i164[] = {0, 1, 0, 1, 1, 0, 0};
    int i165[] = {0, 1, 0, 1, 1, 0, 1};
    int i166[] = {0, 1, 0, 1, 1, 1, 0};
    int i167[] = {0, 1, 0, 1, 1, 1, 1};
    int i168[] = {0, 1, 1, 0, 0, 0, 0};
    int i169[] = {0, 1, 1, 0, 0, 0, 1};
    int i170[] = {0, 1, 1, 0, 0, 1, 0};
    int i171[] = {0, 1, 1, 0, 0, 1, 1};
    int i172[] = {0, 1, 1, 0, 1, 0, 0};
    int i173[] = {0, 1, 1, 0, 1, 0, 1};
    int i174[] = {0, 1, 1, 0, 1, 1, 0};
    int i175[] = {0, 1, 1, 0, 1, 1, 1};
    int i176[] = {0, 1, 1, 1, 0, 0, 0};
    int i177[] = {0, 1, 1, 1, 0, 0, 1};
    int i178[] = {0, 1, 1, 1, 0, 1, 0};
    int i179[] = {0, 1, 1, 1, 0, 1, 1};
    int i180[] = {0, 1, 1, 1, 1, 0, 0};
    int i181[] = {0, 1, 1, 1, 1, 0, 1};
    int i182[] = {0, 1, 1, 1, 1, 1, 0};
    int i183[] = {0, 1, 1, 1, 1, 1, 1};
    int i184[] = {1, 0, 0, 0, 0, 0, 0};
    int i185[] = {1, 0, 0, 0, 0, 0, 1};
    int i186[] = {1, 0, 0, 0, 0, 1, 0};
    int i187[] = {1, 0, 0, 0, 0, 1, 1};
    int i188[] = {1, 0, 0, 0, 1, 0, 0};
    int i189[] = {1, 0, 0, 0, 1, 0, 1};
    int i190[] = {1, 0, 0, 0, 1, 1, 0};
    int i191[] = {1, 0, 0, 0, 1, 1, 1};
    int i192[] = {1, 0, 0, 1, 0, 0, 0};
    int i193[] = {1, 0, 0, 1, 0, 0, 1};
    int i194[] = {1, 0, 0, 1, 0, 1, 0};
    int i195[] = {1, 0, 0, 1, 0, 1, 1};
    int i196[] = {1, 0, 0, 1, 1, 0, 0};
    int i197[] = {1, 0, 0, 1, 1, 0, 1};
    int i198[] = {1, 0, 0, 1, 1, 1, 0};
    int i199[] = {1, 0, 0, 1, 1, 1, 1};
    int i200[] = {1, 0, 1, 0, 0, 0, 0};
    int i201[] = {1, 0, 1, 0, 0, 0, 1};
    int i202[] = {1, 0, 1, 0, 0, 1, 0};
    int i203[] = {1, 0, 1, 0, 0, 1, 1};
    int i204[] = {1, 0, 1, 0, 1, 0, 0};
    int i205[] = {1, 0, 1, 0, 1, 0, 1};
    int i206[] = {1, 0, 1, 0, 1, 1, 0};
    int i207[] = {1, 0, 1, 0, 1, 1, 1};
    int i208[] = {1, 0, 1, 1, 0, 0, 0};
    int i209[] = {1, 0, 1, 1, 0, 0, 1};
    int i210[] = {1, 0, 1, 1, 0, 1, 0};
    int i211[] = {1, 0, 1, 1, 0, 1, 1};
    int i212[] = {1, 0, 1, 1, 1, 0, 0};
    int i213[] = {1, 0, 1, 1, 1, 0, 1};
    int i214[] = {1, 0, 1, 1, 1, 1, 0};
    int i215[] = {1, 0, 1, 1, 1, 1, 1};
    int i216[] = {1, 1, 0, 0, 0, 0, 0};
    int i217[] = {1, 1, 0, 0, 0, 0, 1};
    int i218[] = {1, 1, 0, 0, 0, 1, 0};
    int i219[] = {1, 1, 0, 0, 0, 1, 1};
    int i220[] = {1, 1, 0, 0, 1, 0, 0};
    int i221[] = {1, 1, 0, 0, 1, 0, 1};
    int i222[] = {1, 1, 0, 0, 1, 1, 0};
    int i223[] = {1, 1, 0, 0, 1, 1, 1};
    int i224[] = {1, 1, 0, 1, 0, 0, 0};
    int i225[] = {1, 1, 0, 1, 0, 0, 1};
    int i226[] = {1, 1, 0, 1, 0, 1, 0};
    int i227[] = {1, 1, 0, 1, 0, 1, 1};
    int i228[] = {1, 1, 0, 1, 1, 0, 0};
    int i229[] = {1, 1, 0, 1, 1, 0, 1};
    int i230[] = {1, 1, 0, 1, 1, 1, 0};
    int i231[] = {1, 1, 0, 1, 1, 1, 1};
    int i232[] = {1, 1, 1, 0, 0, 0, 0};
    int i233[] = {1, 1, 1, 0, 0, 0, 1};
    int i234[] = {1, 1, 1, 0, 0, 1, 0};
    int i235[] = {1, 1, 1, 0, 0, 1, 1};
    int i236[] = {1, 1, 1, 0, 1, 0, 0};
    int i237[] = {1, 1, 1, 0, 1, 0, 1};
    int i238[] = {1, 1, 1, 0, 1, 1, 0};
    int i239[] = {1, 1, 1, 0, 1, 1, 1};
    int i240[] = {1, 1, 1, 1, 0, 0, 0};
    int i241[] = {1, 1, 1, 1, 0, 0, 1};
    int i242[] = {1, 1, 1, 1, 0, 1, 0};
    int i243[] = {1, 1, 1, 1, 0, 1, 1};
    int i244[] = {1, 1, 1, 1, 1, 0, 0};
    int i245[] = {1, 1, 1, 1, 1, 0, 1};
    int i246[] = {1, 1, 1, 1, 1, 1, 0};
    is_heap_until(i120, i120+7).check([&](int *r){ CHECK(r == i120+7); });
    is_heap_until(i121, i121+7).check([&](int *r){ CHECK(r == i121+6); });
    is_heap_until(i122, i122+7).check([&](int *r){ CHECK(r == i122+5); });
    is_heap_until(i123, i123+7).check([&](int *r){ CHECK(r == i123+5); });
    is_heap_until(i124, i124+7).check([&](int *r){ CHECK(r == i124+4); });
    is_heap_until(i125, i125+7).check([&](int *r){ CHECK(r == i125+4); });
    is_heap_until(i126, i126+7).check([&](int *r){ CHECK(r == i126+4); });
    is_heap_until(i127, i127+7).check([&](int *r){ CHECK(r == i127+4); });
    is_heap_until(i128, i128+7).check([&](int *r){ CHECK(r == i128+3); });
    is_heap_until(i129, i129+7).check([&](int *r){ CHECK(r == i129+3); });
    is_heap_until(i130, i130+7).check([&](int *r){ CHECK(r == i130+3); });
    is_heap_until(i131, i131+7).check([&](int *r){ CHECK(r == i131+3); });
    is_heap_until(i132, i132+7).check([&](int *r){ CHECK(r == i132+3); });
    is_heap_until(i133, i133+7).check([&](int *r){ CHECK(r == i133+3); });
    is_heap_until(i134, i134+7).check([&](int *r){ CHECK(r == i134+3); });
    is_heap_until(i135, i135+7).check([&](int *r){ CHECK(r == i135+3); });
    is_heap_until(i136, i136+7).check([&](int *r){ CHECK(r == i136+2); });
    is_heap_until(i137, i137+7).check([&](int *r){ CHECK(r == i137+2); });
    is_heap_until(i138, i138+7).check([&](int *r){ CHECK(r == i138+2); });
    is_heap_until(i139, i139+7).check([&](int *r){ CHECK(r == i139+2); });
    is_heap_until(i140, i140+7).check([&](int *r){ CHECK(r == i140+2); });
    is_heap_until(i141, i141+7).check([&](int *r){ CHECK(r == i141+2); });
    is_heap_until(i142, i142+7).check([&](int *r){ CHECK(r == i142+2); });
    is_heap_until(i143, i143+7).check([&](int *r){ CHECK(r == i143+2); });
    is_heap_until(i144, i144+7).check([&](int *r){ CHECK(r == i144+2); });
    is_heap_until(i145, i145+7).check([&](int *r){ CHECK(r == i145+2); });
    is_heap_until(i146, i146+7).check([&](int *r){ CHECK(r == i146+2); });
    is_heap_until(i147, i147+7).check([&](int *r){ CHECK(r == i147+2); });
    is_heap_until(i148, i148+7).check([&](int *r){ CHECK(r == i148+2); });
    is_heap_until(i149, i149+7).check([&](int *r){ CHECK(r == i149+2); });
    is_heap_until(i150, i150+7).check([&](int *r){ CHECK(r == i150+2); });
    is_heap_until(i151, i151+7).check([&](int *r){ CHECK(r == i151+2); });
    is_heap_until(i152, i152+7).check([&](int *r){ CHECK(r == i152+1); });
    is_heap_until(i153, i153+7).check([&](int *r){ CHECK(r == i153+1); });
    is_heap_until(i154, i154+7).check([&](int *r){ CHECK(r == i154+1); });
    is_heap_until(i155, i155+7).check([&](int *r){ CHECK(r == i155+1); });
    is_heap_until(i156, i156+7).check([&](int *r){ CHECK(r == i156+1); });
    is_heap_until(i157, i157+7).check([&](int *r){ CHECK(r == i157+1); });
    is_heap_until(i158, i158+7).check([&](int *r){ CHECK(r == i158+1); });
    is_heap_until(i159, i159+7).check([&](int *r){ CHECK(r == i159+1); });
    is_heap_until(i160, i160+7).check([&](int *r){ CHECK(r == i160+1); });
    is_heap_until(i161, i161+7).check([&](int *r){ CHECK(r == i161+1); });
    is_heap_until(i162, i162+7).check([&](int *r){ CHECK(r == i162+1); });
    is_heap_until(i163, i163+7).check([&](int *r){ CHECK(r == i163+1); });
    is_heap_until(i164, i164+7).check([&](int *r){ CHECK(r == i164+1); });
    is_heap_until(i165, i165+7).check([&](int *r){ CHECK(r == i165+1); });
    is_heap_until(i166, i166+7).check([&](int *r){ CHECK(r == i166+1); });
    is_heap_until(i167, i167+7).check([&](int *r){ CHECK(r == i167+1); });
    is_heap_until(i168, i168+7).check([&](int *r){ CHECK(r == i168+1); });
    is_heap_until(i169, i169+7).check([&](int *r){ CHECK(r == i169+1); });
    is_heap_until(i170, i170+7).check([&](int *r){ CHECK(r == i170+1); });
    is_heap_until(i171, i171+7).check([&](int *r){ CHECK(r == i171+1); });
    is_heap_until(i172, i172+7).check([&](int *r){ CHECK(r == i172+1); });
    is_heap_until(i173, i173+7).check([&](int *r){ CHECK(r == i173+1); });
    is_heap_until(i174, i174+7).check([&](int *r){ CHECK(r == i174+1); });
    is_heap_until(i175, i175+7).check([&](int *r){ CHECK(r == i175+1); });
    is_heap_until(i176, i176+7).check([&](int *r){ CHECK(r == i176+1); });
    is_heap_until(i177, i177+7).check([&](int *r){ CHECK(r == i177+1); });
    is_heap_until(i178, i178+7).check([&](int *r){ CHECK(r == i178+1); });
    is_heap_until(i179, i179+7).check([&](int *r){ CHECK(r == i179+1); });
    is_heap_until(i180, i180+7).check([&](int *r){ CHECK(r == i180+1); });
    is_heap_until(i181, i181+7).check([&](int *r){ CHECK(r == i181+1); });
    is_heap_until(i182, i182+7).check([&](int *r){ CHECK(r == i182+1); });
    is_heap_until(i183, i183+7).check([&](int *r){ CHECK(r == i183+1); });
    is_heap_until(i184, i184+7).check([&](int *r){ CHECK(r == i184+7); });
    is_heap_until(i185, i185+7).check([&](int *r){ CHECK(r == i185+6); });
    is_heap_until(i186, i186+7).check([&](int *r){ CHECK(r == i186+5); });
    is_heap_until(i187, i187+7).check([&](int *r){ CHECK(r == i187+5); });
    is_heap_until(i188, i188+7).check([&](int *r){ CHECK(r == i188+4); });
    is_heap_until(i189, i189+7).check([&](int *r){ CHECK(r == i189+4); });
    is_heap_until(i190, i190+7).check([&](int *r){ CHECK(r == i190+4); });
    is_heap_until(i191, i191+7).check([&](int *r){ CHECK(r == i191+4); });
    is_heap_until(i192, i192+7).check([&](int *r){ CHECK(r == i192+3); });
    is_heap_until(i193, i193+7).check([&](int *r){ CHECK(r == i193+3); });
    is_heap_until(i194, i194+7).check([&](int *r){ CHECK(r == i194+3); });
    is_heap_until(i195, i195+7).check([&](int *r){ CHECK(r == i195+3); });
    is_heap_until(i196, i196+7).check([&](int *r){ CHECK(r == i196+3); });
    is_heap_until(i197, i197+7).check([&](int *r){ CHECK(r == i197+3); });
    is_heap_until(i198, i198+7).check([&](int *r){ CHECK(r == i198+3); });
    is_heap_until(i199, i199+7).check([&](int *r){ CHECK(r == i199+3); });
    is_heap_until(i200, i200+7).check([&](int *r){ CHECK(r == i200+7); });
    is_heap_until(i201, i201+7).check([&](int *r){ CHECK(r == i201+7); });
    is_heap_until(i202, i202+7).check([&](int *r){ CHECK(r == i202+7); });
    is_heap_until(i203, i203+7).check([&](int *r){ CHECK(r == i203+7); });
    is_heap_until(i204, i204+7).check([&](int *r){ CHECK(r == i204+4); });
    is_heap_until(i205, i205+7).check([&](int *r){ CHECK(r == i205+4); });
    is_heap_until(i206, i206+7).check([&](int *r){ CHECK(r == i206+4); });
    is_heap_until(i207, i207+7).check([&](int *r){ CHECK(r == i207+4); });
    is_heap_until(i208, i208+7).check([&](int *r){ CHECK(r == i208+3); });
    is_heap_until(i209, i209+7).check([&](int *r){ CHECK(r == i209+3); });
    is_heap_until(i210, i210+7).check([&](int *r){ CHECK(r == i210+3); });
    is_heap_until(i211, i211+7).check([&](int *r){ CHECK(r == i211+3); });
    is_heap_until(i212, i212+7).check([&](int *r){ CHECK(r == i212+3); });
    is_heap_until(i213, i213+7).check([&](int *r){ CHECK(r == i213+3); });
    is_heap_until(i214, i214+7).check([&](int *r){ CHECK(r == i214+3); });
    is_heap_until(i215, i215+7).check([&](int *r){ CHECK(r == i215+3); });
    is_heap_until(i216, i216+7).check([&](int *r){ CHECK(r == i216+7); });
    is_heap_until(i217, i217+7).check([&](int *r){ CHECK(r == i217+6); });
    is_heap_until(i218, i218+7).check([&](int *r){ CHECK(r == i218+5); });
    is_heap_until(i219, i219+7).check([&](int *r){ CHECK(r == i219+5); });
    is_heap_until(i220, i220+7).check([&](int *r){ CHECK(r == i220+7); });
    is_heap_until(i221, i221+7).check([&](int *r){ CHECK(r == i221+6); });
    is_heap_until(i222, i222+7).check([&](int *r){ CHECK(r == i222+5); });
    is_heap_until(i223, i223+7).check([&](int *r){ CHECK(r == i223+5); });
    is_heap_until(i224, i224+7).check([&](int *r){ CHECK(r == i224+7); });
    is_heap_until(i225, i225+7).check([&](int *r){ CHECK(r == i225+6); });
    is_heap_until(i226, i226+7).check([&](int *r){ CHECK(r == i226+5); });
    is_heap_until(i227, i227+7).check([&](int *r){ CHECK(r == i227+5); });
    is_heap_until(i228, i228+7).check([&](int *r){ CHECK(r == i228+7); });
    is_heap_until(i229, i229+7).check([&](int *r){ CHECK(r == i229+6); });
    is_heap_until(i230, i230+7).check([&](int *r){ CHECK(r == i230+5); });
    is_heap_until(i231, i231+7).check([&](int *r){ CHECK(r == i231+5); });
    is_heap_until(i232, i232+7).check([&](int *r){ CHECK(r == i232+7); });
    is_heap_until(i233, i233+7).check([&](int *r){ CHECK(r == i233+7); });
    is_heap_until(i234, i234+7).check([&](int *r){ CHECK(r == i234+7); });
    is_heap_until(i235, i235+7).check([&](int *r){ CHECK(r == i235+7); });
    is_heap_until(i236, i236+7).check([&](int *r){ CHECK(r == i236+7); });
    is_heap_until(i237, i237+7).check([&](int *r){ CHECK(r == i237+7); });
    is_heap_until(i238, i238+7).check([&](int *r){ CHECK(r == i238+7); });
    is_heap_until(i239, i239+7).check([&](int *r){ CHECK(r == i239+7); });
    is_heap_until(i240, i240+7).check([&](int *r){ CHECK(r == i240+7); });
    is_heap_until(i241, i241+7).check([&](int *r){ CHECK(r == i241+7); });
    is_heap_until(i242, i242+7).check([&](int *r){ CHECK(r == i242+7); });
    is_heap_until(i243, i243+7).check([&](int *r){ CHECK(r == i243+7); });
    is_heap_until(i244, i244+7).check([&](int *r){ CHECK(r == i244+7); });
    is_heap_until(i245, i245+7).check([&](int *r){ CHECK(r == i245+7); });
    is_heap_until(i246, i246+7).check([&](int *r){ CHECK(r == i246+7); });
#endif
}

void test_pred()
{
#ifdef IS_HEAP_UNTIL_3
    auto is_heap_until = ::make_testable_1(ranges::is_heap_until);
    int i1[] = {0, 0};
    is_heap_until(i1, i1, std::greater<int>()).check([&](int *r){ CHECK(r == i1); });
    is_heap_until(i1, i1+1, std::greater<int>()).check([&](int *r){ CHECK(r == i1+1); });
    int i2[] = {0, 1};
    int i3[] = {1, 0};
    is_heap_until(i1, i1+2, std::greater<int>()).check([&](int *r){ CHECK(r == i1+2); });
    is_heap_until(i2, i2+2, std::greater<int>()).check([&](int *r){ CHECK(r == i2+2); });
    is_heap_until(i3, i3+2, std::greater<int>()).check([&](int *r){ CHECK(r == i3+1); });
    int i4[] = {0, 0, 0};
    int i5[] = {0, 0, 1};
    int i6[] = {0, 1, 0};
    int i7[] = {0, 1, 1};
    int i8[] = {1, 0, 0};
    int i9[] = {1, 0, 1};
    int i10[] = {1, 1, 0};
    is_heap_until(i4, i4+3, std::greater<int>()).check([&](int *r){ CHECK(r == i4+3); });
    is_heap_until(i5, i5+3, std::greater<int>()).check([&](int *r){ CHECK(r == i5+3); });
    is_heap_until(i6, i6+3, std::greater<int>()).check([&](int *r){ CHECK(r == i6+3); });
    is_heap_until(i7, i7+3, std::greater<int>()).check([&](int *r){ CHECK(r == i7+3); });
    is_heap_until(i8, i8+3, std::greater<int>()).check([&](int *r){ CHECK(r == i8+1); });
    is_heap_until(i9, i9+3, std::greater<int>()).check([&](int *r){ CHECK(r == i9+1); });
    is_heap_until(i10, i10+3, std::greater<int>()).check([&](int *r){ CHECK(r == i10+2); });
    int i11[] = {0, 0, 0, 0};
    int i12[] = {0, 0, 0, 1};
    int i13[] = {0, 0, 1, 0};
    int i14[] = {0, 0, 1, 1};
    int i15[] = {0, 1, 0, 0};
    int i16[] = {0, 1, 0, 1};
    int i17[] = {0, 1, 1, 0};
    int i18[] = {0, 1, 1, 1};
    int i19[] = {1, 0, 0, 0};
    int i20[] = {1, 0, 0, 1};
    int i21[] = {1, 0, 1, 0};
    int i22[] = {1, 0, 1, 1};
    int i23[] = {1, 1, 0, 0};
    int i24[] = {1, 1, 0, 1};
    int i25[] = {1, 1, 1, 0};
    is_heap_until(i11, i11+4, std::greater<int>()).check([&](int *r){ CHECK(r == i11+4); });
    is_heap_until(i12, i12+4, std::greater<int>()).check([&](int *r){ CHECK(r == i12+4); });
    is_heap_until(i13, i13+4, std::greater<int>()).check([&](int *r){ CHECK(r == i13+4); });
    is_heap_until(i14, i14+4, std::greater<int>()).check([&](int *r){ CHECK(r == i14+4); });
    is_heap_until(i15, i15+4, std::greater<int>()).check([&](int *r){ CHECK(r == i15+3); });
    is_heap_until(i16, i16+4, std::greater<int>()).check([&](int *r){ CHECK(r == i16+4); });
    is_heap_until(i17, i17+4, std::greater<int>()).check([&](int *r){ CHECK(r == i17+3); });
    is_heap_until(i18, i18+4, std::greater<int>()).check([&](int *r){ CHECK(r == i18+4); });
    is_heap_until(i19, i19+4, std::greater<int>()).check([&](int *r){ CHECK(r == i19+1); });
    is_heap_until(i20, i20+4, std::greater<int>()).check([&](int *r){ CHECK(r == i20+1); });
    is_heap_until(i21, i21+4, std::greater<int>()).check([&](int *r){ CHECK(r == i21+1); });
    is_heap_until(i22, i22+4, std::greater<int>()).check([&](int *r){ CHECK(r == i22+1); });
    is_heap_until(i23, i23+4, std::greater<int>()).check([&](int *r){ CHECK(r == i23+2); });
    is_heap_until(i24, i24+4, std::greater<int>()).check([&](int *r){ CHECK(r == i24+2); });
    is_heap_until(i25, i25+4, std::greater<int>()).check([&](int *r){ CHECK(r == i25+3); });
    int i26[] = {0, 0, 0, 0, 0};
    int i27[] = {0, 0, 0, 0, 1};
    int i28[] = {0, 0, 0, 1, 0};
    int i29[] = {0, 0, 0, 1, 1};
    int i30[] = {0, 0, 1, 0, 0};
    int i31[] = {0, 0, 1, 0, 1};
    int i32[] = {0, 0, 1, 1, 0};
    int i33[] = {0, 0, 1, 1, 1};
    int i34[] = {0, 1, 0, 0, 0};
    int i35[] = {0, 1, 0, 0, 1};
    int i36[] = {0, 1, 0, 1, 0};
    int i37[] = {0, 1, 0, 1, 1};
    int i38[] = {0, 1, 1, 0, 0};
    int i39[] = {0, 1, 1, 0, 1};
    int i40[] = {0, 1, 1, 1, 0};
    int i41[] = {0, 1, 1, 1, 1};
    int i42[] = {1, 0, 0, 0, 0};
    int i43[] = {1, 0, 0, 0, 1};
    int i44[] = {1, 0, 0, 1, 0};
    int i45[] = {1, 0, 0, 1, 1};
    int i46[] = {1, 0, 1, 0, 0};
    int i47[] = {1, 0, 1, 0, 1};
    int i48[] = {1, 0, 1, 1, 0};
    int i49[] = {1, 0, 1, 1, 1};
    int i50[] = {1, 1, 0, 0, 0};
    int i51[] = {1, 1, 0, 0, 1};
    int i52[] = {1, 1, 0, 1, 0};
    int i53[] = {1, 1, 0, 1, 1};
    int i54[] = {1, 1, 1, 0, 0};
    int i55[] = {1, 1, 1, 0, 1};
    int i56[] = {1, 1, 1, 1, 0};
    is_heap_until(i26, i26+5, std::greater<int>()).check([&](int *r){ CHECK(r == i26+5); });
    is_heap_until(i27, i27+5, std::greater<int>()).check([&](int *r){ CHECK(r == i27+5); });
    is_heap_until(i28, i28+5, std::greater<int>()).check([&](int *r){ CHECK(r == i28+5); });
    is_heap_until(i29, i29+5, std::greater<int>()).check([&](int *r){ CHECK(r == i29+5); });
    is_heap_until(i30, i30+5, std::greater<int>()).check([&](int *r){ CHECK(r == i30+5); });
    is_heap_until(i31, i31+5, std::greater<int>()).check([&](int *r){ CHECK(r == i31+5); });
    is_heap_until(i32, i32+5, std::greater<int>()).check([&](int *r){ CHECK(r == i32+5); });
    is_heap_until(i33, i33+5, std::greater<int>()).check([&](int *r){ CHECK(r == i33+5); });
    is_heap_until(i34, i34+5, std::greater<int>()).check([&](int *r){ CHECK(r == i34+3); });
    is_heap_until(i35, i35+5, std::greater<int>()).check([&](int *r){ CHECK(r == i35+3); });
    is_heap_until(i36, i36+5, std::greater<int>()).check([&](int *r){ CHECK(r == i36+4); });
    is_heap_until(i37, i37+5, std::greater<int>()).check([&](int *r){ CHECK(r == i37+5); });
    is_heap_until(i38, i38+5, std::greater<int>()).check([&](int *r){ CHECK(r == i38+3); });
    is_heap_until(i39, i39+5, std::greater<int>()).check([&](int *r){ CHECK(r == i39+3); });
    is_heap_until(i40, i40+5, std::greater<int>()).check([&](int *r){ CHECK(r == i40+4); });
    is_heap_until(i41, i41+5, std::greater<int>()).check([&](int *r){ CHECK(r == i41+5); });
    is_heap_until(i42, i42+5, std::greater<int>()).check([&](int *r){ CHECK(r == i42+1); });
    is_heap_until(i43, i43+5, std::greater<int>()).check([&](int *r){ CHECK(r == i43+1); });
    is_heap_until(i44, i44+5, std::greater<int>()).check([&](int *r){ CHECK(r == i44+1); });
    is_heap_until(i45, i45+5, std::greater<int>()).check([&](int *r){ CHECK(r == i45+1); });
    is_heap_until(i46, i46+5, std::greater<int>()).check([&](int *r){ CHECK(r == i46+1); });
    is_heap_until(i47, i47+5, std::greater<int>()).check([&](int *r){ CHECK(r == i47+1); });
    is_heap_until(i48, i48+5, std::greater<int>()).check([&](int *r){ CHECK(r == i48+1); });
    is_heap_until(i49, i49+5, std::greater<int>()).check([&](int *r){ CHECK(r == i49+1); });
    is_heap_until(i50, i50+5, std::greater<int>()).check([&](int *r){ CHECK(r == i50+2); });
    is_heap_until(i51, i51+5, std::greater<int>()).check([&](int *r){ CHECK(r == i51+2); });
    is_heap_until(i52, i52+5, std::greater<int>()).check([&](int *r){ CHECK(r == i52+2); });
    is_heap_until(i53, i53+5, std::greater<int>()).check([&](int *r){ CHECK(r == i53+2); });
    is_heap_until(i54, i54+5, std::greater<int>()).check([&](int *r){ CHECK(r == i54+3); });
    is_heap_until(i55, i55+5, std::greater<int>()).check([&](int *r){ CHECK(r == i55+3); });
    is_heap_until(i56, i56+5, std::greater<int>()).check([&](int *r){ CHECK(r == i56+4); });
    int i57[] = {0, 0, 0, 0, 0, 0};
    int i58[] = {0, 0, 0, 0, 0, 1};
    int i59[] = {0, 0, 0, 0, 1, 0};
    int i60[] = {0, 0, 0, 0, 1, 1};
    int i61[] = {0, 0, 0, 1, 0, 0};
    int i62[] = {0, 0, 0, 1, 0, 1};
    int i63[] = {0, 0, 0, 1, 1, 0};
    int i64[] = {0, 0, 0, 1, 1, 1};
    int i65[] = {0, 0, 1, 0, 0, 0};
    int i66[] = {0, 0, 1, 0, 0, 1};
    int i67[] = {0, 0, 1, 0, 1, 0};
    int i68[] = {0, 0, 1, 0, 1, 1};
    int i69[] = {0, 0, 1, 1, 0, 0};
    int i70[] = {0, 0, 1, 1, 0, 1};
    int i71[] = {0, 0, 1, 1, 1, 0};
    int i72[] = {0, 0, 1, 1, 1, 1};
    int i73[] = {0, 1, 0, 0, 0, 0};
    int i74[] = {0, 1, 0, 0, 0, 1};
    int i75[] = {0, 1, 0, 0, 1, 0};
    int i76[] = {0, 1, 0, 0, 1, 1};
    int i77[] = {0, 1, 0, 1, 0, 0};
    int i78[] = {0, 1, 0, 1, 0, 1};
    int i79[] = {0, 1, 0, 1, 1, 0};
    int i80[] = {0, 1, 0, 1, 1, 1};
    int i81[] = {0, 1, 1, 0, 0, 0};
    int i82[] = {0, 1, 1, 0, 0, 1};
    int i83[] = {0, 1, 1, 0, 1, 0};
    int i84[] = {0, 1, 1, 0, 1, 1};
    int i85[] = {0, 1, 1, 1, 0, 0};
    int i86[] = {0, 1, 1, 1, 0, 1};
    int i87[] = {0, 1, 1, 1, 1, 0};
    int i88[] = {0, 1, 1, 1, 1, 1};
    int i89[] = {1, 0, 0, 0, 0, 0};
    int i90[] = {1, 0, 0, 0, 0, 1};
    int i91[] = {1, 0, 0, 0, 1, 0};
    int i92[] = {1, 0, 0, 0, 1, 1};
    int i93[] = {1, 0, 0, 1, 0, 0};
    int i94[] = {1, 0, 0, 1, 0, 1};
    int i95[] = {1, 0, 0, 1, 1, 0};
    int i96[] = {1, 0, 0, 1, 1, 1};
    int i97[] = {1, 0, 1, 0, 0, 0};
    int i98[] = {1, 0, 1, 0, 0, 1};
    int i99[] = {1, 0, 1, 0, 1, 0};
    int i100[] = {1, 0, 1, 0, 1, 1};
    int i101[] = {1, 0, 1, 1, 0, 0};
    int i102[] = {1, 0, 1, 1, 0, 1};
    int i103[] = {1, 0, 1, 1, 1, 0};
    int i104[] = {1, 0, 1, 1, 1, 1};
    int i105[] = {1, 1, 0, 0, 0, 0};
    int i106[] = {1, 1, 0, 0, 0, 1};
    int i107[] = {1, 1, 0, 0, 1, 0};
    int i108[] = {1, 1, 0, 0, 1, 1};
    int i109[] = {1, 1, 0, 1, 0, 0};
    int i110[] = {1, 1, 0, 1, 0, 1};
    int i111[] = {1, 1, 0, 1, 1, 0};
    int i112[] = {1, 1, 0, 1, 1, 1};
    int i113[] = {1, 1, 1, 0, 0, 0};
    int i114[] = {1, 1, 1, 0, 0, 1};
    int i115[] = {1, 1, 1, 0, 1, 0};
    int i116[] = {1, 1, 1, 0, 1, 1};
    int i117[] = {1, 1, 1, 1, 0, 0};
    int i118[] = {1, 1, 1, 1, 0, 1};
    int i119[] = {1, 1, 1, 1, 1, 0};
    is_heap_until(i57, i57+6, std::greater<int>()).check([&](int *r){ CHECK(r == i57+6); });
    is_heap_until(i58, i58+6, std::greater<int>()).check([&](int *r){ CHECK(r == i58+6); });
    is_heap_until(i59, i59+6, std::greater<int>()).check([&](int *r){ CHECK(r == i59+6); });
    is_heap_until(i60, i60+6, std::greater<int>()).check([&](int *r){ CHECK(r == i60+6); });
    is_heap_until(i61, i61+6, std::greater<int>()).check([&](int *r){ CHECK(r == i61+6); });
    is_heap_until(i62, i62+6, std::greater<int>()).check([&](int *r){ CHECK(r == i62+6); });
    is_heap_until(i63, i63+6, std::greater<int>()).check([&](int *r){ CHECK(r == i63+6); });
    is_heap_until(i64, i64+6, std::greater<int>()).check([&](int *r){ CHECK(r == i64+6); });
    is_heap_until(i65, i65+6, std::greater<int>()).check([&](int *r){ CHECK(r == i65+5); });
    is_heap_until(i66, i66+6, std::greater<int>()).check([&](int *r){ CHECK(r == i66+6); });
    is_heap_until(i67, i67+6, std::greater<int>()).check([&](int *r){ CHECK(r == i67+5); });
    is_heap_until(i68, i68+6, std::greater<int>()).check([&](int *r){ CHECK(r == i68+6); });
    is_heap_until(i69, i69+6, std::greater<int>()).check([&](int *r){ CHECK(r == i69+5); });
    is_heap_until(i70, i70+6, std::greater<int>()).check([&](int *r){ CHECK(r == i70+6); });
    is_heap_until(i71, i71+6, std::greater<int>()).check([&](int *r){ CHECK(r == i71+5); });
    is_heap_until(i72, i72+6, std::greater<int>()).check([&](int *r){ CHECK(r == i72+6); });
    is_heap_until(i73, i73+6, std::greater<int>()).check([&](int *r){ CHECK(r == i73+3); });
    is_heap_until(i74, i74+6, std::greater<int>()).check([&](int *r){ CHECK(r == i74+3); });
    is_heap_until(i75, i75+6, std::greater<int>()).check([&](int *r){ CHECK(r == i75+3); });
    is_heap_until(i76, i76+6, std::greater<int>()).check([&](int *r){ CHECK(r == i76+3); });
    is_heap_until(i77, i77+6, std::greater<int>()).check([&](int *r){ CHECK(r == i77+4); });
    is_heap_until(i78, i78+6, std::greater<int>()).check([&](int *r){ CHECK(r == i78+4); });
    is_heap_until(i79, i79+6, std::greater<int>()).check([&](int *r){ CHECK(r == i79+6); });
    is_heap_until(i80, i80+6, std::greater<int>()).check([&](int *r){ CHECK(r == i80+6); });
    is_heap_until(i81, i81+6, std::greater<int>()).check([&](int *r){ CHECK(r == i81+3); });
    is_heap_until(i82, i82+6, std::greater<int>()).check([&](int *r){ CHECK(r == i82+3); });
    is_heap_until(i83, i83+6, std::greater<int>()).check([&](int *r){ CHECK(r == i83+3); });
    is_heap_until(i84, i84+6, std::greater<int>()).check([&](int *r){ CHECK(r == i84+3); });
    is_heap_until(i85, i85+6, std::greater<int>()).check([&](int *r){ CHECK(r == i85+4); });
    is_heap_until(i86, i86+6, std::greater<int>()).check([&](int *r){ CHECK(r == i86+4); });
    is_heap_until(i87, i87+6, std::greater<int>()).check([&](int *r){ CHECK(r == i87+5); });
    is_heap_until(i88, i88+6, std::greater<int>()).check([&](int *r){ CHECK(r == i88+6); });
    is_heap_until(i89, i89+6, std::greater<int>()).check([&](int *r){ CHECK(r == i89+1); });
    is_heap_until(i90, i90+6, std::greater<int>()).check([&](int *r){ CHECK(r == i90+1); });
    is_heap_until(i91, i91+6, std::greater<int>()).check([&](int *r){ CHECK(r == i91+1); });
    is_heap_until(i92, i92+6, std::greater<int>()).check([&](int *r){ CHECK(r == i92+1); });
    is_heap_until(i93, i93+6, std::greater<int>()).check([&](int *r){ CHECK(r == i93+1); });
    is_heap_until(i94, i94+6, std::greater<int>()).check([&](int *r){ CHECK(r == i94+1); });
    is_heap_until(i95, i95+6, std::greater<int>()).check([&](int *r){ CHECK(r == i95+1); });
    is_heap_until(i96, i96+6, std::greater<int>()).check([&](int *r){ CHECK(r == i96+1); });
    is_heap_until(i97, i97+6, std::greater<int>()).check([&](int *r){ CHECK(r == i97+1); });
    is_heap_until(i98, i98+6, std::greater<int>()).check([&](int *r){ CHECK(r == i98+1); });
    is_heap_until(i99, i99+6, std::greater<int>()).check([&](int *r){ CHECK(r == i99+1); });
    is_heap_until(i100, i100+6, std::greater<int>()).check([&](int *r){ CHECK(r == i100+1); });
    is_heap_until(i101, i101+6, std::greater<int>()).check([&](int *r){ CHECK(r == i101+1); });
    is_heap_until(i102, i102+6, std::greater<int>()).check([&](int *r){ CHECK(r == i102+1); });
    is_heap_until(i103, i103+6, std::greater<int>()).check([&](int *r){ CHECK(r == i103+1); });
    is_heap_until(i104, i104+6, std::greater<int>()).check([&](int *r){ CHECK(r == i104+1); });
    is_heap_until(i105, i105+6, std::greater<int>()).check([&](int *r){ CHECK(r == i105+2); });
    is_heap_until(i106, i106+6, std::greater<int>()).check([&](int *r){ CHECK(r == i106+2); });
    is_heap_until(i107, i107+6, std::greater<int>()).check([&](int *r){ CHECK(r == i107+2); });
    is_heap_until(i108, i108+6, std::greater<int>()).check([&](int *r){ CHECK(r == i108+2); });
    is_heap_until(i109, i109+6, std::greater<int>()).check([&](int *r){ CHECK(r == i109+2); });
    is_heap_until(i110, i110+6, std::greater<int>()).check([&](int *r){ CHECK(r == i110+2); });
    is_heap_until(i111, i111+6, std::greater<int>()).check([&](int *r){ CHECK(r == i111+2); });
    is_heap_until(i112, i112+6, std::greater<int>()).check([&](int *r){ CHECK(r == i112+2); });
    is_heap_until(i113, i113+6, std::greater<int>()).check([&](int *r){ CHECK(r == i113+3); });
    is_heap_until(i114, i114+6, std::greater<int>()).check([&](int *r){ CHECK(r == i114+3); });
    is_heap_until(i115, i115+6, std::greater<int>()).check([&](int *r){ CHECK(r == i115+3); });
    is_heap_until(i116, i116+6, std::greater<int>()).check([&](int *r){ CHECK(r == i116+3); });
    is_heap_until(i117, i117+6, std::greater<int>()).check([&](int *r){ CHECK(r == i117+4); });
    is_heap_until(i118, i118+6, std::greater<int>()).check([&](int *r){ CHECK(r == i118+4); });
    is_heap_until(i119, i119+6, std::greater<int>()).check([&](int *r){ CHECK(r == i119+5); });
#endif
#ifdef IS_HEAP_UNTIL_4
    auto is_heap_until = ::make_testable_1(ranges::is_heap_until);
    int i120[] = {0, 0, 0, 0, 0, 0, 0};
    int i121[] = {0, 0, 0, 0, 0, 0, 1};
    int i122[] = {0, 0, 0, 0, 0, 1, 0};
    int i123[] = {0, 0, 0, 0, 0, 1, 1};
    int i124[] = {0, 0, 0, 0, 1, 0, 0};
    int i125[] = {0, 0, 0, 0, 1, 0, 1};
    int i126[] = {0, 0, 0, 0, 1, 1, 0};
    int i127[] = {0, 0, 0, 0, 1, 1, 1};
    int i128[] = {0, 0, 0, 1, 0, 0, 0};
    int i129[] = {0, 0, 0, 1, 0, 0, 1};
    int i130[] = {0, 0, 0, 1, 0, 1, 0};
    int i131[] = {0, 0, 0, 1, 0, 1, 1};
    int i132[] = {0, 0, 0, 1, 1, 0, 0};
    int i133[] = {0, 0, 0, 1, 1, 0, 1};
    int i134[] = {0, 0, 0, 1, 1, 1, 0};
    int i135[] = {0, 0, 0, 1, 1, 1, 1};
    int i136[] = {0, 0, 1, 0, 0, 0, 0};
    int i137[] = {0, 0, 1, 0, 0, 0, 1};
    int i138[] = {0, 0, 1, 0, 0, 1, 0};
    int i139[] = {0, 0, 1, 0, 0, 1, 1};
    int i140[] = {0, 0, 1, 0, 1, 0, 0};
    int i141[] = {0, 0, 1, 0, 1, 0, 1};
    int i142[] = {0, 0, 1, 0, 1, 1, 0};
    int i143[] = {0, 0, 1, 0, 1, 1, 1};
    int i144[] = {0, 0, 1, 1, 0, 0, 0};
    int i145[] = {0, 0, 1, 1, 0, 0, 1};
    int i146[] = {0, 0, 1, 1, 0, 1, 0};
    int i147[] = {0, 0, 1, 1, 0, 1, 1};
    int i148[] = {0, 0, 1, 1, 1, 0, 0};
    int i149[] = {0, 0, 1, 1, 1, 0, 1};
    int i150[] = {0, 0, 1, 1, 1, 1, 0};
    int i151[] = {0, 0, 1, 1, 1, 1, 1};
    int i152[] = {0, 1, 0, 0, 0, 0, 0};
    int i153[] = {0, 1, 0, 0, 0, 0, 1};
    int i154[] = {0, 1, 0, 0, 0, 1, 0};
    int i155[] = {0, 1, 0, 0, 0, 1, 1};
    int i156[] = {0, 1, 0, 0, 1, 0, 0};
    int i157[] = {0, 1, 0, 0, 1, 0, 1};
    int i158[] = {0, 1, 0, 0, 1, 1, 0};
    int i159[] = {0, 1, 0, 0, 1, 1, 1};
    int i160[] = {0, 1, 0, 1, 0, 0, 0};
    int i161[] = {0, 1, 0, 1, 0, 0, 1};
    int i162[] = {0, 1, 0, 1, 0, 1, 0};
    int i163[] = {0, 1, 0, 1, 0, 1, 1};
    int i164[] = {0, 1, 0, 1, 1, 0, 0};
    int i165[] = {0, 1, 0, 1, 1, 0, 1};
    int i166[] = {0, 1, 0, 1, 1, 1, 0};
    int i167[] = {0, 1, 0, 1, 1, 1, 1};
    int i168[] = {0, 1, 1, 0, 0, 0, 0};
    int i169[] = {0, 1, 1, 0, 0, 0, 1};
    int i170[] = {0, 1, 1, 0, 0, 1, 0};
    int i171[] = {0, 1, 1, 0, 0, 1, 1};
    int i172[] = {0, 1, 1, 0, 1, 0, 0};
    int i173[] = {0, 1, 1, 0, 1, 0, 1};
    int i174[] = {0, 1, 1, 0, 1, 1, 0};
    int i175[] = {0, 1, 1, 0, 1, 1, 1};
    int i176[] = {0, 1, 1, 1, 0, 0, 0};
    int i177[] = {0, 1, 1, 1, 0, 0, 1};
    int i178[] = {0, 1, 1, 1, 0, 1, 0};
    int i179[] = {0, 1, 1, 1, 0, 1, 1};
    int i180[] = {0, 1, 1, 1, 1, 0, 0};
    int i181[] = {0, 1, 1, 1, 1, 0, 1};
    int i182[] = {0, 1, 1, 1, 1, 1, 0};
    int i183[] = {0, 1, 1, 1, 1, 1, 1};
    int i184[] = {1, 0, 0, 0, 0, 0, 0};
    int i185[] = {1, 0, 0, 0, 0, 0, 1};
    int i186[] = {1, 0, 0, 0, 0, 1, 0};
    int i187[] = {1, 0, 0, 0, 0, 1, 1};
    int i188[] = {1, 0, 0, 0, 1, 0, 0};
    int i189[] = {1, 0, 0, 0, 1, 0, 1};
    int i190[] = {1, 0, 0, 0, 1, 1, 0};
    int i191[] = {1, 0, 0, 0, 1, 1, 1};
    int i192[] = {1, 0, 0, 1, 0, 0, 0};
    int i193[] = {1, 0, 0, 1, 0, 0, 1};
    int i194[] = {1, 0, 0, 1, 0, 1, 0};
    int i195[] = {1, 0, 0, 1, 0, 1, 1};
    int i196[] = {1, 0, 0, 1, 1, 0, 0};
    int i197[] = {1, 0, 0, 1, 1, 0, 1};
    int i198[] = {1, 0, 0, 1, 1, 1, 0};
    int i199[] = {1, 0, 0, 1, 1, 1, 1};
    int i200[] = {1, 0, 1, 0, 0, 0, 0};
    int i201[] = {1, 0, 1, 0, 0, 0, 1};
    int i202[] = {1, 0, 1, 0, 0, 1, 0};
    int i203[] = {1, 0, 1, 0, 0, 1, 1};
    int i204[] = {1, 0, 1, 0, 1, 0, 0};
    int i205[] = {1, 0, 1, 0, 1, 0, 1};
    int i206[] = {1, 0, 1, 0, 1, 1, 0};
    int i207[] = {1, 0, 1, 0, 1, 1, 1};
    int i208[] = {1, 0, 1, 1, 0, 0, 0};
    int i209[] = {1, 0, 1, 1, 0, 0, 1};
    int i210[] = {1, 0, 1, 1, 0, 1, 0};
    int i211[] = {1, 0, 1, 1, 0, 1, 1};
    int i212[] = {1, 0, 1, 1, 1, 0, 0};
    int i213[] = {1, 0, 1, 1, 1, 0, 1};
    int i214[] = {1, 0, 1, 1, 1, 1, 0};
    int i215[] = {1, 0, 1, 1, 1, 1, 1};
    int i216[] = {1, 1, 0, 0, 0, 0, 0};
    int i217[] = {1, 1, 0, 0, 0, 0, 1};
    int i218[] = {1, 1, 0, 0, 0, 1, 0};
    int i219[] = {1, 1, 0, 0, 0, 1, 1};
    int i220[] = {1, 1, 0, 0, 1, 0, 0};
    int i221[] = {1, 1, 0, 0, 1, 0, 1};
    int i222[] = {1, 1, 0, 0, 1, 1, 0};
    int i223[] = {1, 1, 0, 0, 1, 1, 1};
    int i224[] = {1, 1, 0, 1, 0, 0, 0};
    int i225[] = {1, 1, 0, 1, 0, 0, 1};
    int i226[] = {1, 1, 0, 1, 0, 1, 0};
    int i227[] = {1, 1, 0, 1, 0, 1, 1};
    int i228[] = {1, 1, 0, 1, 1, 0, 0};
    int i229[] = {1, 1, 0, 1, 1, 0, 1};
    int i230[] = {1, 1, 0, 1, 1, 1, 0};
    int i231[] = {1, 1, 0, 1, 1, 1, 1};
    int i232[] = {1, 1, 1, 0, 0, 0, 0};
    int i233[] = {1, 1, 1, 0, 0, 0, 1};
    int i234[] = {1, 1, 1, 0, 0, 1, 0};
    int i235[] = {1, 1, 1, 0, 0, 1, 1};
    int i236[] = {1, 1, 1, 0, 1, 0, 0};
    int i237[] = {1, 1, 1, 0, 1, 0, 1};
    int i238[] = {1, 1, 1, 0, 1, 1, 0};
    int i239[] = {1, 1, 1, 0, 1, 1, 1};
    int i240[] = {1, 1, 1, 1, 0, 0, 0};
    int i241[] = {1, 1, 1, 1, 0, 0, 1};
    int i242[] = {1, 1, 1, 1, 0, 1, 0};
    int i243[] = {1, 1, 1, 1, 0, 1, 1};
    int i244[] = {1, 1, 1, 1, 1, 0, 0};
    int i245[] = {1, 1, 1, 1, 1, 0, 1};
    int i246[] = {1, 1, 1, 1, 1, 1, 0};
    is_heap_until(i120, i120+7, std::greater<int>()).check([&](int *r){ CHECK(r == i120+7); });
    is_heap_until(i121, i121+7, std::greater<int>()).check([&](int *r){ CHECK(r == i121+7); });
    is_heap_until(i122, i122+7, std::greater<int>()).check([&](int *r){ CHECK(r == i122+7); });
    is_heap_until(i123, i123+7, std::greater<int>()).check([&](int *r){ CHECK(r == i123+7); });
    is_heap_until(i124, i124+7, std::greater<int>()).check([&](int *r){ CHECK(r == i124+7); });
    is_heap_until(i125, i125+7, std::greater<int>()).check([&](int *r){ CHECK(r == i125+7); });
    is_heap_until(i126, i126+7, std::greater<int>()).check([&](int *r){ CHECK(r == i126+7); });
    is_heap_until(i127, i127+7, std::greater<int>()).check([&](int *r){ CHECK(r == i127+7); });
    is_heap_until(i128, i128+7, std::greater<int>()).check([&](int *r){ CHECK(r == i128+7); });
    is_heap_until(i129, i129+7, std::greater<int>()).check([&](int *r){ CHECK(r == i129+7); });
    is_heap_until(i130, i130+7, std::greater<int>()).check([&](int *r){ CHECK(r == i130+7); });
    is_heap_until(i131, i131+7, std::greater<int>()).check([&](int *r){ CHECK(r == i131+7); });
    is_heap_until(i132, i132+7, std::greater<int>()).check([&](int *r){ CHECK(r == i132+7); });
    is_heap_until(i133, i133+7, std::greater<int>()).check([&](int *r){ CHECK(r == i133+7); });
    is_heap_until(i134, i134+7, std::greater<int>()).check([&](int *r){ CHECK(r == i134+7); });
    is_heap_until(i135, i135+7, std::greater<int>()).check([&](int *r){ CHECK(r == i135+7); });
    is_heap_until(i136, i136+7, std::greater<int>()).check([&](int *r){ CHECK(r == i136+5); });
    is_heap_until(i137, i137+7, std::greater<int>()).check([&](int *r){ CHECK(r == i137+5); });
    is_heap_until(i138, i138+7, std::greater<int>()).check([&](int *r){ CHECK(r == i138+6); });
    is_heap_until(i139, i139+7, std::greater<int>()).check([&](int *r){ CHECK(r == i139+7); });
    is_heap_until(i140, i140+7, std::greater<int>()).check([&](int *r){ CHECK(r == i140+5); });
    is_heap_until(i141, i141+7, std::greater<int>()).check([&](int *r){ CHECK(r == i141+5); });
    is_heap_until(i142, i142+7, std::greater<int>()).check([&](int *r){ CHECK(r == i142+6); });
    is_heap_until(i143, i143+7, std::greater<int>()).check([&](int *r){ CHECK(r == i143+7); });
    is_heap_until(i144, i144+7, std::greater<int>()).check([&](int *r){ CHECK(r == i144+5); });
    is_heap_until(i145, i145+7, std::greater<int>()).check([&](int *r){ CHECK(r == i145+5); });
    is_heap_until(i146, i146+7, std::greater<int>()).check([&](int *r){ CHECK(r == i146+6); });
    is_heap_until(i147, i147+7, std::greater<int>()).check([&](int *r){ CHECK(r == i147+7); });
    is_heap_until(i148, i148+7, std::greater<int>()).check([&](int *r){ CHECK(r == i148+5); });
    is_heap_until(i149, i149+7, std::greater<int>()).check([&](int *r){ CHECK(r == i149+5); });
    is_heap_until(i150, i150+7, std::greater<int>()).check([&](int *r){ CHECK(r == i150+6); });
    is_heap_until(i151, i151+7, std::greater<int>()).check([&](int *r){ CHECK(r == i151+7); });
    is_heap_until(i152, i152+7, std::greater<int>()).check([&](int *r){ CHECK(r == i152+3); });
    is_heap_until(i153, i153+7, std::greater<int>()).check([&](int *r){ CHECK(r == i153+3); });
    is_heap_until(i154, i154+7, std::greater<int>()).check([&](int *r){ CHECK(r == i154+3); });
    is_heap_until(i155, i155+7, std::greater<int>()).check([&](int *r){ CHECK(r == i155+3); });
    is_heap_until(i156, i156+7, std::greater<int>()).check([&](int *r){ CHECK(r == i156+3); });
    is_heap_until(i157, i157+7, std::greater<int>()).check([&](int *r){ CHECK(r == i157+3); });
    is_heap_until(i158, i158+7, std::greater<int>()).check([&](int *r){ CHECK(r == i158+3); });
    is_heap_until(i159, i159+7, std::greater<int>()).check([&](int *r){ CHECK(r == i159+3); });
    is_heap_until(i160, i160+7, std::greater<int>()).check([&](int *r){ CHECK(r == i160+4); });
    is_heap_until(i161, i161+7, std::greater<int>()).check([&](int *r){ CHECK(r == i161+4); });
    is_heap_until(i162, i162+7, std::greater<int>()).check([&](int *r){ CHECK(r == i162+4); });
    is_heap_until(i163, i163+7, std::greater<int>()).check([&](int *r){ CHECK(r == i163+4); });
    is_heap_until(i164, i164+7, std::greater<int>()).check([&](int *r){ CHECK(r == i164+7); });
    is_heap_until(i165, i165+7, std::greater<int>()).check([&](int *r){ CHECK(r == i165+7); });
    is_heap_until(i166, i166+7, std::greater<int>()).check([&](int *r){ CHECK(r == i166+7); });
    is_heap_until(i167, i167+7, std::greater<int>()).check([&](int *r){ CHECK(r == i167+7); });
    is_heap_until(i168, i168+7, std::greater<int>()).check([&](int *r){ CHECK(r == i168+3); });
    is_heap_until(i169, i169+7, std::greater<int>()).check([&](int *r){ CHECK(r == i169+3); });
    is_heap_until(i170, i170+7, std::greater<int>()).check([&](int *r){ CHECK(r == i170+3); });
    is_heap_until(i171, i171+7, std::greater<int>()).check([&](int *r){ CHECK(r == i171+3); });
    is_heap_until(i172, i172+7, std::greater<int>()).check([&](int *r){ CHECK(r == i172+3); });
    is_heap_until(i173, i173+7, std::greater<int>()).check([&](int *r){ CHECK(r == i173+3); });
    is_heap_until(i174, i174+7, std::greater<int>()).check([&](int *r){ CHECK(r == i174+3); });
    is_heap_until(i175, i175+7, std::greater<int>()).check([&](int *r){ CHECK(r == i175+3); });
    is_heap_until(i176, i176+7, std::greater<int>()).check([&](int *r){ CHECK(r == i176+4); });
    is_heap_until(i177, i177+7, std::greater<int>()).check([&](int *r){ CHECK(r == i177+4); });
    is_heap_until(i178, i178+7, std::greater<int>()).check([&](int *r){ CHECK(r == i178+4); });
    is_heap_until(i179, i179+7, std::greater<int>()).check([&](int *r){ CHECK(r == i179+4); });
    is_heap_until(i180, i180+7, std::greater<int>()).check([&](int *r){ CHECK(r == i180+5); });
    is_heap_until(i181, i181+7, std::greater<int>()).check([&](int *r){ CHECK(r == i181+5); });
    is_heap_until(i182, i182+7, std::greater<int>()).check([&](int *r){ CHECK(r == i182+6); });
    is_heap_until(i183, i183+7, std::greater<int>()).check([&](int *r){ CHECK(r == i183+7); });
    is_heap_until(i184, i184+7, std::greater<int>()).check([&](int *r){ CHECK(r == i184+1); });
    is_heap_until(i185, i185+7, std::greater<int>()).check([&](int *r){ CHECK(r == i185+1); });
    is_heap_until(i186, i186+7, std::greater<int>()).check([&](int *r){ CHECK(r == i186+1); });
    is_heap_until(i187, i187+7, std::greater<int>()).check([&](int *r){ CHECK(r == i187+1); });
    is_heap_until(i188, i188+7, std::greater<int>()).check([&](int *r){ CHECK(r == i188+1); });
    is_heap_until(i189, i189+7, std::greater<int>()).check([&](int *r){ CHECK(r == i189+1); });
    is_heap_until(i190, i190+7, std::greater<int>()).check([&](int *r){ CHECK(r == i190+1); });
    is_heap_until(i191, i191+7, std::greater<int>()).check([&](int *r){ CHECK(r == i191+1); });
    is_heap_until(i192, i192+7, std::greater<int>()).check([&](int *r){ CHECK(r == i192+1); });
    is_heap_until(i193, i193+7, std::greater<int>()).check([&](int *r){ CHECK(r == i193+1); });
    is_heap_until(i194, i194+7, std::greater<int>()).check([&](int *r){ CHECK(r == i194+1); });
    is_heap_until(i195, i195+7, std::greater<int>()).check([&](int *r){ CHECK(r == i195+1); });
    is_heap_until(i196, i196+7, std::greater<int>()).check([&](int *r){ CHECK(r == i196+1); });
    is_heap_until(i197, i197+7, std::greater<int>()).check([&](int *r){ CHECK(r == i197+1); });
    is_heap_until(i198, i198+7, std::greater<int>()).check([&](int *r){ CHECK(r == i198+1); });
    is_heap_until(i199, i199+7, std::greater<int>()).check([&](int *r){ CHECK(r == i199+1); });
    is_heap_until(i200, i200+7, std::greater<int>()).check([&](int *r){ CHECK(r == i200+1); });
    is_heap_until(i201, i201+7, std::greater<int>()).check([&](int *r){ CHECK(r == i201+1); });
    is_heap_until(i202, i202+7, std::greater<int>()).check([&](int *r){ CHECK(r == i202+1); });
    is_heap_until(i203, i203+7, std::greater<int>()).check([&](int *r){ CHECK(r == i203+1); });
    is_heap_until(i204, i204+7, std::greater<int>()).check([&](int *r){ CHECK(r == i204+1); });
    is_heap_until(i205, i205+7, std::greater<int>()).check([&](int *r){ CHECK(r == i205+1); });
    is_heap_until(i206, i206+7, std::greater<int>()).check([&](int *r){ CHECK(r == i206+1); });
    is_heap_until(i207, i207+7, std::greater<int>()).check([&](int *r){ CHECK(r == i207+1); });
    is_heap_until(i208, i208+7, std::greater<int>()).check([&](int *r){ CHECK(r == i208+1); });
    is_heap_until(i209, i209+7, std::greater<int>()).check([&](int *r){ CHECK(r == i209+1); });
    is_heap_until(i210, i210+7, std::greater<int>()).check([&](int *r){ CHECK(r == i210+1); });
    is_heap_until(i211, i211+7, std::greater<int>()).check([&](int *r){ CHECK(r == i211+1); });
    is_heap_until(i212, i212+7, std::greater<int>()).check([&](int *r){ CHECK(r == i212+1); });
    is_heap_until(i213, i213+7, std::greater<int>()).check([&](int *r){ CHECK(r == i213+1); });
    is_heap_until(i214, i214+7, std::greater<int>()).check([&](int *r){ CHECK(r == i214+1); });
    is_heap_until(i215, i215+7, std::greater<int>()).check([&](int *r){ CHECK(r == i215+1); });
    is_heap_until(i216, i216+7, std::greater<int>()).check([&](int *r){ CHECK(r == i216+2); });
    is_heap_until(i217, i217+7, std::greater<int>()).check([&](int *r){ CHECK(r == i217+2); });
    is_heap_until(i218, i218+7, std::greater<int>()).check([&](int *r){ CHECK(r == i218+2); });
    is_heap_until(i219, i219+7, std::greater<int>()).check([&](int *r){ CHECK(r == i219+2); });
    is_heap_until(i220, i220+7, std::greater<int>()).check([&](int *r){ CHECK(r == i220+2); });
    is_heap_until(i221, i221+7, std::greater<int>()).check([&](int *r){ CHECK(r == i221+2); });
    is_heap_until(i222, i222+7, std::greater<int>()).check([&](int *r){ CHECK(r == i222+2); });
    is_heap_until(i223, i223+7, std::greater<int>()).check([&](int *r){ CHECK(r == i223+2); });
    is_heap_until(i224, i224+7, std::greater<int>()).check([&](int *r){ CHECK(r == i224+2); });
    is_heap_until(i225, i225+7, std::greater<int>()).check([&](int *r){ CHECK(r == i225+2); });
    is_heap_until(i226, i226+7, std::greater<int>()).check([&](int *r){ CHECK(r == i226+2); });
    is_heap_until(i227, i227+7, std::greater<int>()).check([&](int *r){ CHECK(r == i227+2); });
    is_heap_until(i228, i228+7, std::greater<int>()).check([&](int *r){ CHECK(r == i228+2); });
    is_heap_until(i229, i229+7, std::greater<int>()).check([&](int *r){ CHECK(r == i229+2); });
    is_heap_until(i230, i230+7, std::greater<int>()).check([&](int *r){ CHECK(r == i230+2); });
    is_heap_until(i231, i231+7, std::greater<int>()).check([&](int *r){ CHECK(r == i231+2); });
    is_heap_until(i232, i232+7, std::greater<int>()).check([&](int *r){ CHECK(r == i232+3); });
    is_heap_until(i233, i233+7, std::greater<int>()).check([&](int *r){ CHECK(r == i233+3); });
    is_heap_until(i234, i234+7, std::greater<int>()).check([&](int *r){ CHECK(r == i234+3); });
    is_heap_until(i235, i235+7, std::greater<int>()).check([&](int *r){ CHECK(r == i235+3); });
    is_heap_until(i236, i236+7, std::greater<int>()).check([&](int *r){ CHECK(r == i236+3); });
    is_heap_until(i237, i237+7, std::greater<int>()).check([&](int *r){ CHECK(r == i237+3); });
    is_heap_until(i238, i238+7, std::greater<int>()).check([&](int *r){ CHECK(r == i238+3); });
    is_heap_until(i239, i239+7, std::greater<int>()).check([&](int *r){ CHECK(r == i239+3); });
    is_heap_until(i240, i240+7, std::greater<int>()).check([&](int *r){ CHECK(r == i240+4); });
    is_heap_until(i241, i241+7, std::greater<int>()).check([&](int *r){ CHECK(r == i241+4); });
    is_heap_until(i242, i242+7, std::greater<int>()).check([&](int *r){ CHECK(r == i242+4); });
    is_heap_until(i243, i243+7, std::greater<int>()).check([&](int *r){ CHECK(r == i243+4); });
    is_heap_until(i244, i244+7, std::greater<int>()).check([&](int *r){ CHECK(r == i244+5); });
    is_heap_until(i245, i245+7, std::greater<int>()).check([&](int *r){ CHECK(r == i245+5); });
    is_heap_until(i246, i246+7, std::greater<int>()).check([&](int *r){ CHECK(r == i246+6); });
#endif
}

struct S
{
    int i;
};

int main()
{
    test();
    test_pred();

    // Test projections:
    S i185[] = {S{1}, S{0}, S{0}, S{0}, S{0}, S{0}, S{1}};
    ::make_testable_1(ranges::is_heap_until)(i185, i185+7, std::greater<int>(), &S::i)
        .check([&](S *r){ CHECK(r == i185+1); });

    // Test rvalue range
    auto res = ranges::is_heap_until(ranges::view::all(i185), std::greater<int>(), &S::i);
    CHECK(res.get_unsafe() == i185+1);

    return ::test_result();
}
