/*  RetroArch - A frontend for libretro.
 *  Copyright (C) 2010-2014 - Hans-Kristian Arntzen
 *  Copyright (C) 2011-2016 - Daniel De Matteis
 * 
 *  RetroArch is free software: you can redistribute it and/or modify it under the terms
 *  of the GNU General Public License as published by the Free Software Found-
 *  ation, either version 3 of the License, or (at your option) any later version.
 *
 *  RetroArch is distributed in the hope that it will be useful, but WITHOUT ANY WARRANTY;
 *  without even the implied warranty of MERCHANTABILITY or FITNESS FOR A PARTICULAR
 *  PURPOSE.  See the GNU General Public License for more details.
 *
 *  You should have received a copy of the GNU General Public License along with RetroArch.
 *  If not, see <http://www.gnu.org/licenses/>.
 */

#ifndef __MSG_HASH_H
#define __MSG_HASH_H

#include <stdint.h>
#include <stddef.h>

#include <retro_common_api.h>

#include "driver.h"
#include "input/input_driver.h"

RETRO_BEGIN_DECLS

enum msg_file_type
{
   FILE_TYPE_NONE = 0,
   FILE_TYPE_PLAIN,
   FILE_TYPE_DIRECTORY,
   FILE_TYPE_PARENT_DIRECTORY,
   FILE_TYPE_PATH,
   FILE_TYPE_DEVICE,
   FILE_TYPE_CORE,
   FILE_TYPE_PLAYLIST_ENTRY,
   FILE_TYPE_CONTENTLIST_ENTRY,
   FILE_TYPE_SHADER_PRESET,
   FILE_TYPE_SHADER,
   FILE_TYPE_VIDEOFILTER,
   FILE_TYPE_AUDIOFILTER,
   FILE_TYPE_CHEAT,
   FILE_TYPE_OVERLAY,
   FILE_TYPE_FONT,
   FILE_TYPE_CONFIG,
   FILE_TYPE_USE_DIRECTORY,
   FILE_TYPE_SCAN_DIRECTORY,
   FILE_TYPE_CARCHIVE,
   FILE_TYPE_IN_CARCHIVE,
   FILE_TYPE_IMAGE,
   FILE_TYPE_IMAGEVIEWER,
   FILE_TYPE_REMAP,
   FILE_TYPE_DOWNLOAD_CORE,
   FILE_TYPE_DOWNLOAD_URL,
   FILE_TYPE_DOWNLOAD_CORE_CONTENT,
   FILE_TYPE_DOWNLOAD_CORE_INFO,
   FILE_TYPE_DOWNLOAD_THUMBNAIL_CONTENT,
   FILE_TYPE_DOWNLOAD_LAKKA,
   FILE_TYPE_RDB,
   FILE_TYPE_RDB_ENTRY,
   FILE_TYPE_RPL_ENTRY,
   FILE_TYPE_CURSOR,
   FILE_TYPE_BOOL_ON,
   FILE_TYPE_BOOL_OFF,
   FILE_TYPE_RECORD_CONFIG,
   FILE_TYPE_PLAYLIST_COLLECTION,
   FILE_TYPE_PLAYLIST_ASSOCIATION,
   FILE_TYPE_MOVIE,
   FILE_TYPE_MUSIC,
   FILE_TYPE_SHADER_SLANG,
   FILE_TYPE_SHADER_GLSL,
   FILE_TYPE_SHADER_HLSL,
   FILE_TYPE_SHADER_CG,
   FILE_TYPE_SHADER_PRESET_GLSLP,
   FILE_TYPE_SHADER_PRESET_HLSLP,
   FILE_TYPE_SHADER_PRESET_CGP,
   FILE_TYPE_SHADER_PRESET_SLANGP,
   FILE_TYPE_DOWNLOAD_THUMBNAIL,
   FILE_TYPE_MORE,
   FILE_TYPE_COMPRESSED,
   FILE_TYPE_SHA1,
   FILE_TYPE_MD5,
   FILE_TYPE_CRC,

   FILE_TYPE_WEBM,
   FILE_TYPE_F4F,
   FILE_TYPE_F4V,
   FILE_TYPE_OGM,
   FILE_TYPE_MKV,
   FILE_TYPE_AVI,
   FILE_TYPE_M4A,
   FILE_TYPE_3GP,
   FILE_TYPE_MP4,
   FILE_TYPE_MP3,
   FILE_TYPE_FLAC,
   FILE_TYPE_OGG,
   FILE_TYPE_FLV,
   FILE_TYPE_WAV,
   FILE_TYPE_MOV,
   FILE_TYPE_WMV,

   FILE_TYPE_JPEG,
   FILE_TYPE_PNG,
   FILE_TYPE_TGA,
   FILE_TYPE_BMP,

   FILE_TYPE_CUE,
   FILE_TYPE_ISO,
   FILE_TYPE_LUTRO,

   FILE_TYPE_LAST
};

enum msg_hash_enums
{
   MSG_UNKNOWN = 0,
   MSG_LIBRETRO_FRONTEND,
   MSG_LOADING,
   MSG_CONNECTED_TO,
   MSG_FAILED_TO_LOAD,
   MSG_USING_CORE_NAME_FOR_NEW_CONFIG,
   MSG_SAVED_NEW_CONFIG_TO,
   MSG_FAILED_SAVING_CONFIG_TO,
   MSG_INFLATED_CHECKSUM_DID_NOT_MATCH_CRC32,
   MSG_FAILED_TO_EXTRACT_CONTENT_FROM_COMPRESSED_FILE,
   MSG_FILE_NOT_FOUND,
   MSG_RESTORED_OLD_SAVE_STATE,
   MSG_NO_STATE_HAS_BEEN_LOADED_YET,
   MSG_NO_SAVE_STATE_HAS_BEEN_OVERWRITTEN_YET,
   MSG_CANNOT_INFER_NEW_CONFIG_PATH,
   MSG_UNDID_LOAD_STATE,
   MSG_UNDID_SAVE_STATE,
   MSG_FAILED_TO_ACCEPT_INCOMING_SPECTATOR,
   MSG_FAILED_TO_GET_NICKNAME_FROM_CLIENT,
   MSG_FAILED_TO_SEND_NICKNAME_TO_CLIENT,
   MSG_FAILED_TO_SEND_NICKNAME_TO_HOST,
   MSG_FAILED_TO_GENERATE_BSV_HEADER,
   MSG_FAILED_TO_SEND_HEADER_TO_CLIENT,
   MSG_FAILED_TO_RECEIVE_NICKNAME_SIZE_FROM_HOST,
   MSG_FAILED_TO_RECEIVE_NICKNAME,
   MSG_FAILED_TO_RECEIVE_NICKNAME_FROM_HOST,
   MSG_FAILED_TO_RECEIVE_HEADER_FROM_CLIENT,
   MSG_FAILED_TO_RECEIVE_SRAM_DATA_FROM_HOST,
   MSG_FAILED_TO_SEND_NICKNAME_SIZE,
   MSG_FAILED_TO_SEND_NICKNAME,
   MSG_FAILED_TO_SEND_SRAM_DATA_TO_CLIENT,
   MSG_GAME_SPECIFIC_CORE_OPTIONS_FOUND_AT,
   MSG_INVALID_NICKNAME_SIZE,
   MSG_VERSION_OF_LIBRETRO_API,
   MSG_COMPILED_AGAINST_API,
   MSG_ERROR_LIBRETRO_CORE_REQUIRES_SPECIAL_CONTENT,
   MSG_ERROR_LIBRETRO_CORE_REQUIRES_CONTENT,
   MSG_SEVERAL_PATCHES_ARE_EXPLICITLY_DEFINED,
   MSG_DID_NOT_FIND_A_VALID_CONTENT_PATCH,
   MSG_FAILED_TO_ALLOCATE_MEMORY_FOR_PATCHED_CONTENT,
   MSG_CONTENT_LOADING_SKIPPED_IMPLEMENTATION_WILL_DO_IT,
   MSG_PROGRAM,
   MSG_ERROR,
   MSG_FOUND_DISK_LABEL,
   MSG_READING_FIRST_DATA_TRACK,
   MSG_COULD_NOT_FIND_COMPATIBLE_SYSTEM,
   MSG_COMPARING_WITH_KNOWN_MAGIC_NUMBERS,
   MSG_COULD_NOT_FIND_VALID_DATA_TRACK,
   MSG_COULD_NOT_OPEN_DATA_TRACK,
   MSG_FOUND_FIRST_DATA_TRACK_ON_FILE,
   MSG_FRAMES,
   MSG_FOUND_SHADER,
   MSG_LOADING_HISTORY_FILE,
   MSG_COULD_NOT_READ_STATE_FROM_MOVIE,
   MSG_MOVIE_FILE_IS_NOT_A_VALID_BSV1_FILE,
   MSG_AUTOCONFIG_FILE_SAVED_SUCCESSFULLY,
   MSG_AUTOCONFIG_FILE_ERROR_SAVING,
   MSG_SRAM_WILL_NOT_BE_SAVED,
   MSG_RECEIVED,
   MSG_LOADING_CONTENT_FILE,
   MSG_FATAL_ERROR_RECEIVED_IN,
   MSG_FAILED_TO_PATCH,
   MSG_COULD_NOT_READ_MOVIE_HEADER,
   MSG_CRC32_CHECKSUM_MISMATCH,
   MSG_CONTENT_PATCHED_SUCCESSFULLY_IN,
   MSG_USING_LIBRETRO_DUMMY_CORE_RECORDING_SKIPPED,
   MSG_FAILED_TO_OPEN_LIBRETRO_CORE,
   MSG_COULD_NOT_FIND_ANY_NEXT_DRIVER,
   MSG_MOVIE_FORMAT_DIFFERENT_SERIALIZER_VERSION,
   MSG_CONTENT_CRC32S_DIFFER,
   MSG_RECORDING_TERMINATED_DUE_TO_RESIZE,
   MSG_FAILED_TO_START_RECORDING,
   MSG_REVERTING_SAVEFILE_DIRECTORY_TO,
   MSG_ERROR_PARSING_ARGUMENTS,
   MSG_REVERTING_SAVESTATE_DIRECTORY_TO,
   MSG_DOWNLOAD_FAILED,
   MSG_INPUT_CHEAT,
   MSG_INPUT_PRESET_FILENAME,
   MSG_INPUT_CHEAT_FILENAME,
   MSG_REMAP_FILE_SAVED_SUCCESSFULLY,
   MSG_ERROR_SAVING_REMAP_FILE,
   MSG_FAILED_TO_CREATE_THE_DIRECTORY,
   MSG_ERROR_SAVING_CORE_OPTIONS_FILE,
   MSG_CORE_OPTIONS_FILE_CREATED_SUCCESSFULLY,
   MSG_DECOMPRESSION_ALREADY_IN_PROGRESS,
   MSG_DECOMPRESSION_FAILED,
   MSG_DISK_EJECTED,
   MSG_DISK_CLOSED,
   MSG_REWIND_INIT,
   MSG_REWIND_INIT_FAILED,
   MSG_REWIND_INIT_FAILED_THREADED_AUDIO,
   MSG_REWIND_INIT_FAILED_NO_SAVESTATES,
   MSG_LIBRETRO_ABI_BREAK,
   MSG_NETPLAY_FAILED,
   MSG_NETPLAY_FAILED_MOVIE_PLAYBACK_HAS_STARTED,
   MSG_DETECTED_VIEWPORT_OF,
   MSG_RECORDING_TO,
   MSG_HW_RENDERED_MUST_USE_POSTSHADED_RECORDING,
   MSG_VIEWPORT_SIZE_CALCULATION_FAILED,
   MSG_AUTOSAVE_FAILED,
   MSG_MOVIE_RECORD_STOPPED,
   MSG_MOVIE_PLAYBACK_ENDED,
   MSG_TAKING_SCREENSHOT,
   MSG_FAILED_TO_TAKE_SCREENSHOT,
   MSG_CUSTOM_TIMING_GIVEN,
   MSG_SAVING_STATE,
   MSG_LOADING_STATE,
   MSG_FAILED_TO_SAVE_STATE_TO,
   MSG_FAILED_TO_SAVE_SRAM,
   MSG_STATE_SIZE,
   MSG_FAILED_TO_LOAD_CONTENT,
   MSG_COULD_NOT_READ_CONTENT_FILE,
   MSG_SAVED_SUCCESSFULLY_TO,
   MSG_BYTES,
   MSG_BLOCKING_SRAM_OVERWRITE,
   MSG_UNRECOGNIZED_COMMAND,
   MSG_SENDING_COMMAND,
   MSG_RESTARTING_RECORDING_DUE_TO_DRIVER_REINIT,
   MSG_REWINDING,
   MSG_SLOW_MOTION_REWIND,
   MSG_SLOW_MOTION,
   MSG_REWIND_REACHED_END,
   MSG_FAILED_TO_START_MOVIE_RECORD,
   MSG_CHEEVOS_HARDCORE_MODE_ENABLE,
   MSG_STATE_SLOT,
   MSG_STARTING_MOVIE_RECORD_TO,
   MSG_FAILED_TO_APPLY_SHADER,
   MSG_APPLYING_SHADER,
   MSG_SHADER,
   MSG_REDIRECTING_SAVESTATE_TO,
   MSG_REDIRECTING_SAVEFILE_TO,
   MSG_REDIRECTING_CHEATFILE_TO,
   MSG_SCANNING,
   MSG_SCANNING_OF_DIRECTORY_FINISHED,
   MSG_COULD_NOT_PROCESS_ZIP_FILE,
   MSG_LOADED_STATE_FROM_SLOT,
   MSG_REMOVING_TEMPORARY_CONTENT_FILE,
   MSG_FAILED_TO_REMOVE_TEMPORARY_FILE,
   MSG_STARTING_MOVIE_PLAYBACK,
   MSG_APPENDED_DISK,
   MSG_SKIPPING_SRAM_LOAD,
   MSG_CONFIG_DIRECTORY_NOT_SET,
   MSG_SAVED_STATE_TO_SLOT,
   MSG_CORE_DOES_NOT_SUPPORT_SAVESTATES,
   MSG_FAILED_TO_LOAD_STATE,
   MSG_FAILED_TO_UNDO_LOAD_STATE,
   MSG_FAILED_TO_UNDO_SAVE_STATE,
   MSG_RESET,
   MSG_AUDIO_MUTED,
   MSG_AUDIO_UNMUTED,
   MSG_FAILED_TO_UNMUTE_AUDIO,
   MSG_FAILED_TO_LOAD_OVERLAY,
   MSG_PAUSED,
   MSG_UNPAUSED,
   MSG_CORE_DOES_NOT_SUPPORT_DISK_OPTIONS,
   MSG_GRAB_MOUSE_STATE,
   MSG_FAILED_TO_LOAD_MOVIE_FILE,
   MSG_FAILED_TO,
   MSG_SAVING_RAM_TYPE,
   MSG_TO,
   MSG_VIRTUAL_DISK_TRAY,
   MSG_REMOVED_DISK_FROM_TRAY,
   MSG_FAILED_TO_REMOVE_DISK_FROM_TRAY,
   MSG_GOT_INVALID_DISK_INDEX,
   MSG_TASK_FAILED,
   MSG_DOWNLOADING,
   MSG_EXTRACTING,
   MSG_EXTRACTING_FILE,
   MSG_NO_CONTENT_STARTING_DUMMY_CORE,

   MENU_ENUM_LABEL_VALUE_REMAP_FILE,
   MENU_ENUM_LABEL_VALUE_CHEAT_FILE,
   MENU_ENUM_LABEL_INPUT_HOTKEY_BIND_BEGIN,
   MENU_ENUM_LABEL_INPUT_HOTKEY_BIND_END   = MENU_ENUM_LABEL_INPUT_HOTKEY_BIND_BEGIN + RARCH_BIND_LIST_END,

   MENU_ENUM_LABEL_MENU_WALLPAPER_OPACITY,
   MENU_ENUM_LABEL_VALUE_MENU_WALLPAPER_OPACITY,

   MENU_ENUM_LABEL_VALUE_CONFIG,
   MENU_ENUM_LABEL_VALUE_VIDEO_SHADER_PRESET,
   MENU_ENUM_LABEL_VALUE_OVERLAY,
   MENU_ENUM_LABEL_VALUE_AUTO,

   MENU_ENUM_LABEL_VALUE_XMB_ICON_THEME_MONOCHROME,
   MENU_ENUM_LABEL_VALUE_XMB_ICON_THEME_FLATUI,
   MENU_ENUM_LABEL_VALUE_XMB_ICON_THEME_RETROACTIVE,
   MENU_ENUM_LABEL_VALUE_XMB_ICON_THEME_PIXEL,
   MENU_ENUM_LABEL_VALUE_XMB_ICON_THEME_CUSTOM,

   MENU_ENUM_LABEL_VALUE_XMB_MENU_COLOR_THEME_LEGACY_RED,
   MENU_ENUM_LABEL_VALUE_XMB_MENU_COLOR_THEME_DARK_PURPLE,
   MENU_ENUM_LABEL_VALUE_XMB_MENU_COLOR_THEME_MIDNIGHT_BLUE,
   MENU_ENUM_LABEL_VALUE_XMB_MENU_COLOR_THEME_GOLDEN,
   MENU_ENUM_LABEL_VALUE_XMB_MENU_COLOR_THEME_ELECTRIC_BLUE,
   MENU_ENUM_LABEL_VALUE_XMB_MENU_COLOR_THEME_APPLE_GREEN,
   MENU_ENUM_LABEL_VALUE_XMB_MENU_COLOR_THEME_UNDERSEA,
   MENU_ENUM_LABEL_VALUE_XMB_MENU_COLOR_THEME_VOLCANIC_RED,
   MENU_ENUM_LABEL_VALUE_XMB_MENU_COLOR_THEME_DARK,
   MENU_ENUM_LABEL_VALUE_XMB_MENU_COLOR_THEME_PLAIN,

   MENU_ENUM_LABEL_VALUE_SHADER_PIPELINE_RIBBON_SIMPLIFIED,
   MENU_ENUM_LABEL_VALUE_SHADER_PIPELINE_RIBBON,

   MENU_ENUM_LABEL_MATERIALUI_MENU_HEADER_OPACITY,
   MENU_ENUM_LABEL_VALUE_MATERIALUI_MENU_HEADER_OPACITY,
   MENU_ENUM_LABEL_MATERIALUI_MENU_FOOTER_OPACITY,
   MENU_ENUM_LABEL_VALUE_MATERIALUI_MENU_FOOTER_OPACITY,
   MENU_ENUM_LABEL_VALUE_MATERIALUI_MENU_COLOR_THEME_BLUE,
   MENU_ENUM_LABEL_VALUE_MATERIALUI_MENU_COLOR_THEME_BLUE_GREY,
   MENU_ENUM_LABEL_VALUE_MATERIALUI_MENU_COLOR_THEME_RED,
   MENU_ENUM_LABEL_VALUE_MATERIALUI_MENU_COLOR_THEME_GREEN,
   MENU_ENUM_LABEL_VALUE_MATERIALUI_MENU_COLOR_THEME_YELLOW,
   MENU_ENUM_LABEL_VALUE_MATERIALUI_MENU_COLOR_THEME_NVIDIA_SHIELD,
   MENU_ENUM_LABEL_VALUE_MATERIALUI_MENU_COLOR_THEME_DARK_BLUE,

   MENU_ENUM_LABEL_VALUE_INPUT_POLL_TYPE_BEHAVIOR_LATE,
   MENU_ENUM_LABEL_VALUE_INPUT_POLL_TYPE_BEHAVIOR_NORMAL,
   MENU_ENUM_LABEL_VALUE_INPUT_POLL_TYPE_BEHAVIOR_EARLY,
   MENU_ENUM_LABEL_PLAYLIST_COLLECTION_ENTRY,
   MENU_ENUM_LABEL_VALUE_CHEEVOS_UNLOCKED_ENTRY,
   MENU_ENUM_LABEL_CHEEVOS_UNLOCKED_ENTRY,
   MENU_ENUM_LABEL_VALUE_CHEEVOS_LOCKED_ENTRY,
   MENU_ENUM_LABEL_CHEEVOS_LOCKED_ENTRY,
   MENU_ENUM_LABEL_FILEBROWSER_ENTRY,
   MENU_ENUM_LABEL_SHADER_PARAMETERS_ENTRY,
   MENU_ENUM_LABEL_RDB_ENTRY,
   MENU_ENUM_LABEL_URL_ENTRY,
   MENU_ENUM_LABEL_CORE_OPTION_ENTRY,
   MENU_ENUM_LABEL_DEBUG_INFO_ENTRY,
   MENU_ENUM_LABEL_NETWORK_INFO_ENTRY,
   MENU_ENUM_LABEL_SYSTEM_INFO_ENTRY,
   MENU_ENUM_LABEL_CORE_INFO_ENTRY,
   MENU_ENUM_LABEL_PLAYLIST_ENTRY,
   MENU_ENUM_LABEL_START_NET_RETROPAD,
   MENU_ENUM_LABEL_VALUE_START_NET_RETROPAD,

   MENU_ENUM_LABEL_VALUE_INTERNAL_STORAGE_STATUS,

   /* System information */

   MENU_ENUM_LABEL_CPU_ARCHITECTURE,
   MENU_ENUM_LABEL_CPU_CORES,

   MENU_ENUM_LABEL_VALUE_CPU_ARCHITECTURE,
   MENU_ENUM_LABEL_VALUE_CPU_CORES,

   /* Input  */
   
   MENU_ENUM_LABEL_INPUT_LIBRETRO_DEVICE,
   MENU_ENUM_LABEL_INPUT_PLAYER_ANALOG_DPAD_MODE,
   MENU_ENUM_LABEL_INPUT_BACK_AS_MENU_TOGGLE,
   MENU_ENUM_LABEL_INPUT_BACK_AS_MENU_TOGGLE_ENABLE,
   MENU_ENUM_LABEL_INPUT_HOTKEY_BINDS_BEGIN,
   MENU_ENUM_LABEL_INPUT_KEYBOARD_GAMEPAD_MAPPING_TYPE,
   MENU_ENUM_LABEL_INPUT_POLL_TYPE_BEHAVIOR,
   MENU_ENUM_LABEL_INPUT_SETTINGS,
   MENU_ENUM_LABEL_INPUT_SETTINGS_BEGIN,
   MENU_ENUM_LABEL_INPUT_OVERLAY_HIDE_IN_MENU,
   MENU_ENUM_LABEL_INPUT_BACK_AS_MENU_ENUM_TOGGLE_ENABLE,
   MENU_ENUM_LABEL_INPUT_MENU_ENUM_TOGGLE_GAMEPAD_COMBO,
   MENU_ENUM_LABEL_INPUT_HOTKEY_BINDS,
   MENU_ENUM_LABEL_INPUT_OSK_OVERLAY_ENABLE,
   MENU_ENUM_LABEL_INPUT_OVERLAY_ENABLE,
   MENU_ENUM_LABEL_INPUT_PLAYER1_JOYPAD_INDEX,
   MENU_ENUM_LABEL_INPUT_PLAYER2_JOYPAD_INDEX,
   MENU_ENUM_LABEL_INPUT_PLAYER3_JOYPAD_INDEX,
   MENU_ENUM_LABEL_INPUT_PLAYER4_JOYPAD_INDEX,
   MENU_ENUM_LABEL_INPUT_PLAYER5_JOYPAD_INDEX,
   MENU_ENUM_LABEL_INPUT_BIND_DEVICE_ID,
   MENU_ENUM_LABEL_INPUT_BIND_DEVICE_TYPE,
   MENU_ENUM_LABEL_INPUT_DRIVER_LINUXRAW,
   MENU_ENUM_LABEL_INPUT_DRIVER_UDEV,
   MENU_ENUM_LABEL_INPUT_BIND_TIMEOUT,
   MENU_ENUM_LABEL_INPUT_TURBO_PERIOD,
   MENU_ENUM_LABEL_INPUT_MAX_USERS,
   MENU_ENUM_LABEL_INPUT_REMAP_BINDS_ENABLE,
   MENU_ENUM_LABEL_INPUT_AXIS_THRESHOLD,
   MENU_ENUM_LABEL_INPUT_SMALL_KEYBOARD_ENABLE,
   MENU_ENUM_LABEL_INPUT_ICADE_ENABLE,
   MENU_ENUM_LABEL_INPUT_USER_1_BINDS,
   MENU_ENUM_LABEL_INPUT_USER_2_BINDS,
   MENU_ENUM_LABEL_INPUT_USER_3_BINDS,
   MENU_ENUM_LABEL_INPUT_USER_4_BINDS,
   MENU_ENUM_LABEL_INPUT_USER_5_BINDS,
   MENU_ENUM_LABEL_INPUT_USER_6_BINDS,
   MENU_ENUM_LABEL_INPUT_USER_7_BINDS,
   MENU_ENUM_LABEL_INPUT_USER_8_BINDS,
   MENU_ENUM_LABEL_INPUT_USER_9_BINDS,
   MENU_ENUM_LABEL_INPUT_USER_10_BINDS,
   MENU_ENUM_LABEL_INPUT_USER_11_BINDS,
   MENU_ENUM_LABEL_INPUT_USER_12_BINDS,
   MENU_ENUM_LABEL_INPUT_USER_13_BINDS,
   MENU_ENUM_LABEL_INPUT_USER_14_BINDS,
   MENU_ENUM_LABEL_INPUT_USER_15_BINDS,
   MENU_ENUM_LABEL_INPUT_USER_16_BINDS,
   MENU_ENUM_LABEL_INPUT_HOTKEY_SETTINGS,
   MENU_ENUM_LABEL_INPUT_AUTODETECT_ENABLE,
   MENU_ENUM_LABEL_INPUT_REMAPPING_DIRECTORY,
   MENU_ENUM_LABEL_INPUT_DUTY_CYCLE,
   MENU_ENUM_LABEL_INPUT_BIND_MODE,
   MENU_ENUM_LABEL_INPUT_DESCRIPTOR_HIDE_UNBOUND,
   MENU_ENUM_LABEL_INPUT_DESCRIPTOR_LABEL_SHOW,
   MENU_ENUM_LABEL_INPUT_OVERLAY,
   MENU_ENUM_LABEL_INPUT_OSK_OVERLAY,

   MENU_ENUM_LABEL_VALUE_INPUT_USER_BINDS,
   MENU_ENUM_LABEL_VALUE_INPUT_AUTODETECT_ENABLE,
   MENU_ENUM_LABEL_VALUE_INPUT_DUTY_CYCLE,
   MENU_ENUM_LABEL_VALUE_INPUT_DESCRIPTOR_LABEL_SHOW,
   MENU_ENUM_LABEL_VALUE_INPUT_DESCRIPTOR_HIDE_UNBOUND,
   MENU_ENUM_LABEL_VALUE_INPUT_BIND_MODE,
   MENU_ENUM_LABEL_VALUE_INPUT_MAX_USERS,
   MENU_ENUM_LABEL_VALUE_INPUT_REMAP_BINDS_ENABLE,
   MENU_ENUM_LABEL_VALUE_INPUT_AXIS_THRESHOLD,
   MENU_ENUM_LABEL_VALUE_INPUT_BIND_TIMEOUT,
   MENU_ENUM_LABEL_VALUE_INPUT_TURBO_PERIOD,
   MENU_ENUM_LABEL_VALUE_INPUT_OVERLAY_ENABLE,
   MENU_ENUM_LABEL_VALUE_INPUT_OSK_OVERLAY_ENABLE,
   MENU_ENUM_LABEL_VALUE_INPUT_HOTKEY_BINDS,
   MENU_ENUM_LABEL_VALUE_INPUT_BACK_AS_MENU_ENUM_TOGGLE_ENABLE,
   MENU_ENUM_LABEL_VALUE_INPUT_MENU_ENUM_TOGGLE_GAMEPAD_COMBO,
   MENU_ENUM_LABEL_VALUE_INPUT_OVERLAY_HIDE_IN_MENU,
   MENU_ENUM_LABEL_VALUE_INPUT_KEYBOARD_GAMEPAD_MAPPING_TYPE,
   MENU_ENUM_LABEL_VALUE_INPUT_POLL_TYPE_BEHAVIOR,
   MENU_ENUM_LABEL_VALUE_INPUT_BACK_AS_MENU_TOGGLE_ENABLE,
   MENU_ENUM_LABEL_VALUE_INPUT_SMALL_KEYBOARD_ENABLE,
   MENU_ENUM_LABEL_VALUE_INPUT_ICADE_ENABLE,

   /* Video */
   MENU_ENUM_LABEL_VIDEO_FONT_ENABLE,
   MENU_ENUM_LABEL_VIDEO_FONT_PATH,
   MENU_ENUM_LABEL_VIDEO_FONT_SIZE,
   MENU_ENUM_LABEL_VIDEO_MESSAGE_POS_X,
   MENU_ENUM_LABEL_VIDEO_MESSAGE_POS_Y,
   MENU_ENUM_LABEL_VIDEO_FILTER_FLICKER,
   MENU_ENUM_LABEL_VIDEO_SOFT_FILTER,
   MENU_ENUM_LABEL_VIDEO_SWAP_INTERVAL,
   MENU_ENUM_LABEL_VIDEO_MAX_SWAPCHAIN_IMAGES,
   MENU_ENUM_LABEL_VIDEO_GPU_SCREENSHOT,
   MENU_ENUM_LABEL_VIDEO_FULLSCREEN,
   MENU_ENUM_LABEL_VIDEO_BLACK_FRAME_INSERTION,
   MENU_ENUM_LABEL_VIDEO_HARD_SYNC_FRAMES,
   MENU_ENUM_LABEL_VIDEO_FRAME_DELAY,
   MENU_ENUM_LABEL_VIDEO_THREADED,
   MENU_ENUM_LABEL_VIDEO_VSYNC,
   MENU_ENUM_LABEL_VIDEO_HARD_SYNC,
   MENU_ENUM_LABEL_VIDEO_MONITOR_INDEX,
   MENU_ENUM_LABEL_VIDEO_REFRESH_RATE_AUTO,
   MENU_ENUM_LABEL_VIDEO_REFRESH_RATE,
   MENU_ENUM_LABEL_VIDEO_WINDOWED_FULLSCREEN,
   MENU_ENUM_LABEL_VIDEO_FORCE_SRGB_DISABLE,
   MENU_ENUM_LABEL_VIDEO_ROTATION,
   MENU_ENUM_LABEL_VIDEO_SCALE,
   MENU_ENUM_LABEL_VIDEO_SMOOTH,
   MENU_ENUM_LABEL_VIDEO_CROP_OVERSCAN,
   MENU_ENUM_LABEL_VIDEO_SCALE_INTEGER,
   MENU_ENUM_LABEL_VIDEO_VIEWPORT_CUSTOM_X,
   MENU_ENUM_LABEL_VIDEO_VIEWPORT_CUSTOM_Y,
   MENU_ENUM_LABEL_VIDEO_VIEWPORT_CUSTOM_WIDTH,
   MENU_ENUM_LABEL_VIDEO_VIEWPORT_CUSTOM_HEIGHT,
   MENU_ENUM_LABEL_VIDEO_SHARED_CONTEXT,
   MENU_ENUM_LABEL_VIDEO_GAMMA,
   MENU_ENUM_LABEL_VIDEO_ALLOW_ROTATE,

   MENU_ENUM_LABEL_VALUE_VIDEO_VI_WIDTH,
   MENU_ENUM_LABEL_VALUE_VIDEO_SETTINGS,
   MENU_ENUM_LABEL_VALUE_VIDEO_FILTER,
   MENU_ENUM_LABEL_VALUE_VIDEO_FONT_ENABLE,
   MENU_ENUM_LABEL_VALUE_VIDEO_FONT_PATH,
   MENU_ENUM_LABEL_VALUE_VIDEO_FONT_SIZE,
   MENU_ENUM_LABEL_VALUE_VIDEO_MESSAGE_POS_X,
   MENU_ENUM_LABEL_VALUE_VIDEO_MESSAGE_POS_Y,
   MENU_ENUM_LABEL_VALUE_VIDEO_FILTER_FLICKER,
   MENU_ENUM_LABEL_VALUE_VIDEO_SOFT_FILTER,
   MENU_ENUM_LABEL_VALUE_VIDEO_BLACK_FRAME_INSERTION,
   MENU_ENUM_LABEL_VALUE_VIDEO_HARD_SYNC_FRAMES,
   MENU_ENUM_LABEL_VALUE_VIDEO_FRAME_DELAY,
   MENU_ENUM_LABEL_VALUE_VIDEO_ROTATION,
   MENU_ENUM_LABEL_VALUE_VIDEO_THREADED,
   MENU_ENUM_LABEL_VALUE_VIDEO_VSYNC,
   MENU_ENUM_LABEL_VALUE_VIDEO_HARD_SYNC,
   MENU_ENUM_LABEL_VALUE_VIDEO_SWAP_INTERVAL,
   MENU_ENUM_LABEL_VALUE_VIDEO_MAX_SWAPCHAIN_IMAGES,
   MENU_ENUM_LABEL_VALUE_VIDEO_GPU_SCREENSHOT,
   MENU_ENUM_LABEL_VALUE_VIDEO_FULLSCREEN,
   MENU_ENUM_LABEL_VALUE_VIDEO_FORCE_ASPECT,
   MENU_ENUM_LABEL_VALUE_VIDEO_ASPECT_RATIO_AUTO,
   MENU_ENUM_LABEL_VALUE_VIDEO_ASPECT_RATIO_INDEX,
   MENU_ENUM_LABEL_VALUE_VIDEO_VFILTER,
   MENU_ENUM_LABEL_VALUE_VIDEO_GPU_RECORD,
   MENU_ENUM_LABEL_VALUE_VIDEO_GAMMA,
   MENU_ENUM_LABEL_VALUE_VIDEO_ALLOW_ROTATE,
   MENU_ENUM_LABEL_VALUE_VIDEO_SHARED_CONTEXT,
   MENU_ENUM_LABEL_VALUE_VIDEO_MONITOR_INDEX,
   MENU_ENUM_LABEL_VALUE_VIDEO_REFRESH_RATE,
   MENU_ENUM_LABEL_VALUE_VIDEO_WINDOWED_FULLSCREEN,
   MENU_ENUM_LABEL_VALUE_VIDEO_FORCE_SRGB_DISABLE,
   MENU_ENUM_LABEL_VALUE_VIDEO_SCALE,
   MENU_ENUM_LABEL_VALUE_VIDEO_SMOOTH,
   MENU_ENUM_LABEL_VALUE_VIDEO_CROP_OVERSCAN,
   MENU_ENUM_LABEL_VALUE_VIDEO_SCALE_INTEGER,
   MENU_ENUM_LABEL_VALUE_VIDEO_REFRESH_RATE_AUTO,
   MENU_ENUM_LABEL_VALUE_VIDEO_VIEWPORT_CUSTOM_X,
   MENU_ENUM_LABEL_VALUE_VIDEO_VIEWPORT_CUSTOM_Y,
   MENU_ENUM_LABEL_VALUE_VIDEO_VIEWPORT_CUSTOM_WIDTH,
   MENU_ENUM_LABEL_VALUE_VIDEO_VIEWPORT_CUSTOM_HEIGHT,
   MENU_ENUM_LABEL_VALUE_VIDEO_DISABLE_COMPOSITION,
   
   MENU_ENUM_LABEL_VALUE_DOWNLOAD_CORE,

   MENU_ENUM_LABEL_VALUE_PARENT_DIRECTORY,
   MENU_ENUM_LABEL_PARENT_DIRECTORY,

   MENU_ENUM_LABEL_CONTENT_ACTIONS,

   MENU_ENUM_LABEL_RUN,


   /* Menu settings */
   MENU_ENUM_LABEL_MENU_WALLPAPER,
   MENU_ENUM_LABEL_DYNAMIC_WALLPAPER,
   MENU_ENUM_LABEL_PAUSE_NONACTIVE,
   MENU_ENUM_LABEL_MOUSE_ENABLE,
   MENU_ENUM_LABEL_POINTER_ENABLE,
   MENU_ENUM_LABEL_MENU_LINEAR_FILTER,
   MENU_ENUM_LABEL_NAVIGATION_WRAPAROUND,
   MENU_ENUM_LABEL_SHOW_ADVANCED_SETTINGS,
   MENU_ENUM_LABEL_THREADED_DATA_RUNLOOP_ENABLE,
   MENU_ENUM_LABEL_ENTRY_NORMAL_COLOR,
   MENU_ENUM_LABEL_ENTRY_HOVER_COLOR,
   MENU_ENUM_LABEL_XMB_ALPHA_FACTOR,
   MENU_ENUM_LABEL_XMB_FONT,
   MENU_ENUM_LABEL_XMB_THEME,
   MENU_ENUM_LABEL_XMB_MENU_COLOR_THEME,
   MENU_ENUM_LABEL_XMB_SHADOWS_ENABLE,
   MENU_ENUM_LABEL_XMB_RIBBON_ENABLE,
   MENU_ENUM_LABEL_THUMBNAILS,
   MENU_ENUM_LABEL_TIMEDATE_ENABLE,
   MENU_ENUM_LABEL_MATERIALUI_MENU_COLOR_THEME,

   MENU_ENUM_LABEL_VALUE_MENU_WALLPAPER,
   MENU_ENUM_LABEL_VALUE_DYNAMIC_WALLPAPER,
   MENU_ENUM_LABEL_VALUE_PAUSE_NONACTIVE,
   MENU_ENUM_LABEL_VALUE_MOUSE_ENABLE,
   MENU_ENUM_LABEL_VALUE_POINTER_ENABLE,
   MENU_ENUM_LABEL_VALUE_MENU_LINEAR_FILTER,
   MENU_ENUM_LABEL_VALUE_NAVIGATION_WRAPAROUND,
   MENU_ENUM_LABEL_VALUE_SHOW_ADVANCED_SETTINGS,
   MENU_ENUM_LABEL_VALUE_THREADED_DATA_RUNLOOP_ENABLE,
   MENU_ENUM_LABEL_VALUE_ENTRY_NORMAL_COLOR,
   MENU_ENUM_LABEL_VALUE_ENTRY_HOVER_COLOR,
   MENU_ENUM_LABEL_VALUE_XMB_SCALE_FACTOR,
   MENU_ENUM_LABEL_VALUE_XMB_ALPHA_FACTOR,
   MENU_ENUM_LABEL_VALUE_XMB_FONT,
   MENU_ENUM_LABEL_VALUE_XMB_THEME,
   MENU_ENUM_LABEL_VALUE_XMB_MENU_COLOR_THEME,
   MENU_ENUM_LABEL_VALUE_XMB_SHADOWS_ENABLE,
   MENU_ENUM_LABEL_VALUE_XMB_RIBBON_ENABLE,
   MENU_ENUM_LABEL_VALUE_THUMBNAILS,
   MENU_ENUM_LABEL_VALUE_TIMEDATE_ENABLE,

   MENU_ENUM_LABEL_VALUE_MATERIALUI_MENU_COLOR_THEME,

   /* UI settings */
   MENU_ENUM_LABEL_VIDEO_DISABLE_COMPOSITION,
   MENU_ENUM_LABEL_UI_COMPANION_ENABLE,
   MENU_ENUM_LABEL_UI_COMPANION_START_ON_BOOT,
   MENU_ENUM_LABEL_UI_MENUBAR_ENABLE,

   MENU_ENUM_LABEL_VALUE_UI_COMPANION_ENABLE,
   MENU_ENUM_LABEL_VALUE_UI_COMPANION_START_ON_BOOT,
   MENU_ENUM_LABEL_VALUE_UI_MENUBAR_ENABLE,

   /* Menu file browser */
   MENU_ENUM_LABEL_VALUE_MENU_FILE_BROWSER_SETTINGS,
   MENU_ENUM_LABEL_NAVIGATION_BROWSER_FILTER_SUPPORTED_EXTENSIONS_ENABLE,
   MENU_ENUM_LABEL_VALUE_NAVIGATION_BROWSER_FILTER_SUPPORTED_EXTENSIONS_ENABLE,

   /* Playlists */
   MENU_ENUM_LABEL_HISTORY_LIST_ENABLE,
   MENU_ENUM_LABEL_CONTENT_HISTORY_SIZE,

   MENU_ENUM_LABEL_VALUE_CONTENT_HISTORY_SIZE,
   MENU_ENUM_LABEL_VALUE_HISTORY_LIST_ENABLE,

   MENU_ENUM_LABEL_MENU_THROTTLE_FRAMERATE,

   MENU_ENUM_LABEL_NO_ACHIEVEMENTS_TO_DISPLAY,
   MENU_ENUM_LABEL_VALUE_NO_ACHIEVEMENTS_TO_DISPLAY,

   MENU_ENUM_LABEL_NO_ENTRIES_TO_DISPLAY,
   MENU_ENUM_LABEL_VALUE_NO_ENTRIES_TO_DISPLAY,

   /* Help */

   MENU_ENUM_LABEL_VALUE_BASIC_MENU_CONTROLS,
   MENU_ENUM_LABEL_VALUE_BASIC_MENU_CONTROLS_SCROLL_UP,
   MENU_ENUM_LABEL_VALUE_BASIC_MENU_CONTROLS_SCROLL_DOWN,
   MENU_ENUM_LABEL_VALUE_BASIC_MENU_CONTROLS_CONFIRM,
   MENU_ENUM_LABEL_VALUE_BASIC_MENU_CONTROLS_BACK,
   MENU_ENUM_LABEL_VALUE_BASIC_MENU_CONTROLS_START,
   MENU_ENUM_LABEL_VALUE_BASIC_MENU_CONTROLS_INFO,
   MENU_ENUM_LABEL_VALUE_BASIC_MENU_CONTROLS_TOGGLE_MENU,
   MENU_ENUM_LABEL_VALUE_BASIC_MENU_CONTROLS_QUIT,
   MENU_ENUM_LABEL_VALUE_BASIC_MENU_CONTROLS_TOGGLE_KEYBOARD,

   MENU_ENUM_LABEL_VALUE_BASIC_MENU_ENUM_CONTROLS,
   MENU_ENUM_LABEL_VALUE_BASIC_MENU_ENUM_CONTROLS_SCROLL_UP,
   MENU_ENUM_LABEL_VALUE_BASIC_MENU_ENUM_CONTROLS_SCROLL_DOWN,
   MENU_ENUM_LABEL_VALUE_BASIC_MENU_ENUM_CONTROLS_CONFIRM,
   MENU_ENUM_LABEL_VALUE_BASIC_MENU_ENUM_CONTROLS_BACK,
   MENU_ENUM_LABEL_VALUE_BASIC_MENU_ENUM_CONTROLS_START,
   MENU_ENUM_LABEL_VALUE_BASIC_MENU_ENUM_CONTROLS_INFO,
   MENU_ENUM_LABEL_VALUE_BASIC_MENU_ENUM_CONTROLS_TOGGLE_MENU,
   MENU_ENUM_LABEL_VALUE_BASIC_MENU_ENUM_CONTROLS_QUIT,
   MENU_ENUM_LABEL_VALUE_BASIC_MENU_ENUM_CONTROLS_TOGGLE_KEYBOARD,

   MENU_ENUM_LABEL_MENU_SETTINGS,
   MENU_ENUM_LABEL_VALUE_MENU_SETTINGS,

   MENU_ENUM_LABEL_THUMBNAILS_UPDATER_LIST,
   MENU_ENUM_LABEL_VALUE_THUMBNAILS_UPDATER_LIST,

   MENU_ENUM_LABEL_USER_INTERFACE_SETTINGS,
   MENU_ENUM_LABEL_MENU_FILE_BROWSER_SETTINGS,
   MENU_ENUM_LABEL_RETRO_ACHIEVEMENTS_SETTINGS,
   MENU_ENUM_LABEL_VALUE_RETRO_ACHIEVEMENTS_SETTINGS,
   MENU_ENUM_LABEL_UPDATER_SETTINGS,
   MENU_ENUM_LABEL_VALUE_UPDATER_SETTINGS,
   MENU_ENUM_LABEL_NETWORK_SETTINGS,
   MENU_ENUM_LABEL_USER_SETTINGS,
   MENU_ENUM_LABEL_DIRECTORY_SETTINGS,
   MENU_ENUM_LABEL_PRIVACY_SETTINGS,

   MENU_ENUM_LABEL_MENU_ENUM_LINEAR_FILTER,
   MENU_ENUM_LABEL_VALUE_MENU_ENUM_LINEAR_FILTER,

   MENU_ENUM_LABEL_MENU_ENUM_THROTTLE_FRAMERATE,
   MENU_ENUM_LABEL_VALUE_MENU_ENUM_THROTTLE_FRAMERATE,


   MENU_ENUM_LABEL_VALUE_SYSTEM_INFO_DYNAMIC_SUPPORT,


   MENU_ENUM_LABEL_CHEEVOS_HARDCORE_MODE_ENABLE,
   MENU_ENUM_LABEL_VALUE_CHEEVOS_HARDCORE_MODE_ENABLE,

   MENU_ENUM_LABEL_CHEEVOS_TEST_UNOFFICIAL,
   MENU_ENUM_LABEL_VALUE_CHEEVOS_TEST_UNOFFICIAL,

   MENU_ENUM_LABEL_VALUE_ENABLE,

   MENU_ENUM_LABEL_VALUE_CHEEVOS_SETTINGS,

   MENU_ENUM_LABEL_CHEEVOS_ENABLE,


   MENU_ENUM_LABEL_CHEEVOS_DESCRIPTION,

   MENU_ENUM_LABEL_VALUE_CHEEVOS_DESCRIPTION,

   MENU_ENUM_LABEL_VALUE_STATE_SLOT,

   MENU_ENUM_LABEL_STATE_SLOT,


   MENU_ENUM_LABEL_PLAYLIST_SETTINGS_BEGIN,

   MENU_ENUM_LABEL_CHEEVOS_USERNAME,
   MENU_ENUM_LABEL_CHEEVOS_PASSWORD,

   MENU_ENUM_LABEL_VALUE_ACCOUNTS_CHEEVOS_SETTINGS,
   MENU_ENUM_LABEL_ACCOUNTS_CHEEVOS_PASSWORD,
   MENU_ENUM_LABEL_VALUE_ACCOUNTS_CHEEVOS_PASSWORD,

   MENU_ENUM_LABEL_ACCOUNTS_CHEEVOS_USERNAME,
   MENU_ENUM_LABEL_VALUE_ACCOUNTS_CHEEVOS_USERNAME,

   MENU_ENUM_LABEL_CHEEVOS_UNLOCKED_ACHIEVEMENTS,
   MENU_ENUM_LABEL_VALUE_CHEEVOS_UNLOCKED_ACHIEVEMENTS,

   MENU_ENUM_LABEL_CHEEVOS_LOCKED_ACHIEVEMENTS,
   MENU_ENUM_LABEL_VALUE_CHEEVOS_LOCKED_ACHIEVEMENTS,

   MENU_ENUM_LABEL_ACCOUNTS_RETRO_ACHIEVEMENTS,
   MENU_ENUM_LABEL_VALUE_ACCOUNTS_RETRO_ACHIEVEMENTS,

   MENU_ENUM_LABEL_ACCOUNTS_LIST,
   MENU_ENUM_LABEL_VALUE_ACCOUNTS_LIST,
   MENU_ENUM_LABEL_VALUE_ACCOUNTS_LIST_END,

   MENU_ENUM_LABEL_DEBUG_PANEL_ENABLE,
   MENU_ENUM_LABEL_VALUE_DEBUG_PANEL_ENABLE,

   MENU_ENUM_LABEL_VALUE_MENU_ENUM_CONTROLS_PROLOG,

   MENU_ENUM_LABEL_VALUE_HELP_WHAT_IS_A_CORE,
   MENU_ENUM_LABEL_HELP_WHAT_IS_A_CORE,

   MENU_ENUM_LABEL_HELP_LOADING_CONTENT,
   MENU_ENUM_LABEL_VALUE_HELP_LOADING_CONTENT,

   MENU_ENUM_LABEL_HELP_LIST,
   MENU_ENUM_LABEL_VALUE_HELP_LIST,

   MENU_ENUM_LABEL_VALUE_HELP_CONTROLS,
   MENU_ENUM_LABEL_HELP_CONTROLS,


   MENU_ENUM_LABEL_VALUE_EXTRACTING_PLEASE_WAIT,

   MENU_ENUM_LABEL_WELCOME_TO_RETROARCH,

   /* Deferred */
   MENU_ENUM_LABEL_DEFERRED_ARCHIVE_ACTION_DETECT_CORE,
   MENU_ENUM_LABEL_DEFERRED_ARCHIVE_ACTION,
   MENU_ENUM_LABEL_DEFERRED_ARCHIVE_OPEN_DETECT_CORE,
   MENU_ENUM_LABEL_DEFERRED_ARCHIVE_OPEN,
   MENU_ENUM_LABEL_DEFERRED_CORE_CONTENT_LIST,
   MENU_ENUM_LABEL_DEFERRED_CORE_CONTENT_DIRS_LIST,
   MENU_ENUM_LABEL_DEFERRED_CORE_CONTENT_DIRS_SUBDIR_LIST,
   MENU_ENUM_LABEL_DEFERRED_LAKKA_LIST,
   MENU_ENUM_LABEL_DEFERRED_INPUT_HOTKEY_BINDS_LIST,
   MENU_ENUM_LABEL_DEFERRED_DATABASE_MANAGER_LIST,
   MENU_ENUM_LABEL_DEFERRED_VIDEO_FILTER,
   MENU_ENUM_LABEL_DEFERRED_CORE_LIST_SET,
   MENU_ENUM_LABEL_DEFERRED_CURSOR_MANAGER_LIST,
   MENU_ENUM_LABEL_DEFERRED_CURSOR_MANAGER_LIST_RDB_ENTRY_DEVELOPER,
   MENU_ENUM_LABEL_DEFERRED_CURSOR_MANAGER_LIST_RDB_ENTRY_PUBLISHER,
   MENU_ENUM_LABEL_DEFERRED_CURSOR_MANAGER_LIST_RDB_ENTRY_ORIGIN,
   MENU_ENUM_LABEL_DEFERRED_CURSOR_MANAGER_LIST_RDB_ENTRY_FRANCHISE,
   MENU_ENUM_LABEL_DEFERRED_CURSOR_MANAGER_LIST_RDB_ENTRY_EDGE_MAGAZINE_RATING,
   MENU_ENUM_LABEL_DEFERRED_CURSOR_MANAGER_LIST_RDB_ENTRY_EDGE_MAGAZINE_ISSUE,
   MENU_ENUM_LABEL_DEFERRED_CURSOR_MANAGER_LIST_RDB_ENTRY_FAMITSU_MAGAZINE_RATING,
   MENU_ENUM_LABEL_DEFERRED_CURSOR_MANAGER_LIST_RDB_ENTRY_ENHANCEMENT_HW,
   MENU_ENUM_LABEL_DEFERRED_CURSOR_MANAGER_LIST_RDB_ENTRY_RELEASEMONTH,
   MENU_ENUM_LABEL_DEFERRED_CURSOR_MANAGER_LIST_RDB_ENTRY_RELEASEYEAR,
   MENU_ENUM_LABEL_DEFERRED_CURSOR_MANAGER_LIST_RDB_ENTRY_ESRB_RATING,
   MENU_ENUM_LABEL_DEFERRED_CURSOR_MANAGER_LIST_RDB_ENTRY_ELSPA_RATING,
   MENU_ENUM_LABEL_DEFERRED_CURSOR_MANAGER_LIST_RDB_ENTRY_PEGI_RATING,
   MENU_ENUM_LABEL_DEFERRED_CURSOR_MANAGER_LIST_RDB_ENTRY_CERO_RATING,
   MENU_ENUM_LABEL_DEFERRED_CURSOR_MANAGER_LIST_RDB_ENTRY_BBFC_RATING,
   MENU_ENUM_LABEL_DEFERRED_CURSOR_MANAGER_LIST_RDB_ENTRY_MAX_USERS,
   MENU_ENUM_LABEL_DEFERRED_RDB_ENTRY_DETAIL,
   MENU_ENUM_LABEL_DEFERRED_RPL_ENTRY_ACTIONS,
   MENU_ENUM_LABEL_DEFERRED_CORE_LIST,
   MENU_ENUM_LABEL_DEFERRED_CORE_UPDATER_LIST,
   MENU_ENUM_LABEL_DEFERRED_THUMBNAILS_UPDATER_LIST,
   MENU_ENUM_LABEL_DEFERRED_PLAYLIST_SETTINGS_LIST,
   MENU_ENUM_LABEL_DEFERRED_INPUT_SETTINGS_LIST,
   MENU_ENUM_LABEL_DEFERRED_DRIVER_SETTINGS_LIST,
   MENU_ENUM_LABEL_DEFERRED_VIDEO_SETTINGS_LIST,
   MENU_ENUM_LABEL_DEFERRED_CONFIGURATION_SETTINGS_LIST,
   MENU_ENUM_LABEL_DEFERRED_SAVING_SETTINGS_LIST,
   MENU_ENUM_LABEL_DEFERRED_FRAME_THROTTLE_SETTINGS_LIST,
   MENU_ENUM_LABEL_DEFERRED_REWIND_SETTINGS_LIST,
   MENU_ENUM_LABEL_DEFERRED_ONSCREEN_DISPLAY_SETTINGS_LIST,
   MENU_ENUM_LABEL_DEFERRED_ONSCREEN_OVERLAY_SETTINGS_LIST,
   MENU_ENUM_LABEL_DEFERRED_MENU_SETTINGS_LIST,
   MENU_ENUM_LABEL_DEFERRED_USER_INTERFACE_SETTINGS_LIST,
   MENU_ENUM_LABEL_DEFERRED_MENU_FILE_BROWSER_SETTINGS_LIST,
   MENU_ENUM_LABEL_DEFERRED_RETRO_ACHIEVEMENTS_SETTINGS_LIST,
   MENU_ENUM_LABEL_DEFERRED_UPDATER_SETTINGS_LIST,
   MENU_ENUM_LABEL_DEFERRED_NETWORK_SETTINGS_LIST,
   MENU_ENUM_LABEL_DEFERRED_USER_SETTINGS_LIST,
   MENU_ENUM_LABEL_DEFERRED_DIRECTORY_SETTINGS_LIST,
   MENU_ENUM_LABEL_DEFERRED_PRIVACY_SETTINGS_LIST,
   MENU_ENUM_LABEL_DEFERRED_LOGGING_SETTINGS_LIST,
   MENU_ENUM_LABEL_DEFERRED_AUDIO_SETTINGS_LIST,
   MENU_ENUM_LABEL_DEFERRED_CORE_SETTINGS_LIST,
   MENU_ENUM_LABEL_DEFERRED_USER_BINDS_LIST,
   MENU_ENUM_LABEL_DEFERRED_ACCOUNTS_CHEEVOS_LIST,
   MENU_ENUM_LABEL_DEFERRED_ACCOUNTS_LIST,


   MENU_ENUM_LABEL_VALUE_DOWNLOADED_FILE_DETECT_CORE_LIST,
   MENU_ENUM_LABEL_DOWNLOADED_FILE_DETECT_CORE_LIST,


   MENU_ENUM_LABEL_VALUE_SEARCH,

   MENU_ENUM_LABEL_VALUE_DOWNLOAD_CORE_CONTENT,
   MENU_ENUM_LABEL_DOWNLOAD_CORE_CONTENT,
   MENU_ENUM_LABEL_DOWNLOAD_CORE_CONTENT_DIRS,

   MENU_ENUM_LABEL_SCAN_THIS_DIRECTORY,
   MENU_ENUM_LABEL_VALUE_SCAN_THIS_DIRECTORY,

   MENU_ENUM_LABEL_SCAN_DIRECTORY,
   MENU_ENUM_LABEL_VALUE_SCAN_DIRECTORY,

   MENU_ENUM_LABEL_VALUE_SCAN_FILE,
   MENU_ENUM_LABEL_SCAN_FILE,

   MENU_ENUM_LABEL_ADD_CONTENT_LIST,
   MENU_ENUM_LABEL_VALUE_ADD_CONTENT_LIST,


   MENU_ENUM_LABEL_VALUE_DONT_CARE,
   MENU_ENUM_LABEL_VALUE_LINEAR,
   MENU_ENUM_LABEL_VALUE_NEAREST,
   MENU_ENUM_LABEL_VALUE_UNKNOWN,
   MENU_ENUM_LABEL_VALUE_USER,
   MENU_ENUM_LABEL_VALUE_CHEAT,
   MENU_ENUM_LABEL_VALUE_SHADER,
   MENU_ENUM_LABEL_VALUE_DIRECTORY_CONTENT,
   MENU_ENUM_LABEL_VALUE_DIRECTORY_NONE,
   MENU_ENUM_LABEL_VALUE_DIRECTORY_DEFAULT,
   MENU_ENUM_LABEL_VALUE_NOT_AVAILABLE,
   MENU_ENUM_LABEL_VALUE_ASK_ARCHIVE,

   /* Online Updater */

   MENU_ENUM_LABEL_UPDATE_ASSETS,
   MENU_ENUM_LABEL_UPDATE_LAKKA,
   MENU_ENUM_LABEL_UPDATE_CHEATS,
   MENU_ENUM_LABEL_UPDATE_AUTOCONFIG_PROFILES,
   MENU_ENUM_LABEL_UPDATE_DATABASES,
   MENU_ENUM_LABEL_UPDATE_CG_SHADERS,
   MENU_ENUM_LABEL_UPDATE_OVERLAYS,
   MENU_ENUM_LABEL_UPDATE_GLSL_SHADERS,
   MENU_ENUM_LABEL_UPDATE_CORE_INFO_FILES,
   MENU_ENUM_LABEL_UPDATE_AUTOCONFIG_PROFILES_HID,

   MENU_ENUM_LABEL_VALUE_UPDATE_AUTOCONFIG_PROFILES_HID,
   MENU_ENUM_LABEL_VALUE_UPDATE_CORE_INFO_FILES,
   MENU_ENUM_LABEL_VALUE_UPDATE_ASSETS,
   MENU_ENUM_LABEL_VALUE_UPDATE_LAKKA,
   MENU_ENUM_LABEL_VALUE_UPDATE_CHEATS,
   MENU_ENUM_LABEL_VALUE_UPDATE_AUTOCONFIG_PROFILES,
   MENU_ENUM_LABEL_VALUE_UPDATE_DATABASES,
   MENU_ENUM_LABEL_VALUE_UPDATE_OVERLAYS,
   MENU_ENUM_LABEL_VALUE_UPDATE_CG_SHADERS,
   MENU_ENUM_LABEL_VALUE_UPDATE_GLSL_SHADERS,

   MENU_ENUM_LABEL_INFORMATION,
   MENU_ENUM_LABEL_VALUE_INFORMATION,
   MENU_ENUM_LABEL_INFORMATION_LIST,
   MENU_ENUM_LABEL_VALUE_INFORMATION_LIST,

   MENU_ENUM_LABEL_USE_BUILTIN_PLAYER,
   MENU_ENUM_LABEL_VALUE_USE_BUILTIN_PLAYER,

   MENU_ENUM_LABEL_CONTENT_SETTINGS,
   MENU_ENUM_LABEL_VALUE_CONTENT_SETTINGS,

   MENU_ENUM_LABEL_LOAD_CONTENT_LIST,
   MENU_ENUM_LABEL_VALUE_LOAD_CONTENT_LIST,

   MENU_ENUM_LABEL_NO_SETTINGS_FOUND,
   MENU_ENUM_LABEL_VALUE_NO_SETTINGS_FOUND,

   MENU_ENUM_LABEL_NO_PERFORMANCE_COUNTERS,
   MENU_ENUM_LABEL_VALUE_NO_PERFORMANCE_COUNTERS,


   MENU_ENUM_LABEL_FRAME_THROTTLE_SETTINGS,
   MENU_ENUM_LABEL_VALUE_FRAME_THROTTLE_SETTINGS,

   MENU_ENUM_LABEL_FRAME_THROTTLE_ENABLE,
   MENU_ENUM_LABEL_VALUE_FRAME_THROTTLE_ENABLE,

   MENU_ENUM_LABEL_CORE_ENABLE,
   MENU_ENUM_LABEL_VALUE_CORE_ENABLE,




   MENU_ENUM_LABEL_COLLAPSE_SUBGROUPS_ENABLE,
   MENU_ENUM_LABEL_VALUE_COLLAPSE_SUBGROUPS_ENABLE,

   MENU_ENUM_LABEL_RESET,
   MENU_ENUM_LABEL_SLOWMOTION,
   MENU_ENUM_LABEL_HOLD_FAST_FORWARD,
   MENU_ENUM_LABEL_CHEAT_TOGGLE,
   MENU_ENUM_LABEL_PAUSE_TOGGLE,

   MENU_ENUM_LABEL_PAUSE_LIBRETRO,
   MENU_ENUM_LABEL_VALUE_PAUSE_LIBRETRO,

   MENU_ENUM_LABEL_VALUE_DIRECTORY_NOT_FOUND,

   MENU_ENUM_LABEL_NO_ITEMS,
   MENU_ENUM_LABEL_VALUE_NO_ITEMS,

   MENU_ENUM_LABEL_NO_PLAYLISTS,
   MENU_ENUM_LABEL_VALUE_NO_PLAYLISTS,

   MENU_ENUM_LABEL_NO_SHADER_PARAMETERS,

   MSG_INTERFACE,
   MSG_MEMORY,
   MSG_IN_BYTES,
   MSG_IN_MEGABYTES,
   MSG_IN_GIGABYTES,
   MSG_INTERNAL_MEMORY,
   MSG_APPLICATION_DIR,
   MSG_EXTERNAL_APPLICATION_DIR,

   MENU_ENUM_LABEL_ARCHIVE_MODE,
   MENU_ENUM_LABEL_VALUE_ARCHIVE_MODE,
   MENU_ENUM_LABEL_VALUE_SHADER_OPTIONS,
   MENU_ENUM_LABEL_VALUE_USE_THIS_DIRECTORY,
   MENU_ENUM_LABEL_USE_THIS_DIRECTORY,
   MENU_ENUM_LABEL_VALUE_CORE_OPTIONS,
   MENU_ENUM_LABEL_VALUE_NO_SHADER_PARAMETERS,

   MENU_ENUM_LABEL_NO_CORE_INFORMATION_AVAILABLE,
   MENU_ENUM_LABEL_VALUE_NO_CORE_INFORMATION_AVAILABLE,

   MENU_ENUM_LABEL_NO_CORES_AVAILABLE,
   MENU_ENUM_LABEL_VALUE_NO_CORES_AVAILABLE,

   /* Audio */
   MENU_ENUM_LABEL_AUDIO_ENABLE,
   MENU_ENUM_LABEL_AUDIO_SYNC,
   MENU_ENUM_LABEL_AUDIO_VOLUME,
   MENU_ENUM_LABEL_AUDIO_LATENCY,
   MENU_ENUM_LABEL_AUDIO_RATE_CONTROL_DELTA,
   MENU_ENUM_LABEL_AUDIO_MAX_TIMING_SKEW,
   MENU_ENUM_LABEL_AUDIO_DEVICE,
   MENU_ENUM_LABEL_AUDIO_BLOCK_FRAMES,
   MENU_ENUM_LABEL_AUDIO_MUTE,
   MENU_ENUM_LABEL_AUDIO_OUTPUT_RATE,
   MENU_ENUM_LABEL_AUDIO_DSP_PLUGIN,

   MENU_ENUM_LABEL_VALUE_AUDIO_MUTE,
   MENU_ENUM_LABEL_VALUE_AUDIO_OUTPUT_RATE,
   MENU_ENUM_LABEL_VALUE_AUDIO_DSP_PLUGIN,
   MENU_ENUM_LABEL_VALUE_AUDIO_BLOCK_FRAMES,
   MENU_ENUM_LABEL_VALUE_AUDIO_ENABLE,
   MENU_ENUM_LABEL_VALUE_AUDIO_SYNC,
   MENU_ENUM_LABEL_VALUE_AUDIO_VOLUME,
   MENU_ENUM_LABEL_VALUE_AUDIO_LATENCY,
   MENU_ENUM_LABEL_VALUE_AUDIO_RATE_CONTROL_DELTA,
   MENU_ENUM_LABEL_VALUE_AUDIO_MAX_TIMING_SKEW,
   MENU_ENUM_LABEL_VALUE_AUDIO_DEVICE,

   MENU_ENUM_LABEL_SAVE_STATE,
   MENU_ENUM_LABEL_VALUE_LOAD_STATE,
   MENU_ENUM_LABEL_VALUE_UNDO_LOAD_STATE,
   MENU_ENUM_LABEL_VALUE_UNDO_SAVE_STATE,
   MENU_ENUM_LABEL_VALUE_SAVE_STATE,
   MENU_ENUM_LABEL_LOAD_STATE,
   MENU_ENUM_LABEL_UNDO_LOAD_STATE,
   MENU_ENUM_LABEL_UNDO_SAVE_STATE,
   MENU_ENUM_LABEL_REWIND,
   MENU_ENUM_LABEL_NETPLAY_FLIP_PLAYERS,
   MENU_ENUM_LABEL_CHEAT_INDEX_MINUS,
   MENU_ENUM_LABEL_CHEAT_INDEX_PLUS,
   MENU_ENUM_LABEL_SCREENSHOT_DIRECTORY,
   MENU_ENUM_LABEL_SHADER_NEXT,
   MENU_ENUM_LABEL_SHADER_PREV,
   MENU_ENUM_LABEL_FRAME_ADVANCE,
   MENU_ENUM_LABEL_FPS_SHOW,
   MENU_ENUM_LABEL_VALUE_FPS_SHOW,
   MENU_ENUM_LABEL_MOVIE_RECORD_TOGGLE,
   MENU_ENUM_LABEL_L_X_PLUS,
   MENU_ENUM_LABEL_L_X_MINUS,
   MENU_ENUM_LABEL_L_Y_PLUS,
   MENU_ENUM_LABEL_L_Y_MINUS,
   MENU_ENUM_LABEL_R_X_PLUS,
   MENU_ENUM_LABEL_R_X_MINUS,
   MENU_ENUM_LABEL_R_Y_MINUS,
   MENU_ENUM_LABEL_R_Y_PLUS,
   MENU_ENUM_LABEL_BLOCK_SRAM_OVERWRITE,
   MENU_ENUM_LABEL_VALUE_BLOCK_SRAM_OVERWRITE,
   MENU_ENUM_LABEL_CORE_SPECIFIC_CONFIG,
   MENU_ENUM_LABEL_VALUE_CORE_SPECIFIC_CONFIG,
   MENU_ENUM_LABEL_GAME_SPECIFIC_OPTIONS,
   MENU_ENUM_LABEL_VALUE_GAME_SPECIFIC_OPTIONS,
   MENU_ENUM_LABEL_GAME_SPECIFIC_OPTIONS_CREATE,
   MENU_ENUM_LABEL_VALUE_GAME_SPECIFIC_OPTIONS_CREATE,
   MENU_ENUM_LABEL_VALUE_GAME_SPECIFIC_OPTIONS_IN_USE,
   MENU_ENUM_LABEL_GAME_SPECIFIC_OPTIONS_IN_USE,
   MENU_ENUM_LABEL_AUTO_OVERRIDES_ENABLE,
   MENU_ENUM_LABEL_VALUE_AUTO_OVERRIDES_ENABLE,
   MENU_ENUM_LABEL_AUTO_REMAPS_ENABLE,
   MENU_ENUM_LABEL_VALUE_AUTO_REMAPS_ENABLE,
   MENU_ENUM_LABEL_RGUI_SHOW_START_SCREEN,
   MENU_ENUM_LABEL_VALUE_RGUI_SHOW_START_SCREEN,
   MENU_ENUM_LABEL_SCREENSHOT,
   MENU_ENUM_LABEL_REWIND_GRANULARITY,
   MENU_ENUM_LABEL_VALUE_REWIND_GRANULARITY,
   MENU_ENUM_LABEL_VALUE_RUN,
   MENU_ENUM_LABEL_SCREEN_RESOLUTION,
   MENU_ENUM_LABEL_VALUE_SCREEN_RESOLUTION,

   MENU_ENUM_LABEL_TITLE_COLOR,
   MENU_ENUM_LABEL_VALUE_TITLE_COLOR,
   MENU_ENUM_LABEL_SAVESTATE_AUTO_SAVE,
   MENU_ENUM_LABEL_SAVESTATE_AUTO_LOAD,
   MENU_ENUM_LABEL_SAVESTATE_AUTO_INDEX,
   MENU_ENUM_LABEL_VALUE_SAVESTATE_AUTO_INDEX,
   MENU_ENUM_LABEL_VALUE_SAVESTATE_AUTO_SAVE,
   MENU_ENUM_LABEL_VALUE_SAVESTATE_AUTO_LOAD,
   MENU_ENUM_LABEL_SYSTEM_DIRECTORY,
   MENU_ENUM_LABEL_SUSPEND_SCREENSAVER_ENABLE,
   MENU_ENUM_LABEL_VALUE_SUSPEND_SCREENSAVER_ENABLE,
   MENU_ENUM_LABEL_DPI_OVERRIDE_ENABLE,
   MENU_ENUM_LABEL_VALUE_DPI_OVERRIDE_ENABLE,
   MENU_ENUM_LABEL_DPI_OVERRIDE_VALUE,
   MENU_ENUM_LABEL_VALUE_DPI_OVERRIDE_VALUE,
   MENU_ENUM_LABEL_XMB_SCALE_FACTOR,
   MENU_ENUM_LABEL_VOLUME_UP,
   MENU_ENUM_LABEL_VOLUME_DOWN,
   MENU_ENUM_LABEL_LOG_VERBOSITY,
   MENU_ENUM_LABEL_VALUE_LOG_VERBOSITY,
   MENU_ENUM_LABEL_OVERLAY_NEXT,
   MENU_ENUM_LABEL_NETPLAY_ENABLE,
   MENU_ENUM_LABEL_VALUE_NETPLAY_ENABLE,
   MENU_ENUM_LABEL_SSH_ENABLE,
   MENU_ENUM_LABEL_VALUE_SSH_ENABLE,
   MENU_ENUM_LABEL_SAMBA_ENABLE,
   MENU_ENUM_LABEL_VALUE_SAMBA_ENABLE,
   MENU_ENUM_LABEL_BLUETOOTH_ENABLE,
   MENU_ENUM_LABEL_VALUE_BLUETOOTH_ENABLE,
   MENU_ENUM_LABEL_NETPLAY_CLIENT_SWAP_INPUT,
   MENU_ENUM_LABEL_VALUE_NETPLAY_CLIENT_SWAP_INPUT,
   MENU_ENUM_LABEL_NETPLAY_DELAY_FRAMES,
   MENU_ENUM_LABEL_VALUE_NETPLAY_DELAY_FRAMES,
   MENU_ENUM_LABEL_NETPLAY_SPECTATOR_MODE_ENABLE,
   MENU_ENUM_LABEL_VALUE_NETPLAY_SPECTATOR_MODE_ENABLE,
   MENU_ENUM_LABEL_NETPLAY_TCP_UDP_PORT,
   MENU_ENUM_LABEL_VALUE_NETPLAY_TCP_UDP_PORT,
   MENU_ENUM_LABEL_SORT_SAVEFILES_ENABLE,
   MENU_ENUM_LABEL_VALUE_SORT_SAVEFILES_ENABLE,
   MENU_ENUM_LABEL_SORT_SAVESTATES_ENABLE,
   MENU_ENUM_LABEL_VALUE_SORT_SAVESTATES_ENABLE,
   MENU_ENUM_LABEL_NETPLAY_IP_ADDRESS,
   MENU_ENUM_LABEL_VALUE_NETPLAY_IP_ADDRESS,
   MENU_ENUM_LABEL_NETPLAY_MODE,
   MENU_ENUM_LABEL_VALUE_NETPLAY_MODE,
   MENU_ENUM_LABEL_PERFCNT_ENABLE,
   MENU_ENUM_LABEL_VALUE_PERFCNT_ENABLE,
   MENU_ENUM_LABEL_OVERLAY_SCALE,
   MENU_ENUM_LABEL_VALUE_OVERLAY_SCALE,
   MENU_ENUM_LABEL_KEYBOARD_OVERLAY_PRESET,
   MENU_ENUM_LABEL_VALUE_KEYBOARD_OVERLAY_PRESET,
   MENU_ENUM_LABEL_OVERLAY_PRESET,
   MENU_ENUM_LABEL_VALUE_OVERLAY_PRESET,
   MENU_ENUM_LABEL_OVERLAY_OPACITY,
   MENU_ENUM_LABEL_VALUE_OVERLAY_OPACITY,

   MENU_ENUM_LABEL_MENU_ENUM_WALLPAPER,
   MENU_ENUM_LABEL_VALUE_MENU_ENUM_WALLPAPER,

   MENU_ENUM_LABEL_FASTFORWARD_RATIO,
   MENU_ENUM_LABEL_VALUE_FASTFORWARD_RATIO,


   MENU_ENUM_LABEL_REWIND_ENABLE,
   MENU_ENUM_LABEL_VALUE_REWIND_ENABLE,
   MENU_ENUM_LABEL_ENABLE_HOTKEY,
   MENU_ENUM_LABEL_DISK_EJECT_TOGGLE,
   MENU_ENUM_LABEL_DISK_NEXT,
   MENU_ENUM_LABEL_GRAB_MOUSE_TOGGLE,
   MENU_ENUM_LABEL_MENU_ENUM_TOGGLE,
   MENU_ENUM_LABEL_STATE_SLOT_DECREASE,
   MENU_ENUM_LABEL_STATE_SLOT_INCREASE,

   MENU_ENUM_LABEL_LIBRETRO_LOG_LEVEL,
   MENU_ENUM_LABEL_VALUE_LIBRETRO_LOG_LEVEL,


   MENU_ENUM_LABEL_AUTOSAVE_INTERVAL,
   MENU_ENUM_LABEL_VALUE_AUTOSAVE_INTERVAL,
   MENU_ENUM_LABEL_CONFIG_SAVE_ON_EXIT,
   MENU_ENUM_LABEL_VALUE_CONFIG_SAVE_ON_EXIT,

   /* Driver settings */

   MENU_ENUM_LABEL_AUDIO_DRIVER,
   MENU_ENUM_LABEL_JOYPAD_DRIVER,
   MENU_ENUM_LABEL_MENU_DRIVER,
   MENU_ENUM_LABEL_LOCATION_DRIVER,
   MENU_ENUM_LABEL_CAMERA_DRIVER,
   MENU_ENUM_LABEL_AUDIO_RESAMPLER_DRIVER,
   MENU_ENUM_LABEL_RECORD_DRIVER,
   MENU_ENUM_LABEL_VIDEO_DRIVER,
   MENU_ENUM_LABEL_INPUT_DRIVER,

   MENU_ENUM_LABEL_VALUE_AUDIO_RESAMPLER_DRIVER,
   MENU_ENUM_LABEL_VALUE_AUDIO_DRIVER,
   MENU_ENUM_LABEL_VALUE_JOYPAD_DRIVER,
   MENU_ENUM_LABEL_VALUE_INPUT_DRIVER,
   MENU_ENUM_LABEL_VALUE_VIDEO_DRIVER,
   MENU_ENUM_LABEL_VALUE_LOCATION_DRIVER,
   MENU_ENUM_LABEL_VALUE_CAMERA_DRIVER,
   MENU_ENUM_LABEL_VALUE_RECORD_DRIVER,
   MENU_ENUM_LABEL_VALUE_MENU_DRIVER,

   MENU_ENUM_LABEL_VIDEO_DRIVER_GL,
   MENU_ENUM_LABEL_VIDEO_DRIVER_SDL2,
   MENU_ENUM_LABEL_VIDEO_DRIVER_SDL1,
   MENU_ENUM_LABEL_VIDEO_DRIVER_D3D,
   MENU_ENUM_LABEL_VIDEO_DRIVER_EXYNOS,
   MENU_ENUM_LABEL_VIDEO_DRIVER_SUNXI,
   MENU_ENUM_LABEL_VIDEO_DRIVER_DRM,

   MENU_ENUM_LABEL_MENU_ENUM_DRIVER,
   MENU_ENUM_LABEL_VALUE_MENU_ENUM_DRIVER,

   MENU_ENUM_LABEL_AUDIO_RESAMPLER_DRIVER_SINC,
   MENU_ENUM_LABEL_AUDIO_RESAMPLER_DRIVER_CC,

   MENU_ENUM_LABEL_SAVEFILE_DIRECTORY,
   MENU_ENUM_LABEL_VALUE_SAVEFILE_DIRECTORY,
   MENU_ENUM_LABEL_SAVESTATE_DIRECTORY,
   MENU_ENUM_LABEL_VALUE_SAVESTATE_DIRECTORY,
   MENU_ENUM_LABEL_DYNAMIC_WALLPAPERS_DIRECTORY,
   MENU_ENUM_LABEL_VALUE_DYNAMIC_WALLPAPERS_DIRECTORY,
   MENU_ENUM_LABEL_THUMBNAILS_DIRECTORY,
   MENU_ENUM_LABEL_VALUE_THUMBNAILS_DIRECTORY,

   MENU_ENUM_LABEL_SLOWMOTION_RATIO,
   MENU_ENUM_LABEL_VALUE_SLOWMOTION_RATIO,

   MENU_ENUM_LABEL_TURBO,

   /* Privacy settings */

   MENU_ENUM_LABEL_CAMERA_ALLOW,
   MENU_ENUM_LABEL_LOCATION_ALLOW,

   MENU_ENUM_LABEL_VALUE_CAMERA_ALLOW,
   MENU_ENUM_LABEL_VALUE_LOCATION_ALLOW,


   /* RDB Settings */
   MENU_ENUM_LABEL_RDB_ENTRY_ANALOG,
   MENU_ENUM_LABEL_VALUE_RDB_ENTRY_ANALOG,
   MENU_ENUM_LABEL_RDB_ENTRY_SERIAL,
   MENU_ENUM_LABEL_VALUE_RDB_ENTRY_SERIAL,
   MENU_ENUM_LABEL_VALUE_RDB_ENTRY_RUMBLE,
   MENU_ENUM_LABEL_VALUE_RDB_ENTRY_COOP,
   MENU_ENUM_LABEL_RDB_ENTRY_RUMBLE,
   MENU_ENUM_LABEL_RDB_ENTRY_COOP,
   MENU_ENUM_LABEL_RDB_ENTRY_START_CONTENT,
   MENU_ENUM_LABEL_RDB_ENTRY_DESCRIPTION,
   MENU_ENUM_LABEL_RDB_ENTRY_GENRE,
   MENU_ENUM_LABEL_VALUE_RDB_ENTRY_ENHANCEMENT_HW,
   MENU_ENUM_LABEL_RDB_ENTRY_ENHANCEMENT_HW,
   MENU_ENUM_LABEL_RDB_ENTRY_FRANCHISE,
   MENU_ENUM_LABEL_RDB_ENTRY_ORIGIN,
   MENU_ENUM_LABEL_RDB_ENTRY_DEVELOPER,
   MENU_ENUM_LABEL_RDB_ENTRY_NAME,
   MENU_ENUM_LABEL_RDB_ENTRY_PUBLISHER,
   MENU_ENUM_LABEL_VALUE_RDB_ENTRY_ESRB_RATING,
   MENU_ENUM_LABEL_RDB_ENTRY_ESRB_RATING,
   MENU_ENUM_LABEL_VALUE_RDB_ENTRY_BBFC_RATING,
   MENU_ENUM_LABEL_RDB_ENTRY_BBFC_RATING,
   MENU_ENUM_LABEL_VALUE_RDB_ENTRY_ELSPA_RATING,
   MENU_ENUM_LABEL_RDB_ENTRY_ELSPA_RATING,
   MENU_ENUM_LABEL_VALUE_RDB_ENTRY_PEGI_RATING,
   MENU_ENUM_LABEL_RDB_ENTRY_PEGI_RATING,
   MENU_ENUM_LABEL_VALUE_RDB_ENTRY_CERO_RATING,
   MENU_ENUM_LABEL_RDB_ENTRY_CERO_RATING,
   MENU_ENUM_LABEL_RDB_ENTRY_EDGE_MAGAZINE_RATING,
   MENU_ENUM_LABEL_VALUE_RDB_ENTRY_EDGE_MAGAZINE_ISSUE,
   MENU_ENUM_LABEL_RDB_ENTRY_EDGE_MAGAZINE_ISSUE,
   MENU_ENUM_LABEL_RDB_ENTRY_EDGE_MAGAZINE_REVIEW,
   MENU_ENUM_LABEL_RDB_ENTRY_FAMITSU_MAGAZINE_RATING,
   MENU_ENUM_LABEL_RDB_ENTRY_TGDB_RATING,
   MENU_ENUM_LABEL_RDB_ENTRY_RELEASE_MONTH,
   MENU_ENUM_LABEL_RDB_ENTRY_RELEASE_YEAR,
   MENU_ENUM_LABEL_RDB_ENTRY_MAX_USERS,
   MENU_ENUM_LABEL_RDB_ENTRY_SHA1,
   MENU_ENUM_LABEL_RDB_ENTRY_MD5,
   MENU_ENUM_LABEL_RDB_ENTRY_CRC32,

   MENU_ENUM_LABEL_VALUE_RDB_ENTRY_START_CONTENT,
   MENU_ENUM_LABEL_VALUE_RDB_ENTRY_DESCRIPTION,
   MENU_ENUM_LABEL_VALUE_RDB_ENTRY_GENRE,
   MENU_ENUM_LABEL_VALUE_RDB_ENTRY_NAME,
   MENU_ENUM_LABEL_VALUE_RDB_ENTRY_PUBLISHER,
   MENU_ENUM_LABEL_VALUE_RDB_ENTRY_DEVELOPER,
   MENU_ENUM_LABEL_VALUE_RDB_ENTRY_ORIGIN,
   MENU_ENUM_LABEL_VALUE_RDB_ENTRY_FRANCHISE,
   MENU_ENUM_LABEL_VALUE_RDB_ENTRY_EDGE_MAGAZINE_RATING,

   MENU_ENUM_LABEL_VALUE_RDB_ENTRY_EDGE_MAGAZINE_REVIEW,

   MENU_ENUM_LABEL_VALUE_RDB_ENTRY_FAMITSU_MAGAZINE_RATING,

   MENU_ENUM_LABEL_VALUE_RDB_ENTRY_TGDB_RATING,

   MENU_ENUM_LABEL_VALUE_RDB_ENTRY_RELEASE_MONTH,
   MENU_ENUM_LABEL_VALUE_RDB_ENTRY_RELEASE_YEAR,
   MENU_ENUM_LABEL_VALUE_RDB_ENTRY_MAX_USERS,
   MENU_ENUM_LABEL_VALUE_RDB_ENTRY_SHA1,
   MENU_ENUM_LABEL_VALUE_RDB_ENTRY_MD5,
   MENU_ENUM_LABEL_VALUE_RDB_ENTRY_CRC32,

   MENU_ENUM_LABEL_NO_PLAYLIST_ENTRIES_AVAILABLE,
   MENU_ENUM_LABEL_VALUE_NO_PLAYLIST_ENTRIES_AVAILABLE,

   MENU_ENUM_LABEL_VIDEO_SHADER_DEFAULT_FILTER,
   MENU_ENUM_LABEL_VIDEO_SHADER_FILTER_PASS,
   MENU_ENUM_LABEL_VIDEO_SHADER_SCALE_PASS,
   MENU_ENUM_LABEL_VALUE_VIDEO_SHADER_NUM_PASSES,
   MENU_ENUM_LABEL_VIDEO_SHADER_NUM_PASSES,
   MENU_ENUM_LABEL_VALUE_CHEAT_NUM_PASSES,
   MENU_ENUM_LABEL_CHEAT_NUM_PASSES,

   MENU_ENUM_LABEL_VALUE_NO_DISK,

   MENU_ENUM_LABEL_VALUE_MD5,
   MENU_ENUM_LABEL_VALUE_SHA1,
   MENU_ENUM_LABEL_VALUE_CRC,
   MENU_ENUM_LABEL_VALUE_MORE,

   MENU_ENUM_LABEL_HORIZONTAL_MENU,
   MENU_ENUM_LABEL_VALUE_HORIZONTAL_MENU,

   MENU_ENUM_LABEL_SETTINGS_TAB,
   MENU_ENUM_LABEL_VALUE_SETTINGS_TAB,

   MENU_ENUM_LABEL_HISTORY_TAB,
   MENU_ENUM_LABEL_VALUE_HISTORY_TAB,

   MENU_ENUM_LABEL_ADD_TAB,
   MENU_ENUM_LABEL_VALUE_ADD_TAB,

   MENU_ENUM_LABEL_PLAYLISTS_TAB,
   MENU_ENUM_LABEL_VALUE_PLAYLISTS_TAB,

   MENU_ENUM_LABEL_MAIN_MENU,
   MENU_ENUM_LABEL_VALUE_MAIN_MENU,
   MENU_ENUM_LABEL_VALUE_SETTINGS,
   MENU_ENUM_LABEL_VALUE_INPUT_SETTINGS,
   MENU_ENUM_LABEL_VALUE_ON,
   MENU_ENUM_LABEL_VALUE_OFF,
   MENU_ENUM_LABEL_VALUE_TRUE,
   MENU_ENUM_LABEL_VALUE_FALSE,
   MENU_ENUM_LABEL_VALUE_COMP,
   MENU_ENUM_LABEL_VALUE_MUSIC,
   MENU_ENUM_LABEL_VALUE_IMAGE,
   MENU_ENUM_LABEL_VALUE_MOVIE,
   MENU_ENUM_LABEL_VALUE_CORE,
   MENU_ENUM_LABEL_VALUE_CURSOR,
   MENU_ENUM_LABEL_VALUE_FILE,
   MENU_ENUM_LABEL_VALUE_MISSING,
   MENU_ENUM_LABEL_VALUE_PRESENT,
   MENU_ENUM_LABEL_VALUE_OPTIONAL,
   MENU_ENUM_LABEL_VALUE_REQUIRED,
   MENU_ENUM_LABEL_VALUE_RDB,
   MENU_ENUM_LABEL_VALUE_DIR,
   MENU_ENUM_LABEL_VALUE_NO_CORE,
   MENU_ENUM_LABEL_VALUE_DETECT,
   MENU_ENUM_LABEL_VALUE_GLSLP,
   MENU_ENUM_LABEL_VALUE_CGP,
   MENU_ENUM_LABEL_VALUE_GLSL,
   MENU_ENUM_LABEL_VALUE_CG,
   MENU_ENUM_LABEL_VALUE_SLANG,
   MENU_ENUM_LABEL_VALUE_SLANGP,

   MENU_ENUM_LABEL_VALUE_RETROPAD,
   MENU_ENUM_LABEL_VALUE_RETROKEYBOARD,

   MENU_ENUM_LABEL_SYSTEM_BGM_ENABLE,
   MENU_ENUM_LABEL_VALUE_SYSTEM_BGM_ENABLE,



   MENU_ENUM_LABEL_NETWORK_CMD_ENABLE,
   MENU_ENUM_LABEL_VALUE_NETWORK_CMD_ENABLE,
   MENU_ENUM_LABEL_NETWORK_CMD_PORT,
   MENU_ENUM_LABEL_VALUE_NETWORK_CMD_PORT,
   MENU_ENUM_LABEL_STDIN_CMD_ENABLE,
   MENU_ENUM_LABEL_NETWORK_REMOTE_ENABLE,
   MENU_ENUM_LABEL_NETWORK_REMOTE_PORT,
   MENU_ENUM_LABEL_VALUE_NETWORK_REMOTE_PORT,

   MENU_ENUM_LABEL_NETWORK_REMOTE_USER_1_ENABLE,

   MENU_ENUM_LABEL_NETWORK_REMOTE_USER_LAST_ENABLE = MENU_ENUM_LABEL_NETWORK_REMOTE_USER_1_ENABLE + MAX_USERS,

   MENU_ENUM_LABEL_VALUE_STDIN_CMD_ENABLE,
   MENU_ENUM_LABEL_VALUE_NETWORK_REMOTE_ENABLE,
   MENU_ENUM_LABEL_DETECT_CORE_LIST,
   MENU_ENUM_LABEL_VALUE_DETECT_CORE_LIST,
   MENU_ENUM_LABEL_DETECT_CORE_LIST_OK,
   MENU_ENUM_LABEL_START_CORE,
   MENU_ENUM_LABEL_VALUE_START_CORE,
   MENU_ENUM_LABEL_LOAD_CONTENT,
   MENU_ENUM_LABEL_VALUE_LOAD_CONTENT,
   MENU_ENUM_LABEL_VALUE_CORE_UPDATER_LIST,
   MENU_ENUM_LABEL_CORE_UPDATER_LIST,
   MENU_ENUM_LABEL_CORE_UPDATER_AUTO_EXTRACT_ARCHIVE,
   MENU_ENUM_LABEL_VALUE_CORE_UPDATER_AUTO_EXTRACT_ARCHIVE,
   MENU_ENUM_LABEL_CORE_UPDATER_BUILDBOT_URL,
   MENU_ENUM_LABEL_VALUE_CORE_UPDATER_BUILDBOT_URL,
   MENU_ENUM_LABEL_BUILDBOT_ASSETS_URL,
   MENU_ENUM_LABEL_VALUE_BUILDBOT_ASSETS_URL,
   MENU_ENUM_LABEL_DUMMY_ON_CORE_SHUTDOWN,
   MENU_ENUM_LABEL_VALUE_DUMMY_ON_CORE_SHUTDOWN,
   MENU_ENUM_LABEL_CORE_SET_SUPPORTS_NO_CONTENT_ENABLE,
   MENU_ENUM_LABEL_VALUE_CORE_SET_SUPPORTS_NO_CONTENT_ENABLE,
   MENU_ENUM_LABEL_CLOSE_CONTENT,
   MENU_ENUM_LABEL_VALUE_CLOSE_CONTENT,
   MENU_ENUM_LABEL_QUIT_RETROARCH,
   MENU_ENUM_LABEL_VALUE_QUIT_RETROARCH,
   MENU_ENUM_LABEL_SHUTDOWN,
   MENU_ENUM_LABEL_VALUE_SHUTDOWN,
   MENU_ENUM_LABEL_REBOOT,
   MENU_ENUM_LABEL_VALUE_REBOOT,
   MENU_ENUM_LABEL_VALUE_STARTING_DOWNLOAD,
   MENU_ENUM_LABEL_DISK_IMAGE_APPEND,
   MENU_ENUM_LABEL_CORE_LIST,
   MENU_ENUM_LABEL_VALUE_CORE_LIST,
   MENU_ENUM_LABEL_MANAGEMENT,
   MENU_ENUM_LABEL_VALUE_MANAGEMENT,
   MENU_ENUM_LABEL_ONLINE_UPDATER,
   MENU_ENUM_LABEL_VALUE_ONLINE_UPDATER,
   MENU_ENUM_LABEL_SETTINGS,
   MENU_ENUM_LABEL_FRONTEND_COUNTERS,
   MENU_ENUM_LABEL_VALUE_FRONTEND_COUNTERS,
   MENU_ENUM_LABEL_VALUE_CORE_COUNTERS,
   MENU_ENUM_LABEL_CORE_COUNTERS,
   MENU_ENUM_LABEL_LOAD_CONTENT_HISTORY,
   MENU_ENUM_LABEL_VALUE_LOAD_CONTENT_HISTORY,
   MENU_ENUM_LABEL_NETWORK_INFORMATION,
   MENU_ENUM_LABEL_VALUE_NETWORK_INFORMATION,
   MENU_ENUM_LABEL_SYSTEM_INFORMATION,
   MENU_ENUM_LABEL_DEBUG_INFORMATION,
   MENU_ENUM_LABEL_ACHIEVEMENT_LIST,
   MENU_ENUM_LABEL_VALUE_SYSTEM_INFORMATION,
   MENU_ENUM_LABEL_VALUE_DEBUG_INFORMATION,
   MENU_ENUM_LABEL_VALUE_ACHIEVEMENT_LIST,
   MENU_ENUM_LABEL_CORE_INFORMATION,
   MENU_ENUM_LABEL_VALUE_CORE_INFORMATION,
   MENU_ENUM_LABEL_VALUE_VIDEO_SHADER_PARAMETERS,
   MENU_ENUM_LABEL_VIDEO_SHADER_PARAMETERS,
   MENU_ENUM_LABEL_VIDEO_SHADER_PRESET_PARAMETERS,
   MENU_ENUM_LABEL_VALUE_VIDEO_SHADER_PRESET_PARAMETERS,
   MENU_ENUM_LABEL_DISK_OPTIONS,
   MENU_ENUM_LABEL_VALUE_DISK_OPTIONS,
   MENU_ENUM_LABEL_CORE_OPTIONS,
   MENU_ENUM_LABEL_DISK_CYCLE_TRAY_STATUS,
   MENU_ENUM_LABEL_VALUE_DISK_CYCLE_TRAY_STATUS,

   MENU_ENUM_LABEL_NO_CORE_OPTIONS_AVAILABLE,
   MENU_ENUM_LABEL_VALUE_NO_CORE_OPTIONS_AVAILABLE,

   MENU_ENUM_LABEL_VALUE_DISK_INDEX,
   MENU_ENUM_LABEL_VALUE_DISK_IMAGE_APPEND,
   MENU_ENUM_LABEL_DISK_INDEX,
   MENU_ENUM_LABEL_SHADER_OPTIONS,
   MENU_ENUM_LABEL_VALUE_CORE_CHEAT_OPTIONS,
   MENU_ENUM_LABEL_CORE_CHEAT_OPTIONS,
   MENU_ENUM_LABEL_VALUE_CORE_INPUT_REMAPPING_OPTIONS,
   MENU_ENUM_LABEL_CORE_INPUT_REMAPPING_OPTIONS,
   MENU_ENUM_LABEL_VALUE_CURSOR_MANAGER,
   MENU_ENUM_LABEL_VALUE_DATABASE_MANAGER,
   MENU_ENUM_LABEL_DATABASE_MANAGER_LIST,
   MENU_ENUM_LABEL_CURSOR_MANAGER_LIST,
   MENU_ENUM_LABEL_VALUE_SUPPORTED_CORES,
   MENU_ENUM_LABEL_VIDEO_SHADER_PASS,
   MENU_ENUM_LABEL_VIDEO_SHADER_PRESET_TWO,
   MENU_ENUM_LABEL_VIDEO_SHADER_PRESET,
   MENU_ENUM_LABEL_CHEAT_FILE_LOAD,
   MENU_ENUM_LABEL_VALUE_CHEAT_FILE_LOAD,
   MENU_ENUM_LABEL_REMAP_FILE_LOAD,
   MENU_ENUM_LABEL_VALUE_REMAP_FILE_LOAD,
   MENU_ENUM_LABEL_MESSAGE,
   MENU_ENUM_LABEL_INFO_SCREEN,
   MENU_ENUM_LABEL_LOAD_OPEN_ZIP,
   MENU_ENUM_LABEL_CUSTOM_RATIO,
   MENU_ENUM_LABEL_VALUE_CUSTOM_RATIO,
   MENU_ENUM_LABEL_HELP,
   MENU_ENUM_LABEL_VALUE_HELP,
   MENU_ENUM_LABEL_CHEAT_DATABASE_PATH,
   MENU_ENUM_LABEL_VALUE_CHEAT_DATABASE_PATH,
   MENU_ENUM_LABEL_CURSOR_DIRECTORY,
   MENU_ENUM_LABEL_VALUE_CURSOR_DIRECTORY,
   MENU_ENUM_LABEL_OSK_OVERLAY_DIRECTORY,
   MENU_ENUM_LABEL_VALUE_OSK_OVERLAY_DIRECTORY,
   MENU_ENUM_LABEL_RECORDING_OUTPUT_DIRECTORY,
   MENU_ENUM_LABEL_VALUE_RECORDING_OUTPUT_DIRECTORY,
   MENU_ENUM_LABEL_RECORDING_CONFIG_DIRECTORY,
   MENU_ENUM_LABEL_VALUE_RECORDING_CONFIG_DIRECTORY,
   MENU_ENUM_LABEL_VIDEO_FILTER,
   MENU_ENUM_LABEL_PAL60_ENABLE,
   MENU_ENUM_LABEL_VALUE_PAL60_ENABLE,
   MENU_ENUM_LABEL_CONTENT_HISTORY_PATH,
   MENU_ENUM_LABEL_RGUI_BROWSER_DIRECTORY,
   MENU_ENUM_LABEL_VALUE_RGUI_BROWSER_DIRECTORY,
   MENU_ENUM_LABEL_CONTENT_DATABASE_DIRECTORY,
   MENU_ENUM_LABEL_VALUE_CONTENT_DATABASE_DIRECTORY,
   MENU_ENUM_LABEL_PLAYLIST_DIRECTORY,
   MENU_ENUM_LABEL_VALUE_PLAYLIST_DIRECTORY,
   MENU_ENUM_LABEL_CORE_ASSETS_DIRECTORY,
   MENU_ENUM_LABEL_VALUE_CORE_ASSETS_DIRECTORY,
   MENU_ENUM_LABEL_CONTENT_DIRECTORY,
   MENU_ENUM_LABEL_VALUE_SCREENSHOT_DIRECTORY,
   MENU_ENUM_LABEL_VALUE_INPUT_REMAPPING_DIRECTORY,
   MENU_ENUM_LABEL_VIDEO_SHADER_DIR,
   MENU_ENUM_LABEL_VALUE_VIDEO_SHADER_DIR,
   MENU_ENUM_LABEL_VIDEO_FILTER_DIR,
   MENU_ENUM_LABEL_VALUE_VIDEO_FILTER_DIR,
   MENU_ENUM_LABEL_AUDIO_FILTER_DIR,
   MENU_ENUM_LABEL_VALUE_AUDIO_FILTER_DIR,
   MENU_ENUM_LABEL_LIBRETRO_DIR_PATH,
   MENU_ENUM_LABEL_VALUE_LIBRETRO_DIR_PATH,
   MENU_ENUM_LABEL_LIBRETRO_INFO_PATH,
   MENU_ENUM_LABEL_VALUE_LIBRETRO_INFO_PATH,
   MENU_ENUM_LABEL_RGUI_CONFIG_DIRECTORY,
   MENU_ENUM_LABEL_VALUE_RGUI_CONFIG_DIRECTORY,
   MENU_ENUM_LABEL_OVERLAY_DIRECTORY,
   MENU_ENUM_LABEL_VALUE_OVERLAY_DIRECTORY,
   MENU_ENUM_LABEL_VALUE_SYSTEM_DIRECTORY,
   MENU_ENUM_LABEL_ASSETS_DIRECTORY,
   MENU_ENUM_LABEL_VALUE_ASSETS_DIRECTORY,
   MENU_ENUM_LABEL_CACHE_DIRECTORY,
   MENU_ENUM_LABEL_VALUE_CACHE_DIRECTORY,
   MENU_ENUM_LABEL_JOYPAD_AUTOCONFIG_DIR,
   MENU_ENUM_LABEL_VALUE_JOYPAD_AUTOCONFIG_DIR,

   MENU_ENUM_LABEL_DRIVER_SETTINGS,
   MENU_ENUM_LABEL_VALUE_DRIVER_SETTINGS,


   MENU_ENUM_LABEL_VIDEO_SETTINGS,

   MENU_ENUM_LABEL_AUDIO_SETTINGS,
   MENU_ENUM_LABEL_VALUE_AUDIO_SETTINGS,

   MENU_ENUM_LABEL_CORE_SETTINGS,
   MENU_ENUM_LABEL_VALUE_CORE_SETTINGS,

   MENU_ENUM_LABEL_CONFIGURATION_SETTINGS,
   MENU_ENUM_LABEL_VALUE_CONFIGURATION_SETTINGS,

   MENU_ENUM_LABEL_LOGGING_SETTINGS,
   MENU_ENUM_LABEL_VALUE_LOGGING_SETTINGS,

   MENU_ENUM_LABEL_SAVING_SETTINGS,
   MENU_ENUM_LABEL_VALUE_SAVING_SETTINGS,

   MENU_ENUM_LABEL_REWIND_SETTINGS,
   MENU_ENUM_LABEL_VALUE_REWIND_SETTINGS,

   MENU_ENUM_LABEL_RECORDING_SETTINGS,
   MENU_ENUM_LABEL_VALUE_RECORDING_SETTINGS,
   MENU_ENUM_LABEL_SHADER_SETTINGS,
   MENU_ENUM_LABEL_FONT_SETTINGS,
   MENU_ENUM_LABEL_OVERLAY_SETTINGS,
   MENU_ENUM_LABEL_VALUE_OVERLAY_SETTINGS,
   MENU_ENUM_LABEL_ONSCREEN_KEYBOARD_OVERLAY_SETTINGS,
   MENU_ENUM_LABEL_VALUE_MULTIMEDIA_SETTINGS,
   MENU_ENUM_LABEL_VALUE_MENU_ENUM_FILE_BROWSER_SETTINGS,
   MENU_ENUM_LABEL_MENU_ENUM_SETTINGS,
   MENU_ENUM_LABEL_VALUE_MENU_ENUM_SETTINGS,
   MENU_ENUM_LABEL_VALUE_USER_INTERFACE_SETTINGS,
   MENU_ENUM_LABEL_PATCH_SETTINGS,
   MENU_ENUM_LABEL_PLAYLIST_SETTINGS,
   MENU_ENUM_LABEL_VALUE_PLAYLIST_SETTINGS,
   MENU_ENUM_LABEL_CORE_UPDATER_SETTINGS,
   MENU_ENUM_LABEL_VALUE_CORE_UPDATER_SETTINGS,
   MENU_ENUM_LABEL_VALUE_NETWORK_SETTINGS,
   MENU_ENUM_LABEL_VALUE_LAKKA_SERVICES,
   MENU_ENUM_LABEL_LAKKA_SERVICES,
   MENU_ENUM_LABEL_ARCHIVE_SETTINGS,
   MENU_ENUM_LABEL_VALUE_USER_SETTINGS,
   MENU_ENUM_LABEL_VALUE_DIRECTORY_SETTINGS,
   MENU_ENUM_LABEL_VALUE_PRIVACY_SETTINGS,
   MENU_ENUM_LABEL_SHADER_APPLY_CHANGES,
   MENU_ENUM_LABEL_VALUE_SHADER_APPLY_CHANGES,
   MENU_ENUM_LABEL_SAVE_NEW_CONFIG,
   MENU_ENUM_LABEL_VALUE_SAVE_NEW_CONFIG,
   MENU_ENUM_LABEL_ONSCREEN_DISPLAY_SETTINGS,
   MENU_ENUM_LABEL_VALUE_ONSCREEN_DISPLAY_SETTINGS,
   MENU_ENUM_LABEL_ONSCREEN_OVERLAY_SETTINGS,
   MENU_ENUM_LABEL_VALUE_ONSCREEN_OVERLAY_SETTINGS,
   MENU_ENUM_LABEL_VALUE_CHEAT_APPLY_CHANGES,
   MENU_ENUM_LABEL_CHEAT_APPLY_CHANGES,
   MENU_ENUM_LABEL_CUSTOM_BIND,
   MENU_ENUM_LABEL_CUSTOM_BIND_ALL,
   MENU_ENUM_LABEL_CUSTOM_BIND_DEFAULTS,
   MENU_ENUM_LABEL_RESUME_CONTENT,
   MENU_ENUM_LABEL_VALUE_RESUME_CONTENT,
   MENU_ENUM_LABEL_VALUE_RESUME,
   MENU_ENUM_LABEL_RESTART_CONTENT,
   MENU_ENUM_LABEL_RESTART_RETROARCH,
   MENU_ENUM_LABEL_VALUE_RESTART_RETROARCH,
   MENU_ENUM_LABEL_VALUE_RESTART_CONTENT,
   MENU_ENUM_LABEL_TAKE_SCREENSHOT,
   MENU_ENUM_LABEL_VALUE_TAKE_SCREENSHOT,
   MENU_ENUM_LABEL_CONFIGURATIONS,
   MENU_ENUM_LABEL_VALUE_CONFIGURATIONS,
   MENU_ENUM_LABEL_VALUE_CHEAT_FILE_SAVE_AS,
   MENU_ENUM_LABEL_CHEAT_FILE_SAVE_AS,
   MENU_ENUM_LABEL_VIDEO_SHADER_PRESET_SAVE_AS,
   MENU_ENUM_LABEL_VALUE_VIDEO_SHADER_PRESET_SAVE_AS,
   MENU_ENUM_LABEL_VALUE_REMAP_FILE_SAVE_CORE,
   MENU_ENUM_LABEL_VALUE_REMAP_FILE_SAVE_GAME,
   MENU_ENUM_LABEL_REMAP_FILE_SAVE_CORE,
   MENU_ENUM_LABEL_REMAP_FILE_SAVE_GAME,
   MENU_ENUM_LABEL_CONTENT_COLLECTION_LIST,
   MENU_ENUM_LABEL_VALUE_CONTENT_COLLECTION_LIST,
   MENU_ENUM_LABEL_VALUE_UNABLE_TO_READ_COMPRESSED_FILE,
   MENU_ENUM_LABEL_OSK_ENABLE,
   MENU_ENUM_LABEL_EXIT_EMULATOR,
   MENU_ENUM_LABEL_COLLECTION,
   MENU_ENUM_LABEL_USER_LANGUAGE,
   MENU_ENUM_LABEL_VALUE_USER_LANGUAGE,
   MENU_ENUM_LABEL_NETPLAY_NICKNAME,
   MENU_ENUM_LABEL_VALUE_NETPLAY_NICKNAME,
   MENU_ENUM_LABEL_VIDEO_VI_WIDTH,

   MENU_ENUM_LABEL_VIDEO_FORCE_ASPECT,

   MENU_ENUM_LABEL_VIDEO_ASPECT_RATIO_AUTO,

   MENU_ENUM_LABEL_VIDEO_ASPECT_RATIO_INDEX,

   MENU_ENUM_LABEL_VIDEO_VFILTER,

   MENU_ENUM_LABEL_VIDEO_GPU_RECORD,

   MENU_ENUM_LABEL_RECORD_USE_OUTPUT_DIRECTORY,
   MENU_ENUM_LABEL_VALUE_RECORD_USE_OUTPUT_DIRECTORY,

   MENU_ENUM_LABEL_RECORD_CONFIG,
   MENU_ENUM_LABEL_VALUE_RECORD_CONFIG,

   MENU_ENUM_LABEL_RECORD_PATH,
   MENU_ENUM_LABEL_VALUE_RECORD_PATH,

   MENU_ENUM_LABEL_VIDEO_POST_FILTER_RECORD,
   MENU_ENUM_LABEL_VALUE_VIDEO_POST_FILTER_RECORD,

   MENU_ENUM_LABEL_RECORD_ENABLE,
   MENU_ENUM_LABEL_VALUE_RECORD_ENABLE,

   MENU_ENUM_LABEL_VALUE_SECONDS,
   MENU_ENUM_LABEL_VALUE_STATUS,

   MENU_ENUM_LABEL_VALUE_CORE_INFO_CORE_NAME,
   MENU_ENUM_LABEL_VALUE_CORE_INFO_CORE_LABEL,
   MENU_ENUM_LABEL_VALUE_CORE_INFO_SYSTEM_NAME,
   MENU_ENUM_LABEL_VALUE_CORE_INFO_SYSTEM_MANUFACTURER,
   MENU_ENUM_LABEL_VALUE_CORE_INFO_CATEGORIES,
   MENU_ENUM_LABEL_VALUE_CORE_INFO_AUTHORS,
   MENU_ENUM_LABEL_VALUE_CORE_INFO_PERMISSIONS,
   MENU_ENUM_LABEL_VALUE_CORE_INFO_LICENSES,
   MENU_ENUM_LABEL_VALUE_CORE_INFO_SUPPORTED_EXTENSIONS,
   MENU_ENUM_LABEL_VALUE_CORE_INFO_FIRMWARE,
   MENU_ENUM_LABEL_VALUE_CORE_INFO_CORE_NOTES,

   /* System information */

   MENU_ENUM_LABEL_VALUE_SYSTEM_INFO_BUILD_DATE,
   MENU_ENUM_LABEL_VALUE_SYSTEM_INFO_GIT_VERSION,
   MENU_ENUM_LABEL_VALUE_SYSTEM_INFO_CPU_FEATURES,
   MENU_ENUM_LABEL_VALUE_SYSTEM_INFO_FRONTEND_IDENTIFIER,
   MENU_ENUM_LABEL_VALUE_SYSTEM_INFO_FRONTEND_NAME,
   MENU_ENUM_LABEL_VALUE_SYSTEM_INFO_FRONTEND_OS,
   MENU_ENUM_LABEL_VALUE_SYSTEM_INFO_RETRORATING_LEVEL,
   MENU_ENUM_LABEL_VALUE_SYSTEM_INFO_POWER_SOURCE,
   MENU_ENUM_LABEL_VALUE_SYSTEM_INFO_POWER_SOURCE_NO_SOURCE,
   MENU_ENUM_LABEL_VALUE_SYSTEM_INFO_POWER_SOURCE_CHARGING,
   MENU_ENUM_LABEL_VALUE_SYSTEM_INFO_POWER_SOURCE_CHARGED,
   MENU_ENUM_LABEL_VALUE_SYSTEM_INFO_POWER_SOURCE_DISCHARGING,
   MENU_ENUM_LABEL_VALUE_SYSTEM_INFO_VIDEO_CONTEXT_DRIVER,
   MENU_ENUM_LABEL_VALUE_SYSTEM_INFO_DISPLAY_METRIC_MM_WIDTH,
   MENU_ENUM_LABEL_VALUE_SYSTEM_INFO_DISPLAY_METRIC_MM_HEIGHT,
   MENU_ENUM_LABEL_VALUE_SYSTEM_INFO_DISPLAY_METRIC_DPI,
   MENU_ENUM_LABEL_VALUE_SYSTEM_INFO_LIBRETRODB_SUPPORT,
   MENU_ENUM_LABEL_VALUE_SYSTEM_INFO_OVERLAY_SUPPORT,
   MENU_ENUM_LABEL_VALUE_SYSTEM_INFO_COMMAND_IFACE_SUPPORT,
   MENU_ENUM_LABEL_VALUE_SYSTEM_INFO_NETWORK_COMMAND_IFACE_SUPPORT,
   MENU_ENUM_LABEL_VALUE_SYSTEM_INFO_NETWORK_REMOTE_SUPPORT,
   MENU_ENUM_LABEL_VALUE_SYSTEM_INFO_COCOA_SUPPORT,
   MENU_ENUM_LABEL_VALUE_SYSTEM_INFO_RTGA_SUPPORT,
   MENU_ENUM_LABEL_VALUE_SYSTEM_INFO_RBMP_SUPPORT,
   MENU_ENUM_LABEL_VALUE_SYSTEM_INFO_RJPEG_SUPPORT,
   MENU_ENUM_LABEL_VALUE_SYSTEM_INFO_RPNG_SUPPORT,
   MENU_ENUM_LABEL_VALUE_SYSTEM_INFO_SDL_SUPPORT,
   MENU_ENUM_LABEL_VALUE_SYSTEM_INFO_SDL2_SUPPORT,
   MENU_ENUM_LABEL_VALUE_SYSTEM_INFO_VULKAN_SUPPORT,
   MENU_ENUM_LABEL_VALUE_SYSTEM_INFO_OPENGL_SUPPORT,
   MENU_ENUM_LABEL_VALUE_SYSTEM_INFO_OPENGLES_SUPPORT,
   MENU_ENUM_LABEL_VALUE_SYSTEM_INFO_THREADING_SUPPORT,
   MENU_ENUM_LABEL_VALUE_SYSTEM_INFO_KMS_SUPPORT,
   MENU_ENUM_LABEL_VALUE_SYSTEM_INFO_UDEV_SUPPORT,
   MENU_ENUM_LABEL_VALUE_SYSTEM_INFO_OPENVG_SUPPORT,
   MENU_ENUM_LABEL_VALUE_SYSTEM_INFO_EGL_SUPPORT,
   MENU_ENUM_LABEL_VALUE_SYSTEM_INFO_X11_SUPPORT,
   MENU_ENUM_LABEL_VALUE_SYSTEM_INFO_WAYLAND_SUPPORT,
   MENU_ENUM_LABEL_VALUE_SYSTEM_INFO_XVIDEO_SUPPORT,
   MENU_ENUM_LABEL_VALUE_SYSTEM_INFO_ALSA_SUPPORT,
   MENU_ENUM_LABEL_VALUE_SYSTEM_INFO_OSS_SUPPORT,
   MENU_ENUM_LABEL_VALUE_SYSTEM_INFO_OPENAL_SUPPORT,
   MENU_ENUM_LABEL_VALUE_SYSTEM_INFO_OPENSL_SUPPORT,
   MENU_ENUM_LABEL_VALUE_SYSTEM_INFO_RSOUND_SUPPORT,
   MENU_ENUM_LABEL_VALUE_SYSTEM_INFO_ROARAUDIO_SUPPORT,
   MENU_ENUM_LABEL_VALUE_SYSTEM_INFO_JACK_SUPPORT,
   MENU_ENUM_LABEL_VALUE_SYSTEM_INFO_PULSEAUDIO_SUPPORT,
   MENU_ENUM_LABEL_VALUE_SYSTEM_INFO_DSOUND_SUPPORT,
   MENU_ENUM_LABEL_VALUE_SYSTEM_INFO_XAUDIO2_SUPPORT,
   MENU_ENUM_LABEL_VALUE_SYSTEM_INFO_ZLIB_SUPPORT,
   MENU_ENUM_LABEL_VALUE_SYSTEM_INFO_7ZIP_SUPPORT,
   MENU_ENUM_LABEL_VALUE_SYSTEM_INFO_DYLIB_SUPPORT,
   MENU_ENUM_LABEL_VALUE_SYSTEM_INFO_CG_SUPPORT,
   MENU_ENUM_LABEL_VALUE_SYSTEM_INFO_GLSL_SUPPORT,
   MENU_ENUM_LABEL_VALUE_SYSTEM_INFO_HLSL_SUPPORT,
   MENU_ENUM_LABEL_VALUE_SYSTEM_INFO_LIBXML2_SUPPORT,
   MENU_ENUM_LABEL_VALUE_SYSTEM_INFO_SDL_IMAGE_SUPPORT,
   MENU_ENUM_LABEL_VALUE_SYSTEM_INFO_FBO_SUPPORT,
   MENU_ENUM_LABEL_VALUE_SYSTEM_INFO_FFMPEG_SUPPORT,
   MENU_ENUM_LABEL_VALUE_SYSTEM_INFO_CORETEXT_SUPPORT,
   MENU_ENUM_LABEL_VALUE_SYSTEM_INFO_FREETYPE_SUPPORT,
   MENU_ENUM_LABEL_VALUE_SYSTEM_INFO_NETPLAY_SUPPORT,
   MENU_ENUM_LABEL_VALUE_SYSTEM_INFO_PYTHON_SUPPORT,
   MENU_ENUM_LABEL_VALUE_SYSTEM_INFO_V4L2_SUPPORT,
   MENU_ENUM_LABEL_VALUE_SYSTEM_INFO_LIBUSB_SUPPORT,

   MENU_ENUM_LABEL_VALUE_CORE_ASSETS_DIR,
   MENU_ENUM_LABEL_VALUE_CONTENT_DIR,

   MENU_ENUM_LABEL_VALUE_DATABASE_SELECTION,

   MENU_ENUM_LABEL_VALUE_YES,
   MENU_ENUM_LABEL_VALUE_NO,

   MENU_ENUM_LABEL_VALUE_BACK,
   MENU_ENUM_LABEL_VALUE_DISABLED,
   MENU_ENUM_LABEL_VALUE_PORT,

   MENU_ENUM_LABEL_VALUE_LEFT_ANALOG,
   MENU_ENUM_LABEL_VALUE_RIGHT_ANALOG,

   MENU_ENUM_LABEL_VALUE_LANG_ENGLISH,
   MENU_ENUM_LABEL_VALUE_LANG_JAPANESE,
   MENU_ENUM_LABEL_VALUE_LANG_FRENCH,
   MENU_ENUM_LABEL_VALUE_LANG_SPANISH,
   MENU_ENUM_LABEL_VALUE_LANG_GERMAN,
   MENU_ENUM_LABEL_VALUE_LANG_ITALIAN,
   MENU_ENUM_LABEL_VALUE_LANG_DUTCH,
   MENU_ENUM_LABEL_VALUE_LANG_PORTUGUESE,
   MENU_ENUM_LABEL_VALUE_LANG_RUSSIAN,
   MENU_ENUM_LABEL_VALUE_LANG_KOREAN,
   MENU_ENUM_LABEL_VALUE_LANG_CHINESE_TRADITIONAL,
   MENU_ENUM_LABEL_VALUE_LANG_CHINESE_SIMPLIFIED,
   MENU_ENUM_LABEL_VALUE_LANG_ESPERANTO,
   MENU_ENUM_LABEL_VALUE_LANG_POLISH,

   MENU_ENUM_LABEL_VALUE_NONE,

   MENU_ENUM_LABEL_VALUE_NO_INFORMATION_AVAILABLE,


   MENU_ENUM_LABEL_USE_BUILTIN_IMAGE_VIEWER,
   MENU_ENUM_LABEL_VALUE_USE_BUILTIN_IMAGE_VIEWER,

   MENU_ENUM_LABEL_OVERLAY_AUTOLOAD_PREFERRED,
   MENU_ENUM_LABEL_VALUE_OVERLAY_AUTOLOAD_PREFERRED,

   MENU_ENUM_LABEL_OPEN_ARCHIVE,
   MENU_ENUM_LABEL_OPEN_ARCHIVE_DETECT_CORE,
   MENU_ENUM_LABEL_LOAD_ARCHIVE_DETECT_CORE,
   MENU_ENUM_LABEL_LOAD_ARCHIVE,

   MENU_ENUM_LABEL_VALUE_OPEN_ARCHIVE,
   MENU_ENUM_LABEL_VALUE_LOAD_ARCHIVE,

   MENU_ENUM_LABEL_VALUE_WHAT_IS_A_CORE_DESC,

   MENU_ENUM_LABEL_HELP_CHANGE_VIRTUAL_GAMEPAD,
   MENU_ENUM_LABEL_VALUE_HELP_CHANGE_VIRTUAL_GAMEPAD,
   MENU_ENUM_LABEL_VALUE_HELP_CHANGE_VIRTUAL_GAMEPAD_DESC,

   MENU_ENUM_LABEL_HELP_AUDIO_VIDEO_TROUBLESHOOTING,
   MENU_ENUM_LABEL_VALUE_HELP_AUDIO_VIDEO_TROUBLESHOOTING,
   MENU_ENUM_LABEL_VALUE_HELP_AUDIO_VIDEO_TROUBLESHOOTING_DESC,

   MENU_ENUM_LABEL_HELP_SCANNING_CONTENT,
   MENU_ENUM_LABEL_VALUE_HELP_SCANNING_CONTENT,
   MENU_ENUM_LABEL_VALUE_HELP_SCANNING_CONTENT_DESC,

   MENU_ENUM_LABEL_SAVE_CURRENT_CONFIG,
   MENU_ENUM_LABEL_VALUE_SAVE_CURRENT_CONFIG,

   MENU_ENUM_LABEL_VALUE_THUMBNAIL_MODE_SCREENSHOTS,
   MENU_ENUM_LABEL_VALUE_THUMBNAIL_MODE_TITLE_SCREENS,
   MENU_ENUM_LABEL_VALUE_THUMBNAIL_MODE_BOXARTS,

   /* Callback strings */
   MENU_ENUM_LABEL_CB_THUMBNAILS_UPDATER_DOWNLOAD,
   MENU_ENUM_LABEL_CB_DOWNLOAD_URL,
   MENU_ENUM_LABEL_CB_UPDATE_OVERLAYS,
   MENU_ENUM_LABEL_CB_CORE_UPDATER_LIST,
   MENU_ENUM_LABEL_CB_MENU_WALLPAPER,
   MENU_ENUM_LABEL_CB_MENU_THUMBNAIL,
   MENU_ENUM_LABEL_CB_THUMBNAILS_UPDATER_LIST,
   MENU_ENUM_LABEL_CB_LAKKA_LIST,
   MENU_ENUM_LABEL_CB_CORE_CONTENT_LIST,
   MENU_ENUM_LABEL_CB_CORE_CONTENT_DIRS_LIST,
   MENU_ENUM_LABEL_CB_UPDATE_DATABASES,
   MENU_ENUM_LABEL_CB_LAKKA_DOWNLOAD,
   MENU_ENUM_LABEL_CB_UPDATE_CHEATS,
   MENU_ENUM_LABEL_CB_UPDATE_SHADERS_CG,
   MENU_ENUM_LABEL_CB_UPDATE_SHADERS_GLSL,
   MENU_ENUM_LABEL_CB_UPDATE_ASSETS,
   MENU_ENUM_LABEL_CB_CORE_CONTENT_DOWNLOAD,
   MENU_ENUM_LABEL_CB_UPDATE_CORE_INFO_FILES,
   MENU_ENUM_LABEL_CB_UPDATE_AUTOCONFIG_PROFILES,
   MENU_ENUM_LABEL_CB_CORE_UPDATER_DOWNLOAD,
   MENU_ENUM_LABEL_CB_CORE_THUMBNAILS_DOWNLOAD
};


/* Callback strings */

#define CB_CORE_UPDATER_DOWNLOAD                                               0x7412da7dU
#define CB_UPDATE_ASSETS                                                       0xbf85795eU

/* Deferred */

#define MENU_LABEL_DEFERRED_THUMBNAILS_UPDATER_LIST                            0x364dfa2bU
#define MENU_LABEL_DEFERRED_VIDEO_FILTER                                       0x966ad201U
#define MENU_LABEL_DEFERRED_CORE_LIST_SET                                      0xa6d5fdb4U
#define MENU_LABEL_DEFERRED_DATABASE_MANAGER_LIST                              0x7c0b704fU
#define MENU_LABEL_DEFERRED_CURSOR_MANAGER_LIST                                0x45446638U
#define MENU_LABEL_DEFERRED_CURSOR_MANAGER_LIST_RDB_ENTRY_DEVELOPER            0xcbd89be5U
#define MENU_LABEL_DEFERRED_CURSOR_MANAGER_LIST_RDB_ENTRY_PUBLISHER            0x125e594dU
#define MENU_LABEL_DEFERRED_CURSOR_MANAGER_LIST_RDB_ENTRY_ORIGIN               0x4ebaa767U
#define MENU_LABEL_DEFERRED_CURSOR_MANAGER_LIST_RDB_ENTRY_FRANCHISE            0x77f9eff2U
#define MENU_LABEL_DEFERRED_CURSOR_MANAGER_LIST_RDB_ENTRY_EDGE_MAGAZINE_RATING 0x1c7f8a43U
#define MENU_LABEL_DEFERRED_CURSOR_MANAGER_LIST_RDB_ENTRY_EDGE_MAGAZINE_ISSUE  0xaaeebde7U
#define MENU_LABEL_DEFERRED_CURSOR_MANAGER_LIST_RDB_ENTRY_FAMITSU_MAGAZINE_RATING 0xbf7ff5e7U
#define MENU_LABEL_DEFERRED_CURSOR_MANAGER_LIST_RDB_ENTRY_ENHANCEMENT_HW       0x9866bda3U
#define MENU_LABEL_DEFERRED_CURSOR_MANAGER_LIST_RDB_ENTRY_RELEASEMONTH         0x2b36ce66U
#define MENU_LABEL_DEFERRED_CURSOR_MANAGER_LIST_RDB_ENTRY_RELEASEYEAR          0x9c7c6e91U
#define MENU_LABEL_DEFERRED_CURSOR_MANAGER_LIST_RDB_ENTRY_ESRB_RATING          0x68eba20fU
#define MENU_LABEL_DEFERRED_CURSOR_MANAGER_LIST_RDB_ENTRY_ELSPA_RATING         0x8bf6ab18U
#define MENU_LABEL_DEFERRED_CURSOR_MANAGER_LIST_RDB_ENTRY_PEGI_RATING          0x5fc77328U
#define MENU_LABEL_DEFERRED_CURSOR_MANAGER_LIST_RDB_ENTRY_CERO_RATING          0x24f6172cU
#define MENU_LABEL_DEFERRED_CURSOR_MANAGER_LIST_RDB_ENTRY_BBFC_RATING          0x0a8e67f0U
#define MENU_LABEL_DEFERRED_CURSOR_MANAGER_LIST_RDB_ENTRY_MAX_USERS            0xbfcba816U
#define MENU_LABEL_DEFERRED_RDB_ENTRY_DETAIL                                   0xc35416c0U
#define MENU_LABEL_DEFERRED_RPL_ENTRY_ACTIONS                                  0x358a7494U
#define MENU_LABEL_DEFERRED_CORE_LIST                                          0xf157d289U
#define MENU_LABEL_DEFERRED_CORE_UPDATER_LIST                                  0xc315f682U
#define MENU_LABEL_DEFERRED_DRIVER_SETTINGS_LIST                               0xaa5efefcU
#define MENU_LABEL_DEFERRED_VIDEO_SETTINGS_LIST                                0x83c65827U
#define MENU_LABEL_DEFERRED_AUDIO_SETTINGS_LIST                                0x5bba25e2U
#define MENU_LABEL_DEFERRED_PLAYLIST_SETTINGS_LIST                             0x9518e0c7U
#define MENU_LABEL_DEFERRED_INPUT_SETTINGS_LIST                                0x050bec60U
#define MENU_LABEL_DEFERRED_USER_BINDS_LIST                                    0x28c5750eU
#define MENU_LABEL_DEFERRED_ACCOUNTS_CHEEVOS_LIST                              0x1322324cU
#define MENU_LABEL_DEFERRED_ACCOUNTS_LIST                                      0x3d2b8860U
#define MENU_LABEL_DEFERRED_ARCHIVE_ACTION_DETECT_CORE                         0xdc9c0064U
#define MENU_LABEL_DEFERRED_ARCHIVE_ACTION                                     0x7faf0284U
#define MENU_LABEL_DEFERRED_ARCHIVE_OPEN_DETECT_CORE                           0xd9452498U
#define MENU_LABEL_DEFERRED_ARCHIVE_OPEN                                       0xfa0938b8U
#define MENU_LABEL_DEFERRED_CORE_CONTENT_LIST                                  0x76150c63U
#define MENU_LABEL_DEFERRED_LAKKA_LIST                                         0x3db437c4U
#define MENU_LABEL_DEFERRED_INPUT_HOTKEY_BINDS_LIST                            0x10b41d97U

/* Cheevos settings */

#define MENU_LABEL_CHEEVOS_DESCRIPTION                                         0x7e00e0f5U

/* Playlist settings */

#define MENU_LABEL_PLAYLIST_SETTINGS_BEGIN                                     0x80a8d2cbU

/* Accounts settings */

#define MENU_LABEL_ACCOUNTS_CHEEVOS_PASSWORD                                   0x45cf62e3U
#define MENU_LABEL_ACCOUNTS_CHEEVOS_USERNAME                                   0x2bf153f0U
#define MENU_LABEL_ACCOUNTS_RETRO_ACHIEVEMENTS                                 0xe6b7c16cU
#define MENU_LABEL_ACCOUNTS_LIST                                               0x774c15a0U

#define MENU_LABEL_VALUE_ACCOUNTS_LIST_END                                     0x3d559522U


#define MENU_LABEL_DOWNLOADED_FILE_DETECT_CORE_LIST                            0xb4f82700U

/* Scan values */
#define MENU_LABEL_SCAN_THIS_DIRECTORY                                         0x6921b775U
#define MENU_LABEL_SCAN_DIRECTORY                                              0x57de303eU
#define MENU_LABEL_SCAN_FILE                                                   0xd5d1eee9U

/* Online updater settings */

#define MENU_LABEL_UPDATE_LAKKA                                                0x19b51eebU

/* Information settings */

#define MENU_LABEL_INFORMATION_LIST                                            0x225e7606U
#define MENU_LABEL_SYSTEM_INFORMATION                                          0x206ebf0fU
#define MENU_LABEL_NETWORK_INFORMATION                                         0x73ae3cb4U
#define MENU_LABEL_DEBUG_INFORMATION                                           0xeb0d82b1U

#define MENU_LABEL_CONTENT_SETTINGS                                            0xe789f7f6U

#define MENU_LABEL_RESET                                                       0x10474288U

#define MENU_LABEL_ARCHIVE_MODE                                                0x7fac00cbU
#define MENU_LABEL_USE_THIS_DIRECTORY                                          0xc51d351dU
#define MENU_LABEL_SAVE_STATE                                                  0x3a4849b5U
#define MENU_LABEL_LOAD_STATE                                                  0xa39eb286U
#define MENU_LABEL_REWIND                                                      0x1931d5aeU
#define MENU_LABEL_SHADER_NEXT                                                 0x54d359baU
#define MENU_LABEL_SHADER_PREV                                                 0x54d4a758U
#define MENU_LABEL_FRAME_ADVANCE                                               0xd80302a1U
#define MENU_LABEL_MOVIE_RECORD_TOGGLE                                         0xa2d2ff04U
#define MENU_LABEL_L_X_PLUS                                                    0xd7370d4bU
#define MENU_LABEL_L_X_MINUS                                                   0xbde0aaf3U
#define MENU_LABEL_L_Y_PLUS                                                    0xd98c35ecU
#define MENU_LABEL_L_Y_MINUS                                                   0x0adae7b4U
#define MENU_LABEL_R_X_PLUS                                                    0x60c20a91U
#define MENU_LABEL_R_X_MINUS                                                   0x78cb50f9U
#define MENU_LABEL_R_Y_MINUS                                                   0xc5c58dbaU
#define MENU_LABEL_R_Y_PLUS                                                    0x63173332U
#define MENU_LABEL_BLOCK_SRAM_OVERWRITE                                        0xc4e88d08U
#define MENU_LABEL_CORE_SPECIFIC_CONFIG                                        0x3c9a55e8U
#define MENU_LABEL_GAME_SPECIFIC_OPTIONS                                       0x142ec90fU
#define MENU_LABEL_SCREENSHOT                                                  0x9a37f083U
#define MENU_LABEL_SCREEN_RESOLUTION                                           0x5c9b3a58U

/* Menu settings */
#define MENU_LABEL_THUMBNAILS                                                  0x0a3ec67cU
#define MENU_LABEL_SAVESTATE_AUTO_SAVE                                         0xf6f4a05bU
#define MENU_LABEL_SAVESTATE_AUTO_LOAD                                         0xf6f1028cU
#define MENU_LABEL_SAVESTATE_AUTO_INDEX                                        0xd4da8b84U
#define MENU_LABEL_XMB_FONT                                                    0x0ECA56CA2
#define MENU_LABEL_XMB_THEME                                                   0x824c5a7eU
#define MENU_LABEL_XMB_GRADIENT                                                0x18e63099U
#define MENU_LABEL_XMB_RIBBON_ENABLE                                           0x8e89c3edU

#define MENU_LABEL_PERFCNT_ENABLE                                              0x6823dbddU

/* Video settings */
#define MENU_LABEL_VIDEO_FONT_PATH                                             0xd0de729eU
#define MENU_LABEL_VIDEO_VI_WIDTH                                              0x6e4a6d3aU
#define MENU_LABEL_VIDEO_VFILTER                                               0x664f8397U
#define MENU_LABEL_VIDEO_GAMMA                                                 0x08a951beU


#define MENU_LABEL_VIDEO_SHADER_PRESET_SAVE_AS                                 0x3d6e5ce5U
#define MENU_LABEL_VIDEO_SHADER_DEFAULT_FILTER                                 0x4468cb1bU
#define MENU_LABEL_VIDEO_SHADER_FILTER_PASS                                    0x1906c38dU
#define MENU_LABEL_VIDEO_SHADER_SCALE_PASS                                     0x18f7b82fU
#define MENU_LABEL_VIDEO_SHADER_NUM_PASSES                                     0x79b2992fU
#define MENU_LABEL_VIDEO_SHADER_PARAMETERS                                     0x9895c3e5U
#define MENU_LABEL_VIDEO_SHADER_PRESET_PARAMETERS                              0xd18158d7U
#define MENU_LABEL_VIDEO_SHADER_PASS                                           0x4fa31028U
#define MENU_LABEL_VIDEO_SHADER_PRESET                                         0xc5d3bae4U

/* Netplay settings */
#define MENU_LABEL_NETPLAY_FLIP_PLAYERS                                        0x801425abU

/* Input settings */
#define MENU_LABEL_INPUT_OVERLAY                                               0x24e24796U
#define MENU_LABEL_INPUT_KEYBOARD_GAMEPAD_MAPPING_TYPE                         0x3665cbb0U

#define MENU_LABEL_INPUT_HOTKEY_BINDS_BEGIN                                    0x5a56139bU
#define MENU_LABEL_INPUT_SMALL_KEYBOARD_ENABLE                                 0xe6736fc3U
#define MENU_LABEL_INPUT_ICADE_ENABLE                                          0xcd534dd0U
#define MENU_LABEL_INPUT_AUTODETECT_ENABLE                                     0xb1e07facU
#define MENU_LABEL_INPUT_DUTY_CYCLE                                            0xec787129U
#define MENU_LABEL_INPUT_BIND_DEVICE_ID                                        0xd1ea94ecU
#define MENU_LABEL_INPUT_BIND_DEVICE_TYPE                                      0xf6e9f041U
#define MENU_LABEL_INPUT_AXIS_THRESHOLD                                        0xe95c2095U

#define MENU_LABEL_INPUT_OSK_OVERLAY                                           0x11f1c582U

/* Record settings */

#define MENU_LABEL_RECORD_USE_OUTPUT_DIRECTORY                                 0x8343eff4U
#define MENU_LABEL_RECORD_CONFIG                                               0x11c3daf9U
#define MENU_LABEL_RECORD_PATH                                                 0x016d7afaU
#define MENU_LABEL_RECORD_ENABLE                                               0x1654e22aU

/* Cheat options */

#define MENU_LABEL_CHEAT_DATABASE_PATH                                         0x01388b8aU
#define MENU_LABEL_CHEAT_FILE_LOAD                                             0x57336148U
#define MENU_LABEL_CHEAT_INDEX_MINUS                                           0x57f58b6cU
#define MENU_LABEL_CHEAT_INDEX_PLUS                                            0x678542a4U
#define MENU_LABEL_CHEAT_TOGGLE                                                0xe515e0cbU
#define MENU_LABEL_CHEAT_FILE_SAVE_AS                                          0x1f58dccaU
#define MENU_LABEL_CHEAT_APPLY_CHANGES                                         0xde88aa27U

/* Disk settings */

#define MENU_LABEL_DISK_EJECT_TOGGLE                                           0x49633fbbU
#define MENU_LABEL_DISK_NEXT                                                   0xeeaf6c6eU
#define MENU_LABEL_DISK_CYCLE_TRAY_STATUS                                      0x3035cdc1U
#define MENU_LABEL_DISK_INDEX                                                  0x6c14bf54U
#define MENU_LABEL_DISK_OPTIONS                                                0xc61ab5fbU
#define MENU_LABEL_DISK_IMAGE_APPEND                                           0x5af7d709U

/* Menu settings */

#define MENU_LABEL_MENU_TOGGLE                                                 0xfb22e3dbU
#define MENU_LABEL_MENU_WALLPAPER                                              0x3b84de01U
#define MENU_LABEL_MENU_LINEAR_FILTER                                          0x5fe9128cU
#define MENU_LABEL_MENU_THROTTLE_FRAMERATE                                     0x9a8681c5U
#define MENU_LABEL_MENU_SETTINGS                                               0x61e4544bU

#define MENU_LABEL_ENABLE_HOTKEY                                               0xc04037bfU
#define MENU_LABEL_GRAB_MOUSE_TOGGLE                                           0xb2869aaaU
#define MENU_LABEL_STATE_SLOT_DECREASE                                         0xe48b8082U
#define MENU_LABEL_STATE_SLOT_INCREASE                                         0x36a0cbb0U

/* Libretro settings */
#define MENU_LABEL_LIBRETRO_LOG_LEVEL                                          0x57971ac0U

/* Directory settings */

#define MENU_LABEL_CURSOR_DIRECTORY                                            0xdee8d377U
#define MENU_LABEL_OSK_OVERLAY_DIRECTORY                                       0xcce86287U
#define MENU_LABEL_JOYPAD_AUTOCONFIG_DIR                                       0x2f4822d8U
#define MENU_LABEL_RECORDING_OUTPUT_DIRECTORY                                  0x30bece06U
#define MENU_LABEL_RECORDING_CONFIG_DIRECTORY                                  0x3c3f274bU
#define MENU_LABEL_LIBRETRO_DIR_PATH                                           0x1af1eb72U
#define MENU_LABEL_AUDIO_FILTER_DIR                                            0x4bd96ebaU
#define MENU_LABEL_VIDEO_SHADER_DIR                                            0x30f53b10U
#define MENU_LABEL_VIDEO_FILTER_DIR                                            0x67603f1fU
#define MENU_LABEL_SCREENSHOT_DIRECTORY                                        0x552612d7U
#define MENU_LABEL_SYSTEM_DIRECTORY                                            0x35a6fb9eU
#define MENU_LABEL_INPUT_REMAPPING_DIRECTORY                                   0x5233c20bU
#define MENU_LABEL_OVERLAY_DIRECTORY                                           0xc4ed3d1bU
#define MENU_LABEL_SAVEFILE_DIRECTORY                                          0x92773488U
#define MENU_LABEL_SAVESTATE_DIRECTORY                                         0x90551289U
#define MENU_LABEL_DYNAMIC_WALLPAPERS_DIRECTORY                                0x62f975b8U
#define MENU_LABEL_THUMBNAILS_DIRECTORY                                        0xdea77410U
#define MENU_LABEL_RGUI_BROWSER_DIRECTORY                                      0xa86cba73U
#define MENU_LABEL_CONTENT_DATABASE_DIRECTORY                                  0x6b443f80U
#define MENU_LABEL_PLAYLIST_DIRECTORY                                          0x6361820bU
#define MENU_LABEL_CORE_ASSETS_DIRECTORY                                       0x8ba5ee54U
#define MENU_LABEL_CONTENT_DIRECTORY                                           0x7738dc14U
#define MENU_LABEL_RGUI_CONFIG_DIRECTORY                                       0x0cb3e005U
#define MENU_LABEL_ASSETS_DIRECTORY                                            0xde1ae8ecU
#define MENU_LABEL_CACHE_DIRECTORY                                             0x851dfb8dU

/* RDB settings */

#define MENU_LABEL_NO_PLAYLIST_ENTRIES_AVAILABLE                               0x8888c5acU
#define MENU_LABEL_RDB_ENTRY_START_CONTENT                                     0x95025a55U
#define MENU_LABEL_RDB_ENTRY_PUBLISHER                                         0x4d7bcdfbU
#define MENU_LABEL_RDB_ENTRY_DEVELOPER                                         0x06f61093U
#define MENU_LABEL_RDB_ENTRY_ORIGIN                                            0xb176aad5U
#define MENU_LABEL_RDB_ENTRY_FRANCHISE                                         0xb31764a0U
#define MENU_LABEL_RDB_ENTRY_ENHANCEMENT_HW                                    0x79ee4f11U
#define MENU_LABEL_RDB_ENTRY_ESRB_RATING                                       0xe138fa3dU
#define MENU_LABEL_RDB_ENTRY_BBFC_RATING                                       0x82dbc01eU
#define MENU_LABEL_RDB_ENTRY_ELSPA_RATING                                      0x0def0906U
#define MENU_LABEL_RDB_ENTRY_PEGI_RATING                                       0xd814cb56U
#define MENU_LABEL_RDB_ENTRY_CERO_RATING                                       0x9d436f5aU
#define MENU_LABEL_RDB_ENTRY_EDGE_MAGAZINE_RATING                              0x9735f631U
#define MENU_LABEL_RDB_ENTRY_EDGE_MAGAZINE_ISSUE                               0xd5706415U
#define MENU_LABEL_RDB_ENTRY_FAMITSU_MAGAZINE_RATING                           0x01a50315U
#define MENU_LABEL_RDB_ENTRY_RELEASE_MONTH                                     0xad2f2c54U
#define MENU_LABEL_RDB_ENTRY_RELEASE_YEAR                                      0x14c9c6bfU
#define MENU_LABEL_RDB_ENTRY_MAX_USERS                                         0xfae91cc4U

#define MENU_LABEL_DETECT_CORE_LIST                                            0xaa07c341U
#define MENU_LABEL_DETECT_CORE_LIST_OK                                         0xabba2a7aU
#define MENU_LABEL_CLOSE_CONTENT                                               0x4b622170U
#define MENU_LABEL_CORE_LIST                                                   0xa22bb14dU
#define MENU_LABEL_MANAGEMENT                                                  0x2516c88aU
#define MENU_LABEL_FRONTEND_COUNTERS                                           0xe5696877U
#define MENU_LABEL_CORE_COUNTERS                                               0x64cc83e0U
#define MENU_LABEL_ACHIEVEMENT_LIST                                            0x7b90fc49U
#define MENU_LABEL_CORE_INFORMATION                                            0xb638e0d3U
#define MENU_LABEL_CORE_OPTIONS                                                0xf65e60f9U
#define MENU_LABEL_SHADER_OPTIONS                                              0x1f7d2fc7U
#define MENU_LABEL_CORE_CHEAT_OPTIONS                                          0x9293171dU
#define MENU_LABEL_CORE_INPUT_REMAPPING_OPTIONS                                0x7836a8caU
#define MENU_LABEL_DATABASE_MANAGER_LIST                                       0x7f853d8fU
#define MENU_LABEL_CURSOR_MANAGER_LIST                                         0xa969e378U
#define MENU_LABEL_REMAP_FILE_LOAD                                             0x9c2799b8U
#define MENU_LABEL_INFO_SCREEN                                                 0xd97853d0U
#define MENU_LABEL_CUSTOM_RATIO                                                0xf038731eU
#define MENU_LABEL_PAL60_ENABLE                                                0x62bc416eU
#define MENU_LABEL_CONTENT_HISTORY_PATH                                        0x6f22fb9dU
#define MENU_LABEL_RECORDING_SETTINGS                                          0x1a80b313U
#define MENU_LABEL_ONSCREEN_KEYBOARD_OVERLAY_SETTINGS                          0xa6de9ba6U
#define MENU_LABEL_PLAYLIST_SETTINGS                                           0xdb3e0e07U
#define MENU_LABEL_ARCHIVE_SETTINGS                                            0x78e85398U
#define MENU_LABEL_DIRECTORY_SETTINGS                                          0xb817bd2bU
#define MENU_LABEL_SHADER_APPLY_CHANGES                                        0x4f7306b9U
#define MENU_LABEL_ONSCREEN_DISPLAY_SETTINGS                                   0x67571029U
#define MENU_LABEL_CUSTOM_BIND                                                 0x1e84b3fcU
#define MENU_LABEL_CUSTOM_BIND_ALL                                             0x79ac14f4U
#define MENU_LABEL_CUSTOM_BIND_DEFAULTS                                        0xe88f7b13U
#define MENU_LABEL_CONFIGURATIONS                                              0x3e930a50U
#define MENU_LABEL_REMAP_FILE_SAVE_CORE                                        0x7c9d4c8fU
#define MENU_LABEL_REMAP_FILE_SAVE_GAME                                        0x7c9f41e0U
#define MENU_LABEL_CONTENT_COLLECTION_LIST                                     0x32d1df83U
#define MENU_LABEL_OSK_ENABLE                                                  0x8e208498U
#define MENU_LABEL_EXIT_EMULATOR                                               0x86d5d467U
#define MENU_LABEL_COLLECTION                                                  0x5fea5991U

#define MENU_LABEL_OPEN_ARCHIVE                                                0x78c0ca58U
#define MENU_LABEL_OPEN_ARCHIVE_DETECT_CORE                                    0x92442638U
#define MENU_LABEL_LOAD_ARCHIVE_DETECT_CORE                                    0x681f2f46U
#define MENU_LABEL_LOAD_ARCHIVE                                                0xc3834e66U

/* Help */
#define MENU_LABEL_REWIND_ENABLE                                               0x9761e074U
#define MENU_LABEL_REWIND_GRANULARITY                                          0xe859cbdfU

#define MENU_LABEL_LIBRETRO_INFO_PATH                                          0xe552b25fU

#define MENU_LABEL_AUTOSAVE_INTERVAL                                           0xecc87351U

#define MENU_LABEL_CONFIG_SAVE_ON_EXIT                                         0x79b590feU

#define MENU_LABEL_CAMERA_ALLOW                                                0xc14d302cU
#define MENU_LABEL_LOCATION_ALLOW                                              0xf089275cU

#define MENU_LABEL_OVERLAY_NEXT                                                0x7a459145U

#define MENU_LABEL_INPUT_DRIVER                                                0x4c087840U
#define MENU_LABEL_INPUT_DRIVER_LINUXRAW                                       0xc33c6b9fU
#define MENU_LABEL_INPUT_DRIVER_UDEV                                           0x7c9eeeb9U

#define MENU_LABEL_AUDIO_MUTE                                                  0xe0ca1151U
#define MENU_LABEL_AUDIO_DSP_PLUGIN                                            0x4a69572bU
#define MENU_LABEL_AUDIO_MAX_TIMING_SKEW                                       0x4c96f75cU

#define MENU_LABEL_AUDIO_RESAMPLER_DRIVER                                      0xedcba9ecU
#define MENU_LABEL_AUDIO_RESAMPLER_DRIVER_SINC                                 0x7c9dec52U
#define MENU_LABEL_AUDIO_RESAMPLER_DRIVER_CC                                   0x0059732bU

#define MENU_LABEL_VIDEO_DRIVER                                                0x1805a5e7U
#define MENU_LABEL_VIDEO_DRIVER_GL                                             0x005977f8U
#define MENU_LABEL_VIDEO_DRIVER_SDL2                                           0x7c9dd69aU
#define MENU_LABEL_VIDEO_DRIVER_SDL1                                           0x0b88a968U
#define MENU_LABEL_VIDEO_DRIVER_D3D                                            0x0b886340U
#define MENU_LABEL_VIDEO_DRIVER_EXYNOS                                         0xfc37c54bU
#define MENU_LABEL_VIDEO_DRIVER_SUNXI                                          0x10620e3cU
#define MENU_LABEL_VIDEO_DRIVER_DRM                                            0x61a89bfaU
#define MENU_LABEL_VIDEO_ROTATION                                              0x4ce6882bU
#define MENU_LABEL_VIDEO_SCALE                                                 0x09835d63U
#define MENU_LABEL_VIDEO_CROP_OVERSCAN                                         0x861f7a2fU
#define MENU_LABEL_VIDEO_SCALE_INTEGER                                         0x65c4b090U
#define MENU_LABEL_VIDEO_VSYNC                                                 0x09c2d34eU
#define MENU_LABEL_VIDEO_BLACK_FRAME_INSERTION                                 0x53477f5cU
#define MENU_LABEL_VIDEO_HARD_SYNC_FRAMES                                      0xce0ece13U
#define MENU_LABEL_VIDEO_FRAME_DELAY                                           0xd4aa9df4U
#define MENU_LABEL_VIDEO_FULLSCREEN                                            0x9506dd4eU
#define MENU_LABEL_VIDEO_SWAP_INTERVAL                                         0x5673ff9aU
#define MENU_LABEL_VIDEO_GPU_SCREENSHOT                                        0xee2fcb44U
#define MENU_LABEL_VIDEO_FILTER                                                0x1c0eb741U
#define MENU_LABEL_VIDEO_REFRESH_RATE_AUTO                                     0x9addb6cdU
#define MENU_LABEL_VIDEO_THREADED                                              0x0626179cU
#define MENU_LABEL_VIDEO_MONITOR_INDEX                                         0xb6fcdc9aU
#define MENU_LABEL_VIDEO_HARD_SYNC                                             0xdcd623b6U
#define MENU_LABEL_RGUI_SHOW_START_SCREEN                                      0x6b38f0e8U
#define MENU_LABEL_PAUSE_NONACTIVE                                             0x580bf549U
#define MENU_LABEL_AUDIO_DEVICE                                                0x2574eac6U
#define MENU_LABEL_AUDIO_VOLUME                                                0x502173aeU
#define MENU_LABEL_AUDIO_RATE_CONTROL_DELTA                                    0xc8bde3cbU
#define MENU_LABEL_SLOWMOTION_RATIO                                            0x626b3ffeU
#define MENU_LABEL_FASTFORWARD_RATIO                                           0x3a0c2706U
#define MENU_LABEL_INPUT_TURBO_PERIOD                                          0xf7a97482U
#define MENU_LABEL_LOG_VERBOSITY                                               0x6648c96dU
#define MENU_LABEL_SLOWMOTION                                                  0x6a269ea0U
#define MENU_LABEL_HOLD_FAST_FORWARD                                           0xebe2e4cdU
#define MENU_LABEL_PAUSE_TOGGLE                                                0x557634e4U
#define MENU_LABEL_WELCOME_TO_RETROARCH                                        0xbcff0b3cU
#define MENU_LABEL_HELP_CONTROLS                                               0x04859221U
#define MENU_LABEL_HELP_LIST                                                   0x006af669U
#define MENU_LABEL_HELP_WHAT_IS_A_CORE                                         0x83fcbc44U
#define MENU_LABEL_HELP_LOADING_CONTENT                                        0x231d8245U
#define MENU_LABEL_HELP_SCANNING_CONTENT                                       0x1dec52b8U
#define MENU_LABEL_HELP_CHANGE_VIRTUAL_GAMEPAD                                 0x6e66ef07U
#define MENU_LABEL_HELP_AUDIO_VIDEO_TROUBLESHOOTING                            0xd44d395cU
#define MENU_LABEL_TURBO                                                       0x107434f1U
#define MENU_LABEL_VOLUME_UP                                                   0xa66e9681U
#define MENU_LABEL_VOLUME_DOWN                                                 0xfc64f3d4U
#define MENU_LABEL_VALUE_EXTRACTING_PLEASE_WAIT                                0xec5a348bU

#define MENU_LABEL_VIDEO_DISABLE_COMPOSITION                                   0x5cbb6222U
#define MENU_LABEL_VALUE_MENU_CONTROLS_PROLOG                                  0x72674cdfU
#define MENU_LABEL_VALUE_HELP_WHAT_IS_A_CORE                                   0xf3b0f77eU
#define MENU_LABEL_VALUE_HELP_LOADING_CONTENT                                  0x70bab027U
#define MENU_LABEL_VALUE_HELP_LIST                                             0x6c57426aU
#define MENU_LABEL_VALUE_HELP_CONTROLS                                         0xe5c9f6a2U
#define MENU_LABEL_VALUE_WHAT_IS_A_CORE_DESC                                   0xc832957eU
#define MENU_LABEL_VALUE_HELP_CHANGE_VIRTUAL_GAMEPAD                           0x27ed0204U
#define MENU_LABEL_VALUE_HELP_CHANGE_VIRTUAL_GAMEPAD_DESC                      0x9d0e79dbU
#define MENU_LABEL_VALUE_HELP_AUDIO_VIDEO_TROUBLESHOOTING                      0xd0e5c3ffU
#define MENU_LABEL_VALUE_HELP_AUDIO_VIDEO_TROUBLESHOOTING_DESC                 0x60031d7aU
#define MENU_LABEL_VALUE_HELP_SCANNING_CONTENT                                 0x74b36f11U
#define MENU_LABEL_VALUE_HELP_SCANNING_CONTENT_DESC                            0xac947056U

/* Main menu */
#define MENU_LABEL_LOAD_CONTENT                                                0x828943c3U
#define MENU_LABEL_LOAD_CONTENT_LIST                                           0x5745de1fU
#define MENU_LABEL_LOAD_CONTENT_HISTORY                                        0xfe1d79e5U
#define MENU_LABEL_ADD_CONTENT_LIST                                            0x046f4668U
#define MENU_LABEL_ONLINE_UPDATER                                              0xcac0025eU
#define MENU_LABEL_SETTINGS                                                    0x1304dc16U
#define MENU_LABEL_SAVE_CURRENT_CONFIG                                         0x8840ba8bU
#define MENU_LABEL_SAVE_NEW_CONFIG                                             0xcce9ab72U
#define MENU_LABEL_HELP                                                        0x7c97d2eeU
#define MENU_VALUE_HORIZONTAL_MENU                                             0x35761704U
#define MENU_LABEL_QUIT_RETROARCH                                              0x84b0bc71U

const char *msg_hash_to_str(enum msg_hash_enums msg);

const char *msg_hash_to_str_fr(enum msg_hash_enums msg);
int menu_hash_get_help_fr(uint32_t hash, char *s, size_t len);

#ifdef HAVE_UTF8
const char *msg_hash_to_str_ru(enum msg_hash_enums msg);
#endif

const char *msg_hash_to_str_de(enum msg_hash_enums msg);
int menu_hash_get_help_de(uint32_t hash, char *s, size_t len);

const char *msg_hash_to_str_es(enum msg_hash_enums msg);
int menu_hash_get_help_es(uint32_t hash, char *s, size_t len);

const char *msg_hash_to_str_eo(enum msg_hash_enums msg);
int menu_hash_get_help_eo(uint32_t hash, char *s, size_t len);

const char *msg_hash_to_str_it(enum msg_hash_enums msg);
int menu_hash_get_help_it(uint32_t hash, char *s, size_t len);

const char *msg_hash_to_str_pt(enum msg_hash_enums msg);
int menu_hash_get_help_pt(uint32_t hash, char *s, size_t len);

const char *msg_hash_to_str_pl(enum msg_hash_enums msg);
int menu_hash_get_help_pl(uint32_t hash, char *s, size_t len);

const char *msg_hash_to_str_nl(enum msg_hash_enums msg);
int menu_hash_get_help_nl(uint32_t hash, char *s, size_t len);

const char *msg_hash_to_str_us(enum msg_hash_enums msg);
int menu_hash_get_help_us(uint32_t hash, char *s, size_t len);

int menu_hash_get_help(uint32_t hash, char *s, size_t len);

enum msg_file_type msg_hash_to_file_type(uint32_t hash);

uint32_t msg_hash_calculate(const char *s);

RETRO_END_DECLS

#endif

