#include "rheolef.h"
using namespace rheolef;
using namespace std;
#include "p_laplacian.h"
int main(int argc, char**argv) { 
  environment rheolef (argc,argv);
  geo omega_h (argv[1]);
  Float eps = numeric_limits<Float>::epsilon();
  string approx   = (argc > 2) ?      argv[2]  : "P1";
  Float  p        = (argc > 3) ? atof(argv[3]) : 1.5;
  Float  tol      = (argc > 4) ? atof(argv[4]) : eps;
  size_t max_iter = (argc > 5) ? atoi(argv[5]) : 500;
  derr << "# P-Laplacian problem by damped Newton:" << endl
       << "# geo = " << omega_h.name() << endl
       << "# approx = " << approx << endl
       << "# p = " << p << endl;
  p_laplacian F (p, omega_h, approx);
  field uh = F.initial ();
  int status = damped_newton (F, uh, tol, max_iter, &derr);
  dout << catchmark("p") << p << endl
       << catchmark("u") << uh;
  return status;
}
