#ifndef _RHEOLEF_VEC_CONCAT_H
#define _RHEOLEF_VEC_CONCAT_H
///
/// This file is part of Rheolef.
///
/// Copyright (C) 2000-2009 Pierre Saramito <Pierre.Saramito@imag.fr>
///
/// Rheolef is free software; you can redistribute it and/or modify
/// it under the terms of the GNU General Public License as published by
/// the Free Software Foundation; either version 2 of the License, or
/// (at your option) any later version.
///
/// Rheolef is distributed in the hope that it will be useful,
/// but WITHOUT ANY WARRANTY; without even the implied warranty of
/// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
/// GNU General Public License for more details.
///
/// You should have received a copy of the GNU General Public License
/// along with Rheolef; if not, write to the Free Software
/// Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
///
/// =========================================================================
// build vec from initializer lists
//
#include "rheolef/vec.h"

namespace rheolef {

template <class T, class M>
class vec_concat_value {
public:
// typedef:
 typedef enum { scalar, scalars, vector} variant_type;
// allocators:
 vec_concat_value (int x)                   : s(x), ss(),  v(),  variant(scalar) {}
 vec_concat_value (const T& x)              : s(x), ss(),  v(),  variant(scalar) {}
 vec_concat_value (const std::vector<T>& x) : s(),  ss(x), v(),  variant(scalars) {}
 vec_concat_value (const vec<T,M>& x)       : s(),  ss(),  v(x), variant(vector) {}
// data:
public:
 T              s;
 std::vector<T> ss;
 vec<T,M>       v;
 variant_type variant;
};

template <class T, class M>
class vec_concat {
public:
// typedef:
  typedef typename vec<T,M>::size_type   size_type;
  typedef vec_concat_value<T,M>          value_type;

// allocators:

  vec_concat () : _l() {}
  vec<T,M> build_vec() const;

#ifdef _RHEOLEF_HAVE_STD_INITIALIZER_LIST
  vec_concat (const std::initializer_list<value_type>& il) : _l() {
#ifdef _RHEOLEF_HAVE_STD_INITIALIZER_ITERATOR
    typedef typename std::initializer_list<value_type>::const_iterator const_iterator;
#else // _RHEOLEF_HAVE_STD_INITIALIZER_ITERATOR
    typedef const value_type* const_iterator;
#endif // _RHEOLEF_HAVE_STD_INITIALIZER_ITERATOR
    for (const_iterator iter = il.begin(); iter != il.end(); ++iter) {
        _l.push_back(*iter);
    }
  }
#endif // _RHEOLEF_HAVE_STD_INITIALIZER_LIST

#ifdef TO_CLEAN
  friend std::ostream& operator<< (std::ostream& o, const vec_concat<T,M>& x) {
    std::cout << "{";
    for(typename std::list<value_type>::const_iterator iter = x._l.begin(); iter != x._l.end(); ++iter) {
        std::cout << *iter << " ";
    }
    return std::cout << "}";
  }
#endif // TO_CLEAN

// data:
protected:
  std::list<value_type> _l;
};

#ifdef _RHEOLEF_HAVE_STD_INITIALIZER_LIST
template <class T, class M>
inline
vec<T,M>::vec (const std::initializer_list<vec_concat_value<T,M> >& init_list)
{
  vec_concat<T,M> vc (init_list);
  vec<T,M>::operator= (vc.build_vec());
}
template <class T, class M>
inline
vec<T,M>&
vec<T,M>::operator= (const std::initializer_list<vec_concat_value<T,M> >& init_list)
{
  vec_concat<T,M> vc (init_list);
  vec<T,M>::operator= (vc.build_vec());
  return *this;
}
#endif // _RHEOLEF_HAVE_STD_INITIALIZER_LIST

} // namespace rheolef
#endif // _RHEOLEF_VEC_CONCAT_H
