% -----------------------------------------------------------------------------
%  (C) Altran Praxis Limited
% -----------------------------------------------------------------------------
% 
%  The SPARK toolset is free software; you can redistribute it and/or modify it
%  under terms of the GNU General Public License as published by the Free
%  Software Foundation; either version 3, or (at your option) any later
%  version. The SPARK toolset is distributed in the hope that it will be
%  useful, but WITHOUT ANY WARRANTY; without even the implied warranty of
%  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the GNU General
%  Public License for more details. You should have received a copy of the GNU
%  General Public License distributed with the SPARK toolset; see file
%  COPYING3. If not, go to http://www.gnu.org/licenses for a complete copy of
%  the license.
% 
% =============================================================================


/*** NEWVC - load a new VC ready for a proof attempt ***/
newvc :-
        \+ is_vc(_X),
        !,
        nl,
        write('There are no VCs to prove.'),
        nl,
        fail.
newvc :-
        check_whether_to_proceed,
        clear_up_could_facts,
        fdl_file_title(TITLE),
        (
           command_arg(vc_number, VCNUM)
        ;
           nl,
           write('The following VCs have not yet been proved:'),
           nl,
           list_vcs_still_to_prove,
           repeat,
              nl,
              prompt_user('Which VC? '),
              rread(VCNUM)
        ),
        integer(VCNUM),
        makename(TITLE, VCNUM, VCNAME),
        (
           is_vc(VCNAME)
        ;
           write('VC does not exist; try again'),
           fail
        ),
        !,
        do_vc(VCNAME),
        assertz(logfact(vcname, VCNAME)),
        retractall(current_vc(_,_)),
        asserta(current_vc(VCNAME,VCNUM)),
        retractall(step_number(_)),
        asserta(step_number(0)),
        retractall(indentation(_)),
        asserta(indentation(0)),
        retractall(current_root(_,_)),                          /* CFR028 */
        retractall(var_const(_,_,p)),                           /* CFR028 */
        list,
        !.


/* DO_VC(LABEL) - clear up and try to prove VC stored as vc(LABEL,FACT) ***/
do_vc(N) :-
   clear_vc,
   retractall(case_pointer(_)),
   assertz(case_pointer(0)),
   retractall(vc_name(_)),
   retractall(on_case(_,_,_)),
   retractall(case(_,_,_)),
   retractall(proved_for_case(_,_)),
   add_vc(N), !.


/*** CLEAR_VC - retract all current hypotheses and conclusions ***/
clear_vc :-
        retractall(hyp(_,_)),
        retractall(conc(_,_)),
        retractall(forgotten(_)),
        retractall(deleted(_)),
        retractall(deleted_hyp(_,_)),
        retractall(subgoal_formula(_,_,_,_)),
        retractall(qvar(_)),
        retractall(uvar(_)),
        nl.


add_vc(N) :- vc(N,Fact), asserta(Fact), fail.
add_vc(_).


list_vcs_still_to_prove :-
        vcs_to_prove(VCLIST),
        tab(5),
        write_numbers_left(VCLIST),
        !.

write_numbers_left([[N]]) :-
        print(N),
        nl,
        !.
write_numbers_left([[L|REST]]) :-
        last(REST,U),
        print(L-U),
        nl,
        !.
write_numbers_left([[N]|OTHERS]) :-
        print(N),
        write(', '),
        write_numbers_left(OTHERS),
        !.
write_numbers_left([[L|REST]|OTHERS]) :-
        last(REST,U),
        print(L-U),
        write(', '),
        write_numbers_left(OTHERS),
        !.


check_whether_to_proceed :-
        \+ conc(_,_),
        case_pointer(0),
        current_vc(_, N),
        vcs_to_prove(VCS),
        \+ still_left_to_prove(N, VCS),
        !.
check_whether_to_proceed :-
        \+ conc(_,_),
        case_pointer(0),
        \+ current_vc(_, _),            /* for startup case */
        !.
check_whether_to_proceed :-
        nl,
        write('WARNING: The proof of the current VC is incomplete, either because there'),
        nl,
        write('are still some unproven conclusions, or because you need another "done".'),
        nl,
        write('(You may wish to complete proof (with DONE?) before proceeding.)'),              /* CFR002 */
        nl, nl,
        repeat,
           write('Type "yes" to continue NEWVC command, "no" to continue this proof ...'),
           nl,                                                  /* CFR002 */
           read_answer('Perform NEWVC', REPLY),                 /* CFR002 */
        /* until */ (REPLY = yes ; REPLY = no),
        !,
        REPLY = yes.


/*** still_left_to_prove(N, VCS) ***/
still_left_to_prove(N, [N]).
still_left_to_prove(N, [H|_]) :-
        is_in(N, H).
still_left_to_prove(N, [_|T]) :-
        still_left_to_prove(N, T).
%###############################################################################
%END-OF-FILE
