-------------------------------------------------------------------------------
-- (C) Altran Praxis Limited
-------------------------------------------------------------------------------
--
-- The SPARK toolset is free software; you can redistribute it and/or modify it
-- under terms of the GNU General Public License as published by the Free
-- Software Foundation; either version 3, or (at your option) any later
-- version. The SPARK toolset is distributed in the hope that it will be
-- useful, but WITHOUT ANY WARRANTY; without even the implied warranty of
-- MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the GNU General
-- Public License for more details. You should have received a copy of the GNU
-- General Public License distributed with the SPARK toolset; see file
-- COPYING3. If not, go to http://www.gnu.org/licenses for a complete copy of
-- the license.
--
--=============================================================================

-- packed version of Get_Expected_Symbols.
separate (SP_Expected_Symbols)
procedure Get_Expected_Symbols
  (Error_State         : in     SP_Productions.SP_State;
   No_Of_Terminals     :    out SP_Ess_Sym_Range;
   Terminal_List       :    out SP_Exp_Sym_List;
   No_Of_Non_Terminals :    out SP_Ess_Sym_Range;
   Non_Terminal_List   :    out SP_Exp_Sym_List)
is
   Loc_Entry                          : Ess_Symbol_Entry;
   Sym_List_Index                     : Exp_Sym_Range;
   Terminal_Count, Non_Terminal_Count : SP_Ess_Sym_Range;
begin
   Loc_Entry          := Expected_Symbols (Error_State);
   Sym_List_Index     := Exp_Sym_Range ((Loc_Entry / Index) mod Index_Lim);
   Terminal_Count     := SP_Ess_Sym_Range ((Loc_Entry / N_Terminals) mod Term_Lim);
   Non_Terminal_Count := SP_Ess_Sym_Range ((Loc_Entry / N_Non_Terminals) mod Non_Term_Lim);

   for CurrIndex in SP_Ess_Sym_Range range 1 .. Terminal_Count loop
      --# accept Flow, 23, Terminal_List, "Expected flow error";
      Terminal_List (CurrIndex) := Essential_Symbols (Sym_List_Index);
      --# end accept;

      if CurrIndex < Terminal_Count then
         Sym_List_Index := Sym_List_Index + 1;
      end if;
   end loop;

   if Natural (Non_Terminal_Count) > 0 then
      Sym_List_Index := Exp_Sym_Range ((Natural ((Loc_Entry / Index) mod Index_Lim)) + Natural (Terminal_Count));
      for CurrIndex in SP_Ess_Sym_Range range 1 .. Non_Terminal_Count loop
         --# accept Flow, 23, Non_Terminal_List, "Expected flow error";
         Non_Terminal_List (CurrIndex) := Essential_Symbols (Sym_List_Index);
         --# end accept;

         if CurrIndex < Non_Terminal_Count then
            Sym_List_Index := Sym_List_Index + 1;
         end if;
      end loop;
   end if;

   if Error_State = 1 and then Terminal_Count = 0 and then Non_Terminal_Count = 0 then
      Non_Terminal_Count := 1;
      --# accept Flow, 504, Non_Terminal_List, "Expected flow error";
      Non_Terminal_List (1) := SP_Symbols.SP_Non_Terminal'Succ (SP_Symbols.SP_Non_Terminal'First);
      --# end accept;
   end if;
   No_Of_Terminals     := Terminal_Count;
   No_Of_Non_Terminals := Non_Terminal_Count;

   --# accept Flow, 602, Terminal_List, Terminal_List, "Expected flow error" &
   --#        Flow, 602, Non_Terminal_List, Non_Terminal_List, "Expected flow error";
end Get_Expected_Symbols;
