/* ====================================================================
 * Copyright (c) 2009       Martin Hauner
 *                          http://subcommander.tigris.org
 *
 * Subcommander is licensed as described in the file doc/COPYING, which
 * you should have received as part of this distribution.
 * ====================================================================
 */

#ifndef _WCVIEWITEMPROXYMODEL_TEST_H
#define _WCVIEWITEMPROXYMODEL_TEST_H

// cppunit
#include <cppunit/TestFixture.h>
#include <cppunit/extensions/HelperMacros.h>

// sc
class ConfigManager;
class WcViewModel;
class WcViewItemProxyModel;
class WcViewTreeItemModel;

// qt
#include <QtCore/QObject>
class QModelIndex;


class WcViewItemProxyModelTest : public CppUnit::TestCase 
{
  CPPUNIT_TEST_SUITE( WcViewItemProxyModelTest );
  CPPUNIT_TEST( emitsModelResetSignals );
  CPPUNIT_TEST( emitsLayoutChangedSignals );
  CPPUNIT_TEST( emitsRowsInsertedSignals );
  CPPUNIT_TEST_SUITE_END(); 

public:
  void setUp();
  void tearDown();

  // Tests
  void emitsModelResetSignals();
  void emitsLayoutChangedSignals();
  void emitsRowsInsertedSignals();

#if 0
  void srcDataChanged( const QModelIndex& srcTopLeft, const QModelIndex&
    srcBottomRight );
  void srcHeaderDataChanged( Qt::Orientation orientation,
    int first, int last );
  void srcRowsAboutToBeInserted( const QModelIndex& srcParent,
    int start, int end );
  void srcRowsAboutToBeRemoved( const QModelIndex& srcParent,
    int start, int end );
  void srcRowsInserted( const QModelIndex& srcParent,
    int start, int end );
  void srcRowsRemoved( const QModelIndex& srcParent,
    int start, int end );
#endif

private:
  WcViewTreeItemModel*  _model;
  WcViewItemProxyModel* _proxy;
};

#endif // _WCVIEWITEMPROXYMODEL_TEST_H
