/* ====================================================================
 * Copyright (c) 2009       Martin Hauner
 *                          http://subcommander.tigris.org
 *
 * Subcommander is licensed as described in the file doc/COPYING, which
 * you should have received as part of this distribution.
 * ====================================================================
 */

#ifndef _ASSERTIONTRAIT_UUID_H
#define _ASSERTIONTRAIT_UUID_H

// sc
#include "util/uuid.h"
#include "util/String.h"

CPPUNIT_NS_BEGIN

/** This adds Uuid support to CPPUNIT_ASSERT_EQUALS. */
template<> struct /*CPPUNIT_NS::*/assertion_traits<Uuid>
{
  static bool equal( const Uuid& x, const Uuid& y )
  {
    return x == y;
  }

  static std::string toString( const Uuid& x )
  {
    sc::String uuid = x.toString();
    std::string text = '"' + 
      (!uuid.isEmpty() ? std::string(uuid) : "<null>") + '"';
    OStringStream ost;
    ost << text;
    return ost.str();
  }
};

CPPUNIT_NS_END


#endif // _ASSERTIONTRAIT_UUID_H
