/* ====================================================================
 * Copyright (c) 2003-2006, The Subcommander Crew
 *                          http://subcommander.tigris.org
 *
 * Subcommander is licensed as described in the file doc/COPYING, which
 * you should have received as part of this distribution.
 * ====================================================================
 */

#ifndef _SC_GUARD_H
#define _SC_GUARD_H

namespace sc
{

/**
 * Guard for scoped locking.
 * Template allows us usage with arbitary lock types, eg Mutex, RWLock, NullLock.
 */
template<class LOCK> class Guard
{
public:
  Guard(LOCK& lock) : _lock(lock)
  {
    _lock.lock();
  }

  ~Guard()
  {
    _lock.unlock();
  }

private:
  LOCK& _lock;
};

} // namespace

#endif // _SC_GUARD_H
