// Copyright 2019-2021 Graham Clark. All rights reserved.  Use of this source
// code is governed by the MIT license that can be found in the LICENSE
// file.

package streams

import (
	"fmt"
	"log"
	"strings"
	"testing"

	"github.com/stretchr/testify/assert"
)

//======================================================================

// 	00000010  30 61 20 53 65 72 76 65  72 20 28 50 72 6f 46 54  0a Serve r (ProFT
// 	00000020  50 44 20 41 6e 6f 6e 79  6d 6f 75 73 20 53 65 72  PD Anony mous Ser
// 	00000030  76 65 72 29 20 5b 31 39  32 2e 31 36 38 2e 31 2e  ver) [19 2.168.1.
// 	00000040  32 33 31 5d 0d 0a                                 231]..
// 00000000  55 53 45 52 20 66 74 70  0d 0a                    USER ftp ..
// 	00000046  33 33 31 20 41 6e 6f 6e  79 6d 6f 75 73 20 6c 6f  331 Anon ymous lo
// 	00000056  67 69 6e 20 6f 6b 2c 20  73 65 6e 64 20 79 6f 75  gin ok,  send you
// 	00000066  72 20 63 6f 6d 70 6c 65  74 65 20 65 6d 61 69 6c  r comple te email
// 	00000076  20 61 64 64 72 65 73 73  20 61 73 20 79 6f 75 72   address  as your
// 	00000086  20 70 61 73 73 77 6f 72  64 2e 0d 0a               passwor d...
// 0000000A  50 41 53 53 20 66 74 70  0d 0a                    PASS ftp ..

func TestArgConv(t *testing.T) {
	inp1 := `

===================================================================
Follow: tcp,raw
Filter: tcp.stream eq 0
Node 0: 192.168.1.182:62014
Node 1: 192.168.1.231:21
	3232302050726f4654504420312e332e306120536572766572202850726f4654504420416e6f6e796d6f75732053657276657229205b3139322e3136382e312e3233315d0d0a
55534552206674700d0a
	33333120416e6f6e796d6f7573206c6f67696e206f6b2c2073656e6420796f757220636f6d706c65746520656d61696c206164647265737320617320796f75722070617373776f72642e0d0a
===================================================================
`
	fmt.Printf("GCLA: testing '%s'\n", inp1)
	got, err := ParseReader("", strings.NewReader(inp1))
	if err != nil {
		log.Fatal(err)
	}
	fmt.Println("=", got)
}

func TestArgConv2(t *testing.T) {
	inp1 := `

===================================================================
Follow: tcp,raw
Filter: tcp.stream eq 0
Node 0: 192.168.0.114:1137
Node 1: 192.168.0.193:21
	3232302050726f4654504420312e332e306120536572766572202850726f4654504420416e6f6e796d6f75732053657276657229205b3139322e3136382e312e3233315d0d0a
55534552206674700d0a
	33333120416e6f6e796d6f7573206c6f67696e206f6b2c2073656e6420796f757220636f6d706c65746520656d61696c206164647265737320617320796f75722070617373776f72642e0d0a
50415353206674700d0a
	32333020416e6f6e796d6f757320616363657373206772616e7465642c207265737472696374696f6e73206170706c792e0d0a
535953540d0a
	32313520554e495820547970653a204c380d0a
464541540d0a
	3231312d46656174757265733a0a204d44544d0a20524553542053545245414d0a2053495a450d0a
	32313120456e640d0a
5057440d0a
	32353720222f222069732063757272656e74206469726563746f72792e0d0a
455053560d0a
	32323920456e746572696e6720457874656e6465642050617373697665204d6f646520287c7c7c35383631327c290d0a
4c4953540d0a
	313530204f70656e696e67204153434949206d6f6465206461746120636f6e6e656374696f6e20666f722066696c65206c6973740d0a
	323236205472616e7366657220636f6d706c6574652e0d0a
5459504520490d0a
	32303020547970652073657420746f20490d0a
53495a4520726573756d652e646f630d0a
	3231332033393432340d0a
455053560d0a
	32323920456e746572696e6720457874656e6465642050617373697665204d6f646520287c7c7c33373130307c290d0a
5245545220726573756d652e646f630d0a
	313530204f70656e696e672042494e415259206d6f6465206461746120636f6e6e656374696f6e20666f7220726573756d652e646f6320283339343234206279746573290d0a
	323236205472616e7366657220636f6d706c6574652e0d0a
4d44544d20726573756d652e646f630d0a
	3231332032303037303831353032323235320d0a
4357442075706c6f6164730d0a
	3235302043574420636f6d6d616e64207375636365737366756c0d0a
5057440d0a
	32353720222f75706c6f616473222069732063757272656e74206469726563746f72792e0d0a
455053560d0a
	32323920456e746572696e6720457874656e6465642050617373697665204d6f646520287c7c7c33363938367c290d0a
53544f5220524541444d450d0a
	313530204f70656e696e672042494e415259206d6f6465206461746120636f6e6e656374696f6e20666f7220524541444d450d0a
	323236205472616e7366657220636f6d706c6574652e0d0a
4d4b4420746573746469720d0a
	35353020746573746469723a2046696c65206578697374730d0a
===================================================================
`
	fmt.Printf("Testing: '%s'\n", inp1)
	got, err := ParseReader("", strings.NewReader(inp1))
	if err != nil {
		log.Fatal(err)
	}
	fmt.Println("=", got)
}

type errContext struct{}

func (f errContext) Err() error {
	return StreamParseError{}
}

type noErrContext struct{}

func (f noErrContext) Err() error {
	return nil
}

func TestArgConv3(t *testing.T) {
	inp1 := `

===================================================================
Follow: tcp,raw
Filter: tcp.stream eq 0
Node 0: 192.168.0.114:1137
Node 1: 192.168.0.193:21
	3232302050726f4654504420312e332e306120536572766572202850726f4654504420416e6f6e796d6f75732053657276657229205b3139322e3136382e312e3233315d0d0a
55534552206674700d0a
===================================================================
`
	fmt.Printf("Testing: '%s'\n", inp1)
	_, err := ParseReader("", strings.NewReader(inp1), GlobalStore("context", errContext{}))
	assert.Error(t, err)
	_, err = ParseReader("", strings.NewReader(inp1), GlobalStore("context", noErrContext{}))
	assert.NoError(t, err)
}

//======================================================================
// Local Variables:
// mode: Go
// fill-column: 110
// End:
