/*
 * Find service
 *
 * This plugin is released under the GPL
 */
 
#include <includes.h>

#define EN_NAME "Services"
#define FR_NAME "Services"

#define EN_FAMILY "Misc."
#define FR_FAMILY "Divers"

#define EN_DESC "This plugin attempts to guess which\n\
service is running on the remote ports. For instance,\n\
it searches for a web server which could listen on\n\
another port than 80 and set the results in the plugins\n\
knowledge base.\n\n\
Risk factor : None"

#define FR_DESC "Ce plugin tente de deviner quels\n\
services tournent sur quels ports.\n\
Par exemple, il cherche si un serveur\n\
web tourne sur un port autre que le 80\n\
et il stocke ses rsultats dans la\n\
base de connaissance des plugins.\n\n\
Facteur de risque : Aucun"

#define EN_COPY "Written by Renaud Deraison <deraison@cvs.nessus.org>"
#define FR_COPY "Ecrit par Renaud Deraison <deraison@cvs.nessus.org>"

#define EN_SUMM "Find what is listening on which port"
#define FR_SUMM "Dtermine ce qui coute sur quel port"
/*
 * XXX
 * This plugin is highly beta and NOT complete
 *
 */
 
int plugin_init(desc)
 struct arglist * desc;
{ 
 plug_set_name(desc, FR_NAME, "francais");
 plug_set_name(desc, EN_NAME, NULL);
 
 
 plug_set_category(desc, ACT_GATHER_INFO);
 
 
 plug_set_family(desc, FR_FAMILY, "francais");
 plug_set_family(desc, EN_FAMILY, NULL);
 
 plug_set_description(desc, FR_DESC, "francais");
 plug_set_description(desc, EN_DESC, NULL);
 
 plug_set_summary(desc, FR_SUMM, "francais");
 plug_set_summary(desc, EN_SUMM,NULL);
 
 plug_set_copyright(desc, FR_COPY, "francais");
 plug_set_copyright(desc, EN_COPY, NULL);
 return(0);
}


void mark_nntp_server(desc, port, buffer)
 struct arglist * desc;
 int port;
 char * buffer;
{
 plug_set_key(desc, "Services/nntp", ARG_INT, (void*)port);
 plug_set_key(desc, "nntp/banner", ARG_STRING, buffer);
 if(port!=119)
  post_info(desc, port, "an NNTP server is running on this port");
}


void mark_http_server(desc, port, buffer)
 struct arglist * desc;
 int port;
 char * buffer;
{
   plug_set_key(desc, "Services/www", ARG_INT, (void *)port);
   plug_set_key(desc, "www/banner", ARG_STRING, buffer);
   if(port != 80)
      post_info(desc, port, "a web server is running on this port");
    
}

void mark_rmserver(desc, port, buffer)
 struct arglist * desc;
 int port;
 char * buffer;
{
   plug_set_key(desc, "Services/realserver", ARG_INT, (void *)port);
   plug_set_key(desc, "realserver/banner", ARG_STRING, buffer);
   post_info(desc, port, "a RealMedia server is running on this port");
    
}

void mark_smtp_server(desc, port, buffer)
 struct arglist * desc;
 int port;
 char * buffer;
{
 plug_set_key(desc, "Services/smtp", ARG_INT, (void *)port);
 plug_set_key(desc, "smtp/banner", ARG_STRING, buffer);
 if(strstr(buffer, " postfix"))plug_set_key(desc, "smtp/postfix", ARG_INT,(void*) 1);
 if(port != 25)
 {
  char * report = emalloc(255 + strlen(buffer));
  char *t = strchr(buffer, '\n');
  if(t)t[0]=0;
  sprintf(report, "a SMTP server is running on this port.\n\
Here is its banner : \n%s", buffer);
   post_info(desc, port, report);
   efree(&report);
 }
}

void mark_ftp_server(desc, port, buffer)
 struct arglist * desc;
 int port;
 char * buffer;
{
 plug_set_key(desc, "Services/ftp", ARG_INT, (void *)port);
 plug_set_key(desc, "ftp/banner", ARG_STRING, buffer);
 if(port != 21)
 {
  char * report = emalloc(255 + strlen(buffer));
  char *t = strchr(buffer, '\n');
  if(t)t[0]=0;
  sprintf(report, "a FTP server is running on this port.\n\
Here is its banner : \n%s", buffer);
   post_info(desc, port, report);
   efree(&report);
 }
}

void
mark_ssh_server(desc, port, buffer)
 struct arglist * desc;
 int port;
 char * buffer;
{
 plug_set_key(desc, "Services/ssh", ARG_INT, (void *)port);
 while((buffer[strlen(buffer)-1]=='\n')||
       (buffer[strlen(buffer)-1]=='\r'))buffer[strlen(buffer)-1]='\0';
 plug_set_key(desc, "ssh/banner", ARG_STRING, buffer);
 if(port!=22)post_info(desc, port, "a ssh server is running on this port");
}

void
mark_http_proxy(desc, port, buffer)
 struct arglist * desc;
 int port;
 char * buffer;
{
 plug_set_key(desc, "Services/http_proxy", ARG_INT, (void *)port);
 plug_set_key(desc, "http_proxy/banner", ARG_STRING, buffer);
 post_info(desc, port, "an HTTP proxy is running on this port");
}

void
mark_pop_server(desc, port, buffer)
 struct arglist * desc;
 int port;
 char * buffer;
{
 char * c = strchr(buffer, '\n');
 if(c)c[0]=0;
 if(!strcmp(buffer, "+ok"))
  {
  plug_set_key(desc, "Services/pop1", ARG_INT, (void *)port);
  plug_set_key(desc, "pop1/banner", ARG_STRING, buffer);
  }
  else if(!strcmp(buffer, "+ok pop2"))
   {
   plug_set_key(desc, "Services/pop2", ARG_INT, (void *)port);
   plug_set_key(desc, "pop2/banner", ARG_STRING, buffer);
   }
   else
    {
    plug_set_key(desc, "Services/pop3", ARG_INT, (void *)port);
    plug_set_key(desc, "pop3/banner", ARG_STRING, buffer);
    }
}

void
mark_imap_server(desc, port, buffer)
 struct arglist * desc;
 int port;
 char * buffer;
{
 plug_set_key(desc, "Services/imap", ARG_INT, (void *)port);
 plug_set_key(desc, "imap/banner", ARG_STRING, buffer);
 if(port != 143)post_info(desc, port, "an IMAP server is running on this port");
}

void
mark_linuxconf(desc, port, buffer)
 struct arglist * desc;
 int port;
 char * buffer;
{
 plug_set_key(desc, "Services/linuxconf", ARG_INT, (void *)port);
 plug_set_key(desc, "linuxconf/banner", ARG_STRING, buffer);
 
 post_info(desc, port, "Linuxconf is running on this port");
}
int plugin_run(desc)
 struct arglist * desc;
{
 struct arglist * h = arg_get_value(desc, "HOSTNAME");
 char * head = "Ports/tcp/";
 int len_head = strlen(head);
 if(!h)return(1);
 h = arg_get_value(desc, "key");
 if(!h)return(1);
 /*
  * Search for a web server and stop when one is found
  */
 while(h && h->next)
 {
  if((strlen(h->name) > len_head)&&
     !strncmp(h->name, head, len_head))
  {
  int soc;
  char * buffer = emalloc(2048);
  fd_set fd;
  int port = atoi(h->name+len_head);
  struct timeval tv = {3,0};
  soc = open_sock_tcp(desc, port);
  if(soc >= 0)
  {
   sprintf(buffer, "HEAD / HTTP/1.0\n\n");
   send(soc, buffer, strlen(buffer), 0);
   FD_ZERO(&fd);
   FD_SET(soc, &fd);
   if(select(soc+1, &fd, NULL, NULL, &tv)>0)
   {
    int i;
    int len;
    bzero(buffer, 2000);
    recv(soc, buffer, 2048, 0);
    len = strlen(buffer);
    for(i=0;i<len;i++)buffer[i] = tolower(buffer[i]);
    if(strstr(buffer, "smtp"))
    	mark_smtp_server(desc, port, buffer);	
    else if(strstr(buffer, "rmserver")||strstr(buffer, "realserver"))
        mark_rmserver(desc, port, buffer);
    else if(strstr(buffer, "http")&&strstr(buffer, "200"))
    	mark_http_server(desc, port, buffer);   
    else if(strstr(buffer, "ftp"))
    	mark_ftp_server(desc, port, buffer);	
    else if(strstr(buffer, "ssh"))
    	mark_ssh_server(desc, port, buffer);
    else if(strstr(buffer, "+ok"))
    	mark_pop_server(desc, port, buffer);
    else if(strstr(buffer, "* ok imap4"))
    	mark_imap_server(desc, port, buffer);
      else if(strstr(buffer, "inn ")||strstr(buffer, "posting OK"))
    	mark_nntp_server(desc, port, buffer);	
    else if(strstr(buffer, "networking/linuxconf"))
        mark_linuxconf(desc, port, buffer);	
    else if(strstr(buffer, "http")&&strstr(buffer, "cache")&&
    	    strstr(buffer, "error"))
	mark_http_proxy(desc, port, buffer);	
   }
   shutdown(soc, 2);
   close(soc);
   efree(&buffer);
   }
  }
  if(h)h = h->next;
  }
 return(0);
}
