#
# This script was written by Noam Rathaus <noamr@securiteam.com>
#
# See the Nessus Scripts License for details
#

if(description)
{
 name["english"] = "Predicable TCP Sequence number";
 script_name(english:name["english"]);
 
 desc["english"] = "Take a look at the TCP Sequence number changes, retrieved from the IP stack.
If the change isn't sufficiently randomized, a remote attacker can perform
sequence number predication. This can help a remote attacker create
successful attacks, such as Session Hijacking and Session Spoofing. The
nature of these attacks require an attacker to predict the next sequence
number, and therefore to prevent these attacks, the TCP sequence number has
to change randomly.

More Information:
http://www.securiteam.com/unixfocus/Linux_vulnerable_to_Blind_TCP_Spoofing.html

Risk factor : Depends on the outcome.";

 script_description(english:desc["english"]);
 
 summary["english"] = "Predicable TCP Sequence number";
 script_summary(english:summary["english"]);
 
 script_category(ACT_GATHER_INFO);
 
 script_copyright(english:"This script is Copyright (C) 1999 SecuriTeam");
 family["english"] = "General";
 script_family(english:family["english"]);
 script_exclude_keys("Host/tcp_seq");
 
 exit(0);
}

#
# The script code starts here
#

key = get_kb_item("Host/tcp_seq");
if(key)exit(0);


srcaddr = this_host();
dstaddr = get_host_ip();

IPH = 20;
IP_LEN = IPH; 

ip = forge_ip_packet(   ip_v : 4,
			ip_hl : 5,
			ip_tos : 0,
			ip_len : IP_LEN, 
		        ip_id : 0xABA,
			ip_p : IPPROTO_TCP,
			ip_ttl : 255,
		        ip_off : 0,
			ip_src : srcaddr,
			ip_dst : dstaddr);

port = get_host_open_port();
if(!port)port = 139;
 
tcpip = forge_tcp_packet(    ip       : ip,
                             th_sport : port,
                             th_dport : port,
                             th_flags : TH_SYN,
                             th_seq   : 0xF1C,
                             th_ack   : 0,
                             th_x2    : 0,
                             th_off   : 5,
                             th_win   : 512,
                             th_urp   : 0);

filter = string("tcp and (src addr ", dstaddr, " and dst addr ", srcaddr, " dst port ", port, ")"); 

data_warning = "
Predictable TCP sequence number : 
If numbers are close apart, or rise by the same number all the time,
it means that it is easy to predict the next sequence number that will
be used by the computer (since these aren't randomized enough).

This may help attackers with several other attacks, such as Session
Hijacking or with Session Spoofing, where in those cases the attacker
needs to predict certain charactistics of the attacked computer.

The TCP sequence numbers retrieved and their relative size were: 
";

relative = -1;  
answer_count = 0;
for (packet_count = 0; packet_count < 10; packet_count = packet_count + 1)  
{
 result = send_packet(tcpip, pcap_active:TRUE, filter:filter);
 if ((packet_count > 5) && (answer_count == 0))
 {
  exit(0);
 }

 if (result)
 {
  answer_count = answer_count + 1;
  tcp_seq = get_tcp_element(tcp:result, element:"th_seq");
  if (relative == -1)
  {
   relative = tcp_seq;
   data_warning = data_warning + string("SEQ: ", tcp_seq, "\n");
  }
  else
  {
   relative = tcp_seq - relative;
   data_warning = data_warning + string("SEQ: ", tcp_seq, " relative size: ", relative, "\n");
   relative = tcp_seq;
  }
 }
}

if (answer_count) security_warning(port:0, data:data_warning);

