/***************************************************************************/
/* 	This code is part of X-toolkit widget library called Nws 	   */
/*	Copyright (c) 1997,1998,1999 Ondrejicka Stefan			   */
/*	(ondrej@idata.sk)						   */
/*	Distributed under GPL 2 or later				   */
/***************************************************************************/

#include <X11/IntrinsicP.h>
#include <X11/StringDefs.h>
#include <Nws/CardP.h>
#include <Nws/Init.h>
#include <Nws/utils.h>
#include <X11/extensions/shape.h>
#include <Nws/cvt.h>

static XtResource resources[] = {
	{XtNjustify ,
	 XtCJustify ,
	 XtRJustify ,
	 sizeof(((CardRec*)NULL)->card.justify),
	 XtOffsetOf(CardRec,card.justify),
	 XtRImmediate ,
	 (XtPointer) XtCcenter 
	},
	{XtNlabel,
	 XtCLabel,
	 XtRString,
	 sizeof(((CardRec*)NULL)->card.label),
	 XtOffsetOf(CardRec,card.label),
	 XtRImmediate,
	(XtPointer) NULL 
	},
	{XtNfont,
	 XtCFont,
	 XtRFontStruct,
	 sizeof(XFontStruct *),
	 XtOffsetOf(CardRec,card.font),
	 XtRString,
	 (XtPointer) XtDefaultFont 
	},
	{XtNactivate,
	 XtCActivate,
	 XtRCallback,
	 sizeof(((CardRec*)NULL)->card.activate),
	 XtOffsetOf(CardRec,card.activate),
	 XtRImmediate,
	 (XtPointer)NULL 
	},
	{XtNcorner,
	 XtCCorner,
	 XtRInt,
	 sizeof(int),
	 XtOffsetOf(CardRec,card.corner),
	 XtRImmediate,
	 (XtPointer) 3,
	},
	{XtNspacing,
	 XtCSpacing,
	 XtRInt,
	 sizeof(int),
	 XtOffsetOf(CardRec,card.spacing),
	 XtRImmediate,
	 (XtPointer) 4,
	},
        {
         XtNbox_type,
         XtCBox_type,
         XtRBox_type,
         sizeof(int),
	 XtOffsetOf(CardRec,base.box_type),
         XtRImmediate,
         (XtPointer) XtCno_box
        },
};

static void draw_tab ();

static void ClassInitialize();
static void Initialize ();
static void Realize ();
static void Resize ();
static void Redisplay ();
static void Activate ();
static XtGeometryResult QueryGeometry();
static void Destroy();


static XtActionsRec actions[] = {
{"activate", Activate},
};

static char trans_tab[] = 
	"<Btn1Down>: activate()\n\
	 <Key>space: activate()\n\
	 <Key>Return: activate()\n\
	 <Enter>: highlight() show_help()\n\
         <Leave>: unhighlight() hide_help()\n\
	 ~Shift<Key>Tab: traverseForward()\n\
	 Shift<Key>Tab: traverseBackward()\n\
	 <FocusIn>: focusIn()\n\
	 <FocusOut>: focusOut()\n\
         <BtnDown>: hide_help()\n\
         <KeyDown>: hide_help()";

CardClassRec cardClassRec = {
{ 
/* core */
/* superclass */		(WidgetClass) &baseClassRec,
/* class_name */		"Card",
/* widget_size */		sizeof(CardRec),
/* class_initialize */		ClassInitialize,
/* class_part_initialize */	NULL,
/* class_inited */		FALSE,
/* initialize */		(XtInitProc) Initialize,
/* initialize_hook */		NULL,
/* realize */			Realize,
/* actions */			actions,
/* num_actions */		XtNumber(actions),
/* resources */			resources,
/* num_resources */		XtNumber(resources),
/* xrm_class */			NULLQUARK,
/* compress_motion */		True ,
/* compress_exposure */		True,
/* compress_enterleave */	True ,
/* visible_interest */		False ,
/* destroy */			Destroy,
/* resize */			(XtWidgetProc) Resize,
/* expose */			(XtExposeProc) Redisplay,
/* set_values */		NULL,
/* set_values_hook */		NULL,
/* set_values_almost */		XtInheritSetValuesAlmost,
/* get_values_hook */		NULL,
/* accept_focus */		XtInheritAcceptFocus,
/* version */			XtVersion,
/* callback_private */		NULL,
/* tm_tabel */			trans_tab,
/* query_geometry */		QueryGeometry,
/* display_accelerator */	XtInheritDisplayAccelerator,
/* extensions */		NULL, 
   },
/* base */
   {
    /* get_internal_dimension  */ XtInheritGetInternalDimension,
    /* set_internal_dimension  */ XtInheritSetInternalDimension,
    /* highlight	       */ XtInheritHighlight,
    /* unhighlight	       */ XtInheritUnhighlight,
    /* highlightBorder	       */ XtInheritHighlightBorder,
    /* unhighlightBorder       */ XtInheritUnhighlightBorder,
   },
   {
/* empty */			0
   }
};

WidgetClass cardWidgetClass = (WidgetClass) &cardClassRec;

static void ClassInitialize()
{
	_InitializeWidgetSet();
}


static void Activate(w,event,params,num_params)
Widget w;
XEvent*event;
String*params;
Cardinal*num_params;
{
	CardWidget cw = (CardWidget) w;

	if (cw->card.activate)
		XtCallCallbackList(w,cw->card.activate, NULL);

}


static void Initialize(request,w,args,num_args)
Widget  request;
Widget w;
ArgList  args;
Cardinal * num_args;
{

	CardWidget cw = (CardWidget) w;
	XtGCMask mask;
	XGCValues values;
	Display *dpy = XtDisplay(w);
	Dimension width = 0, height = 0;

	values.background = cw->core.background_pixel;
	values.foreground = cw->base.foreground;
	mask =  GCBackground | GCForeground;
	cw->card.linegc = XCreateGC(dpy,RootWindowOfScreen(XtScreen(w)),
			mask, &values);

	values.foreground = cw->base.foreground;
	values.background = cw->core.background_pixel;
	values.font = ((CardWidget)w)->card.font->fid;
	mask= GCForeground | GCFont | GCBackground;
	cw->card.textgc = XCreateGC(dpy,RootWindowOfScreen(XtScreen(w)),
			mask, &values);

	if (cw->card.label)
	{
		height= cw->card.font->max_bounds.descent +
			cw->card.font->max_bounds.ascent + 2*cw->card.spacing +
			cw->base.box_width;
		width=  2*cw->card.spacing + 2*cw->base.box_width +
			XTextWidth(cw->card.font,cw->card.label,
				   strlen(cw->card.label));

		cw->card.label = XtNewString(cw->card.label);

	}

	if (!cw->core.width) cw->core.width = width;
	if (!cw->core.height) cw->core.height = height;
}

static void Destroy (w)
Widget w;
{
	CardWidget cw = (CardWidget) w;

	XtDestroyGC(cw->card.textgc);
	XtDestroyGC(cw->card.linegc);

	if (cw->card.label)
		XtFree(cw->card.label);
}

static void Realize(w,mask,attributes)
Widget w;
XtValueMask * mask;
XSetWindowAttributes * attributes;
{
    Region region;
    XPoint poly[7];
    CardWidget cw = (CardWidget) w;

    coreClassRec.core_class.realize(w, mask, attributes);

    /*
     *   2 o------------------o 3
     *    /                    \
     *  1 o		       o 4
     *    |		       |
     *  0 o--------------------o 5
     */
    poly[0].x = 0;			poly[0].y = cw->core.height;
    poly[1].x = 0;			poly[1].y = cw->card.corner;
    poly[2].x = cw->card.corner;	poly[2].y = 0;
    poly[3].x = cw->core.width - cw->card.corner;	poly[3].y = 0;
    poly[4].x = cw->core.width;		poly[4].y = cw->card.corner;
    poly[5].x = cw->core.width;		poly[5].y = cw->core.height;
    poly[6] = poly[0];

    region = XPolygonRegion(poly, 7, EvenOddRule);
    XShapeCombineRegion(XtDisplay(w), XtWindow(w), ShapeBounding,
			0, 0, region, ShapeSet);
    XDestroyRegion(region);
}

static void Resize(w)
Widget w;
{
    Region region;
    XPoint poly[7];
    CardWidget cw = (CardWidget) w;

    if (! XtIsRealized(w)) return;

    poly[0].x = 0;			poly[0].y = cw->core.height;
    poly[1].x = 0;			poly[1].y = cw->card.corner;
    poly[2].x = cw->card.corner;	poly[2].y = 0;
    poly[3].x = cw->core.width - cw->card.corner;	poly[3].y = 0;
    poly[4].x = cw->core.width;		poly[4].y = cw->card.corner;
    poly[5].x = cw->core.width;		poly[5].y = cw->core.height;
    poly[6] = poly[0];

    region = XPolygonRegion(poly, 7, EvenOddRule);
    XShapeCombineRegion(XtDisplay(w), XtWindow(w), ShapeBounding,
			0, 0, region, ShapeSet);
    XDestroyRegion(region);
}

static void Redisplay(w,event,region)
Widget w;
XEvent * event;
Region  region;
{
	CardWidget cw = (CardWidget) w;

	if (! XtIsRealized(w)) return;

	draw_tab(w);

	if (cw->base.focused) 
		((BaseWidgetClass)w->core.widget_class)->base_class.highlightBorder(w);

	if (!XtIsSensitive(w)) Xt_SetInsensitive(w);
}

static void draw_tab(w)
Widget w;
{
	CardWidget cw = (CardWidget) w;
	XPoint poly[8];
	Display *dpy = XtDisplay(w);
	int width,twidth,yp;

	if (cw->card.label)
	{
		twidth = XTextWidth(cw->card.font , cw->card.label ,
			strlen(cw->card.label));
		width = cw->core.width - 2 * (cw->card.spacing + cw->base.box_width);
		yp = (cw->core.height ) / 2 + cw->base.box_width +
			(cw->card.font->max_bounds.descent + 
			cw->card.font->max_bounds.ascent) / 2 ;

		switch (cw->card.justify)
			
		{
			case XtCleft:
				XDrawString(XtDisplay(w),XtWindow(w),cw->card.textgc,
					cw->card.spacing + cw->base.box_width , yp ,
					cw->card.label,strlen(cw->card.label));
				break;
			case XtCright:
				XDrawString(XtDisplay(w),XtWindow(w),cw->card.textgc,
					width + cw->card.spacing + cw->base.box_width
					- twidth , yp ,
					cw->card.label,strlen(cw->card.label));
				break;
			default:
				XDrawString(XtDisplay(w),XtWindow(w),cw->card.textgc,
					(width + cw->card.spacing + cw->base.box_width)/2
					- twidth / 2 , yp ,
					cw->card.label,strlen(cw->card.label));
		}
						
	}

	poly[0].x = 0;			poly[0].y = cw->core.height;
	poly[1].x = 0;			poly[1].y = cw->card.corner;
	poly[2].x = cw->card.corner;	poly[2].y = 0;
	poly[3].x = cw->core.width - cw->card.corner;	poly[3].y = 0;
	poly[4].x = cw->core.width - cw->card.corner - cw->base.box_width; poly[4].y = cw->base.box_width;
	poly[5].x = cw->card.corner + cw->base.box_width; poly[5].y = cw->base.box_width;
	poly[6].x = cw->base.box_width; poly[6].y = cw->card.corner + cw->base.box_width;
	poly[7].x = cw->base.box_width; poly[7].y = cw->core.height;

	XSetForeground(XtDisplay(w),cw->card.linegc,cw->base.light);

	XFillPolygon(dpy,XtWindow(w),cw->card.linegc,poly,8,Convex,CoordModeOrigin);


	poly[0].x = cw->core.width - cw->card.corner;	poly[0].y = 0;
	poly[1].x = cw->core.width;	poly[1].y = cw->card.corner;
	poly[2].x = cw->core.width;	poly[2].y = cw->core.height;
	poly[3].x = cw->core.width - cw->base.box_width; poly[3].y = cw->core.height;
	poly[4].x = cw->core.width - cw->base.box_width; poly[4].y = cw->card.corner;
	poly[5].x = cw->core.width - cw->card.corner - cw->base.box_width; poly[5].y = cw->base.box_width;
	
	XSetForeground(XtDisplay(w),cw->card.linegc,cw->base.dark);

	XFillPolygon(dpy,XtWindow(w),cw->card.linegc,poly,6,Convex,CoordModeOrigin);

}

static XtGeometryResult QueryGeometry(w, intended , preferred)
Widget w;
XtWidgetGeometry *intended;
XtWidgetGeometry *preferred;
{
        CardWidget cw = (CardWidget) w;

        preferred->request_mode = CWWidth | CWHeight;

        preferred->width = (Dimension)(cw->core.width);
        preferred->height = (Dimension)(cw->core.height);

        if (((intended->request_mode & (CWWidth | CWHeight))
                == (CWWidth | CWHeight)) &&
                intended->width == preferred->width &&
                intended->height == preferred->height)
                return XtGeometryYes;

        else if (preferred->width == cw->core.width &&
                preferred->height == cw->core.height)
                return XtGeometryNo;

        else return XtGeometryAlmost;

}
