/***************************************************************************/
/* 	This code is part of X-toolkit widget library called Nws 	   */
/*	Copyright (c) 1997,1998,1999 Ondrejicka Stefan			   */
/*	(ondrej@idata.sk)						   */
/*	Distributed under GPL 2 or later				   */
/***************************************************************************/

#ifndef _ColP_H_
#define _ColP_H_

#include	<Nws/BaseConstP.h>
#include	<Nws/Col.h>


typedef struct {
	char	empty;
} ColClassPart;

typedef struct _ColClassRec {
	CoreClassPart		core_class;
	CompositeClassPart	composite_class;
	ConstraintClassPart	constraint_class;
	BaseConstClassPart	baseConst_class;
	ColClassPart		col_class;
} ColClassRec;

extern ColClassRec colClassRec;

typedef struct {
	/* resources */
	int		spacing;
	Boolean		homogenous;
	/* private */
} ColPart;

typedef struct _ColRec {
	CorePart		core;
	CompositePart		composite;
	ConstraintPart		constraint;
	BaseConstPart		baseConst;
	ColPart			col;
} ColRec;

typedef struct _ColConstraintsPart {
	int	gravitation;
	int	bottom_space;
	int	top_space;
	Boolean resizable;
} ColConstraintsPart;

typedef struct _ColConstraintsRec {
	ColConstraintsPart	col;
} ColConstraintsRec, *ColConstraints;

#endif
