//
//  Configuration.h - the main Configuration class that will be right under
//  	the root data structure, Althea.  
//  -- created 4/20/00  updated 4/20/00
///////////////////////////////////////////////////////////////////////

#ifndef CONFIGURATION_H
#define CONFIGURATION_H
namespace std {};
using namespace std;

#include <iostream.h>
#include <string>
#include <gdk/gdkkeysyms.h>
#include <gtk/gtk.h>
#include <stdlib.h>

// Enum class for our keystrokes
enum keystrokes {
	//For Main Window
	CHECK_MAIL,
	DELETE_MESSAGE,
	FORWARD_MESSAGE,
	COMPOSE_MESSAGE,
	PRINT_MESSAGE,
	QUIT_ALTHEA,
	REPLY_MESSAGE,
	SAVE_MESSAGE,
	
	// New Message window accelerators
	SEND_MESSAGE,
	ATTACH_FILE,
	CLOSE_MESSAGE
	
};
	
class Configuration
{
private:
	bool expert_mode;
	unsigned int key_accelerators[20];
public:
	// Constructor
	Configuration ()
	{
		for (int i = 0; i < 20; i++)
			key_accelerators[i] = 0;
	}
	// Accessors
	bool get_expert_mode();
	unsigned int get_key_accelerator(keystrokes key);

	// Mutators
	void toggle_expert_mode();
	void set_expert_mode();
	void set_beginner_mode();
	void set_key_accelerator(keystrokes key, char accelerator);

	// Debugging purposes only
	void display( );
};

#endif
