#include <string>
#include <memory>
#include <ace/Method_Object.h>
#include <ace/Task.h>
#include <ace/Activation_Queue.h>
#include <ace/Synch.h>

class DBThreadPool: public ACE_Task<ACE_MT_SYNCH> {

public:

  // upperQueueLimit and lowerQueueLimit default values, which so far aren't overrided , mark the
  // request queue size mean average values that make us grow or shrink. This should be tuned. If
  // you find that they aren't accurate for your needs, modify them and recompile.
  
  DBThreadPool(int initThreads = 4, 
	       int minThreads = 4,
	       int maxThreads = 20,
	       int upperQueueLimit = 2,
	       int lowerQueueLimit = 0);   
  
  ~DBThreadPool();

  // ACE_Task
  void open(int nthreads);
  void shutdown();
  int svc(void);

  // Do Work
  void submit(ACE_Method_Object *t);
  int reviewThreads(int growBlock);

private:

  int growThreads(int growth);
  int shrinkThreads(int shrink);
  /*  int checkmem(string message);  */

  // Memory control
  int _initialMemory;
  int _lastMemory;

  int updateMovingAverage(int value);
  int _nThreads;
  int _initThreads;
  int _minThreads;
  int _maxThreads;

  const static unsigned int MOVING_AVERAGE_SIZE = 5;
  int _movingAverage[MOVING_AVERAGE_SIZE];

  // Config
  int _upperQueueLimit;
  int _lowerQueueLimit;

  // Accounting
  int _growCount;
  int _shrinkCount;




public:

  // Used by the thread pool
  inline int getQueueSize() { return activation_queue_.method_count(); }
  inline int getThreads() { return _nthreads.value(); }
  inline string getName() { return _name; }

private:

  string _name;
  ACE_Atomic_Op<ACE_Thread_Mutex,int> _nthreads;
  ACE_Activation_Queue activation_queue_;


};
