/* hey emacs! -*- Mode: C++; c-file-style: "stroustrup"; indent-tabs-mode: nil -*- */
/*
 * $Id: DdtMD.cc,v 1.2 2002/04/08 07:11:28 benoit Exp $
 *
 * Copyright (c) 2001 Benoit Joly <benoit@dhis.net>
 *
 * DDT comes with ABSOLUTELY NO WARRANTY and is licenced under the
 * GNU General Public License (version 2 or later). This license
 * can be retrieved from http://www.gnu.org/copyleft/gnu.html.
 *
 */
#include <string.h>
#include "DdtMD.h"

DdtMD::DdtMD(MDAlgos algo)
{
    this->algo = algo;
  
    // create a cipher handle
    mdHandle = gcry_md_open((gcry_md_algos)algo, 0);  
  
    if(mdHandle == NULL)
    {
        // mdHandler is null
    }
}

DdtMD::~DdtMD()
{
    // close the mdHandle
    gcry_md_close(mdHandle);
}

void DdtMD::write(unsigned char *buf, int length)
{
    gcry_md_write(mdHandle, buf, length);
}

int DdtMD::getAlgoDigestLength(MDAlgos algo)
{
    return gcry_md_get_algo_dlen(algo);
}

int DdtMD::digest(MDAlgos algo, unsigned char* buf, int bufLength, unsigned char * digest, int digestLength)
{
    DdtMD md(algo);
    md.write(buf, bufLength);
    return md.doFinal(digest, digestLength);
}


int DdtMD::doFinal(unsigned char *buf, int length)
{
    gcry_md_final(mdHandle);

    byte *md = gcry_md_read(mdHandle, algo);

    int mdLength = getAlgoDigestLength(algo);

    if(length < mdLength)
    {
        // error
    }

    memcpy(buf, md, mdLength);

    return mdLength;
}
