/*
 *    Copyright (C) 1998,1999,2000 Nikos Mavroyanopoulos
 *
 *    This program is free software; you can redistribute it and/or modify
 *    it under the terms of the GNU General Public License as published by
 *    the Free Software Foundation; either version 2 of the License, or
 *    (at your option) any later version.
 *
 *    This program is distributed in the hope that it will be useful,
 *    but WITHOUT ANY WARRANTY; without even the implied warranty of
 *    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *    GNU General Public License for more details.
 *
 *    You should have received a copy of the GNU General Public License
 *    along with this program; if not, write to the Free Software
 *    Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
 */

/* $Id: random.c,v 1.1.1.1 2000/05/22 13:09:35 nmav Exp $ */

#ifndef DEFINES_H
#define DEFINES_H
#include <defines.h>
#endif

static char rcsid[] = "$Id: random.c,v 1.1.1.1 2000/05/22 13:09:35 nmav Exp $";

#ifdef HAVE_DEV_RANDOM

static FILE *ffd;

word32
get_rand32()
{
	int fd, x;
	word32 rand_data;

	fd = open(NAME_OF_DEV_URANDOM, O_RDONLY);
	if (fd == -1) {
		perror(NAME_OF_DEV_URANDOM);
		exit(-1);
	}
	do {
		x = read(fd, &rand_data, sizeof(rand_data));
	}
	while (x != sizeof(rand_data) && x > 0);
	close(fd);

	return rand_data;

}


word8
get_rand8()
{

	int fd, x;
	word8 rand_data;

	fd = open(NAME_OF_DEV_URANDOM, O_RDONLY);
	if (fd == -1) {
		perror(NAME_OF_DEV_URANDOM);
		exit(-1);
	}
	do {
		x = read(fd, &rand_data, sizeof(rand_data));
	}
	while (x != sizeof(rand_data) && x > 0);
	close(fd);

	return rand_data;
}



word32
get_safe_rand32()
{
	int fd, x;
	word32 rand_data;

	fd = open(NAME_OF_DEV_RANDOM, O_RDONLY);
	if (fd == -1) {
		perror(NAME_OF_DEV_RANDOM);
		exit(-1);
	}
	do {
		x = read(fd, &rand_data, sizeof(rand_data));
	}
	while (x != sizeof(rand_data) && x > 0);
	close(fd);

	return rand_data;

}


word8
get_safe_rand8()
{

	int fd, x;
	word8 rand_data;

	fd = open(NAME_OF_DEV_RANDOM, O_RDONLY);
	if (fd == -1) {
		perror(NAME_OF_DEV_RANDOM);
		exit(-1);
	}
	do {
		x = read(fd, &rand_data, sizeof(rand_data));
	}
	while (x != sizeof(rand_data) && x > 0);
	close(fd);

	return rand_data;
}

/* When need of many data is required */

int open_rand(int safe)
{
	if (safe == 0) {
		ffd = fopen(NAME_OF_DEV_URANDOM, "rb");
		if (ffd == NULL) {
			perror(NAME_OF_DEV_URANDOM);
			exit(-1);
		}
	} else {
		ffd = fopen(NAME_OF_DEV_RANDOM, "rb");
		if (ffd == NULL) {
			perror(NAME_OF_DEV_RANDOM);
			exit(-1);
		}
	}
	return 0;
}

void close_rand()
{
	fclose(ffd);
}

word32
get_o_rand32()
{
	int x;
	word32 rand_data;

	do {
		x = fread(&rand_data, sizeof(rand_data), 1, ffd);
	}
	while (x != sizeof(rand_data) && x > 0);

	return rand_data;

}

word8
get_o_rand8()
{

	int x;
	word8 rand_data;

	do {
		x = fread(&rand_data, sizeof(rand_data), 1, ffd);
	}
	while (x != sizeof(rand_data) && x > 0);

	return rand_data;
}


#endif				/* HAVE_DEV_RANDOM */
