#include <ptlib.h>

#include "main.h"
#include "version.h"

#include <h323ep.h>
#include <h323t38.h>

PCREATE_PROCESS(T38App);

T38EndPoint::T38EndPoint()
{
}

T38EndPoint::~T38EndPoint()
{
}

T38App::T38App()
	: PProcess("Open H323 Project", "T38App", 
		MAJOR_VERSION, MINOR_VERSION, BUILD_TYPE, BUILD_NUMBER)
{
}

T38App::~T38App()
{
}

void T38App::Main()
{

  PConfigArgs args(GetArguments());

  args.Parse(
    "t-trace."
    "o-output:"
    "-tcp."
    "-udp."
    "u:"
    "F"
    , FALSE);

  if (args.GetCount() < 1) {
    cout << "usage: t38 [options] destaddr" << endl
         << "where options are:" << endl
         << "  -t    enable tracing" << endl
         << "  -o    output tracing to file" << endl
	 << "  -u    set local username" << endl
	 << "  --udp enable UDP transport" << endl
	 << "  --tcp enable TCP transport" << endl
	 << "  -F    disable fastStart" << endl;

    return;
  }

  PString destAddr = args[0];

  PTrace::Initialise(args.GetOptionCount('t'),
	                   args.HasOption('o') ? (const char *)args.GetOptionString('o') : NULL);

  T38EndPoint endpoint;
  if (args.HasOption('u'))
    endpoint.SetLocalUserName(args.GetOptionString('u'));
  else
    endpoint.SetLocalUserName(getenv("USER"));

  H323_T38Capability::TransportMode transportMode = H323_T38Capability::e_UDP;
  if (args.HasOption("udp"))
    transportMode = H323_T38Capability::e_UDP;
  else if (args.HasOption("tcp"))
    transportMode = H323_T38Capability::e_SingleTCP;

  endpoint.SetCapability(0, 0, new H323_T38Capability(transportMode));

  if (args.HasOption('F'))
    endpoint.DisableFastStart(TRUE);
	
  PTRACE(1, "Making the call...");

  PString token;
  endpoint.MakeCall(destAddr, token);

  Sleep(100000);
}
