/***************************************************************************
                          qdbtableviewsum.cpp  -  description
                             -------------------
    begin                : Mon Jul 24 2000
    version              : $Id: qdbtableviewsum.cpp,v 1.5 2001/03/14 13:59:04 joerg_bemme Exp $
    copyright            : (C) 2000 by Jrg Bemm
    email                : info@bemme.de
 ***************************************************************************/

/***************************************************************************
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 ***************************************************************************/

#include "qdbtableviewsum.h"

QDBTableViewSum::QDBTableViewSum(QWidget *parent, const char *name,
														SQLQuerier *sql_ptr, SQLTable *table_ptr,
														const char *fields_ptr )
: QDBTableView(parent,name,sql_ptr,table_ptr)
{
	table = table_ptr;
	fields = fields_ptr;

	setMinimumSize( 600, 400 );

	buildSums();
}

QDBTableViewSum::~QDBTableViewSum(){
}

void QDBTableViewSum::buildSums()
{
	int i,ii,i3;
	float fSumme;
	QString sSumme;
	QString value;
	QDBListViewItem *lItem;

	if (table->sQuery.length() != 0) {
		if (columns() == 0)
			getColumns();

		clear();

		// add 2 lines
		for ( i = 1; i > -1; i-- ) {
			lItem = new QDBListViewItem( this, 0, 0 );
			// Loop through all datafields
			for ( ii = 0; ii < table->getnFields(); ii++ ) {
				if (i == 0) { // first line
					if (ii != 0)
						if (strstr(fields, table->fName(ii)) != NULL)
							lItem->setText( ii, "------------" );
				} else {
					if (ii != 0) {
						if (strstr(fields, table->fName(ii)) != NULL) {
							if (nTuples > 0) {
								fSumme = 0;
								for ( i3 = 0; i3 < table->getnTuples(); i3++ ) {
									value = table->getValue( i3, table->fName(ii) );
									fSumme = fSumme + value.toFloat();
								}
								sSumme.setNum(fSumme);
								lItem->setText( ii, sSumme );
							}
						}
					}
				}
			}
		}
		// read tuples
		update( table, false );
	}
}
