/* Seahorse
 *
 * Copyright (C) 1999, 2000 Anthony Mulcahy
 * Copyrigth (C) 2000,2001 Jos Carlos Garca Sogo
 *   
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 * 
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA 02111-1307, USA.
 *
 */

#ifdef HAVE_CONFIG_H
#  include <config.h>
#endif

#include <gnome.h>

#include <sys/types.h>
#include <sys/wait.h>
#include <stdio.h>
#include <stdlib.h>
#include <string.h>
#include <unistd.h>
#include <errno.h>
#include <fcntl.h>
#include <ctype.h>

#include "gpg-interface.h"
#include "seahorsesig.h"
#include "seahorse.h"
#include "support.h"
#include "keyrings.h"


GtkWidget *decrypt_fileselection;
GtkWidget *encrypt_fileselection;
GtkWidget *encrypt_outfs;
GtkWidget *decrypt_outfs;
GtkWidget *pref_dialog;
GtkWidget *verify_decrypt;
GtkWidget *sign_encrypt;
GtkWidget *find_string_dialog;
char		*signencrypt_filename;
char		*signencrypt_outfilename;
char		*signencrypt_username;
char		*verifydecrypt_filename;
char		*verifydecrypt_outfilename;
char		*comment;
char		*default_cipher;
char		*last_find_string;
static gchar 		*default_key = NULL;
int		ascii_arm = 1;
int		datasrc_active_btn = 1;
int		enable_comment = 1;
int		output_to_file = 0;
int		textmode = 0;
int		signencrypt_active_btn = 0;
int		verifydecrypt_active_btn = 0;

/********************* Internal State Variables *********************/

static char	*clipboard_string = NULL;
static int	clearsign = 1;
static int	decrypt = 0;
static int	detachedsign = 0;
static int	encrypt_flag = 0;
static int	selection_received = FALSE;
static int	sign = 0;
static int	textarea = TRUE;


/********************* Utility Routines *********************/


gint
check_entry       (GtkWidget	*widget,
				gchar		**text)
{
     *text = g_strdup (gtk_entry_get_text (GTK_ENTRY (widget)) );
	if (strlen (*text) == 0) {
		gtk_widget_grab_focus (widget);
		return 1;
	} else return 0;
}


gint
check_free_entry	       (GtkWidget	*widget,
					gchar		**text)
{
	gchar	*text_buf;

     text_buf = gtk_entry_get_text (GTK_ENTRY (widget));
	if (*text != NULL)
			free (*text);
     *text = strdup (text_buf);
	if (strlen (*text) == 0) {
		gtk_widget_grab_focus (widget);
		return 1;
	} else return 0;
}


static int
get_selection			(GtkWidget	*widget)
{
	static GdkAtom atom = GDK_NONE;

	selection_received = FALSE;
	atom = gdk_atom_intern ("STRING", FALSE);
	if (atom == GDK_NONE) {
		return 1;
	} else {
		gtk_selection_convert (widget,
				GDK_SELECTION_PRIMARY, atom,
				GDK_CURRENT_TIME);
		return 0;
	}
}

int
read_from_file(int fd)
{
    GtkWidget *data_textbox;
    int read_len;
    char *buf;
    size_t size, alloc_size;

    size = 0;
    alloc_size = 4096;

    buf = malloc (alloc_size);
    if (buf == NULL)
    {
        fprintf(stderr,"can't allocate buf");
        return 1;
    }

    for(;;)
    {
        if (size + 4096 > alloc_size) {
            alloc_size += 4096;
            buf = realloc (buf , alloc_size);
            if (buf == NULL)
            {
                fprintf(stderr,"can't reallocate buf");
                return 1;
            }
        }
        if ((read_len =  read (fd, &buf[size], alloc_size - size - 1)) < 0) {
            if (errno == EINTR)
                continue;
            break;
        }
        if (read_len == 0)  /* EOF */
        {
            break;
        }
        size += read_len;
    }
    buf[size] = 0;
    
    data_textbox = get_widget (main_win, "data_textbox");
    gtk_text_insert(GTK_TEXT (data_textbox), NULL, NULL, NULL, buf, -1);
    free(buf);
    
    return 0;
}

gboolean
on_main_win_delete_event               (GtkWidget       *widget,
                                        GdkEvent        *event,
                                        gpointer         user_data)
{
	on_exit1_activate (NULL, NULL);
	return (FALSE); /* NOT REACHED */
}




void save_config () {
	gnome_config_push_prefix ("/seahorse/General/");
	gnome_config_private_set_int ("ascii_arm", ascii_arm);
	gnome_config_private_set_string ("comment", comment);
	gnome_config_private_set_int ("enable_comment", enable_comment);
	gnome_config_private_set_int ("datasrc_active_btn", datasrc_active_btn);
	gnome_config_private_set_int ("output_to_file", output_to_file);
	gnome_config_private_set_int ("textmode", textmode);
	gnome_config_private_set_int ("signencrypt_active_btn", signencrypt_active_btn);
	gnome_config_private_set_int ("verifydecrypt_active_btn", verifydecrypt_active_btn);
	gnome_config_private_set_string ("default_cipher", default_cipher);
	gnome_config_private_set_string ("default_key", default_key);
	gnome_config_pop_prefix ();
	gnome_config_sync ();
}

void load_config () {
		gnome_config_push_prefix ("/seahorse/General/");
	ascii_arm = gnome_config_private_get_int ("ascii_arm=1");
	enable_comment = gnome_config_private_get_int ("enable_comment=1");
	comment = gnome_config_private_get_string ("comment");
	if ( (comment!=NULL) && (strlen (comment) == 0)) {
		g_free (comment);
		comment = NULL;
	}
	datasrc_active_btn = gnome_config_private_get_int ("datasrc_active_btn = 1");
	output_to_file = gnome_config_private_get_int ("output_to_file=0");
	textmode = gnome_config_private_get_int ("textmode=0");
	signencrypt_active_btn = gnome_config_private_get_int ("signencrypt_active_btn=0");
	verifydecrypt_active_btn = gnome_config_private_get_int ("verifydecrypt_active_btn=0");
	default_cipher = gnome_config_private_get_string ("default_cipher=CAST5");
	default_key = gnome_config_private_get_string ("default_key");
	gnome_config_pop_prefix ();
}


void
on_exit1_activate                      (GtkMenuItem     *menuitem,
                                        gpointer         user_data)
{
	save_config();
	gtk_exit (0);
}


void
on_errorbox_clicked                    (GnomeDialog     *gnomedialog,
                                        gint             arg1,
                                        gpointer         user_data)
{
	gtk_exit (1);
}


void
encrypt_fs_button_clicked              (GtkButton       *button,
                                        gpointer         user_data)
{
	char *filename;
  	GtkWidget *sign_encrypt_file;

	filename = gtk_file_selection_get_filename
		(GTK_FILE_SELECTION (encrypt_fileselection));

	sign_encrypt_file = get_widget (sign_encrypt, 
			"sign_encrypt_file");
	gtk_entry_set_text (GTK_ENTRY (sign_encrypt_file), filename);

	gtk_widget_destroy (encrypt_fileselection);
}


void
encrypt_outfs_btn_clicked              (GtkButton       *button,
                                        gpointer         user_data)
{

	char *filename;
  	GtkWidget *signencrypt_outfile;

	filename = gtk_file_selection_get_filename
		(GTK_FILE_SELECTION (encrypt_outfs));

	signencrypt_outfile = get_widget (sign_encrypt, 
			"signencrypt_outfile");
	gtk_entry_set_text (GTK_ENTRY (signencrypt_outfile),
			filename);
	gtk_entry_append_text (GTK_ENTRY (signencrypt_outfile),
			".gpg");

	gtk_widget_destroy (encrypt_outfs);
}


void
decrypt_fs_button_clicked              (GtkButton       *button,
                                        gpointer         user_data)
{
	char *filename;
  	GtkWidget *verify_decrypt_file;

	filename = gtk_file_selection_get_filename (GTK_FILE_SELECTION (decrypt_fileselection));

  	verify_decrypt_file = get_widget (verify_decrypt, "verify_decrypt_file");
        gtk_entry_set_text (GTK_ENTRY (verify_decrypt_file), filename);
	
	gtk_widget_destroy (decrypt_fileselection);
}


void
decrypt_outfs_btn_clicked              (GtkButton       *button,
                                        gpointer         user_data)
{
	char *filename;
  	GtkWidget *verifydecrypt_outfile;

	filename = gtk_file_selection_get_filename
		(GTK_FILE_SELECTION (decrypt_outfs));

	verifydecrypt_outfile = get_widget (verify_decrypt, 
			"verifydecrypt_outfile");
	gtk_entry_set_text (GTK_ENTRY (verifydecrypt_outfile),
			filename);

	gtk_widget_destroy (decrypt_outfs);
}


/********************* Toggle Buttons *********************/

void
on_ascii_arm_btn_toggled               (GtkToggleButton *togglebutton,
                                        gpointer         user_data)
{
  	GtkWidget *widget;

	ascii_arm = GTK_TOGGLE_BUTTON (togglebutton)->active;
	if (!ascii_arm && !clearsign) {
		widget = get_widget (sign_encrypt, "outfile_btn");
		gtk_toggle_button_set_active (GTK_TOGGLE_BUTTON (widget),
				TRUE);
	}
	widget = get_widget (sign_encrypt, "outtext_btn");
	gtk_widget_set_sensitive (widget, (ascii_arm || clearsign));
}


void
on_ascii_arm_btn2_toggled              (GtkToggleButton *togglebutton,
                                        gpointer         user_data)
{
	ascii_arm = GTK_TOGGLE_BUTTON (togglebutton)->active;
}


void
on_decrypt_btn_toggled                 (GtkToggleButton *togglebutton,
                                        gpointer         user_data)
{
  	GtkWidget *widget;

	verifydecrypt_active_btn = 1;
 	if (GTK_TOGGLE_BUTTON (togglebutton)->active) {
		decrypt = 1;
		widget = get_widget (verify_decrypt, 
				"vdpassphraselbl");
		gtk_widget_set_sensitive (widget, TRUE);
		widget = get_widget (verify_decrypt, 
				"verify_decrypt_passphrase");
		gtk_widget_set_sensitive (widget, TRUE);
	}
}


void
on_pref_enable_comment_toggled         (GtkToggleButton *togglebutton,
                                        gpointer         user_data)
{
  	GtkWidget *widget;

	enable_comment = GTK_TOGGLE_BUTTON (togglebutton)->active;
	widget = get_widget (pref_dialog, "pref_comment");
	gtk_widget_set_sensitive (widget, enable_comment);
}


void
on_clearsign_btn_toggled               (GtkToggleButton *togglebutton,
                                        gpointer         user_data)
{
  	GtkWidget *widget;

	signencrypt_active_btn = 0;
 	if (GTK_TOGGLE_BUTTON (togglebutton)->active) {
		clearsign = 1;
		detachedsign = 0;
		encrypt_flag = 0;
		sign = 0;
  		widget = get_widget (sign_encrypt, 
				"sepassphraselbl");
		gtk_widget_set_sensitive (widget, TRUE);
  		widget = get_widget (sign_encrypt, 
				"sign_encrypt_passphrase");
		gtk_widget_set_sensitive (widget, TRUE);
  		widget = get_widget (sign_encrypt, 
				"signencrypt_usernamecombo");
		gtk_widget_set_sensitive (widget, FALSE);
	}
	if (!ascii_arm && !clearsign) {
		widget = get_widget (sign_encrypt, "outfile_btn");
		gtk_toggle_button_set_active (GTK_TOGGLE_BUTTON (widget),
				TRUE);
	}
	widget = get_widget (sign_encrypt, "outtext_btn");
	gtk_widget_set_sensitive (widget, (ascii_arm || clearsign));
}


void
on_detachedsign_btn_toggled            (GtkToggleButton *togglebutton,
                                        gpointer         user_data)
{
  	GtkWidget *widget;

	signencrypt_active_btn = 1;
 	if (GTK_TOGGLE_BUTTON (togglebutton)->active) {
		clearsign = 0;
		detachedsign = 1;
		encrypt_flag = 0;
		sign = 0;
  		widget = get_widget (sign_encrypt, 
				"sepassphraselbl");
		gtk_widget_set_sensitive (widget, TRUE);
  		widget = get_widget (sign_encrypt, 
				"sign_encrypt_passphrase");
		gtk_widget_set_sensitive (widget, TRUE);
  		widget = get_widget (sign_encrypt, 
				"signencrypt_usernamecombo");
		gtk_widget_set_sensitive (widget, FALSE);
	}
	if (!ascii_arm && !clearsign) {
		widget = get_widget (sign_encrypt, "outfile_btn");
		gtk_toggle_button_set_active (GTK_TOGGLE_BUTTON (widget),
				TRUE);
	}
	widget = get_widget (sign_encrypt, "outtext_btn");
	gtk_widget_set_sensitive (widget, (ascii_arm || clearsign));
}


void
on_encrypt_btn_toggled                 (GtkToggleButton *togglebutton,
                                        gpointer         user_data)
{
  	GtkWidget *widget;

	signencrypt_active_btn = 3;
	if (GTK_TOGGLE_BUTTON (togglebutton)->active) {
		clearsign = 0;
		detachedsign = 0;
		encrypt_flag = 1;
		sign = 0;
  		widget = get_widget (sign_encrypt, 
				"sepassphraselbl");
		gtk_widget_set_sensitive (widget, FALSE);
  		widget = get_widget (sign_encrypt, 
				"sign_encrypt_passphrase");
		gtk_widget_set_sensitive (widget, FALSE);
  		widget = get_widget (sign_encrypt, 
				"signencrypt_usernamecombo");
		gtk_widget_set_sensitive (widget, TRUE);
	}
	if (!ascii_arm && !clearsign) {
		widget = get_widget (sign_encrypt, "outfile_btn");
		gtk_toggle_button_set_active (GTK_TOGGLE_BUTTON (widget),
				TRUE);
	}
	widget = get_widget (sign_encrypt, "outtext_btn");
	gtk_widget_set_sensitive (widget, (ascii_arm || clearsign));
}


void
on_encryptclipboard_btn_toggled        (GtkToggleButton *togglebutton,
                                        gpointer         user_data)
{
  	GtkWidget *widget;

	datasrc_active_btn = 2;
	if (GTK_TOGGLE_BUTTON (togglebutton)->active) {
		widget = get_widget (sign_encrypt, 
				"sign_encrypt_file");
		gtk_widget_set_sensitive (widget, FALSE);
		widget = get_widget (sign_encrypt, 
				"sign_encrypt_file_btn");
		gtk_widget_set_sensitive (widget, FALSE);
	}
}


void
on_encryptfile_btn_toggled             (GtkToggleButton *togglebutton,
                                        gpointer         user_data)
{
  	GtkWidget *widget;

	datasrc_active_btn = 0;
	if (GTK_TOGGLE_BUTTON (togglebutton)->active) {
		widget = get_widget (sign_encrypt, 
				"sign_encrypt_file");
		gtk_widget_set_sensitive (widget, TRUE);
		widget = get_widget (sign_encrypt, 
				"sign_encrypt_file_btn");
		gtk_widget_set_sensitive (widget, TRUE);
	}
}


void
on_encrypttextarea_btn_toggled         (GtkToggleButton *togglebutton,
                                        gpointer         user_data)
{
  	GtkWidget *widget;

	datasrc_active_btn = 1;
	textarea = GTK_TOGGLE_BUTTON (togglebutton)->active;
	if (GTK_TOGGLE_BUTTON (togglebutton)->active) {
		widget = get_widget (sign_encrypt, 
				"sign_encrypt_file");
		gtk_widget_set_sensitive (widget, FALSE);
		widget = get_widget (sign_encrypt, 
				"sign_encrypt_file_btn");
		gtk_widget_set_sensitive (widget, FALSE);
	}
}


void
on_decryptclipboard_btn_toggled        (GtkToggleButton *togglebutton,
                                        gpointer         user_data)
{
  	GtkWidget *widget;

	datasrc_active_btn = 2;
	if (GTK_TOGGLE_BUTTON (togglebutton)->active) {
		widget = get_widget (verify_decrypt, 
				"verify_decrypt_file");
		gtk_widget_set_sensitive (widget, FALSE);
		widget = get_widget (verify_decrypt, 
				"verify_decrypt_file_btn");
		gtk_widget_set_sensitive (widget, FALSE);
	}
}


void
on_decryptfile_btn_toggled             (GtkToggleButton *togglebutton,
                                        gpointer         user_data)
{
  	GtkWidget *widget;

	datasrc_active_btn = 0;
	if (GTK_TOGGLE_BUTTON (togglebutton)->active) {
		widget = get_widget (verify_decrypt, 
				"verify_decrypt_file");
		gtk_widget_set_sensitive (widget, TRUE);
		widget = get_widget (verify_decrypt, 
				"verify_decrypt_file_btn");
		gtk_widget_set_sensitive (widget, TRUE);
	}
}


void
on_decrypttextarea_btn_toggled         (GtkToggleButton *togglebutton,
                                        gpointer         user_data)
{
  	GtkWidget *widget;

	datasrc_active_btn = 1;
	textarea = GTK_TOGGLE_BUTTON (togglebutton)->active;
	if (GTK_TOGGLE_BUTTON (togglebutton)->active) {
		widget = get_widget (verify_decrypt, 
				"verify_decrypt_file");
		gtk_widget_set_sensitive (widget, FALSE);
		widget = get_widget (verify_decrypt, 
				"verify_decrypt_file_btn");
		gtk_widget_set_sensitive (widget, FALSE);
	}
}


void
on_outfilese_toggled                   (GtkToggleButton *togglebutton,
                                        gpointer         user_data)
{
	GtkWidget *widget;

	output_to_file = GTK_TOGGLE_BUTTON (togglebutton)->active;
	if (GTK_TOGGLE_BUTTON (togglebutton)->active) {
		widget = get_widget (sign_encrypt, 
				"signencrypt_outfile");
		gtk_widget_set_sensitive (widget, TRUE);
		widget = get_widget (sign_encrypt, 
				"signencrypt_outfilebtn");
		gtk_widget_set_sensitive (widget, TRUE);
	}
}


void
on_outtextse_toggled                   (GtkToggleButton *togglebutton,
                                        gpointer         user_data)
{
	GtkWidget *widget;

	if (GTK_TOGGLE_BUTTON (togglebutton)->active) {
		widget = get_widget (sign_encrypt, 
				"signencrypt_outfile");
		gtk_widget_set_sensitive (widget, FALSE);
		widget = get_widget (sign_encrypt, 
				"signencrypt_outfilebtn");
		gtk_widget_set_sensitive (widget, FALSE);
	}
}


void
on_outfilevd_toggled                   (GtkToggleButton *togglebutton,
                                        gpointer         user_data)
{
	GtkWidget *widget;

	output_to_file = GTK_TOGGLE_BUTTON (togglebutton)->active;
	if (GTK_TOGGLE_BUTTON (togglebutton)->active) {
		widget = get_widget (verify_decrypt, 
				"verifydecrypt_outfile");
		gtk_widget_set_sensitive (widget, TRUE);
		widget = get_widget (verify_decrypt, 
				"verifydecrypt_outfilebtn");
		gtk_widget_set_sensitive (widget, TRUE);
	}
}


void
on_outtextvd_toggled                   (GtkToggleButton *togglebutton,
                                        gpointer         user_data)
{
	GtkWidget *widget;

	if (GTK_TOGGLE_BUTTON (togglebutton)->active) {
		widget = get_widget (verify_decrypt, 
				"verifydecrypt_outfile");
		gtk_widget_set_sensitive (widget, FALSE);
		widget = get_widget (verify_decrypt, 
				"verifydecrypt_outfilebtn");
		gtk_widget_set_sensitive (widget, FALSE);
	}
}


void
on_sign_btn_toggled                    (GtkToggleButton *togglebutton,
                                        gpointer         user_data)
{
  	GtkWidget *widget;

	signencrypt_active_btn = 2;
	if (GTK_TOGGLE_BUTTON (togglebutton)->active) {
		clearsign = 0;
		detachedsign = 0;
		encrypt_flag = 0;
		sign = 1;
  		widget = get_widget (sign_encrypt, 
				"sepassphraselbl");
		gtk_widget_set_sensitive (widget, TRUE);
  		widget = get_widget (sign_encrypt, 
				"sign_encrypt_passphrase");
		gtk_widget_set_sensitive (widget, TRUE);
  		widget = get_widget (sign_encrypt, 
				"signencrypt_usernamecombo");
		gtk_widget_set_sensitive (widget, FALSE);
	}
	if (!ascii_arm && !clearsign) {
		widget = get_widget (sign_encrypt, "outfile_btn");
		gtk_toggle_button_set_active (GTK_TOGGLE_BUTTON (widget),
				TRUE);
	}
	widget = get_widget (sign_encrypt, "outtext_btn");
	gtk_widget_set_sensitive (widget, (ascii_arm || clearsign));
}


void
on_signencrypt_btn_toggled             (GtkToggleButton *togglebutton,
                                        gpointer         user_data)
{
  	GtkWidget *widget;

	signencrypt_active_btn = 4;
	if (GTK_TOGGLE_BUTTON (togglebutton)->active) {
		clearsign = 0;
		detachedsign = 0;
		encrypt_flag = 1;
		sign = 1;
  		widget = get_widget (sign_encrypt, 
				"sepassphraselbl");
		gtk_widget_set_sensitive (widget, TRUE);
  		widget = get_widget (sign_encrypt, 
				"sign_encrypt_passphrase");
		gtk_widget_set_sensitive (widget, TRUE);
  		widget = get_widget (sign_encrypt, 
				"signencrypt_usernamecombo");
		gtk_widget_set_sensitive (widget, TRUE);
	}
	if (!ascii_arm && !clearsign) {
		widget = get_widget (sign_encrypt, "outfile_btn");
		gtk_toggle_button_set_active (GTK_TOGGLE_BUTTON (widget),
				TRUE);
	}
	widget = get_widget (sign_encrypt, "outtext_btn");
	gtk_widget_set_sensitive (widget, (ascii_arm || clearsign));
}


void
on_textmode_btn_toggled                (GtkToggleButton *togglebutton,
                                        gpointer         user_data)
{
	textmode = GTK_TOGGLE_BUTTON (togglebutton)->active;
}


void
on_verify_btn_toggled                  (GtkToggleButton *togglebutton,
                                        gpointer         user_data)
{
  	GtkWidget *widget;

	verifydecrypt_active_btn = 0;
 	if (GTK_TOGGLE_BUTTON (togglebutton)->active) {
		decrypt = 0;
		widget = get_widget (verify_decrypt, 
				"vdpassphraselbl");
		gtk_widget_set_sensitive (widget, FALSE);
		widget = get_widget (verify_decrypt, 
				"verify_decrypt_passphrase");
		gtk_widget_set_sensitive (widget, FALSE);
	}
}


/********************* Sign & Encrypt *********************/

void
on_sign_encrypt_activate               (GtkEditable     *editable,
                                        gpointer         user_data)
{
	on_sign_encrypt_ok_clicked (NULL, NULL);
}


void
on_sign_encrypt_ok_clicked             (GtkButton       *button,
                                        gpointer         user_data)
{
	char *output;
        char *diagnostics;
	char *passphrase = "";
	int result;
  	GtkWidget *data_textbox;
  	GtkWidget *log_textbox;
  	GtkWidget *passphrase_entry;
  	GtkWidget *sign_encrypt_file;
  	GtkWidget *signencrypt_outfile;
  	GtkWidget *sign_encrypt_username;


  	data_textbox = get_widget (main_win, "data_textbox");
  	log_textbox = get_widget (main_win, "log_textbox");

	if (textarea) {
		GtkWidget	*data_textbox;

		data_textbox = get_widget (main_win, "data_textbox");
		gtk_editable_select_region (GTK_EDITABLE (data_textbox), 0, gtk_text_get_length(GTK_TEXT (data_textbox)));
	}

	if (datasrc_active_btn) {
		get_selection (sign_encrypt);
	}


	if (clearsign || detachedsign || sign) {
  		passphrase_entry = get_widget (sign_encrypt, 
					       "sign_encrypt_passphrase");
		if (check_entry (passphrase_entry, &passphrase))
			return;
	}

	if (encrypt_flag) {
  		sign_encrypt_username = get_widget (sign_encrypt, 
					     "sign_encrypt_username");
		if (check_free_entry (sign_encrypt_username,
					&signencrypt_username))
			return;
	}

	if (datasrc_active_btn) {
		while (!selection_received)
			gtk_main_iteration();
		if (clipboard_string == NULL) {
			gtk_text_insert(GTK_TEXT (log_textbox), NULL, NULL, NULL, "\nCan't encrypt clipboard, because no text is selected!\n", -1);
			return;
		}
	} else {
		sign_encrypt_file = get_widget (sign_encrypt,
				"sign_encrypt_file");
		if (check_free_entry (sign_encrypt_file,
					&signencrypt_filename))
			return;
	}

	if (output_to_file) {
		signencrypt_outfile = get_widget (sign_encrypt,
				"signencrypt_outfile");
		if (check_free_entry (signencrypt_outfile,
					&signencrypt_outfilename))
			return;
	}

	result = gpg_sign_encrypt (sign, clearsign,
			detachedsign, encrypt_flag,
			ascii_arm, textmode, 
			datasrc_active_btn, output_to_file, 
			signencrypt_filename, 
			signencrypt_outfilename, 
			clipboard_string, passphrase, 
			signencrypt_username, 
			default_key, &output, 
			&diagnostics);

  	gtk_widget_destroy (sign_encrypt);

	if (result == 0) {
	}
	else ;

        if( (output!=NULL) && (strlen(output)>0) )
        {
            on_clear_activate (NULL, NULL);
            gtk_text_insert(GTK_TEXT (data_textbox), NULL, NULL, NULL, output, -1);
        } else {
            if( textarea )
                gtk_editable_select_region (GTK_EDITABLE (data_textbox), 0,0);
        }
	gtk_text_insert(GTK_TEXT (log_textbox), NULL, NULL, NULL, "----\n", -1);
	gtk_text_insert(GTK_TEXT (log_textbox), NULL, NULL, NULL, diagnostics, -1);
	if (output_to_file) {
		if (!strcmp (signencrypt_outfilename,"-")) {
			printf ("\n%s\n", output);
		}
	}

	free (output);
	free (diagnostics);
}


void
on_sign_encrypt_cancel_clicked         (GtkButton       *button,
                                        gpointer         user_data)
{
	gtk_widget_destroy (sign_encrypt);
}


void
on_sign_encrypt_file_clicked           (GtkButton       *button,
                                        gpointer         user_data)
{
	encrypt_fileselection = create_encrypt_fileselection ();
	gtk_widget_show (encrypt_fileselection);
}


void
on_signencrypt_outfile_clicked         (GtkButton       *button,
                                        gpointer         user_data)
{
	encrypt_outfs = create_encrypt_outfs ();
	gtk_widget_show (encrypt_outfs);
}


void
encrypt_button_clicked                 (GtkButton       *button,
                                        gpointer         user_data)
{
	on_encrypt_activate (NULL, NULL);
}


void
on_encrypt_activate                    (GtkMenuItem     *menuitem,
                                        gpointer         user_data)
{
	GList		*glist;
	GtkWidget	*ascii_arm_btn;
	GtkWidget	*combo;
  	GtkWidget	*active_btn;
	GtkWidget	*outfile_btn;
	GtkWidget	*sign_encrypt_file;
	GtkWidget	*signencrypt_outfile;
	GtkWidget	*signencrypt_outfilebtn;
	GtkWidget	*signencrypt_outtextbtn;
  	GtkWidget	*sign_encrypt_username;
	GtkWidget	*textmode_btn;

        static GtkTargetEntry drag_types[] =
        {
            { "text/uri-list", 0, TARGET_URI_LIST },
        };
        static gint n_drag_types = sizeof(drag_types)/sizeof(drag_types[0]);

  	sign_encrypt = create_sign_encrypt ();

	if (signencrypt_active_btn == 1) {
		active_btn = get_widget (sign_encrypt, "detachedsign_btn");
		gtk_toggle_button_set_active (GTK_TOGGLE_BUTTON (active_btn), TRUE);
	} else if (signencrypt_active_btn == 2) {
		active_btn = get_widget (sign_encrypt, "sign_btn");
		gtk_toggle_button_set_active (GTK_TOGGLE_BUTTON (active_btn), TRUE);
	} else if (signencrypt_active_btn == 3) {
		active_btn = get_widget (sign_encrypt, "encrypt_btn");
		gtk_toggle_button_set_active (GTK_TOGGLE_BUTTON (active_btn), TRUE);
	} else if (signencrypt_active_btn == 4) {
		active_btn = get_widget (sign_encrypt, "signencrypt_btn");
		gtk_toggle_button_set_active (GTK_TOGGLE_BUTTON (active_btn), TRUE);
	} else {
		active_btn = get_widget (sign_encrypt, "clearsign_btn");
		gtk_toggle_button_set_active (GTK_TOGGLE_BUTTON (active_btn), TRUE);
	}


	if (datasrc_active_btn == 0) {
		active_btn = get_widget (sign_encrypt,"encrypt_file_btn");
		gtk_toggle_button_set_active (GTK_TOGGLE_BUTTON (active_btn), TRUE);
	} else if (datasrc_active_btn == 2) {
		active_btn = get_widget (sign_encrypt, "encrypt_clipboard_btn");
		gtk_toggle_button_set_active (GTK_TOGGLE_BUTTON (active_btn), TRUE);
	} else {
		active_btn = get_widget (sign_encrypt, "encrypt_textarea_btn");
		gtk_toggle_button_set_active (GTK_TOGGLE_BUTTON (active_btn), TRUE);
	}


  	sign_encrypt_file = get_widget (sign_encrypt, "sign_encrypt_file");
	if (signencrypt_filename != NULL) {
		gtk_entry_set_text (GTK_ENTRY (sign_encrypt_file),
				signencrypt_filename);
	}
        gtk_drag_dest_set (sign_encrypt_file,
                           GTK_DEST_DEFAULT_MOTION |
                           GTK_DEST_DEFAULT_HIGHLIGHT |
                           GTK_DEST_DEFAULT_DROP,
                           drag_types, n_drag_types,
                           GDK_ACTION_COPY);
	
  	signencrypt_outfile = get_widget (sign_encrypt, 
			"signencrypt_outfile");
	if (signencrypt_outfilename != NULL) {
		gtk_entry_set_text (GTK_ENTRY (signencrypt_outfile),
				signencrypt_outfilename);
	}
        gtk_drag_dest_set (signencrypt_outfile,
                           GTK_DEST_DEFAULT_MOTION |
                           GTK_DEST_DEFAULT_HIGHLIGHT |
                           GTK_DEST_DEFAULT_DROP,
                           drag_types, n_drag_types,
                           GDK_ACTION_COPY);
	
	if ((glist = make_name_list ()) != NULL) {
		combo = get_widget (sign_encrypt,
				"signencrypt_usernamecombo");
		gtk_combo_set_popdown_strings(GTK_COMBO(combo), glist);
	}

  	sign_encrypt_username = get_widget (sign_encrypt, 
				     "sign_encrypt_username");
	if (signencrypt_username != NULL) {
		gtk_entry_set_text (GTK_ENTRY (sign_encrypt_username),
				signencrypt_username);
	}

  	ascii_arm_btn = get_widget (sign_encrypt, "ascii_arm_btn");
	gtk_toggle_button_set_active (GTK_TOGGLE_BUTTON (ascii_arm_btn),
			ascii_arm);
	if (!ascii_arm && !clearsign) {
		output_to_file = TRUE;
	}
	signencrypt_outtextbtn = get_widget (sign_encrypt, 
			"outtext_btn");
	gtk_widget_set_sensitive (signencrypt_outtextbtn, 
			(ascii_arm || clearsign));

  	textmode_btn = get_widget (sign_encrypt, "textmode_btn");
	gtk_toggle_button_set_active (GTK_TOGGLE_BUTTON (textmode_btn),
			textmode);

  	signencrypt_outfilebtn = get_widget (sign_encrypt, 
			"signencrypt_outfilebtn");
  	outfile_btn = get_widget (sign_encrypt, "outfile_btn");
	gtk_toggle_button_set_active (GTK_TOGGLE_BUTTON (outfile_btn),
			output_to_file);
 	if (output_to_file) {
		gtk_widget_set_sensitive (signencrypt_outfile, TRUE);
		gtk_widget_set_sensitive (signencrypt_outfilebtn, TRUE);
	} else {
		gtk_widget_set_sensitive (signencrypt_outfile, FALSE);
		gtk_widget_set_sensitive (signencrypt_outfilebtn, FALSE);
	}

  	gtk_widget_show (sign_encrypt);
}


/********************* Verify & Decrypt *********************/

void
on_verify_decrypt_activate             (GtkEditable     *editable,
                                        gpointer         user_data)
{
	on_verify_decrypt_ok_clicked (NULL, NULL);
}


void
on_verify_decrypt_ok_clicked           (GtkButton       *button,
                                        gpointer         user_data)
{
	char *output;
	char *diagnostics;
	char *passphrase = "";
	int result;
  	GtkWidget *data_textbox;
  	GtkWidget *log_textbox;
  	GtkWidget *verify_decrypt_file;
  	GtkWidget *verifydecrypt_outfile;
  	GtkWidget *passphrase_entry;


  	data_textbox = get_widget (main_win, "data_textbox");
  	log_textbox = get_widget (main_win, "log_textbox");
	
	if (textarea) {
		GtkWidget	*data_textbox;

		data_textbox = get_widget (main_win, "data_textbox");
		gtk_editable_select_region (GTK_EDITABLE (data_textbox), 0, gtk_text_get_length(GTK_TEXT (data_textbox)));
	}

	if (datasrc_active_btn) {
		get_selection (verify_decrypt);
		while (!selection_received)
			gtk_main_iteration();
		if (clipboard_string == NULL) {
			gtk_text_insert(GTK_TEXT (log_textbox), NULL, NULL, NULL, "\nCan't decrypt clipboard, because no text is selected!\n", -1);
			return;
		}
	} else {
  		verify_decrypt_file = get_widget (verify_decrypt,
				"verify_decrypt_file");
		if (check_free_entry (verify_decrypt_file,
					&verifydecrypt_filename))
			return;
	}


	if (decrypt) {
  		passphrase_entry = get_widget (verify_decrypt, 
					       "verify_decrypt_passphrase");
		if (check_entry (passphrase_entry, &passphrase))
			return;
	}

	if (output_to_file) {
		verifydecrypt_outfile = get_widget (verify_decrypt,
				"verifydecrypt_outfile");
		if (check_free_entry (verifydecrypt_outfile,
					&verifydecrypt_outfilename))
			return;
	}

	result = gpg_decrypt (decrypt, datasrc_active_btn, 
			output_to_file, verifydecrypt_filename,
			verifydecrypt_outfilename, clipboard_string,
			passphrase, &output, &diagnostics);

  	gtk_widget_destroy (verify_decrypt);

        if( (output!=NULL) && (strlen(output)>0) )
        {
            on_clear_activate (NULL, NULL);
            gtk_text_insert(GTK_TEXT (data_textbox), NULL, NULL, NULL, output, -1);
        } else {
            if( textarea )
                gtk_editable_select_region (GTK_EDITABLE (data_textbox), 0,0);
        }
	gtk_text_insert(GTK_TEXT (log_textbox), NULL, NULL, NULL, "----\n", -1);
	gtk_text_insert(GTK_TEXT (log_textbox), NULL, NULL, NULL, diagnostics, -1);
	if (output_to_file) {
		if (!strcmp (verifydecrypt_outfilename,"-")) {
			printf ("\n%s\n", output);
			printf ("\n%s\n", diagnostics);
		}
	}
	free (output);
	free (diagnostics);

	if (result == 0) {
	}
	else ;
}


void
on_verify_decrypt_cancel_clicked       (GtkButton       *button,
                                        gpointer         user_data)
{
  gtk_widget_destroy (verify_decrypt);
}


void
on_verify_decrypt_file_clicked         (GtkButton       *button,
                                        gpointer         user_data)
{
  decrypt_fileselection = create_decrypt_fileselection ();
  gtk_widget_show (decrypt_fileselection);
}


void
on_verifydecrypt_outfile_clicked       (GtkButton       *button,
                                        gpointer         user_data)
{
  decrypt_outfs = create_decrypt_outfs ();
  gtk_widget_show (decrypt_outfs);
}


void
decrypt_button_clicked                 (GtkButton       *button,
                                        gpointer         user_data)
{
	on_decrypt_activate (NULL, NULL);
}


void
on_decrypt_activate                    (GtkMenuItem     *menuitem,
                                        gpointer         user_data)
{
  	GtkWidget	*active_btn;
	GtkWidget	*outfile_btn;
	GtkWidget	*verify_decrypt_file;
	GtkWidget	*verify_decrypt_file_btn;
	GtkWidget	*verifydecrypt_outfile;
	GtkWidget	*verifydecrypt_outfilebtn;

        static GtkTargetEntry drag_types[] =
        {
            { "text/uri-list", 0, TARGET_URI_LIST },
        };
        static gint n_drag_types = sizeof(drag_types)/sizeof(drag_types[0]);

	verify_decrypt = create_verify_decrypt ();

	if (verifydecrypt_active_btn == 1) {
		active_btn = get_widget (verify_decrypt, "decrypt_btn");
		gtk_toggle_button_set_active (GTK_TOGGLE_BUTTON (active_btn), TRUE);
	} else {
		active_btn = get_widget (verify_decrypt, "verify_btn");
		gtk_toggle_button_set_active (GTK_TOGGLE_BUTTON (active_btn), TRUE);
	}


	if (datasrc_active_btn == 0) {
		active_btn = get_widget (verify_decrypt,"decrypt_file_btn");
		gtk_toggle_button_set_active (GTK_TOGGLE_BUTTON (active_btn), TRUE);
	} else if (datasrc_active_btn == 2) {
		active_btn = get_widget (verify_decrypt, "decrypt_clipboard_btn");
		gtk_toggle_button_set_active (GTK_TOGGLE_BUTTON (active_btn), TRUE);
	} else {
		active_btn = get_widget (verify_decrypt, "decrypt_textarea_btn");
		gtk_toggle_button_set_active (GTK_TOGGLE_BUTTON (active_btn), TRUE);
	}


  	verify_decrypt_file = get_widget (verify_decrypt,
			"verify_decrypt_file");
	if (verifydecrypt_filename != NULL) {
		gtk_entry_set_text (GTK_ENTRY (verify_decrypt_file),
				verifydecrypt_filename);
	}
        gtk_drag_dest_set (verify_decrypt_file,
                           GTK_DEST_DEFAULT_MOTION |
                           GTK_DEST_DEFAULT_HIGHLIGHT |
                           GTK_DEST_DEFAULT_DROP,
                           drag_types, n_drag_types,
                           GDK_ACTION_COPY);
	
  	verifydecrypt_outfile = get_widget (verify_decrypt,
			"verifydecrypt_outfile");
	if (verifydecrypt_outfilename != NULL) {
		gtk_entry_set_text (GTK_ENTRY (verifydecrypt_outfile),
				verifydecrypt_outfilename);
	}
        gtk_drag_dest_set (verifydecrypt_outfile,
                           GTK_DEST_DEFAULT_MOTION |
                           GTK_DEST_DEFAULT_HIGHLIGHT |
                           GTK_DEST_DEFAULT_DROP,
                           drag_types, n_drag_types,
                           GDK_ACTION_COPY);
	
  	verify_decrypt_file_btn = get_widget (verify_decrypt,
			"verify_decrypt_file_btn");

	gtk_widget_set_sensitive (verifydecrypt_outfile, 
			output_to_file);
  	verifydecrypt_outfilebtn = get_widget (verify_decrypt, 
			"verifydecrypt_outfilebtn");
	gtk_widget_set_sensitive (verifydecrypt_outfilebtn, 
			output_to_file);

  	outfile_btn = get_widget (verify_decrypt, "outfile_btn");
	gtk_toggle_button_set_active (GTK_TOGGLE_BUTTON (outfile_btn),
			output_to_file);

	gtk_widget_show (verify_decrypt);
}

/********************* *********************/

void
on_about_activate                      (GtkMenuItem     *menuitem,
                                        gpointer         user_data)
{
  GtkWidget *about_dialog;

  about_dialog = create_about_dialog ();
  gtk_widget_show (about_dialog);
}


void
on_preferences_activate                (GtkMenuItem     *menuitem,
                                        gpointer         user_data)
{
	const char delimiter1[] = "\n";
	const char delimiter2[] = ",";
	char	*cipher_list;
	char	*diagnostics;
	char	*line;
	char	*temp_buffer;

	GList		*glist;
	GList		*cipher_glist = NULL;
	GtkWidget	*button;
	GtkWidget	*combo;
	GtkWidget	*entry;
	Key *key;

	key = NULL;
	pref_dialog = create_pref_dialog ();

	if ((glist = make_secretkey_list ()) != NULL) {
		combo = get_widget (pref_dialog,
				"default_key");
		gtk_combo_set_popdown_strings(GTK_COMBO(combo), glist);
	}
	entry = get_widget (pref_dialog, "pref_default_key");
	if (default_key != NULL) {
		if (strlen(default_key) != 0) 
			key = keyring_get_key_with_keyid (MyKeyring, default_key);
		if (key != NULL)
			gtk_entry_set_text (GTK_ENTRY (entry), key->UserID);
	}
	
	button = get_widget (pref_dialog, "pref_enable_comment");
	gtk_toggle_button_set_active (GTK_TOGGLE_BUTTON (button), 
			enable_comment);
	entry = get_widget (pref_dialog, "pref_comment");
	if (comment != NULL)
		gtk_entry_set_text (GTK_ENTRY (entry), comment);
	gtk_widget_set_sensitive (entry, enable_comment);
	

	gpg_version (&cipher_list, &diagnostics);
	temp_buffer = strdup (cipher_list);
	line = strtok (temp_buffer, delimiter1);
	while (line != NULL) {
		if (!strncmp (line, "Cipher", 6)) {
			cipher_list = strdup (line+7);
		}
		line = strtok (NULL, delimiter1);
	}
	free (temp_buffer);
	temp_buffer = strdup (cipher_list);
	line = strtok (temp_buffer, delimiter2);
	while (line != NULL) {
		cipher_glist = g_list_append (cipher_glist, strdup (line+1));
		line = strtok (NULL, delimiter2);
	}
	free (temp_buffer);
	if (cipher_glist != NULL) {
		combo = get_widget (pref_dialog,
				"default_cipher");
		gtk_combo_set_popdown_strings(GTK_COMBO(combo), 
				cipher_glist);
	}
	entry = get_widget (pref_dialog, "pref_default_cipher");
	if (default_cipher != NULL)
		gtk_entry_set_text (GTK_ENTRY (entry), default_cipher);

	gtk_widget_show (pref_dialog);
}


/*********************************************************************/

void
on_sign_encrypt_selection_received     (GtkWidget       *widget,
                                        GtkSelectionData *data,
                                        guint            time,
                                        gpointer         user_data)
{
	if (clipboard_string != NULL)
		free (clipboard_string);
	selection_received = TRUE;
	if (data->length < 0) {
		/*g_print ("Selection retrieval failed\n");*/
		return;
	}
	if (data->type != GDK_SELECTION_TYPE_STRING) {
		/*g_print ("Selection was not returned as string!\n");*/
		return;
	}
        clipboard_string = strdup ((char *)data->data);
	return;
}


void
on_verify_decrypt_selection_received   (GtkWidget       *widget,
                                        GtkSelectionData *data,
                                        guint            time,
                                        gpointer         user_data)
{
	if (clipboard_string != NULL)
		free (clipboard_string);
	selection_received = TRUE;
	if (data->length < 0) {
		/*g_print ("Selection retrieval failed\n");*/
		return;
	}
	if (data->type != GDK_SELECTION_TYPE_STRING) {
		/*g_print ("Selection was not returned as string!\n");*/
		return;
	}
        clipboard_string = strdup ((char *)data->data);
	return;
}




void
on_paste_activate                      (GtkMenuItem     *menuitem,
                                        gpointer         user_data)
{
	GtkWidget	*data_textbox;

  	data_textbox = get_widget (main_win, "data_textbox");
	get_selection (data_textbox);
}


void
on_selectall_activate                  (GtkMenuItem     *menuitem,
                                        gpointer         user_data)
{
	GtkWidget	*data_textbox;

  	data_textbox = get_widget (main_win, "data_textbox");
	gtk_editable_select_region (GTK_EDITABLE (data_textbox), 0, 
			gtk_text_get_length(GTK_TEXT (data_textbox)));
}


void
on_clear_activate                      (GtkMenuItem     *menuitem,
                                        gpointer         user_data)
{
	GtkWidget	*data_textbox;

  	data_textbox = get_widget (main_win, "data_textbox");
	gtk_text_set_point(GTK_TEXT (data_textbox), 0);
	gtk_text_forward_delete (GTK_TEXT (data_textbox),
			gtk_text_get_length(GTK_TEXT (data_textbox)));
}


void
on_data_textbox_selection_received     (GtkWidget       *widget,
                                        GtkSelectionData *data,
                                        guint            time,
                                        gpointer         user_data)
{
	if (clipboard_string != NULL)
		free (clipboard_string);
	selection_received = TRUE;
	if (data->length < 0) {
		/*g_print ("Selection retrieval failed\n");*/
		return;
	}
	if (data->type != GDK_SELECTION_TYPE_STRING) {
		/*g_print ("Selection was not returned as string!\n");*/
		return;
	}
        clipboard_string = strdup ((char *)data->data);
	return;
}


void
on_signencrypt_outfile_drag_data_received
                                        (GtkWidget       *widget,
                                        GdkDragContext  *drag_context,
                                        gint             x,
                                        gint             y,
                                        GtkSelectionData *selection_data,
                                        guint            info,
                                        guint            time,
                                        gpointer         user_data)
{
    GList *names;
    char *filename = NULL;
    GtkWidget *outfile_btn, *signencrypt_outfile;

    if (!selection_data->data)
        return;
	
    switch (info){
    case TARGET_URI_LIST:
        names = gnome_uri_list_extract_uris ((char *)selection_data->data);
		
        if (!names)
            return;

        /* we ignore all but the first filename */
        filename = names->data;
	if (strncmp (filename, "file:", 5) == 0)
        {
            filename += 5;
            outfile_btn = get_widget (sign_encrypt, "outfile_btn");
            gtk_toggle_button_set_active (GTK_TOGGLE_BUTTON (outfile_btn), TRUE);
            signencrypt_outfile = get_widget (sign_encrypt, "signencrypt_outfile");
            if (signencrypt_outfile != NULL) {
		gtk_entry_set_text (GTK_ENTRY (signencrypt_outfile),
                                    filename);
            }
        }

        gnome_uri_list_free_strings (names);
        break;
        
    }
}


void
on_sign_encrypt_file_drag_data_received
                                        (GtkWidget       *widget,
                                        GdkDragContext  *drag_context,
                                        gint             x,
                                        gint             y,
                                        GtkSelectionData *selection_data,
                                        guint            info,
                                        guint            time,
                                        gpointer         user_data)
{
    GList *names;
    char *filename = NULL;
    GtkWidget *encrypt_file_btn, *sign_encrypt_file;

    if (!selection_data->data)
        return;
	
    switch (info){
    case TARGET_URI_LIST:
        names = gnome_uri_list_extract_uris ((char *)selection_data->data);
		
        if (!names)
            return;

        /* we ignore all but the first filename */
        filename = names->data;
	if (strncmp (filename, "file:", 5) == 0)
        {
            filename += 5;
            encrypt_file_btn = get_widget (sign_encrypt, "encrypt_file_btn");
            gtk_toggle_button_set_active (GTK_TOGGLE_BUTTON (encrypt_file_btn), TRUE);
            sign_encrypt_file = get_widget (sign_encrypt, "sign_encrypt_file");
            if (sign_encrypt_file != NULL) {
		gtk_entry_set_text (GTK_ENTRY (sign_encrypt_file),
                                    filename);
            }
        }

        gnome_uri_list_free_strings (names);
        break;
        
    }
}


void
on_verifydecrypt_outfile_drag_data_received
                                        (GtkWidget       *widget,
                                        GdkDragContext  *drag_context,
                                        gint             x,
                                        gint             y,
                                        GtkSelectionData *selection_data,
                                        guint            info,
                                        guint            time,
                                        gpointer         user_data)
{
    GList *names;
    char *filename = NULL;
    GtkWidget *outfile_btn, *verifydecrypt_outfile;

    if (!selection_data->data)
        return;
	
    switch (info){
    case TARGET_URI_LIST:
        names = gnome_uri_list_extract_uris ((char *)selection_data->data);
		
        if (!names)
            return;

        /* we ignore all but the first filename */
        filename = names->data;
	if (strncmp (filename, "file:", 5) == 0)
        {
            filename += 5;
            outfile_btn = get_widget (verify_decrypt, "outfile_btn");
            gtk_toggle_button_set_active (GTK_TOGGLE_BUTTON (outfile_btn), TRUE);
            verifydecrypt_outfile = get_widget (verify_decrypt, "verifydecrypt_outfile");
            if (verifydecrypt_outfile != NULL) {
		gtk_entry_set_text (GTK_ENTRY (verifydecrypt_outfile),
                                    filename);
            }
        }

        gnome_uri_list_free_strings (names);
        break;
        
    }
}


void
on_verify_decrypt_file_drag_data_received
                                        (GtkWidget       *widget,
                                        GdkDragContext  *drag_context,
                                        gint             x,
                                        gint             y,
                                        GtkSelectionData *selection_data,
                                        guint            info,
                                        guint            time,
                                        gpointer         user_data)
{
    GList *names;
    char *filename = NULL;
    GtkWidget *decrypt_file_btn, *verify_decrypt_file;

    if (!selection_data->data)
        return;
	
    switch (info){
    case TARGET_URI_LIST:
        names = gnome_uri_list_extract_uris ((char *)selection_data->data);
		
        if (!names)
            return;

        /* we ignore all but the first filename */
        filename = names->data;
	if (strncmp (filename, "file:", 5) == 0)
        {
            filename += 5;
            decrypt_file_btn = get_widget (verify_decrypt, "decrypt_file_btn");
            gtk_toggle_button_set_active (GTK_TOGGLE_BUTTON (decrypt_file_btn), TRUE);
            verify_decrypt_file = get_widget (verify_decrypt, "verify_decrypt_file");
            if (verify_decrypt_file != NULL) {
		gtk_entry_set_text (GTK_ENTRY (verify_decrypt_file),
                                    filename);
            }
        }

        gnome_uri_list_free_strings (names);
        break;
        
    }
}


void
on_data_textbox_drag_data_received     (GtkWidget       *widget,
                                        GdkDragContext  *drag_context,
                                        gint             x,
                                        gint             y,
                                        GtkSelectionData *selection_data,
                                        guint            info,
                                        guint            time,
                                        gpointer         user_data)
{
    GList *names;
    char *filename = NULL;
    int fd;

    if (!selection_data->data)
        return;
	
    switch (info){
    case TARGET_URI_LIST:
        names = gnome_uri_list_extract_uris ((char *)selection_data->data);
		
        if (!names)
            return;

        /* we ignore all but the first filename */
        filename = names->data;
	if (strncmp (filename, "file:", 5) == 0)
        {
            filename += 5;
            if( (fd=open(filename,O_RDONLY))>=0 )
            {
                gtk_text_set_point(GTK_TEXT (widget), 0);
                gtk_text_forward_delete (GTK_TEXT (widget),
                                         gtk_text_get_length(GTK_TEXT (widget)));
                read_from_file(fd);
                close(fd);
            }
        }

        gnome_uri_list_free_strings (names);
        break;
        
    }
}


/* button11 is encrypt */

void
on_button11_drag_data_received         (GtkWidget       *widget,
                                        GdkDragContext  *drag_context,
                                        gint             x,
                                        gint             y,
                                        GtkSelectionData *selection_data,
                                        guint            info,
                                        guint            time,
                                        gpointer         user_data)
{
    GList *names;
    char *filename = NULL;
    GtkWidget *encrypt_file_btn, *sign_encrypt_file;

    if (!selection_data->data)
        return;
	
    switch (info){
    case TARGET_URI_LIST:
        names = gnome_uri_list_extract_uris ((char *)selection_data->data);
		
        if (!names)
            return;

        /* we ignore all but the first filename */
        filename = names->data;
	if (strncmp (filename, "file:", 5) == 0)
        {
            filename += 5;
            on_encrypt_activate (NULL, NULL);
            encrypt_file_btn = get_widget (sign_encrypt, "encrypt_file_btn");
            gtk_toggle_button_set_active (GTK_TOGGLE_BUTTON (encrypt_file_btn), TRUE);
            sign_encrypt_file = get_widget (sign_encrypt, "sign_encrypt_file");
            if (sign_encrypt_file != NULL) {
		gtk_entry_set_text (GTK_ENTRY (sign_encrypt_file),
                                    filename);
            }
        }

        gnome_uri_list_free_strings (names);
        break;
        
    }
}


/* button12 is decrypt */

void
on_button12_drag_data_received         (GtkWidget       *widget,
                                        GdkDragContext  *drag_context,
                                        gint             x,
                                        gint             y,
                                        GtkSelectionData *selection_data,
                                        guint            info,
                                        guint            time,
                                        gpointer         user_data)
{
    GList *names;
    char *filename = NULL;
    GtkWidget *decrypt_file_btn, *verify_decrypt_file;

    if (!selection_data->data)
        return;
	
    switch (info){
    case TARGET_URI_LIST:
        names = gnome_uri_list_extract_uris ((char *)selection_data->data);
		
        if (!names)
            return;

        /* we ignore all but the first filename */
        filename = names->data;
	if (strncmp (filename, "file:", 5) == 0)
        {
            filename += 5;
            on_decrypt_activate (NULL, NULL);
            decrypt_file_btn = get_widget (verify_decrypt, "decrypt_file_btn");
            gtk_toggle_button_set_active (GTK_TOGGLE_BUTTON (decrypt_file_btn), TRUE);
            verify_decrypt_file = get_widget (verify_decrypt, "verify_decrypt_file");
            if (verify_decrypt_file != NULL) {
		gtk_entry_set_text (GTK_ENTRY (verify_decrypt_file),
                                    filename);
            }
        }

        gnome_uri_list_free_strings (names);
        break;
        
    }
}


/********************* Preferences Dialog ****************************/


void
on_pref_default_cipher_activate        (GtkEditable     *editable,
                                        gpointer         user_data)
{
	on_prefdialog_ok_clicked (NULL, NULL);              
}


void
on_pref_default_key_activate           (GtkEditable     *editable,
                                        gpointer         user_data)
{
	on_prefdialog_ok_clicked (NULL, NULL);              
}


void
on_prefdialog_ok_clicked               (GtkButton       *button,
                                        gpointer         user_data)
{
	on_prefdialog_apply_clicked (NULL, NULL);
	gtk_widget_destroy (pref_dialog);
	save_config();
	
}


void
on_prefdialog_cancel_clicked           (GtkButton       *button,
                                        gpointer         user_data)
{
	gtk_widget_destroy (pref_dialog);
}


void
on_prefdialog_apply_clicked            (GtkButton       *button,
                                        gpointer         user_data)
{
	GtkWidget *pref_comment;
	GtkWidget *pref_default_cipher;
	GtkWidget *pref_default_key;
	gchar	*default_buf;
	Key *key;

     default_buf = NULL;
  	pref_default_key = get_widget (pref_dialog, "pref_default_key");
	if (check_free_entry (pref_default_key, &default_buf))
		return;

	
	key = keyring_get_key_with_userid(MyKeyring, default_buf);
	if (default_key !=  NULL)
		g_free (default_key);

	default_key = g_strdup (key->KeyID);
	g_free (default_buf);

  	pref_comment = get_widget (pref_dialog, "pref_comment");
	check_free_entry (pref_comment, &comment);

  	pref_default_cipher = get_widget (pref_dialog, 
			"pref_default_cipher");
	if (check_free_entry (pref_default_cipher, &default_cipher))
		return;
}


gboolean
on_key_press_event                     (GtkWidget       *widget,
                                        GdkEventKey     *event,
                                        gpointer         user_data)
{
	if (event->state & GDK_MOD1_MASK)
	{
		gtk_signal_emit_stop_by_name (GTK_OBJECT (widget),
				"key_press_event");
		return FALSE;
	}

	return TRUE;
}


void
on_find1_activate                      (GtkMenuItem     *menuitem,
                                        gpointer         user_data)
{
    GtkWidget *find_string_text;
    find_string_dialog = create_find_string ();
    find_string_text = get_widget (find_string_dialog, "find_string_text");

    if (last_find_string != NULL) {
        gtk_entry_set_text (GTK_ENTRY (find_string_text),
                            last_find_string);
    }
    gtk_widget_show (find_string_dialog);
    gtk_widget_grab_focus (find_string_text);
}


void
on_find_again1_activate                (GtkMenuItem     *menuitem,
                                        gpointer         user_data)
{
    GtkWidget *data_textbox;
    GtkText       *text;
    GtkEditable   *editable;
    gint curr, stop, i, start;
    gchar *chars, *lower_find_string;

    data_textbox = get_widget (main_win, "data_textbox");
    text=GTK_TEXT (data_textbox);
    editable=GTK_EDITABLE(data_textbox);
    if( last_find_string==NULL )
        return;

    lower_find_string=g_strdup(last_find_string);
    i=0;
    while( lower_find_string[i]!=0 )
    {
        lower_find_string[i]=tolower(lower_find_string[i]);
        i++;
    }
    start=gtk_editable_get_position( editable );
    chars=gtk_editable_get_chars( editable, 0, -1 );
    stop=0;
    while( chars[stop]!=0 )
    {
        chars[stop]=tolower(chars[stop]);
        stop++;
    }
    if( start>=stop )
        start=0;
    for(curr=start+1;;curr++)
    {
        if( curr>=stop )
            curr=0;
        if( curr==start ) /* wrapped around one time */
            break;
        for(i=0;;i++)
        {
            if( lower_find_string[i]==0 )
            {
                gtk_editable_set_position(editable, curr );
                gtk_editable_select_region (editable,curr, curr+i);
                g_free(chars);
                g_free(lower_find_string);
                return;
            }
            if( curr+i>=stop )
                break;
            if( chars[curr+i]!=lower_find_string[i] )
                break;
        }
    }
    g_free(chars);
    g_free(lower_find_string);
}


void
on_finddialog_activate                 (GtkEditable     *editable,
                                        gpointer         user_data)
{
    GtkWidget *find_string_text;
    
    find_string_text = get_widget (find_string_dialog, "find_string_text");
    if (check_free_entry (find_string_text, &last_find_string))
        return;

    gtk_widget_destroy (find_string_dialog);

    on_find_again1_activate(NULL,NULL);
}


void
on_finddialog_find_clicked             (GtkButton       *button,
                                        gpointer         user_data)
{
    on_finddialog_activate (NULL, NULL);
}


void
on_finddialog_close_clicked            (GtkButton       *button,
                                        gpointer         user_data)
{
    gtk_widget_destroy (find_string_dialog);
}


void
on_find_string_text_activate           (GtkEditable     *editable,
                                        gpointer         user_data)
{
    on_finddialog_activate (NULL, NULL);
}



void
on_keymanager_file_activate            (GtkMenuItem     *menuitem,
                                        gpointer         user_data)
{

}


void
on_keymanager_key_activate             (GtkMenuItem     *menuitem,
                                        gpointer         user_data)
{

}


void
on_keymanager_properties_activate      (GtkMenuItem     *menuitem,
                                        gpointer         user_data)
{

}


void
on_keymanager_exit_activate            (GtkMenuItem     *menuitem,
                                        gpointer         user_data)
{

}


void
on_keymanager_prefs_activate           (GtkMenuItem     *menuitem,
                                        gpointer         user_data)
{

}


void
on_keymanager_help_activate            (GtkMenuItem     *menuitem,
                                        gpointer         user_data)
{

}


void
on_keymanager_about_activate           (GtkMenuItem     *menuitem,
                                        gpointer         user_data)
{

}


void
on_changepass_ok_clicked               (GtkButton       *button,
                                        gpointer         user_data)
{

}




