<?/* 
+-------------------------------------------------------------------------+
| raXnet cacti: the rrdtool frontend                                      |
+-------------------------------------------------------------------------+
| This code was crafted by Ian Berry, make sure any questions             |
| about the structure or integrity of this code be directed to:           |
| - rax@kuhncom.net                                                       |
| - iberry@onion.dyndns.org                                               |
+-------------------------------------------------------------------------+
| raXnet home: http://raxnet.sourceforge.net                              |
+-------------------------------------------------------------------------+
| Function Library Documentation:                                         |
|                                                                         |
+   ["options"]["sql_type_column"] - the name of the SQL column that      |
| 	  contains the 'Type' field.                                          |
|	["options"]["sql_string"]* - the SQL string to use when getting data. |
|	["options"]["sql_connection_id"] - the SQL connection id to the       |
|	  database server.                                                    |
|	["options"]["indent"] - the character to use for indentation.         |
|	["options"]["remove_action"]* - the URL to use when removing an item. |
|    ["options"]["sql_delete_table_name"] - the table name to use when    |
|	  deleting items from a tree.                                         |
|	["remove_branch"] - set to 'true' when you want to delete items       |
|	  instead of drawing them on the screen.                              |
|	["branch_to_remove"] - the id of the starting branch to delete.       |
|	                                                                      |
|	Items:                                                                |
|	["item"][<NUM>] - the name of the 'Type', must match values exactly   |
|	  to the SQL 'Type' column.                                           |
|	["item_action"][<NUM>]* - the URL to use when an item is clicked.     |
|	["item_td_code"][<NUM>]* - extra code to be included in the TD        |
|	                                                                      |
|	* - these items are passed to PHP's eval function before being passed |
|	  back to the browser, put and runtime code here.                     |
|	                                                                      |
|	Once the array is created, make sure it is passed to the 'GrowTree'   |
|	function to draw the tree.                                            |
+-------------------------------------------------------------------------+
*/?>
<?

function GrowTree($array_tree) {
	if ($array_tree["options"]["start_branch"] == "") {
		DrawLeaf(0,$array_tree,$array_values,0);
	}else{
		DrawLeaf($array_tree["options"]["start_branch"],$array_tree,$array_values,0);
	}
}

function DrawLeaf($branch,$array_tree,$array_values,$level) {
	include ('include/config.php');
	include_once ('include/form.php');
	
	/* if we are displaying part of the tree; first draw the item that
	they clicked on, then all of the children. This is done mainly 
	for looks because it is easier to visualize the tree this way */
	if (isset($array_tree["options"]["sql_header_string"]) == true) {
		$item_to_eval = $array_tree["options"]["sql_header_string"];
		eval ("\$sql_item = \"$item_to_eval\";");
		unset($array_tree["options"]["sql_header_string"]);
	}else{
		$item_to_eval = $array_tree["options"]["sql_string"];
		eval ("\$sql_item = \"$item_to_eval\";");
	}
	
	$sql_id = mysql_query($sql_item, $array_tree["options"]["sql_connection_id"]);
	$rows = mysql_num_rows($sql_id); $i = 0;
	
	/* loop through all items */
	while ($i < $rows) {
		if ($array_values["remove"]["start"] == true) {
			if ($array_values["remove"]["start_branch"] >= $level) {
				$array_values["remove"]["start"] = false;
			}
		}
		
		if (isset($array_values["hide"]["start_branch"]) == true) {
			if ($array_values["hide"]["start_branch"] >= $level) {
				unset($array_values["hide"]["start_branch"]);
			}
		}
		
		/* action type: draw or delete? */
		if ($array_tree["remove"]["remove_branch"] == true) {
			/* once we get to the item we want to delete, keep deleting until we arrive
			at an adjecent spot in the tree */
			if ($array_tree["remove"]["branch_to_remove"] == mysql_result($sql_id, $i, "id")) {
				$array_values["remove"]["start"] = true;
				$array_values["remove"]["start_branch"] = $level;
			}
			
			if ($array_values["remove"]["start"] == true) {
				mysql_query("delete from " . $array_tree["options"]["sql_delete_table_name"]
					 . " where id=" . mysql_result($sql_id, $i, "id")
					 , $array_tree["options"]["sql_connection_id"]);
			}
		}else{
			if (isset($array_values["hide"]["start_branch"]) == false) {
				/* create the &nbsp's for html (3 for each indent, times 6 characters) */
				//$indent = str_pad("", $level*3*(strlen($array_tree["options"]["indent"])), $array_tree["options"]["indent"]);
				$pix = $level * 20;
				$indent = "<img src=\"images/gray_line.gif\" width=\"$pix\" height=\"1\" align=\"middle\">&nbsp;";
				
				
				/* set up variables used in this section */
				$start_tr = ""; $end_tr = ""; $start_nested_table = ""; $end_nested_table = ""; $td_indent = ""; /* array counter */
				
				/* put the current column type in a variable for easy access (c) :) */
				$current_column_type = mysql_result($sql_id, $i, $array_tree["options"]["sql_type_column"]);
				
				/* get the next type (if we're not the last item) to see when to end a row on an
				'off' column */
				if (($i+2) <= $rows) {
					$next_column_type= mysql_result($sql_id, ($i+1), $array_tree["options"]["sql_type_column"]);
				}
				
				/* figure out if the user wants a margin; if this item can have children,
				and if it can draw a '+' */
				if ($array_tree["options"]["create_margin"] == true) {
					if ($array_tree["item_can_have_children"][$current_column_type] == true) {
						if ($array_tree["options"]["use_expand_contract"] == true) {
							if (mysql_result($sql_id, $i, "status") == "1") {
								/* PHP: EVAL */
								$item_to_eval = $array_tree["options"]["show_item"];
								eval ("\$show_hide_item = \"$item_to_eval\";");
							}else{
								/* PHP: EVAL */
								$item_to_eval = $array_tree["options"]["hide_item"];
								eval ("\$show_hide_item = \"$item_to_eval\";");
							}
							
							$html_margin = "<td bgcolor=\"$color_panel\" width=\"1%\">$show_hide_item</td>";
						}
					}else{
						$html_margin = "<td bgcolor=\"$color_panel\" align=\"center\" width=\"1%\"></td>";
					}
				}else{
					$html_margin = "";
				}
				
				/* do some basic preparation depending on if the user is using columns or not */
				if ($array_tree["item_columns"][$current_column_type] == "") {
					/* always start a new row when columns aren't in use */
					/* start a new row: 1) using alternating colors or 2) default */
					if ($array_tree["options"]["alternating_row_colors"] == true) {
						$start_tr = ReturnMatrixRowAlternateColorBegin($color_alternate,$color_light,$array_values["row_counter"]);
					}else{
						$start_tr =  "<tr>";
					}
					
					/* for a one column deal ALWAYS use the ident */
					$td_indent = $indent;
					
					/* nothing special; end the row */
					$end_tr = "</tr>";
				}else{
					/* if the 'current_column_type' has changed 1) set the column #1 to 1
					2) start a new row */
					if ($array_values["last_tree_type"] != $current_column_type) {
						/* reset counter when type changes */
						$array_values["column"][$current_column_type] = 0;
					}
					
					$array_values["column"][$current_column_type]++;
					
					/* only display margin on column #1 */
					if ($array_values["column"][$current_column_type] == 1) {
						$td_indent = $indent;
						
						$start_tr =  "<tr>";
						
						if ($array_tree["item_columns"][$current_column_type] > 1) {
							$start_nested_table = "<td><table><tr>";
						}
					}else{
						$html_margin = "";
						$td_indent = "&nbsp;";
					}
					
					if ($array_values["column"][$current_column_type] == $array_tree["item_columns"][$current_column_type]) {
						/* this row is done; clean up and move on */
						$array_values["column"][$current_column_type] = 0;
						
						$end_tr = "</tr>";
						
						if ($array_tree["item_columns"][$current_column_type] > 1) {
							$end_nested_table = "</tr></table></td>";
						}
					}elseif (($i+1) >= $rows) {
						/* if we are "out of graphs"; go on to the next row */
						$end_tr = "</tr>";
						$end_nested_table = "</tr></table></td>";
					}elseif ($next_column_type != $current_column_type) {
						/* if it is not the end of the row; but our forcasting powers tell us that
						it is the end of the row; end it */
						$end_tr = "</tr>";
						$end_nested_table = "</tr></table></td>";
					}
				}
				
				/* PHP: EVAL */
				$item_to_eval = $array_tree["item_action"][$current_column_type];
				eval ("\$html_item = \"$item_to_eval\";");
				
				/* PHP: EVAL */
				$item_to_eval = $array_tree["item_td_code"][$current_column_type];
				eval ("\$html_td_item = \"$item_to_eval\";");
				
				/* draw the main item */
				DrawMatrixCustom("$start_tr$html_margin$start_nested_table<td $html_td_item>$td_indent$html_item</td>"); $array_values["row_counter"]++;
				
				/* PHP: EVAL */
				if ($array_tree["options"]["moveup_action"] != "") {
					$item_to_eval = $array_tree["options"]["moveup_action"];
					$item_to_eval2 = $array_tree["options"]["movedown_action"];
					eval ("\$html_item = \"$item_to_eval\";");
					eval ("\$html_item2 = \"$item_to_eval2\";");
					
					DrawMatrixLoopItem("[<a href=\"$html_item2\">Down</a>], [<a href=\"$html_item\">Up</a>]","","",false,"");
				}
				
				/* PHP: EVAL */
				if ($array_tree["options"]["remove_action"] != "") {
					$item_to_eval = $array_tree["options"]["remove_action"];
					eval ("\$html_item = \"$item_to_eval\";");
					
					DrawMatrixLoopItemAction("Remove",$color_panel,"",false,$html_item);
				}
				
				DrawMatrixCustom("$end_nested_table$end_tr");
				
				$array_values["last_tree_type"] = $current_column_type;
				
				/* if do the hide thing if config says we can */
				if ($array_tree["options"]["use_expand_contract"] == true) {
					if (mysql_result($sql_id, $i, "status") == "1") { /* hide all chilren */
						/* initiate hide until we're done with this parent */
						$array_values["hide"]["start_branch"] = $level;
					}
				}
			}
		}
		
		/* if the branch is a parent, call the function again to make it recursive */
		if (IsParent(mysql_result($sql_id, $i, "id"),$array_tree["options"]["tree_id"]) == true) {
			$array_values["row_counter"] = DrawLeaf(mysql_result($sql_id, $i, "id"),$array_tree,$array_values,$level+1);
		}
		
		$i++;
	}
	
	return $array_values["row_counter"];
}

function IsParent($id, $tree_id) {
	include ("include/database.php");
	
	/* make acual sql connection */
	$sql_id = mysql_query("select * from graph_hierarchy_items where parent=$id and treeid=$tree_id", $cnn_id);
	
	/* check to see if it has any children, if so return sql id */
	if (mysql_num_rows($sql_id) != 0) {
		return true;
	}else{
		return false;
	}
}

function ReturnMatrixRowAlternateColorBegin($row_color1, $row_color2, $row_value) {
	if (($row_value % 2) == 1) {
		$current_color = $row_color1;
	}else{
		$current_color = $row_color2;
	}
	
	return "<tr bgcolor=\"#$current_color\">";
}

?>