// Copyright 2018 The Chromium Authors. All rights reserved.
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.

#include "chrome/services/cups_ipp_parser/ipp_parser.h"

#include <memory>
#include <utility>

namespace chrome {

IppParser::IppParser(
    std::unique_ptr<service_manager::ServiceContextRef> service_ref)
    : service_ref_(std::move(service_ref)) {}

IppParser::~IppParser() = default;

void IppParser::ParseIpp(const std::string& to_parse,
                         ParseIppCallback callback) {
  DVLOG(1) << "IppParser stubbed";
  std::move(callback).Run(mojom::IppParserResult::FAILURE, nullptr);
}

}  // namespace chrome
