// Copyright 2019 The Chromium Authors. All rights reserved.
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.

#ifndef CHROME_BROWSER_PERMISSIONS_CONTEXTUAL_NOTIFICATION_PERMISSION_UI_SELECTOR_H_
#define CHROME_BROWSER_PERMISSIONS_CONTEXTUAL_NOTIFICATION_PERMISSION_UI_SELECTOR_H_

#include "base/callback.h"
#include "base/optional.h"
#include "chrome/browser/permissions/crowd_deny_safe_browsing_request.h"
#include "components/permissions/notification_permission_ui_selector.h"

namespace permissions {
class PermissionRequest;
}

namespace url {
class Origin;
}

// Determines if crowd deny or abusive blocklists prescribe that the quiet UI
// should be used to display a notification permission request on a given site.
// This is the case when the  both of the below sources classify the origin as
// spammy or abusive:
//   a) CrowdDenyPreloadData, that is, the component updater, and
//   b) CrowdDenySafeBrowsingRequest, that is, on-demand Safe Browsing pings.
//
// Each instance of this class is long-lived and can support multiple requests,
// but only one at a time.
class ContextualNotificationPermissionUiSelector
    : public permissions::NotificationPermissionUiSelector {
 public:
  ContextualNotificationPermissionUiSelector();
  ~ContextualNotificationPermissionUiSelector() override;

  // NotificationPermissionUiSelector:
  void SelectUiToUse(permissions::PermissionRequest* request,
                     DecisionMadeCallback callback) override;

  void Cancel() override;

 private:
  ContextualNotificationPermissionUiSelector(
      const ContextualNotificationPermissionUiSelector&) = delete;
  ContextualNotificationPermissionUiSelector& operator=(
      const ContextualNotificationPermissionUiSelector&) = delete;

  void EvaluatePerSiteTriggers(const url::Origin& origin);
  void OnSafeBrowsingVerdictReceived(
      Decision candidate_decision,
      CrowdDenySafeBrowsingRequest::Verdict verdict);
  void Notify(const Decision& decision);

  base::Optional<CrowdDenySafeBrowsingRequest> safe_browsing_request_;
  DecisionMadeCallback callback_;
};

#endif  // CHROME_BROWSER_PERMISSIONS_CONTEXTUAL_NOTIFICATION_PERMISSION_UI_SELECTOR_H_
