// Copyright 2020 The Chromium Authors. All rights reserved.
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.

#ifndef CHROME_BROWSER_CHROMEOS_EXTENSIONS_FILE_MANAGER_PRIVATE_API_HOLDING_SPACE_H_
#define CHROME_BROWSER_CHROMEOS_EXTENSIONS_FILE_MANAGER_PRIVATE_API_HOLDING_SPACE_H_

#include "extensions/browser/extension_function.h"

namespace extensions {

class FileManagerPrivateInternalToggleAddedToHoldingSpaceFunction
    : public ExtensionFunction {
 public:
  FileManagerPrivateInternalToggleAddedToHoldingSpaceFunction();

  DECLARE_EXTENSION_FUNCTION(
      "fileManagerPrivateInternal.toggleAddedToHoldingSpace",
      FILEMANAGERPRIVATEINTERNAL_TOGGLEADDEDTOHOLDINGSPACE)

 protected:
  ~FileManagerPrivateInternalToggleAddedToHoldingSpaceFunction() override;

  // ExtensionFunction overrides.
  ResponseAction Run() override;
};

class FileManagerPrivateGetHoldingSpaceStateFunction
    : public ExtensionFunction {
 public:
  FileManagerPrivateGetHoldingSpaceStateFunction();

  DECLARE_EXTENSION_FUNCTION("fileManagerPrivate.getHoldingSpaceState",
                             FILEMANAGERPRIVATEINTERNAL_GETHOLDINGSPACESTATE)

 protected:
  ~FileManagerPrivateGetHoldingSpaceStateFunction() override;

  // ExtensionFunction overrides.
  ResponseAction Run() override;
};

}  // namespace extensions

#endif  // CHROME_BROWSER_CHROMEOS_EXTENSIONS_FILE_MANAGER_PRIVATE_API_HOLDING_SPACE_H_
