#! perl
#
# TITLE: Webmail
#
# $Id: admin-47webmail.pl,v 1.2 2001/12/08 19:06:01 mrsam Exp $
#
# Copyright 2001 Double Precision, Inc.  See COPYING for
# distribution information.


use webadmin;

my $errmsg="";

if ($cgi->param("submit"))
{
    if ($cgi->param("maildirfilterconfig"))
    {
	my $fh=OpenConfigFile("maildirfilterconfig");

	if ($fh)	# Already exists
	{
	    close($fh);
	}
	else
	{
	    SaveMultiLineConfigFile("maildirfilterconfig",
				    [ "MAILDIRFILTER=../.mailfilter",
				      "MAILDIR=./Maildir" ]);
	}
    }
    else
    {
	DeleteConfigFile("maildirfilterconfig");
    }

    my $qc=$cgi->param("AUTORESPONSEQUOTAC")+0;

    my $qs=$cgi->param("AUTORESPONSEQUOTAS")+0;

    $qc=0 if $qc < 0;
    $qs=0 if $qs < 0;

    if ($qc > 0 || $qs > 0)
    {
	$qc= $qc ? $qc . "C":"";
	$qs= $qs ? $qs . "S":"";
	SaveOneLineConfigFile("autoresponsequota", "$qc$qs");
    }
    else
    {
	DeleteConfigFile("autoresponsequota");
    }

    if ($cgi->param("NOCHANGINGFROM"))
    {
	DeleteConfigFile("nochangingfrom");
    }
    else
    {
	SaveOneLineConfigFile("nochangingfrom", "");
    }

    if ($cgi->param("USEXSENDER"))
    {
	SaveOneLineConfigFile("usexsender", "");
    }
    else
    {
	DeleteConfigFile("usexsender");
    }

    if ($cgi->param("IMAGES"))
    {
	DeleteConfigFile("noimages");
    }
    else
    {
	SaveOneLineConfigFile("noimages", "");
    }

    my @logindomainlist=split(/\n/, $cgi->param("logindomainlist"));

    grep { s/\s+$//; s/^\s+//; } @logindomainlist;
    grep { $_=lc($_); } @logindomainlist;

    @logindomainlist=sort grep(/./, @logindomainlist);

    if ($#logindomainlist >= 0)
    {
	SaveMultiLineConfigFile("logindomainlist", \@logindomainlist);
    }
    else
    {
	DeleteConfigFile("logindomainlist", \@logindomainlist);
    }

    my $calendarmode=$cgi->param("calendarmode");

    if ($calendarmode eq "local" || $calendarmode eq "net")
    {
	SaveOneLineConfigFile("calendarmode", $calendarmode);
    }
    else
    {
	DeleteConfigFile("calendarmode");
    }
    changed("test -x ${libexecdir}/courier/pcpd || exit 0; if test \"\`cat ${sysconfdir}/calendarmode 2>/dev/null\`\" = 'net' ; then $libexecdir/courier/pcpd start ; else $libexecdir/courier/pcpd stop ; fi");
    $errmsg="\@SAVED\@";
}

my $autoresponsequota=ReadOneLineConfigFile("autoresponsequota");

my $AUTORESPONSEQUOTAC="";
my $AUTORESPONSEQUOTAS="";

while ($autoresponsequota =~ /([0-9]+)(.)(.*)/)
{
    my ($n, $c, $rest)=($1,$2,$3);

    $autoresponsequota=$rest;

    $AUTORESPONSEQUOTAC=$n if $c eq "C";
    $AUTORESPONSEQUOTAS=$n if $c eq "S";
}

sub cexists {
    my $n=shift;

    my $fh=OpenConfigFile($n);

    if ($fh)
    {
	close($fh);
	return 1;
    }
    return undef;
}

my $maildirfilterconfig="<input type=checkbox name=\"maildirfilterconfig\" "
    . ( cexists("maildirfilterconfig") ? "CHECKED":"") . ">";
my $NOCHANGINGFROM="<input type=checkbox name=\"NOCHANGINGFROM\" "
    . ( cexists("nochangingfrom") ? "":"CHECKED") . ">";
my $USEXSENDER="<input type=checkbox name=\"USEXSENDER\" "
    . ( cexists("usexsender") ? "CHECKED":"") . ">";
my $IMAGES="<input type=checkbox name=\"IMAGES\" "
    . ( cexists("noimages") ? "":"CHECKED") . ">";
my $logindomainlist="";

my $fh=OpenConfigFile("logindomainlist");

$logindomainlist="<textarea rows=8 name=logindomainlist columns=40>";

if ($fh)
{
    $logindomainlist .= htmlescape(join("", <$fh>));
    close($fh);
}
$logindomainlist .= "</textarea>";

my $calendarmode=ReadOneLineConfigFile("calendarmode");

my $calendarmodeHtml="<select name=\"calendarmode\">"
  . "<option value=\"\">\@CALDISABLED\@"
  . "<option value=\"local\" " . ($calendarmode eq "local"
				  ? "SELECTED":"")
  . ">\@CALLOCAL\@"
  . "<option value=\"net\" " . ($calendarmode eq "net"
				? "SELECTED":"")
  . ">\@CALNET\@</select>";

display_form("admin-47webmail.html",
	     {
		 "ERRMSG" => $errmsg,
		 "maildirfilterconfig" => $maildirfilterconfig,
		 "AUTORESPONSEQUOTAC" => $AUTORESPONSEQUOTAC,
		 "AUTORESPONSEQUOTAS" => $AUTORESPONSEQUOTAS,

		 "NOCHANGINGFROM" => $NOCHANGINGFROM,
		 "USEXSENDER" => $USEXSENDER,
		 "IMAGES" => $IMAGES,
		 "logindomainlist" => $logindomainlist,

		 "calendarmode" => $calendarmodeHtml,
	     }
	     );
