#ifndef __chxliteprefs_h
#define __chxliteprefs_h


#include "hxtypes.h"
#include "hxmap.h"
#include "unkimp.h"
#include "hxstring.h"
#include "hxprefs.h"
#include "hxengin.h"


class CHXStringList;
class CHXDataFile;
struct IHXCommonClassFactory;
class HXMutex;


enum ParseState
{
    eParsingWhiteSpace,
    eParsingName,
    eParsingValue,
    eParsingShadow,
    eParsingComment
};

class CHXLitePrefs : public IHXPreferences,
		     public IHXPreferences3,
#if !defined(HELIX_CONFIG_LITEPREFS_SLUGGISH_OUT)
		     public IHXCallback,
#endif
		     public CUnknownIMP
{
public:
    CHXLitePrefs(const char* pRootPath = NULL);
    virtual ~CHXLitePrefs();

    DECLARE_UNKNOWN(CHXLitePrefs);

    // CHXLitePrefs
    STDMETHOD(SetContext)	        (THIS_ IUnknown* pContext);
    STDMETHOD(Commit)		        (THIS);
    STDMETHOD(SetAutoCommit)            (THIS_ bool bAutoCommit);
    STDMETHOD(ResetPrefs)               (THIS);

    // IHXPreferences
    STDMETHOD(ReadPref)		(THIS_ const char* pName,
					REF(IHXBuffer*) pValue);
    STDMETHOD(WritePref)	(THIS_ const char* pName,
					IHXBuffer* pValue);

    // IHXPreferences3
    STDMETHOD(Open)		(THIS_ const char* pCompanyName,
					const char* pProductName,
					ULONG32 nProdMajorVer,
					ULONG32 nProdMinorVer);
    STDMETHOD(OpenShared)	(THIS_ const char* pCompanyName);
    STDMETHOD(DeletePref)	(THIS_ const char* pPrekKey);

#if !defined(HELIX_CONFIG_LITEPREFS_SLUGGISH_OUT)
    // IHXCallback
    STDMETHOD(Func)		(THIS);
#endif // (HELIX_CONFIG_LITEPREFS_SLUGGISH_OUT)

    void                        Close(void);

private:

    CHXString GetFullPath(const CHXString& strFileName);
    void PossiblyCommitPrefChange();

    

    CHXMapStringToOb		m_prefs;
    HXMutex*			m_pMutex;
    IHXCommonClassFactory*	m_pFactory;
    IHXScheduler*		m_pScheduler;
    CallbackHandle		m_hCallback;
    CHXString                   m_strRootPath;
    CHXString                   m_strFileName;
    bool                        m_bAutoCommit;
};



#endif /* #ifndef __chxliteprefs_h */
