/* serial elbug = electronic morse key. */
/* by Günther Montag dl4mge */
/* elbug is distributed alone and as part of the hf package. */
/* Just compile me by 'gcc elbug.c -o elbug' */
/* and copy elbug to user/local/bin. */
/* Call me as root. */
/* How to cable your homebrew elbug? See below! */

/*
 *      This program is free software; you can redistribute it and/or modify
 *      it under the terms of the GNU General Public License as published by
 *      the Free Software Foundation; either version 2 of the License, or
 *      (at your option) any later version.
 *
 *      This program is distributed in the hope that it will be useful,
 *      but WITHOUT ANY WARRANTY; without even the implied warranty of
 *      MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *      GNU General Public License for more details.
 *
 *      You should have received a copy of the GNU General Public License
 *      along with this program; if not, write to the Free Software
 *      Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
 *
 *
 */

#include <stdio.h>
#include <sys/io.h>
#include <sys/time.h>
#include <sys/ioctl.h>
#include <fcntl.h>
#include <unistd.h>
#include <string.h>
#include <stdlib.h>

char *cable = "\n"
	"* * * elbug - electronic morse key by dl4mge. How to cable: * * *\n"
	"*  Middle pad: +9V via Resistor 2 k                             *\n"                           
	"*  Left  contact: -> DCD (9-pin plug: 1) (25-pin plug: 8)       *\n"
	"*  Right contact: -> CTS (9-pin plug: 8) (25-pin plug: 5)       *\n"
	"*  Ground:               (9-pin plug: 5) (25-pin plug: 7)       *\n"
	"* * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * *\n" ;


/* default parameters */
int pin = TIOCM_RTS;
char* name_ptt = "/dev/ttyS0";
int port = 0x3f8;
int invert_ptt = 0;
unsigned int wpm = 12;

int fd_ptt;
int dotus;

void wait(int us) {
    struct timeval tv;
    tv.tv_sec = 0;
    tv.tv_usec = us;
    select (0, NULL, NULL, NULL, &tv);
}

void output_elbug_serial(int ptt)
{
	if (fd_ptt < 0) {
	    printf("no serial port open for output.\n");
	    exit (1);
	}
	if (ioctl(fd_ptt, 
	    ((ptt && !invert_ptt) || (!ptt && invert_ptt)) ? 
	    TIOCMBIS : TIOCMBIC, &pin)) {
	    printf ("ioctl: TIOCMBI[CS]\n");
	    printf ( "serial port can not be accessed!\n");
	    exit (1);
	}
}

void elbug_send_dit() {
    output_elbug_serial(1);
//    printf(".");
    wait(dotus);
    output_elbug_serial(0);
    wait(dotus);
}

void elbug_send_dah() {
    output_elbug_serial(1);
//    printf("_");    
    wait(dotus * 3);
    output_elbug_serial(0);
    wait(dotus);
}

int main(int argc, char *argv[]) {
    int c, err = 0;
    unsigned short int dcd, cts;
    
    while ((c = getopt(argc, argv, "w:s:di")) != -1) {
	switch (c) {
	    case 's':
		name_ptt = optarg;
		if (! strcmp (name_ptt, "/dev/ttyS0")) {
		    port = 0x03F8;
		    break;
		}
		if (! strcmp (name_ptt, "/dev/ttyS1")) {
		    port = 0x02F8;
		    break;
		}
		if (! strcmp (name_ptt, "/dev/ttyS2")) {
		    port = 0x03E8;
		    break;
		}
		if (! strcmp (name_ptt, "/dev/ttyS3")) {
		    port = 0x02E8;
		    break;
		}
		break;
    	    case 'd':
		pin = TIOCM_DTR;
    		break;
            case 'i':
	        invert_ptt = 1;
    	        break;
    	    case 'w':
		wpm = strtoul(optarg, NULL, 0);
		if (wpm < 3 || wpm > 90) {
		    printf("Speed %d out of range 3...90 wpm\n", wpm);
    		    err++;
		}

		break;
	    default:
        	err++;
        	break;
    	}
    	if (err) {
    	    printf("/* dl4mge's elbug.*/\n"
		"usage: elbug [-w <speed wpm>] [-s <ptt comm port>] [-d] [-i] \n"
			"  -w: speed in wpm              (default: 12 words per minute)\n"
			"  -s: serial port for in/output (default: /dev/ttyS0)\n"
			"  -d: output through DTR pin    (default is RTS)\n"
			"  -i: invert PTT                (default: PTT = positive)\n"
			"%s", cable);
	exit (0);
	}
    }
    if ((err = ioperm(port, 8, 1))) {
	printf("permission problem for serial port %04x: ioperm = %d\n", 
	    port, err);
	printf("This program has to be called with root permissions.\n");
    }
    if ((fd_ptt = open(name_ptt, O_RDWR, 0)) < 0) {
	printf("error in opening ptt device %s - maybe try another one?\n", 
	    name_ptt);
    }
    dotus = 1000000 / (wpm * 50 / 60);

    printf("%s",cable);
    printf("\nelbug: %d wpm at %s, address %04x, %s %s\n",
	wpm, name_ptt, port,
	invert_ptt ? "inverted ptt output," : "",
	pin == TIOCM_DTR ? "DTR output" : "RTS output");
    printf("A dit will last %d ms.\n", dotus/1000);
    printf("See options by elbug -h. Stop me by <strg>c.\n");
    
    output_elbug_serial(0);

    /* main loop */
    for (;;) {
	dcd = inb(port + 6) & 128;
	cts = inb(port + 6) & 16;    
	if (cts) elbug_send_dit();
	if (dcd) elbug_send_dah();
	wait(3000);
    }
}
