/* 
 *	HT Editor
 *	htneent.cc
 *
 *	Copyright (C) 1999, 2000, 2001 Stefan Weyergraf (stefan@weyergraf.de)
 *
 *	This program is free software; you can redistribute it and/or modify
 *	it under the terms of the GNU General Public License version 2 as
 *	published by the Free Software Foundation.
 *
 *	This program is distributed in the hope that it will be useful,
 *	but WITHOUT ANY WARRANTY; without even the implied warranty of
 *	MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *	GNU General Public License for more details.
 *
 *	You should have received a copy of the GNU General Public License
 *	along with this program; if not, write to the Free Software
 *	Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
 */

#include "htatom.h"
#include "htne.h"
#include "htneent.h"
#include "httag.h"
#include "formats.h"

ht_tag_flags_s ne_entflags[] =
{
	{-1, "NE - entrypoint flags"},
	{0,  "[00] exported"},
	{1,  "[01] single data"},
	{2,  "[02] reserved"},
	{0, 0}
};

ht_view *htneentrypoints_init(bounds *b, ht_streamfile *file, ht_format_group *group)
{
	ht_ne_shared_data *ne_shared=(ht_ne_shared_data *)group->get_shared_data();

	dword h=ne_shared->hdr_ofs;
	ht_uformat_viewer *v=new ht_uformat_viewer();
	v->init(b, DESC_NE_ENTRYPOINTS, VC_EDIT, file, group);
	ht_mask_sub *m=new ht_mask_sub();
	m->init(file, 0);

	register_atom(ATOM_NE_ENTFLAGS, ne_entflags);

	char line[1024], *l;	/* possible buffer overflow */
	sprintf(line, "* NE entrypoint table at offset %08x", h+ne_shared->hdr.enttab);
	m->add_mask(line);

	dword o=h+ne_shared->hdr.enttab;
	NE_ENTRYPOINT_HEADER e;
	file->seek(o);
	file->read(&e, sizeof e);
	o+=sizeof e;

	dword index=1;
	while (o<h+ne_shared->hdr.enttab+ne_shared->hdr.cbenttab) {
		if (e.seg_index==0) {
/*			sprintf(line, "null entries [%d]", e.entry_count);
			m->add_mask(line);*/
		} else if (e.seg_index==0xff) {
			sprintf(line, "entrypoints for movable segment [%d]", e.entry_count);
			m->add_mask(line);
		} else {
			sprintf(line, "entrypoints for segment %d [%d]", e.seg_index, e.entry_count);
			m->add_mask(line);
		}
		for (int i=0; i<e.entry_count; i++) {
			if (e.seg_index==0) {
			} else if (e.seg_index==0xff) {
				l=line;
				l+=sprintf(l, "%04x: ", index);
				l=tag_make_edit_byte(l, o+3);
				*(l++)=':';
				l=tag_make_edit_word(l, o+4, tag_endian_little);
				l+=sprintf(l, " flags=");
				l=tag_make_edit_byte(l, o);
				*(l++)=' ';
				l=tag_make_flags(l, ATOM_NE_ENTFLAGS, o);
				*l=0;
				m->add_mask(line);
				o+=sizeof (NE_ENTRYPOINT_MOVABLE);
			} else {
				l=line;
				l+=sprintf(l, "%04x:    ", index);
				l=tag_make_edit_word(l, o+1, tag_endian_little);
				l+=sprintf(l, " flags=");
				l=tag_make_edit_byte(l, o);
				*(l++)=' ';
				l=tag_make_flags(l, ATOM_NE_ENTFLAGS, o);
				*l=0;
				m->add_mask(line);
				o+=sizeof (NE_ENTRYPOINT_FIXED);
			}
			index++;
		}
		file->seek(o);
		file->read(&e, sizeof e);
		o+=sizeof e;
	}

	v->insertsub(m);

	return v;
}

format_viewer_if htneentrypoints_if = {
	htneentrypoints_init,
	0
};
