<?php
/**
 * $Horde: imp/contacts.php,v 2.67.10.10 2008/05/21 01:16:32 chuck Exp $
 *
 * Copyright 2002-2008 The Horde Project (http://www.horde.org/)
 *
 * See the enclosed file COPYING for license information (GPL). If you
 * did not receive this file, see http://www.fsf.org/copyleft/gpl.html.
 */

@define('IMP_BASE', dirname(__FILE__));
$authentication = 'horde';
require_once IMP_BASE . '/lib/base.php';
require_once IMP_BASE . '/lib/Template.php';

/* Get the lists of address books through the API. */
$source_list = $registry->call('contacts/sources');

/* If we self-submitted, use that source. Otherwise, choose a good
 * source. */
$source = Util::getFormData('source');
if (empty($source) || !isset($source_list[$source])) {
    /* We don't just pass the second argument to getFormData() because
     * we want to trap for invalid sources, not just no source. */
    reset($source_list);
    $source = key($source_list);
}

/* Get the search as submitted (defaults to '' which should list everyone). */
$search = Util::getFormData('search');

/* Get the name of the calling form (Defaults to 'compose'). */
$formname = Util::getFormData('formname', 'compose');

/* Are we limiting to only the 'To:' field? */
$to_only = Util::getFormData('to_only');

$apiargs = array(
    'addresses' => array($search),
    'addressbooks' => array($source),
    'fields' => array()
);

if ($search_fields_pref = $prefs->getValue('search_fields')) {
    foreach (explode("\n", $search_fields_pref) as $s) {
        $s = trim($s);
        $s = explode("\t", $s);
        if (!empty($s[0]) && ($s[0] == $source)) {
            $apiargs['fields'][array_shift($s)] = $s;
            break;
        }
    }
}

$results = array();
if (Util::getFormData('searched') || $prefs->getValue('display_contact')) {
    $results = $registry->call('contacts/search', $apiargs);
}

/* The results list returns an array for each source searched - at least
 * that's how it looks to me. Make it all one array instead. */
$addresses = array();
foreach ($results as $r) {
    $addresses = array_merge($addresses, $r);
}

/* If self-submitted, preserve the currently selected users encoded by
 * javascript to pass as value|text. */
$selected_addresses = array();
$sa = explode('|', Util::getFormData('sa'));
for ($i = 0; $i < count($sa) - 1; $i += 2) {
    $selected_addresses[] = array('val' => $sa[$i], 'text' => $sa[$i + 1]);
}

/* Set the default list display (name or email). */
$display = Util::getFormData('display', 'name');

/* Prepare the contacts template. */
$template = new IMP_Template();
$template->setOption('gettext', true);

$template->set('action', Horde::url(Util::addParameter(Horde::applicationUrl('contacts.php'), 'uniq', base_convert(microtime(), 10, 36))));
$template->set('formname', $formname);
$template->set('formInput', Util::formInput());
$template->set('search', htmlspecialchars($search));
if (count($source_list) > 1) {
    $template->set('multiple_source', true);
    $s_list = array();
    foreach ($source_list as $key => $select) {
       $s_list[] = array('val' => $key, 'selected' => ($key == $source), 'label' => htmlspecialchars($select));
    }
    $template->set('source_list', $s_list);
} else {
    $template->set('source_list', key($source_list));
}
if ($browser->isBrowser('msie')) {
    $template->set('select_event', ' ondblclick="addAddress(\'to\')"');
    $template->set('option_event', null);
} else {
    $template->set('select_event', null);
    $template->set('option_event', ' ondblclick="addAddress(\'to\')"');
}
$a_list = array();
foreach ($addresses as $addr) {
    if (!empty($addr['email'])) {
        if ($display == 'email') {
            $a_list[] = array('val' => rawurlencode(String::convertCharset($addr['name'], NLS::getCharset(), 'UTF-8')), 'label' => $addr['email']);
        } else {
            $a_list[] = array('val' => rawurlencode(String::convertCharset($addr['email'], NLS::getCharset(), 'UTF-8')), 'label' => $addr['name']);
        }
    }
}
$template->set('a_list', $a_list);
$template->set('cc', !$to_only);
$template->set('sa', $selected_addresses);
$template->set('name_selected', ($display == 'name'));
$template->set('email_selected', ($display == 'email'));

/* Display the form. */
$title = _("Address Book");
Horde::addScriptFile('prototype.js', 'imp', true);
Horde::addScriptFile('contacts.js', 'imp', true);
require IMP_TEMPLATES . '/common-header.inc';
IMP::addInlineScript(array(
    'var display = \'' . $display . '\'',
    'var formname = \'' . $formname . '\'',
    'var to_only = ' . intval($to_only),
));
echo $template->fetch(IMP_TEMPLATES . '/contacts/contacts.html');
require $registry->get('templates', 'horde') . '/common-footer.inc';
