#ifndef KP_KIO_H
#define KP_KIO_H


#include <vector>

#include <qobject.h>
#include <qfile.h>
#include <qtextstream.h>
#include "../config.h"
#include <kio/job.h>

class Kio: public QObject
{
  Q_OBJECT

public:
  Kio();

  bool download(const KURL & from, const QString & to);

private:
  bool worked;

private slots:
  void slotIOJobFinished( KIO::Job *job );
};

class Kiod: public QObject
{
  Q_OBJECT

public:
  Kiod();

  bool listDir(QString url, QString fname);

private:
  QFile *file;
  QTextStream *fileT;
  bool worked;

private slots:
  void slotListEntries( KIO::Job *, const KIO::UDSEntryList&  );
  void slotFinished( KIO::Job *);
};
#endif
