/* kasprefsdlg.cpp
**
** Copyright (C) 2001-2004 Richard Moore <rich@kde.org>
** Contributor: Mosfet
**     All rights reserved.
**
** KasBar is dual-licensed: you can choose the GPL or the BSD license.
** Short forms of both licenses are included below.
*/

/*
** This program is free software; you can redistribute it and/or modify
** it under the terms of the GNU General Public License as published by
** the Free Software Foundation; either version 2 of the License, or
** (at your option) any later version.
**
** This program is distributed in the hope that it will be useful,
** but WITHOUT ANY WARRANTY; without even the implied warranty of
** MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the
** GNU General Public License for more details.
**
** You should have received a copy of the GNU General Public License
** along with this program in a file called COPYING; if not, write to
** the Free Software Foundation, Inc., 59 Temple Place, Suite 330, Boston,
** MA 02111-1307, USA.
*/

/*
** Redistribution and use in source and binary forms, with or without
** modification, are permitted provided that the following conditions
** are met:
** 1. Redistributions of source code must retain the above copyright
**    notice, this list of conditions and the following disclaimer.
** 2. Redistributions in binary form must reproduce the above copyright
**    notice, this list of conditions and the following disclaimer in the
**    documentation and/or other materials provided with the distribution.
**
** THIS SOFTWARE IS PROVIDED BY THE AUTHORS AND CONTRIBUTORS ``AS IS'' AND
** ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE
** IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE
** ARE DISCLAIMED.  IN NO EVENT SHALL THE REGENTS OR CONTRIBUTORS BE LIABLE
** FOR ANY DIRECT, INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR CONSEQUENTIAL
** DAMAGES (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS
** OR SERVICES; LOSS OF USE, DATA, OR PROFITS; OR BUSINESS INTERRUPTION)
** HOWEVER CAUSED AND ON ANY THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT
** LIABILITY, OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY
** OUT OF THE USE OF THIS SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF
** SUCH DAMAGE.
*/

/*
** Bug reports and questions can be sent to kde-devel@kde.org
*/

#include <qgrid.h>
#include <qvbox.h>
#include <qcombobox.h>
#include <qcheckbox.h>
#include <qlabel.h>
#include <qslider.h>
#include <qspinbox.h>
#include <qwhatsthis.h>

#include <kdialogbase.h>
#include <kcolorbutton.h>
#include <klocale.h>
#include <kconfig.h>
#include <knuminput.h>
#include <kglobal.h>
#include <kiconloader.h>

#include "kastasker.h"
#include "kasprefsdlg.h"

#define Icon(x) KGlobal::instance()->iconLoader()->loadIcon( x, KIcon::NoGroup, KIcon::SizeMedium )


KasPrefsDialog::KasPrefsDialog( KasTasker *kas )
   : KDialogBase( KDialogBase::IconList, i18n("Kasbar Preferences"),
		  KDialogBase::Ok | KDialogBase::Cancel,
		  KDialogBase::Ok,
		  kas, "kasbarPrefsDialog", /*true*/false ),
     kasbar( kas )
{
   addLookPage();
   addThumbsPage();
   addBehavePage();
   addColorsPage();

   resize( 410, 310 );
}

KasPrefsDialog::~KasPrefsDialog()
{

}

void KasPrefsDialog::addLookPage()
{
   QVBox *lookPage = addVBoxPage( i18n("Appearance"), QString::null, Icon( "appearance" ) );

   QHBox *itemSizeBox = new QHBox( lookPage );
   QWhatsThis::add( itemSizeBox,
		    i18n( "Specifies the size of the task items." ) );

   QLabel *itemSizeLabel = new QLabel( i18n("Si&ze:"), itemSizeBox );

   itemSizeCombo = new QComboBox( itemSizeBox );
   itemSizeCombo->insertItem( i18n( "Large" ) );
   itemSizeCombo->insertItem( i18n( "Medium" ) );
   itemSizeCombo->insertItem( i18n( "Small" ) );
   itemSizeCombo->setCurrentItem( kasbar->itemSize() );

   connect( itemSizeCombo, SIGNAL( activated( int ) ),
	    kasbar, SLOT( setItemSize( int ) ) );
   itemSizeLabel->setBuddy( itemSizeCombo );

   transCheck = new QCheckBox( i18n("Trans&parent"), lookPage );
   QWhatsThis::add( transCheck, i18n( "Enables pseudo-transparent mode." ) );
   transCheck->setChecked( kasbar->isTransparent() );
   connect( transCheck, SIGNAL( toggled(bool) ), kasbar, SLOT( setTransparent(bool) ) );

   tintCheck = new QCheckBox( i18n("Enable t&int"), lookPage );
   QWhatsThis::add( tintCheck,
		    i18n( "Enables tinting the background that shows through in transparent mode." ) );
   tintCheck->setChecked( kasbar->hasTint() );
   connect( tintCheck, SIGNAL( toggled(bool) ), kasbar, SLOT( setTint(bool) ) );

   QHBox *tintColBox = new QHBox( lookPage );
   QWhatsThis::add( tintColBox,
		    i18n( "Specifies the color used for the background tint." ) );
   connect( tintCheck, SIGNAL( toggled(bool) ), tintColBox, SLOT( setEnabled(bool) ) );
   tintColBox->setEnabled( kasbar->hasTint() );

   QLabel *tintLabel = new QLabel( i18n("Tint &color:"), tintColBox );

   tintButton = new KColorButton( kasbar->tintColor(), tintColBox );
   connect( tintButton, SIGNAL( changed( const QColor & ) ),
	    kasbar, SLOT( setTintColor( const QColor & ) ) );
   tintLabel->setBuddy( tintButton );

   QHBox *tintAmtBox = new QHBox( lookPage );
   QWhatsThis::add( tintAmtBox,
		    i18n( "Specifies the strength of the background tint." ) );
   connect( tintCheck, SIGNAL( toggled(bool) ), tintAmtBox, SLOT( setEnabled(bool) ) );
   tintAmtBox->setEnabled( kasbar->hasTint() );

   QLabel *tintStrengthLabel = new QLabel( i18n("Tint &strength: "), tintAmtBox );

   int percent = (int) (kasbar->tintAmount() * 100.0);
   tintAmount = new QSlider( 0, 100, 1, percent, Horizontal, tintAmtBox );
   tintAmount->setTracking( true );
   connect( tintAmount, SIGNAL( valueChanged( int ) ),
	    kasbar, SLOT( setTintAmount( int ) ) );
   tintStrengthLabel->setBuddy( tintAmount );

   new QWidget( lookPage, "spacer" );
}

void KasPrefsDialog::addThumbsPage()
{
   QVBox *thumbsPage = addVBoxPage( i18n("Thumbnails"), QString::null, Icon( "icons" ) );

   thumbsCheck = new QCheckBox( i18n("Enable thu&mbnails"), thumbsPage );
   QWhatsThis::add( thumbsCheck,
		    i18n( "Enables the display of a thumbnailed image of the window when "
			  "you move your mouse pointer over an item. The thumbnails are "
			  "approximate, and may not reflect the current window contents.\n\n"
			  "Using this option on a slow machine may cause performance problems." ) );
   thumbsCheck->setChecked( kasbar->thumbnailsEnabled() );
   connect( thumbsCheck, SIGNAL( toggled(bool) ), kasbar, SLOT( setThumbnailsEnabled(bool) ) );

   QHBox *thumbSizeBox = new QHBox( thumbsPage );
   QWhatsThis::add( thumbSizeBox,
		    i18n( "Controls the size of the window thumbnails. Using large sizes may "
			  "cause performance problems." ) );
   QLabel *thumbSizeLabel = new QLabel( i18n("Thumbnail &size: "), thumbSizeBox );
   int percent = (int) (kasbar->thumbnailSize() * 100.0);
   thumbSizeSlider = new QSlider( 0, 100, 1, percent, Horizontal, thumbSizeBox );
   connect( thumbSizeSlider, SIGNAL( valueChanged( int ) ),
	    kasbar, SLOT( setThumbnailSize( int ) ) );
   thumbSizeLabel->setBuddy( thumbSizeSlider );

   QHBox *thumbUpdateBox = new QHBox( thumbsPage );
   thumbUpdateBox->setSpacing( spacingHint() );
   QWhatsThis::add( thumbUpdateBox,
		    i18n( "Controls the frequency with which the thumbnail of the active window "
			  "is updated. If the value is 0 then no updates will be performed.\n\n"
			  "Using small values may cause performance problems on slow machines." ) );
   QLabel *thumbUpdateLabel = new QLabel( i18n("&Update thumbnail every: "), thumbUpdateBox );
   thumbUpdateSpin = new QSpinBox( 0, 1000, 1, thumbUpdateBox );
   thumbUpdateSpin->setValue( kasbar->thumbnailUpdateDelay() );
   connect( thumbUpdateSpin, SIGNAL( valueChanged( int ) ),
   	    kasbar, SLOT( setThumbnailUpdateDelay( int ) ) );
   new QLabel( i18n("seconds"), thumbUpdateBox );
   thumbUpdateLabel->setBuddy( thumbUpdateSpin );

   new QWidget( thumbsPage, "spacer" );
}

void KasPrefsDialog::addBehavePage()
{
   QVBox *behavePage = addVBoxPage( i18n("Behavior"), QString::null, Icon( "window_list" ) );

   notifierCheck = new QCheckBox( i18n("Enable &startup notifier"), behavePage );
   QWhatsThis::add( notifierCheck,
		    i18n( "Enables the display of tasks that are starting but have not yet "
			  "created a window." ) );
   notifierCheck->setChecked( kasbar->notifierEnabled() );
   connect( notifierCheck, SIGNAL( toggled(bool) ), kasbar, SLOT( setNotifierEnabled(bool) ) );

   modifiedCheck = new QCheckBox( i18n("Enable &modified indicator"), behavePage );
   QWhatsThis::add( modifiedCheck,
		    i18n( "Enables the display of a floppy disk state icon for windows containing "
			  "a modified document." ) );
   modifiedCheck->setChecked( kasbar->showModified() );
   connect( modifiedCheck, SIGNAL( toggled(bool) ), kasbar, SLOT( setShowModified(bool) ) );

   progressCheck = new QCheckBox( i18n("Enable &progress indicator"), behavePage );
   QWhatsThis::add( progressCheck,
		    i18n( "Enables the display of a progress bar in the label of windows that "
			  "are progress indicators." ) );
   progressCheck->setChecked( kasbar->showProgress() );
   connect( progressCheck, SIGNAL( toggled(bool) ), kasbar, SLOT( setShowProgress(bool) ) );

   showAllWindowsCheck = new QCheckBox( i18n("Show all &windows"), behavePage );
   QWhatsThis::add( showAllWindowsCheck,
		    i18n( "Enables the display of all windows, not just those on the current desktop." ) );
   showAllWindowsCheck->setChecked( kasbar->showAllWindows() );
   connect( showAllWindowsCheck, SIGNAL( toggled(bool) ), kasbar, SLOT( setShowAllWindows(bool) ) );

   groupWindowsCheck = new QCheckBox( i18n("&Group windows"), behavePage );
   QWhatsThis::add( groupWindowsCheck,
		    i18n( "Enables the grouping together of related windows." ) );
   groupWindowsCheck->setChecked( kasbar->groupWindows() );
   connect( groupWindowsCheck, SIGNAL( toggled(bool) ),
	    kasbar, SLOT( setGroupWindows(bool) ) );

   QHBox *maxBoxesBox = new QHBox( behavePage );
   QWhatsThis::add( maxBoxesBox,
		    i18n( "Specifies the maximum number of items that should be placed in a line "
			  "before starting a new row or column. If the value is 0 then all the "
			  "available space will be used." ) );
   QLabel *maxBoxesLabel = new QLabel( i18n("Ma&x boxes: "), maxBoxesBox );

   KConfig *conf = kasbar->config();
   if ( conf )
       conf->setGroup( "Layout" );
   maxBoxesSpin = new KIntSpinBox( 0, 50, 1,
				   conf ? conf->readNumEntry( "MaxBoxes", 0 ) : 11,
				   10,
				   maxBoxesBox, "maxboxes" );
   connect( maxBoxesSpin, SIGNAL( valueChanged( int ) ), kasbar, SLOT( setMaxBoxes( int ) ) );
   maxBoxesLabel->setBuddy( maxBoxesSpin );

   new QWidget( behavePage, "spacer" );
}

void KasPrefsDialog::addColorsPage()
{
   QVBox *colorsPage = addVBoxPage( i18n("Colors"), QString::null, Icon( "colors" ) );
   QGrid *grid = new QGrid( 2, colorsPage );

   // Item label colors
   QLabel *labelPenLabel = new QLabel( i18n("Label &pen:"), grid );
   labelPenButton = new KColorButton( kasbar->labelPenColor(), grid );
   connect( labelPenButton, SIGNAL( changed( const QColor & ) ),
	    kasbar, SLOT( setLabelPenColor( const QColor & ) ) );
   labelPenLabel->setBuddy( labelPenButton );

   QLabel *labelBackgroundLabel = new QLabel( i18n("Label &background:"), grid );
   labelBackgroundButton = new KColorButton( kasbar->labelBgColor(), grid );
   connect( labelBackgroundButton, SIGNAL( changed( const QColor & ) ),
	    kasbar, SLOT( setLabelBgColor( const QColor & ) ) );
   labelBackgroundLabel->setBuddy( labelBackgroundButton );

   QLabel *progressLabel = new QLabel( i18n("&Progress indicator:"), grid );
   progressButton = new KColorButton( kasbar->progressColor(), grid );
   connect( progressButton, SIGNAL( changed( const QColor & ) ),
	    kasbar, SLOT( setProgressColor( const QColor & ) ) );
   progressLabel->setBuddy( progressButton );

   new QWidget( colorsPage, "spacer" );
}

void KasPrefsDialog::accept()
{
   QDialog::accept();

   KConfig *conf = kasbar->config();
   if ( !conf )
      return;

   conf->setGroup("Appearance");
   conf->writeEntry( "ItemSize", kasbar->itemSize() );
   conf->writeEntry( "Transparent", kasbar->isTransparent() );
   conf->writeEntry( "EnableTint", kasbar->hasTint() );
   conf->writeEntry( "TintColor", kasbar->tintColor() );
   conf->writeEntry( "TintAmount", kasbar->tintAmount() );

   conf->setGroup("Colors");
   conf->writeEntry( "LabelPenColor", kasbar->labelPenColor() );
   conf->writeEntry( "LabelBgColor", kasbar->labelBgColor() );
   conf->writeEntry( "InactivePenColor", kasbar->inactivePenColor() );
   conf->writeEntry( "InactiveBgColor", kasbar->inactiveBgColor() );
   conf->writeEntry( "ActivePenColor", kasbar->activePenColor() );
   conf->writeEntry( "ActiveBgColor", kasbar->activeBgColor() );
   conf->writeEntry( "ProgressColor", kasbar->progressColor() );

   conf->setGroup("Thumbnails");
   conf->writeEntry( "Thumbnails", kasbar->thumbnailsEnabled() );
   conf->writeEntry( "ThumbnailSize", kasbar->thumbnailSize() );
   conf->writeEntry( "ThumbnailUpdateDelay", kasbar->thumbnailUpdateDelay() );

   conf->setGroup("Behaviour");
   conf->writeEntry( "StartupNotifier", kasbar->notifierEnabled() );
   conf->writeEntry( "ModifiedIndicator", kasbar->showModified() );
   conf->writeEntry( "ProgressIndicator", kasbar->showProgress() );
   conf->writeEntry( "ShowAllWindows", kasbar->showAllWindows() );
   conf->writeEntry( "GroupWindows", kasbar->groupWindows() );

   conf->setGroup("Layout");
   conf->writeEntry( "MaxBoxes", maxBoxesSpin->value() );

   conf->sync();
}

#include "kasprefsdlg.moc"
