/* ****************************************************************************
  This file is part of KBabel

  Copyright (C) 2000 by Matthias Kiefer
                            <matthias.kiefer@gmx.de>

  This program is free software; you can redistribute it and/or modify
  it under the terms of the GNU General Public License as published by
  the Free Software Foundation; either version 2 of the License, or
  (at your option) any later version.

  This program is distributed in the hope that it will be useful,
  but WITHOUT ANY WARRANTY; without even the implied warranty of
  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
  GNU General Public License for more details.

  You should have received a copy of the GNU General Public License
  along with this program; if not, write to the Free Software
  Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.

**************************************************************************** */
#include <qcheckbox.h>
#include <qlabel.h>
#include <qlayout.h>

#include <kfiledialog.h>
#include <qpushbutton.h>
#include <klineedit.h>
#include <klocale.h>
#include <kurlrequester.h>

#include "preferenceswidget.h"
#include "pwidget.h"

PreferencesWidget::PreferencesWidget(QWidget *parent, const char* name)
        : PrefWidget(parent,name)
        , changed(false)
{
    QVBoxLayout *layout = new QVBoxLayout(this);
        
    prefWidget = new PWidget(this);
    layout->addWidget(prefWidget);


    connect(prefWidget->urlInput->lineEdit(),SIGNAL(textChanged(const QString&))
                    , this, SLOT(setChanged()));
}

PreferencesWidget::~PreferencesWidget()
{
}


void PreferencesWidget::apply()
{
    emit applySettings();
}

void PreferencesWidget::cancel()
{
    emit restoreSettings();
}

void PreferencesWidget::standard()
{
    prefWidget->urlInput->setURL("@PACKAGE@.po");
    changed=true;
}

void PreferencesWidget::setURL(const QString url)
{
    prefWidget->urlInput->setURL(url);
    changed=false;
}

QString PreferencesWidget::url()
{
    changed = false;
    return prefWidget->urlInput->url();
}

bool PreferencesWidget::ignoreFuzzy()
{
    changed=false;
    return prefWidget->fuzzyBtn->isChecked();
}

void PreferencesWidget::setIgnoreFuzzy(bool flag)
{
    prefWidget->fuzzyBtn->setChecked(flag);
}

bool PreferencesWidget::settingsChanged() const
{
    return changed;
}

void PreferencesWidget::setChanged()
{
    changed=true;
}


#include "preferenceswidget.moc"
