/* ****************************************************************************
  This file is part of KBabel

  Copyright (C) 1999-2000 by Matthias Kiefer
                            <matthias.kiefer@gmx.de>

  This program is free software; you can redistribute it and/or modify
  it under the terms of the GNU General Public License as published by
  the Free Software Foundation; either version 2 of the License, or
  (at your option) any later version.

  This program is distributed in the hope that it will be useful,
  but WITHOUT ANY WARRANTY; without even the implied warranty of
  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
  GNU General Public License for more details.

  You should have received a copy of the GNU General Public License
  along with this program; if not, write to the Free Software
  Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.

**************************************************************************** */

#include "kbcatalog.h"
#include "kbabelview.h"
#include "headereditor.h"
#include "editcmd.h"


KBCatalog::KBCatalog(QObject* parent, const char* name) 
         : Catalog(parent,name)
{
   _headerEditor=0;
}


KBCatalog::~KBCatalog()
{
   if(_headerEditor)
      delete _headerEditor;
}

HeaderEditor* KBCatalog::headerEditor()
{
   if(!_headerEditor)
   {
      _headerEditor = new HeaderEditor(this,"_headerEditor");
   }

   return _headerEditor;
}



#include "kbcatalog.moc"
