%{

#include <qstring.h>
#include <stdlib.h>
#include <iostream.h>
#include <stdio.h>
#include "catalogitem.h"
#include <unistd.h>

#define YYERROR_VERBOSE

extern int yylex();
extern int lineno;

void yyerror( const char *s )
{
        qDebug( "%s in line %d", s, lineno);
        exit(1);
}

%}

%union
{
  QCString *str;
  CatalogItem *item;
}

%token <str> T_COMMENT
%token <str> T_STRING
%token T_MSGID
%token T_MSGSTR

%type <str> string
%type <str> msgid
%type <str> msgstr
%type <str> comment
%type <item> block
%%

main : main block final_comment {
		qDebug(($2)->msgstr().latin1());
		delete $2; // I remove it here	
	}
	| /* empty */

final_comment : comment {  }

block : comment msgid msgstr {
		$$ = new CatalogItem(($2)->data(), ($3)->data(), ($1)->data());
		delete $1;
		delete $2;
		delete $3;
	}

comment
	: T_COMMENT comment { $$ = new QCString(*($1) + *($2));
  	  delete $1;
	  delete $2;
	}
	| /* empty */ { $$ = new QCString(""); }

msgid
	: T_MSGID string {
		$$ = $2;
	}

msgstr : T_MSGSTR string {
		$$ = $2;
	/*
		QString tmp = *($2);
		int i;
		while ((i = tmp.find('&')) != -1)
			tmp.replace(i, 1, " ");
		while ((i = tmp.find("\\n")) != -1)
			tmp.replace(i, 2, " ");
		if (tmp.left(8) == "Comment=")
		  tmp = tmp.mid(8);
		if (tmp.left(5) == "Name=")
		  tmp = tmp.mid(5);
		cerr << tmp.ascii() << endl;
	*/
	}

string : T_STRING string {
		$$ = new QCString(*($1) + *($2));
		delete $1;
		delete $2;
	}
       | /* none */ { $$ = new QCString(""); }

%%

