/*
 * Decompiled with CFR 0.152.
 */
package com.jcraft.jorbis;

import com.jcraft.jogg.Buffer;
import com.jcraft.jorbis.Block;
import com.jcraft.jorbis.CodeBook;
import com.jcraft.jorbis.DspState;
import com.jcraft.jorbis.FuncResidue;
import com.jcraft.jorbis.Info;
import com.jcraft.jorbis.InfoMode;
import com.jcraft.jorbis.InfoResidue0;
import com.jcraft.jorbis.LookResidue0;

class Residue0
extends FuncResidue {
    static int[][][] partword = new int[2][][];

    Residue0() {
    }

    void pack(Object object, Buffer buffer) {
        int n;
        InfoResidue0 infoResidue0 = (InfoResidue0)object;
        int n2 = 0;
        buffer.write(infoResidue0.begin, 24);
        buffer.write(infoResidue0.end, 24);
        buffer.write(infoResidue0.grouping - 1, 24);
        buffer.write(infoResidue0.partitions - 1, 6);
        buffer.write(infoResidue0.groupbook, 8);
        for (n = 0; n < infoResidue0.partitions; ++n) {
            if (Residue0.ilog(infoResidue0.secondstages[n]) > 3) {
                buffer.write(infoResidue0.secondstages[n], 3);
                buffer.write(1, 1);
                buffer.write(infoResidue0.secondstages[n] >>> 3, 5);
            } else {
                buffer.write(infoResidue0.secondstages[n], 4);
            }
            n2 += Residue0.icount(infoResidue0.secondstages[n]);
        }
        for (n = 0; n < n2; ++n) {
            buffer.write(infoResidue0.booklist[n], 8);
        }
    }

    Object unpack(Info info, Buffer buffer) {
        int n;
        int n2 = 0;
        InfoResidue0 infoResidue0 = new InfoResidue0();
        infoResidue0.begin = buffer.read(24);
        infoResidue0.end = buffer.read(24);
        infoResidue0.grouping = buffer.read(24) + 1;
        infoResidue0.partitions = buffer.read(6) + 1;
        infoResidue0.groupbook = buffer.read(8);
        for (n = 0; n < infoResidue0.partitions; ++n) {
            int n3 = buffer.read(3);
            if (buffer.read(1) != 0) {
                n3 |= buffer.read(5) << 3;
            }
            infoResidue0.secondstages[n] = n3;
            n2 += Residue0.icount(n3);
        }
        for (n = 0; n < n2; ++n) {
            infoResidue0.booklist[n] = buffer.read(8);
        }
        if (infoResidue0.groupbook >= info.books) {
            this.free_info(infoResidue0);
            return null;
        }
        for (n = 0; n < n2; ++n) {
            if (infoResidue0.booklist[n] < info.books) continue;
            this.free_info(infoResidue0);
            return null;
        }
        return infoResidue0;
    }

    Object look(DspState dspState, InfoMode infoMode, Object object) {
        int n;
        int n2;
        int n3;
        InfoResidue0 infoResidue0 = (InfoResidue0)object;
        LookResidue0 lookResidue0 = new LookResidue0();
        int n4 = 0;
        int n5 = 0;
        lookResidue0.info = infoResidue0;
        lookResidue0.map = infoMode.mapping;
        lookResidue0.parts = infoResidue0.partitions;
        lookResidue0.fullbooks = dspState.fullbooks;
        lookResidue0.phrasebook = dspState.fullbooks[infoResidue0.groupbook];
        int n6 = lookResidue0.phrasebook.dim;
        lookResidue0.partbooks = new int[lookResidue0.parts][];
        for (n3 = 0; n3 < lookResidue0.parts; ++n3) {
            n2 = Residue0.ilog(infoResidue0.secondstages[n3]);
            if (n2 == 0) continue;
            if (n2 > n5) {
                n5 = n2;
            }
            lookResidue0.partbooks[n3] = new int[n2];
            for (n = 0; n < n2; ++n) {
                if ((infoResidue0.secondstages[n3] & 1 << n) == 0) continue;
                lookResidue0.partbooks[n3][n] = infoResidue0.booklist[n4++];
            }
        }
        lookResidue0.partvals = (int)Math.rint(Math.pow(lookResidue0.parts, n6));
        lookResidue0.stages = n5;
        lookResidue0.decodemap = new int[lookResidue0.partvals][];
        for (n3 = 0; n3 < lookResidue0.partvals; ++n3) {
            n2 = n3;
            n = lookResidue0.partvals / lookResidue0.parts;
            lookResidue0.decodemap[n3] = new int[n6];
            for (int i = 0; i < n6; ++i) {
                int n7 = n2 / n;
                n2 -= n7 * n;
                n /= lookResidue0.parts;
                lookResidue0.decodemap[n3][i] = n7;
            }
        }
        return lookResidue0;
    }

    void free_info(Object object) {
    }

    void free_look(Object object) {
    }

    int forward(Block block, Object object, float[][] fArray, int n) {
        System.err.println("Residue0.forward: not implemented");
        return 0;
    }

    static synchronized int _01inverse(Block block, Object object, float[][] fArray, int n, int n2) {
        int n3;
        LookResidue0 lookResidue0 = (LookResidue0)object;
        InfoResidue0 infoResidue0 = lookResidue0.info;
        int n4 = infoResidue0.grouping;
        int n5 = lookResidue0.phrasebook.dim;
        int n6 = infoResidue0.end - infoResidue0.begin;
        int n7 = n6 / n4;
        int n8 = (n7 + n5 - 1) / n5;
        if (partword.length < n) {
            partword = new int[n][][];
            for (n3 = 0; n3 < n; ++n3) {
                Residue0.partword[n3] = new int[n8][];
            }
        } else {
            for (n3 = 0; n3 < n; ++n3) {
                if (partword[n3] != null && partword[n3].length >= n8) continue;
                Residue0.partword[n3] = new int[n8][];
            }
        }
        for (int i = 0; i < lookResidue0.stages; ++i) {
            int n9 = 0;
            int n10 = 0;
            while (n9 < n7) {
                int n11;
                if (i == 0) {
                    for (n3 = 0; n3 < n; ++n3) {
                        n11 = lookResidue0.phrasebook.decode(block.opb);
                        if (n11 == -1) {
                            return 0;
                        }
                        Residue0.partword[n3][n10] = lookResidue0.decodemap[n11];
                        if (partword[n3][n10] != null) continue;
                        return 0;
                    }
                }
                for (int j = 0; j < n5 && n9 < n7; ++j, ++n9) {
                    for (n3 = 0; n3 < n; ++n3) {
                        CodeBook codeBook;
                        n11 = infoResidue0.begin + n9 * n4;
                        if ((infoResidue0.secondstages[partword[n3][n10][j]] & 1 << i) == 0 || (codeBook = lookResidue0.fullbooks[lookResidue0.partbooks[partword[n3][n10][j]][i]]) == null || !(n2 == 0 ? codeBook.decodevs_add(fArray[n3], n11, block.opb, n4) == -1 : n2 == 1 && codeBook.decodev_add(fArray[n3], n11, block.opb, n4) == -1)) continue;
                        return 0;
                    }
                }
                ++n10;
            }
        }
        return 0;
    }

    static int _2inverse(Block block, Object object, float[][] fArray, int n) {
        LookResidue0 lookResidue0 = (LookResidue0)object;
        InfoResidue0 infoResidue0 = lookResidue0.info;
        int n2 = infoResidue0.grouping;
        int n3 = lookResidue0.phrasebook.dim;
        int n4 = infoResidue0.end - infoResidue0.begin;
        int n5 = n4 / n2;
        int n6 = (n5 + n3 - 1) / n3;
        int[][] nArrayArray = new int[n6][];
        for (int i = 0; i < lookResidue0.stages; ++i) {
            int n7 = 0;
            int n8 = 0;
            while (n7 < n5) {
                int n9;
                if (i == 0) {
                    n9 = lookResidue0.phrasebook.decode(block.opb);
                    if (n9 == -1) {
                        return 0;
                    }
                    nArrayArray[n8] = lookResidue0.decodemap[n9];
                    if (nArrayArray[n8] == null) {
                        return 0;
                    }
                }
                for (int j = 0; j < n3 && n7 < n5; ++j, ++n7) {
                    CodeBook codeBook;
                    n9 = infoResidue0.begin + n7 * n2;
                    if ((infoResidue0.secondstages[nArrayArray[n8][j]] & 1 << i) == 0 || (codeBook = lookResidue0.fullbooks[lookResidue0.partbooks[nArrayArray[n8][j]][i]]) == null || codeBook.decodevv_add(fArray, n9, n, block.opb, n2) != -1) continue;
                    return 0;
                }
                ++n8;
            }
        }
        return 0;
    }

    int inverse(Block block, Object object, float[][] fArray, int[] nArray, int n) {
        int n2 = 0;
        for (int i = 0; i < n; ++i) {
            if (nArray[i] == 0) continue;
            fArray[n2++] = fArray[i];
        }
        if (n2 != 0) {
            return Residue0._01inverse(block, object, fArray, n2, 0);
        }
        return 0;
    }

    private static int ilog(int n) {
        int n2 = 0;
        while (n != 0) {
            ++n2;
            n >>>= 1;
        }
        return n2;
    }

    private static int icount(int n) {
        int n2 = 0;
        while (n != 0) {
            n2 += n & 1;
            n >>>= 1;
        }
        return n2;
    }
}

