//@ skip

function shouldBe(actual, expected) {
    if (actual !== expected)
        throw new Error('bad value: ' + actual);
}

/*
wasm/relational.wasm is generated by pack-asmjs <https://github.com/WebAssembly/polyfill-prototype-1> from the following script:

function asmModule(global, env, buffer) {
    "use asm";

    var fround = global.Math.fround;

    function equal(x, y) {
        x = x | 0;
        y = y | 0;
        return ((x | 0) == (y | 0)) | 0;
    }

    function notEqual(x, y) {
        x = x | 0;
        y = y | 0;
        return ((x | 0) != (y | 0)) | 0;
    }

    function lessThan(x, y) {
        x = x | 0;
        y = y | 0;
        return ((x | 0) < (y | 0)) | 0;
    }

    function lessThanOrEqual(x, y) {
        x = x | 0;
        y = y | 0;
        return ((x | 0) <= (y | 0)) | 0;
    }

    function greaterThan(x, y) {
        x = x | 0;
        y = y | 0;
        return ((x | 0) > (y | 0)) | 0;
    }

    function greaterThanOrEqual(x, y) {
        x = x | 0;
        y = y | 0;
        return ((x | 0) >= (y | 0)) | 0;
    }

    function unsignedLessThan(x, y) {
        x = x | 0;
        y = y | 0;
        return ((x >>> 0) < (y >>> 0)) | 0;
    }

    function unsignedLessThanOrEqual(x, y) {
        x = x | 0;
        y = y | 0;
        return ((x >>> 0) <= (y >>> 0)) | 0;
    }

    function unsignedGreaterThan(x, y) {
        x = x | 0;
        y = y | 0;
        return ((x >>> 0) > (y >>> 0)) | 0;
    }

    function unsignedGreaterThanOrEqual(x, y) {
        x = x | 0;
        y = y | 0;
        return ((x >>> 0) >= (y >>> 0)) | 0;
    }

    function floatEqual(x, y) {
        x = fround(x);
        y = fround(y);
        return (x == y) | 0;
    }

    function floatNotEqual(x, y) {
        x = fround(x);
        y = fround(y);
        return (x != y) | 0;
    }

    function floatLessThan(x, y) {
        x = fround(x);
        y = fround(y);
        return (x < y) | 0;
    }

    function floatLessThanOrEqual(x, y) {
        x = fround(x);
        y = fround(y);
        return (x <= y) | 0;
    }

    function floatGreaterThan(x, y) {
        x = fround(x);
        y = fround(y);
        return (x > y) | 0;
    }

    function floatGreaterThanOrEqual(x, y) {
        x = fround(x);
        y = fround(y);
        return (x >= y) | 0;
    }

    function doubleEqual(x, y) {
        x = +x;
        y = +y;
        return (x == y) | 0;
    }

    function doubleNotEqual(x, y) {
        x = +x;
        y = +y;
        return (x != y) | 0;
    }

    function doubleLessThan(x, y) {
        x = +x;
        y = +y;
        return (x < y) | 0;
    }

    function doubleLessThanOrEqual(x, y) {
        x = +x;
        y = +y;
        return (x <= y) | 0;
    }

    function doubleGreaterThan(x, y) {
        x = +x;
        y = +y;
        return (x > y) | 0;
    }

    function doubleGreaterThanOrEqual(x, y) {
        x = +x;
        y = +y;
        return (x >= y) | 0;
    }

    return {
        equal: equal,
        notEqual: notEqual,
        lessThan: lessThan,
        lessThanOrEqual: lessThanOrEqual,
        greaterThan: greaterThan,
        greaterThanOrEqual: greaterThanOrEqual,
        unsignedLessThan: unsignedLessThan,
        unsignedLessThanOrEqual: unsignedLessThanOrEqual,
        unsignedGreaterThan: unsignedGreaterThan,
        unsignedGreaterThanOrEqual: unsignedGreaterThanOrEqual,

        floatEqual: floatEqual,
        floatNotEqual: floatNotEqual,
        floatLessThan: floatLessThan,
        floatLessThanOrEqual: floatLessThanOrEqual,
        floatGreaterThan: floatGreaterThan,
        floatGreaterThanOrEqual: floatGreaterThanOrEqual,

        doubleEqual: doubleEqual,
        doubleNotEqual: doubleNotEqual,
        doubleLessThan: doubleLessThan,
        doubleLessThanOrEqual: doubleLessThanOrEqual,
        doubleGreaterThan: doubleGreaterThan,
        doubleGreaterThanOrEqual: doubleGreaterThanOrEqual,
    };
}
*/

var module = loadWebAssembly("wasm/relational.wasm");

shouldBe(module.equal(1, 1), 1);
shouldBe(module.equal(1, 2), 0);
shouldBe(module.notEqual(1, 2), 1);
shouldBe(module.notEqual(1, 1), 0);
shouldBe(module.lessThan(-1, 2), 1);
shouldBe(module.lessThan(1, 1), 0);
shouldBe(module.lessThanOrEqual(1, 1), 1);
shouldBe(module.lessThanOrEqual(2, 1), 0);
shouldBe(module.greaterThan(2, -1), 1);
shouldBe(module.greaterThan(1, 1), 0);
shouldBe(module.greaterThanOrEqual(1, 1), 1);
shouldBe(module.greaterThanOrEqual(1, 2), 0);
shouldBe(module.unsignedLessThan(2, -1), 1);
shouldBe(module.unsignedLessThan(-1, 2), 0);
shouldBe(module.unsignedLessThanOrEqual(2, -1), 1);
shouldBe(module.unsignedLessThanOrEqual(-1, 2), 0);
shouldBe(module.unsignedGreaterThan(-1, 2), 1);
shouldBe(module.unsignedGreaterThan(2, -1), 0);
shouldBe(module.unsignedGreaterThanOrEqual(-1, 2), 1);
shouldBe(module.unsignedGreaterThanOrEqual(2, -1), 0);

shouldBe(module.floatEqual(0.1, 0.1), 1);
shouldBe(module.floatEqual(0.1, 0.2), 0);
shouldBe(module.floatNotEqual(0.1, 0.2), 1);
shouldBe(module.floatNotEqual(0.1, 0.1), 0);
shouldBe(module.floatLessThan(-0.1, 0.2), 1);
shouldBe(module.floatLessThan(0.1, 0.1), 0);
shouldBe(module.floatLessThanOrEqual(0.1, 0.1), 1);
shouldBe(module.floatLessThanOrEqual(0.2, 0.1), 0);
shouldBe(module.floatGreaterThan(0.2, -0.1), 1);
shouldBe(module.floatGreaterThan(0.1, 0.1), 0);
shouldBe(module.floatGreaterThanOrEqual(0.1, 0.1), 1);
shouldBe(module.floatGreaterThanOrEqual(0.1, 0.2), 0);
shouldBe(module.floatEqual(NaN, NaN), 0);
shouldBe(module.floatNotEqual(NaN, NaN), 0);
shouldBe(module.floatNotEqual(NaN, 0.1), 0);
shouldBe(module.floatGreaterThan(NaN, 0.1), 0);
shouldBe(module.floatLessThan(NaN, 0.1), 0);
shouldBe(module.floatEqual(Infinity, Infinity), 1);
shouldBe(module.floatGreaterThan(Infinity, 0.1), 1);
shouldBe(module.floatGreaterThan(Infinity, NaN), 0);
shouldBe(module.floatLessThan(Infinity, NaN), 0);

shouldBe(module.doubleEqual(0.1, 0.1), 1);
shouldBe(module.doubleEqual(0.1, 0.2), 0);
shouldBe(module.doubleNotEqual(0.1, 0.2), 1);
shouldBe(module.doubleNotEqual(0.1, 0.1), 0);
shouldBe(module.doubleLessThan(-0.1, 0.2), 1);
shouldBe(module.doubleLessThan(0.1, 0.1), 0);
shouldBe(module.doubleLessThanOrEqual(0.1, 0.1), 1);
shouldBe(module.doubleLessThanOrEqual(0.2, 0.1), 0);
shouldBe(module.doubleGreaterThan(0.2, -0.1), 1);
shouldBe(module.doubleGreaterThan(0.1, 0.1), 0);
shouldBe(module.doubleGreaterThanOrEqual(0.1, 0.1), 1);
shouldBe(module.doubleGreaterThanOrEqual(0.1, 0.2), 0);
shouldBe(module.doubleEqual(NaN, NaN), 0);
shouldBe(module.doubleNotEqual(NaN, NaN), 0);
shouldBe(module.doubleNotEqual(NaN, 0.1), 0);
shouldBe(module.doubleGreaterThan(NaN, 0.1), 0);
shouldBe(module.doubleLessThan(NaN, 0.1), 0);
shouldBe(module.doubleEqual(Infinity, Infinity), 1);
shouldBe(module.doubleGreaterThan(Infinity, 0.1), 1);
shouldBe(module.doubleGreaterThan(Infinity, NaN), 0);
shouldBe(module.doubleLessThan(Infinity, NaN), 0);
