/*
 * Decompiled with CFR 0.152.
 */
package org.openide.explorer.propertysheet.editors;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.GridLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.beans.PropertyChangeSupport;
import javax.swing.DefaultComboBoxModel;
import javax.swing.JCheckBox;
import javax.swing.JComboBox;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.border.CompoundBorder;
import javax.swing.border.EmptyBorder;
import javax.swing.border.TitledBorder;
import org.openide.explorer.propertysheet.editors.ModifierEditor;
import org.openide.util.NbBundle;
import org.openide.util.WeakListener;

class ModifierPanel
extends JPanel {
    public static final String PROP_MASK = "mask";
    public static final String PROP_MODIFIER = "modifier";
    private static final int CHECK_ABSTRACT = 0;
    private static final int CHECK_FINAL = 1;
    private static final int CHECK_STATIC = 2;
    private static final int CHECK_SYNCHRONIZED = 3;
    private static final int CHECK_TRANSIENT = 4;
    private static final int CHECK_VOLATILE = 5;
    private static final int CHECK_NATIVE = 6;
    static final String[] MODIFIER_NAMES = new String[]{"abstract", "final", "static", "synchronized", "transient", "volatile", "native"};
    private static final String[] MODIFIER_DESCRIPTION_KEYS = new String[]{"ACSD_ModifierPanel_Modifier_Abstract", "ACSD_ModifierPanel_Modifier_Final", "ACSD_ModifierPanel_Modifier_Static", "ACSD_ModifierPanel_Modifier_Synchronized", "ACSD_ModifierPanel_Modifier_Transient", "ACSD_ModifierPanel_Modifier_Volatile", "ACSD_ModifierPanel_Modifier_Native"};
    private static final String[] MODIFIER_MNEMONICS_KEYS = new String[]{"ModifierPanel_Modifier_Abstract_Mnemonic", "ModifierPanel_Modifier_Final_Mnemonic", "ModifierPanel_Modifier_Static_Mnemonic", "ModifierPanel_Modifier_Synchronized_Mnemonic", "ModifierPanel_Modifier_Transient_Mnemonic", "ModifierPanel_Modifier_Volatile_Mnemonic", "ModifierPanel_Modifier_Native_Mnemonic"};
    static final int[] MODIFIER_VALUES = new int[]{1024, 16, 8, 32, 128, 64, 256};
    static final int MODIFIER_COUNT = MODIFIER_VALUES.length;
    static final String[] ACCESS_NAMES = new String[]{"<default>", "private", "protected", "public"};
    static final int[] ACCESS_VALUES = new int[]{0, 2, 4, 1};
    static final int ACCESS_MASK = 7;
    static final int EDITABLE_MASK = 1535;
    private ModifierEditor myEditor;
    private int[] currentAccessValues;
    private String[] currentAccessNames;
    private JCheckBox[] checks;
    private ActionListener listener;
    private boolean ignored = false;
    private PropertyChangeSupport propertyChangeSupport;
    static final long serialVersionUID = 6884758007403225916L;
    private JComboBox accessCombo;
    private JPanel modifPanel;
    private JLabel jLabel1;
    private JPanel jPanel2;
    static /* synthetic */ Class class$org$openide$explorer$propertysheet$editors$ModifierPanel;

    public ModifierPanel(ModifierEditor modifierEditor) {
        this.myEditor = modifierEditor;
        this.currentAccessValues = ACCESS_VALUES;
        this.currentAccessNames = ACCESS_NAMES;
        this.myEditor.addPropertyChangeListener(WeakListener.propertyChange(new PropertyChangeListener(){

            public void propertyChange(PropertyChangeEvent propertyChangeEvent) {
                if (ModifierPanel.PROP_MODIFIER.equals(propertyChangeEvent.getPropertyName()) || ModifierPanel.PROP_MASK.equals(propertyChangeEvent.getPropertyName())) {
                    ModifierPanel.this.updateAccess();
                    ModifierPanel.this.ignored = true;
                    ModifierPanel.this.updateComponents();
                    ModifierPanel.this.ignored = false;
                }
            }
        }, this.myEditor));
        this.listener = new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                int n = ModifierPanel.this.accessCombo.getSelectedIndex();
                if (actionEvent.getSource() == ModifierPanel.this.accessCombo && n < 0) {
                    return;
                }
                if (ModifierPanel.this.checks[0].isSelected() && (ModifierPanel.this.myEditor.getModifier() & MODIFIER_VALUES[0]) == 0 && (ModifierPanel.this.myEditor.getModifier() & 2) > 0) {
                    ModifierPanel.this.checks[0].setSelected(false);
                }
                if (n >= 0 && (ModifierPanel.this.currentAccessValues[ModifierPanel.this.accessCombo.getSelectedIndex()] & 2) > 0 && (ModifierPanel.this.myEditor.getModifier() & 2) == 0) {
                    ModifierPanel.this.checks[0].setSelected(false);
                }
                ModifierPanel.this.excludeChecks(0, 1);
                ModifierPanel.this.excludeChecks(0, 6);
                ModifierPanel.this.excludeChecks(0, 2);
                ModifierPanel.this.excludeChecks(0, 3);
                ModifierPanel.this.excludeChecks(5, 1);
                if (!ModifierPanel.this.ignored) {
                    ModifierPanel.this.updateValue();
                }
            }
        };
        this.ignored = true;
        this.initComponents();
        this.modifPanel.setBorder(new CompoundBorder(new TitledBorder(ModifierPanel.getString("LAB_Modifiers")), new EmptyBorder(new Insets(3, 3, 3, 3))));
        this.propertyChangeSupport = new PropertyChangeSupport(this);
        this.updateAccess();
        this.updateModifiers();
        this.updateComponents();
        this.ignored = false;
        this.jLabel1.setDisplayedMnemonic(ModifierPanel.getString("LAB_AccessRights_Mnemonic").charAt(0));
        this.jLabel1.getAccessibleContext().setAccessibleDescription(ModifierPanel.getString("ACSD_AccessRights"));
    }

    private void excludeChecks(int n, int n2) {
        if (this.checks[n].isSelected() && (this.myEditor.getModifier() & MODIFIER_VALUES[n]) == 0) {
            this.checks[n2].setSelected(false);
        } else if (this.checks[n2].isSelected() && (this.myEditor.getModifier() & MODIFIER_VALUES[n2]) == 0) {
            this.checks[n].setSelected(false);
        }
    }

    private void initComponents() {
        this.modifPanel = new JPanel();
        this.jPanel2 = new JPanel();
        this.jLabel1 = new JLabel();
        this.accessCombo = new JComboBox();
        this.setLayout(new BorderLayout());
        this.setBorder(new EmptyBorder(new Insets(6, 7, 6, 7)));
        this.modifPanel.setLayout(new GridLayout(4, 2, 4, 4));
        this.checks = new JCheckBox[MODIFIER_COUNT];
        int n = 0;
        while (n < MODIFIER_COUNT) {
            this.checks[n] = new JCheckBox(MODIFIER_NAMES[n]);
            this.checks[n].setMnemonic(ModifierPanel.getModifierMnemonics(n));
            this.checks[n].getAccessibleContext().setAccessibleDescription(ModifierPanel.getModifierDescription(n));
            this.modifPanel.add(this.checks[n]);
            this.checks[n].setEnabled((this.myEditor.getMask() & MODIFIER_VALUES[n]) != 0);
            this.checks[n].addActionListener(this.listener);
            ++n;
        }
        this.add((Component)this.modifPanel, "Center");
        this.jPanel2.setLayout(new BorderLayout(8, 8));
        this.jPanel2.setBorder(new EmptyBorder(new Insets(5, 5, 5, 5)));
        this.jLabel1.setText(ModifierPanel.getString("LAB_AccessRights"));
        this.jLabel1.setLabelFor(this.accessCombo);
        this.jPanel2.add((Component)this.jLabel1, "West");
        this.accessCombo.addActionListener(this.listener);
        this.jPanel2.add((Component)this.accessCombo, "Center");
        this.add((Component)this.jPanel2, "North");
    }

    public void addPropertyChangeListener(PropertyChangeListener propertyChangeListener) {
        this.propertyChangeSupport.addPropertyChangeListener(propertyChangeListener);
    }

    public void removePropertyChangeListener(PropertyChangeListener propertyChangeListener) {
        this.propertyChangeSupport.removePropertyChangeListener(propertyChangeListener);
    }

    private void updateAccess() {
        int n = this.myEditor.getModifier() & 7;
        int n2 = -1;
        int n3 = 1;
        int n4 = 1;
        while (n4 < ACCESS_VALUES.length) {
            if ((ACCESS_VALUES[n4] & this.myEditor.getMask()) != 0) {
                ++n3;
            }
            ++n4;
        }
        this.currentAccessValues = new int[n3];
        this.currentAccessNames = new String[n3];
        this.currentAccessValues[0] = ACCESS_VALUES[0];
        this.currentAccessNames[0] = ACCESS_NAMES[0];
        n3 = 1;
        int n5 = 1;
        while (n5 < ACCESS_VALUES.length) {
            if ((ACCESS_VALUES[n5] & this.myEditor.getMask()) != 0) {
                this.currentAccessValues[n3] = ACCESS_VALUES[n5];
                this.currentAccessNames[n3] = ACCESS_NAMES[n5];
                if (ACCESS_VALUES[n5] == n) {
                    n2 = n3;
                }
                ++n3;
            }
            ++n5;
        }
        if (n2 == -1 && n == 0) {
            n2 = 0;
        }
        this.ignored = true;
        this.accessCombo.setModel(new DefaultComboBoxModel<String>(this.currentAccessNames));
        this.accessCombo.setSelectedIndex(n2);
        this.ignored = false;
    }

    private void updateModifiers() {
        int n = 0;
        while (n < MODIFIER_COUNT) {
            this.checks[n].setEnabled((this.myEditor.getMask() & MODIFIER_VALUES[n]) != 0);
            ++n;
        }
    }

    private void updateComponents() {
        this.updateAccessCombo();
        this.updateModifiers();
        int n = 0;
        while (n < MODIFIER_COUNT) {
            this.checks[n].setSelected((this.myEditor.getModifier() & MODIFIER_VALUES[n]) != 0);
            ++n;
        }
    }

    private void updateAccessCombo() {
        int n = -1;
        int n2 = 1;
        while (n2 < this.currentAccessValues.length) {
            if ((this.currentAccessValues[n2] & this.myEditor.getModifier()) != 0) {
                if (n != -1) {
                    n = -1;
                    break;
                }
                n = n2;
            }
            ++n2;
        }
        if (this.accessCombo.getSelectedIndex() != n) {
            this.accessCombo.setSelectedIndex(n);
        }
    }

    private void updateValue() {
        int n = 0;
        int n2 = this.accessCombo.getSelectedIndex();
        n = n2 == -1 ? this.myEditor.getModifier() & 7 : (n |= this.currentAccessValues[n2]);
        int n3 = 0;
        while (n3 < MODIFIER_COUNT) {
            if (this.checks[n3].isSelected() & this.checks[n3].isEnabled()) {
                n |= MODIFIER_VALUES[n3];
            }
            ++n3;
        }
        if (this.myEditor.getModifier() != n) {
            this.myEditor.setModifier(n);
        }
    }

    private static String getString(String string) {
        return NbBundle.getBundle(class$org$openide$explorer$propertysheet$editors$ModifierPanel == null ? (class$org$openide$explorer$propertysheet$editors$ModifierPanel = ModifierPanel.class$("org.openide.explorer.propertysheet.editors.ModifierPanel")) : class$org$openide$explorer$propertysheet$editors$ModifierPanel).getString(string);
    }

    static String getModifierDescription(int n) {
        return ModifierPanel.getString(MODIFIER_DESCRIPTION_KEYS[n]);
    }

    static char getModifierMnemonics(int n) {
        return ModifierPanel.getString(MODIFIER_MNEMONICS_KEYS[n]).charAt(0);
    }

    static /* synthetic */ Class class$(String string) {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }
}

