/*
 * Decompiled with CFR 0.152.
 */
package org.openoffice.xmerge.converter.xml.sxc;

import java.util.Enumeration;
import java.util.Vector;
import org.openoffice.xmerge.converter.xml.OfficeConstants;
import org.openoffice.xmerge.converter.xml.sxc.SheetSettings;
import org.openoffice.xmerge.util.Debug;
import org.openoffice.xmerge.util.XmlUtil;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

public class BookSettings
implements OfficeConstants {
    private Document settings = null;
    private boolean hasColumnRowHeaders = true;
    private String activeSheet = new String();
    private Vector worksheetSettings = new Vector();

    public BookSettings(Vector vector) {
        this.worksheetSettings = vector;
    }

    public BookSettings(Node node) {
        this.readNode(node);
    }

    public void addAttribute(String string, String string2) {
        if (string.equals("ActiveTable")) {
            this.activeSheet = string2;
        } else if (string.equals("HasColumnRowHeaders")) {
            Boolean bl = Boolean.valueOf(string2);
            this.hasColumnRowHeaders = bl;
        }
    }

    private void addConfigItem(Node node, String string, String string2, String string3) {
        Element element = this.settings.createElement("config:config-item");
        element.setAttribute("config:name", string);
        element.setAttribute("config:type", string2);
        element.appendChild(this.settings.createTextNode(string3));
        node.appendChild(element);
    }

    public String getActiveSheet() {
        return this.activeSheet;
    }

    public Vector getSheetSettings() {
        return this.worksheetSettings;
    }

    public boolean hasColumnRowHeaders() {
        return this.hasColumnRowHeaders;
    }

    public void readNode(Node node) {
        if (node.hasChildNodes()) {
            NodeList nodeList = node.getChildNodes();
            int n = nodeList.getLength();
            int n2 = 0;
            while (n2 < n) {
                Node node2 = nodeList.item(n2);
                if (node2.getNodeType() == 1) {
                    Object object;
                    String string = node2.getNodeName();
                    if (string.equals("config:config-item")) {
                        object = node2.getAttributes();
                        Node node3 = object.getNamedItem("config:name");
                        String string2 = node3.getNodeValue();
                        NodeList nodeList2 = node2.getChildNodes();
                        int n3 = nodeList2.getLength();
                        String string3 = "";
                        int n4 = 0;
                        while (n4 < n3) {
                            Node node4 = nodeList2.item(n4);
                            if (node4.getNodeType() == 3) {
                                string3 = node4.getNodeValue();
                            }
                            ++n4;
                        }
                        this.addAttribute(string2, string3);
                    } else if (string.equals("config:config-item-map-named")) {
                        this.readNode(node2);
                    } else if (string.equals("config:config-item-map-entry")) {
                        object = new SheetSettings(node2);
                        this.worksheetSettings.add(object);
                    } else {
                        Debug.log(4, "<OTHERS " + XmlUtil.getNodeInfo(node2) + " />");
                    }
                }
                ++n2;
            }
        }
    }

    public void setActiveSheet(String string) {
        this.activeSheet = string;
    }

    public void setColumnRowHeaders(boolean bl) {
        this.hasColumnRowHeaders = bl;
    }

    public void writeNode(Document document, Node node) {
        Object object;
        this.settings = document;
        Element element = document.createElement("config:config-item-map-named");
        element.setAttribute("config:name", "Tables");
        Enumeration enumeration = this.worksheetSettings.elements();
        while (enumeration.hasMoreElements()) {
            object = (SheetSettings)enumeration.nextElement();
            ((SheetSettings)object).writeNode(document, element);
        }
        this.addConfigItem(node, "ActiveTable", "string", this.activeSheet);
        object = Boolean.toString(this.hasColumnRowHeaders);
        this.addConfigItem(node, "HasColumnRowHeaders", "boolean", (String)object);
        node.appendChild(element);
    }
}

