/*************************************************************************
 *
 *  $RCSfile: Busiaddr.cxx,v $
 *
 *  $Revision: 1.3 $
 *
 *  last change: $Author: hr $ $Date: 2003/03/25 16:01:42 $
 *
 *  The Contents of this file are made available subject to the terms of
 *  either of the following licenses
 *
 *         - GNU Lesser General Public License Version 2.1
 *         - Sun Industry Standards Source License Version 1.1
 *
 *  Sun Microsystems Inc., October, 2000
 *
 *  GNU Lesser General Public License Version 2.1
 *  =============================================
 *  Copyright 2000 by Sun Microsystems, Inc.
 *  901 San Antonio Road, Palo Alto, CA 94303, USA
 *
 *  This library is free software; you can redistribute it and/or
 *  modify it under the terms of the GNU Lesser General Public
 *  License version 2.1, as published by the Free Software Foundation.
 *
 *  This library is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 *  Lesser General Public License for more details.
 *
 *  You should have received a copy of the GNU Lesser General Public
 *  License along with this library; if not, write to the Free Software
 *  Foundation, Inc., 59 Temple Place, Suite 330, Boston,
 *  MA  02111-1307  USA
 *
 *
 *  Sun Industry Standards Source License Version 1.1
 *  =================================================
 *  The contents of this file are subject to the Sun Industry Standards
 *  Source License Version 1.1 (the "License"); You may not use this file
 *  except in compliance with the License. You may obtain a copy of the
 *  License at http://www.openoffice.org/license.html.
 *
 *  Software provided under this License is provided on an "AS IS" basis,
 *  WITHOUT WARRANTY OF ANY KIND, EITHER EXPRESSED OR IMPLIED, INCLUDING,
 *  WITHOUT LIMITATION, WARRANTIES THAT THE SOFTWARE IS FREE OF DEFECTS,
 *  MERCHANTABLE, FIT FOR A PARTICULAR PURPOSE, OR NON-INFRINGING.
 *  See the License for the specific provisions governing your rights and
 *  obligations concerning the Software.
 *
 *  The Initial Developer of the Original Code is: Sun Microsystems, Inc.
 *
 *  Copyright: 2000 by Sun Microsystems, Inc.
 *
 *  All Rights Reserved.
 *
 *  Contributor(s): _______________________________________
 *
 *
 ************************************************************************/

#include "sections.hrc"
#include "busiaddr.hxx"
#include "adrresid.hxx"
#include "datman.hxx"

#define LSTR_OFFICE		L"Office"
#define LSTR_STREET 	L"Address"
#define LSTR_CITY	 	L"City"
#define LSTR_STATE  	L"State"
#define LSTR_COUNTRY	L"Country"
#define LSTR_ZIP	 	L"ZIP"
#define LSTR_POBOX	 	L"PO-Box"
#define LSTR_BUSINESS 	L"Business"

AdrBusinessAddress::AdrBusinessAddress( Window * pParent, AdrDataManagerHdl pDM)
    : AdrBasePage( pParent,pDM,AdrResId(RID_TP_BUSIADDR)),
    aFtOffice	( this, ResId( FT_OFFICE ) ),
    aEdOffice	( this, ResId( ED_OFFICE ) ),
    aFtStreet	( this, ResId( FT_STREET ) ),
    aEdStreet	( this, ResId( ED_STREET ) ),
    aFtCity		( this, ResId( FT_CITY	 ) ),
    aEdCity		( this, ResId( ED_CITY	 ) ),
    aFtState	( this, ResId( FT_STATE	 ) ),
    aEdState	( this, ResId( ED_STATE  ) ),
    aFtCountry	( this, ResId( FT_COUNTRY) ),
    aEdCountry	( this, ResId( ED_COUNTRY) ),
    aFtZIP		( this, ResId( FT_ZIP	 ) ),
    aEdZIP		( this, ResId( ED_ZIP	 ) ),
    aEdPOBox	( this, ResId( ED_POBOX	 ) )
{
    FreeResource();

	UString aStrBusiness(LSTR_BUSINESS);
	Sequence<UString> seqBusiness(&aStrBusiness,1);

	InsertToFieldList(&aEdOffice,	LSTR_OFFICE,	seqBusiness);
	InsertToFieldList(&aEdStreet,	LSTR_STREET,	seqBusiness);
	InsertToFieldList(&aEdCity,		LSTR_CITY,		seqBusiness);
	InsertToFieldList(&aEdState,	LSTR_STATE,		seqBusiness);
	InsertToFieldList(&aEdCountry,	LSTR_ZIP,		seqBusiness);
	InsertToFieldList(&aEdZIP,		LSTR_POBOX,		seqBusiness);	
}

AdrBusinessAddress* CreateBusinessAddress( Window * pParent, AdrDataManagerHdl ppDM)
{
	AdrBusinessAddress* pAdrBusinessAddress=NULL;
	
	if(*ppDM != NULL)
	{
		AdrDataManagerPtr pDM= *ppDM;
		UString aStrBusiness(LSTR_BUSINESS);
		Sequence<UString> seqBusiness(&aStrBusiness,1);

		if(	pDM -> GetMaxFieldCount(LSTR_OFFICE,seqBusiness) >0 ||
			pDM -> GetMaxFieldCount(LSTR_STREET,seqBusiness) >0 ||
			pDM -> GetMaxFieldCount(LSTR_CITY,seqBusiness)   >0 ||
			pDM -> GetMaxFieldCount(LSTR_STATE,seqBusiness)  >0 ||
			pDM -> GetMaxFieldCount(LSTR_COUNTRY,seqBusiness)>0 ||
			pDM -> GetMaxFieldCount(LSTR_ZIP,seqBusiness)	 >0 ||
			pDM -> GetMaxFieldCount(LSTR_POBOX,seqBusiness)  >0 )
		{
			pAdrBusinessAddress = new AdrBusinessAddress(pParent,ppDM);
		}
	}
	return pAdrBusinessAddress;
}

