/*************************************************************************
 *
 *  $RCSfile: indexentrysupplier.hxx,v $
 *
 *  $Revision: 1.9 $
 *
 *  last change: $Author: vg $ $Date: 2003/04/24 11:02:53 $
 *
 *  The Contents of this file are made available subject to the terms of
 *  either of the following licenses
 *
 *         - GNU Lesser General Public License Version 2.1
 *         - Sun Industry Standards Source License Version 1.1
 *
 *  Sun Microsystems Inc., October, 2000
 *
 *  GNU Lesser General Public License Version 2.1
 *  =============================================
 *  Copyright 2000 by Sun Microsystems, Inc.
 *  901 San Antonio Road, Palo Alto, CA 94303, USA
 *
 *  This library is free software; you can redistribute it and/or
 *  modify it under the terms of the GNU Lesser General Public
 *  License version 2.1, as published by the Free Software Foundation.
 *
 *  This library is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 *  Lesser General Public License for more details.
 *
 *  You should have received a copy of the GNU Lesser General Public
 *  License along with this library; if not, write to the Free Software
 *  Foundation, Inc., 59 Temple Place, Suite 330, Boston,
 *  MA  02111-1307  USA
 *
 *
 *  Sun Industry Standards Source License Version 1.1
 *  =================================================
 *  The contents of this file are subject to the Sun Industry Standards
 *  Source License Version 1.1 (the "License"); You may not use this file
 *  except in compliance with the License. You may obtain a copy of the
 *  License at http://www.openoffice.org/license.html.
 *
 *  Software provided under this License is provided on an "AS IS" basis,
 *  WITHOUT WARRANTY OF ANY KIND, EITHER EXPRESSED OR IMPLIED, INCLUDING,
 *  WITHOUT LIMITATION, WARRANTIES THAT THE SOFTWARE IS FREE OF DEFECTS,
 *  MERCHANTABLE, FIT FOR A PARTICULAR PURPOSE, OR NON-INFRINGING.
 *  See the License for the specific provisions governing your rights and
 *  obligations concerning the Software.
 *
 *  The Initial Developer of the Original Code is: Sun Microsystems, Inc.
 *
 *  Copyright: 2000 by Sun Microsystems, Inc.
 *
 *  All Rights Reserved.
 *
 *  Contributor(s): _______________________________________
 *
 *
 ************************************************************************/
#ifndef _I18N_INDEXENTRYSUPPLIER_HXX_
#define _I18N_INDEXENTRYSUPPLIER_HXX_

#include <com/sun/star/i18n/XExtendedIndexEntrySupplier.hpp>
#include <cppuhelper/implbase2.hxx> // helper for implementations
#include <com/sun/star/i18n/XCharacterClassification.hpp>
#include <com/sun/star/lang/XServiceInfo.hpp>
#include <tools/list.hxx>

namespace com { namespace sun { namespace star { namespace i18n {

//	----------------------------------------------------
//	class IndexEntrySupplier
//	----------------------------------------------------
class IndexEntrySupplier : public cppu::WeakImplHelper2 
<
	com::sun::star::i18n::XExtendedIndexEntrySupplier,
	com::sun::star::lang::XServiceInfo
>
{
public:
	IndexEntrySupplier( const com::sun::star::uno::Reference < com::sun::star::lang::XMultiServiceFactory >& rxMSF );

	// Methods
	virtual com::sun::star::uno::Sequence < com::sun::star::lang::Locale > SAL_CALL getLocaleList() 
		throw (com::sun::star::uno::RuntimeException);

	virtual com::sun::star::uno::Sequence < rtl::OUString > SAL_CALL getAlgorithmList( 
		const com::sun::star::lang::Locale& rLocale )
		throw (com::sun::star::uno::RuntimeException);

	virtual sal_Bool SAL_CALL loadAlgorithm( 
		const com::sun::star::lang::Locale& rLocale,
		const rtl::OUString& SortAlgorithm, sal_Int32 collatorOptions ) 
		throw (com::sun::star::uno::RuntimeException);

	virtual sal_Bool SAL_CALL usePhoneticEntry(
		const com::sun::star::lang::Locale& rLocale ) 
		throw (com::sun::star::uno::RuntimeException);

	virtual rtl::OUString SAL_CALL getPhoneticCandidate( const rtl::OUString& IndexEntry,
		const com::sun::star::lang::Locale& rLocale ) 
		throw (com::sun::star::uno::RuntimeException);

	virtual rtl::OUString SAL_CALL getIndexKey( const rtl::OUString& IndexEntry,
		const rtl::OUString& PhoneticEntry, const com::sun::star::lang::Locale& rLocale ) 
		throw (com::sun::star::uno::RuntimeException);

	virtual sal_Int16 SAL_CALL compareIndexEntry( const rtl::OUString& IndexEntry1,
		const rtl::OUString& PhoneticEntry1, const com::sun::star::lang::Locale& rLocale1,
		const rtl::OUString& IndexEntry2, const ::rtl::OUString& PhoneticEntry2, 
		const com::sun::star::lang::Locale& rLocale2 )
		throw (com::sun::star::uno::RuntimeException);

	virtual rtl::OUString SAL_CALL getIndexCharacter( const rtl::OUString& IndexEntry,
		const com::sun::star::lang::Locale& rLocale, const rtl::OUString& SortAlgorithm ) 
		throw (com::sun::star::uno::RuntimeException);

	virtual rtl::OUString SAL_CALL getIndexFollowPageWord( sal_Bool MorePages,
		const com::sun::star::lang::Locale& rLocale ) 
		throw (com::sun::star::uno::RuntimeException);

	//XServiceInfo
	virtual rtl::OUString SAL_CALL getImplementationName() 
		throw( com::sun::star::uno::RuntimeException );
	virtual sal_Bool SAL_CALL supportsService(const rtl::OUString& ServiceName) 
		throw( com::sun::star::uno::RuntimeException );
	virtual com::sun::star::uno::Sequence< rtl::OUString > SAL_CALL getSupportedServiceNames() 
		throw( com::sun::star::uno::RuntimeException );

private:
	rtl::OUString aServiceName;
	com::sun::star::uno::Reference < com::sun::star::i18n::XExtendedIndexEntrySupplier > xIES;
	com::sun::star::uno::Reference < com::sun::star::lang::XMultiServiceFactory > xMSF;
	sal_Bool SAL_CALL createLocaleSpecificIndexEntrySupplier(const rtl::OUString& name) throw( com::sun::star::uno::RuntimeException );
	com::sun::star::uno::Reference < com::sun::star::i18n::XExtendedIndexEntrySupplier > SAL_CALL getLocaleSpecificIndexEntrySupplier(
		const com::sun::star::lang::Locale& rLocale, const rtl::OUString& rSortAlgorithm) throw (com::sun::star::uno::RuntimeException);

protected:
	sal_Char *implementationName;
	com::sun::star::lang::Locale aLocale;
	rtl::OUString aSortAlgorithm;
	friend sal_Bool SAL_CALL operator == (const com::sun::star::lang::Locale& l1, const com::sun::star::lang::Locale& l2);
};

} } } } 

#endif
