/*************************************************************************
 *
 *  $RCSfile: graphpro.cxx,v $
 *
 *  $Revision: 1.1.1.1 $
 *
 *  last change: $Author: hr $ $Date: 2000/09/18 16:48:32 $
 *
 *  The Contents of this file are made available subject to the terms of
 *  either of the following licenses
 *
 *         - GNU Lesser General Public License Version 2.1
 *         - Sun Industry Standards Source License Version 1.1
 *
 *  Sun Microsystems Inc., October, 2000
 *
 *  GNU Lesser General Public License Version 2.1
 *  =============================================
 *  Copyright 2000 by Sun Microsystems, Inc.
 *  901 San Antonio Road, Palo Alto, CA 94303, USA
 *
 *  This library is free software; you can redistribute it and/or
 *  modify it under the terms of the GNU Lesser General Public
 *  License version 2.1, as published by the Free Software Foundation.
 *
 *  This library is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 *  Lesser General Public License for more details.
 *
 *  You should have received a copy of the GNU Lesser General Public
 *  License along with this library; if not, write to the Free Software
 *  Foundation, Inc., 59 Temple Place, Suite 330, Boston,
 *  MA  02111-1307  USA
 *
 *
 *  Sun Industry Standards Source License Version 1.1
 *  =================================================
 *  The contents of this file are subject to the Sun Industry Standards
 *  Source License Version 1.1 (the "License"); You may not use this file
 *  except in compliance with the License. You may obtain a copy of the
 *  License at http://www.openoffice.org/license.html.
 *
 *  Software provided under this License is provided on an "AS IS" basis,
 *  WITHOUT WARRANTY OF ANY KIND, EITHER EXPRESSED OR IMPLIED, INCLUDING,
 *  WITHOUT LIMITATION, WARRANTIES THAT THE SOFTWARE IS FREE OF DEFECTS,
 *  MERCHANTABLE, FIT FOR A PARTICULAR PURPOSE, OR NON-INFRINGING.
 *  See the License for the specific provisions governing your rights and
 *  obligations concerning the Software.
 *
 *  The Initial Developer of the Original Code is: Sun Microsystems, Inc.
 *
 *  Copyright: 2000 by Sun Microsystems, Inc.
 *
 *  All Rights Reserved.
 *
 *  Contributor(s): _______________________________________
 *
 *
 ************************************************************************/

#ifndef _SFX_PROGRESS_HXX
#include <sfx2/progress.hxx>
#endif

#ifndef _SFXAPP_HXX //autogen
#include <sfx2/app.hxx>
#endif
#ifndef _SFXSTBMGR_HXX //autogen
#include <sfx2/stbmgr.hxx>
#endif
#ifndef _FILTER_HXX //autogen
#include <svtools/filter.hxx>
#endif

#include "strings.hrc"
#include "graphpro.hxx"
#include "sdresid.hxx"


/*************************************************************************
|*
|*	Ctor
|*
\************************************************************************/


FilterProgress::FilterProgress( GraphicFilter* _pFilter, SfxObjectShell* pShell ) :
				pFilter( _pFilter )
{
	String aPrgTitle( SdResId( STR_DRAW_FILTERPROGRESS ) );
	mpProgress = new SfxProgress( pShell, aPrgTitle, 100 );
	pFilter->SetUpdatePercentHdl( LINK( this, FilterProgress, Update ) );
}


/*************************************************************************
|*
|*	Dtor
|*
\************************************************************************/


FilterProgress::~FilterProgress()
{
	if ( pFilter )
		pFilter->SetUpdatePercentHdl( Link() );

	if ( mpProgress )
		delete mpProgress;
}

void FilterProgress::SetState( ULONG nVal, ULONG nNewRange /* = 0 */ )
{
	if( mpProgress )
		mpProgress->SetState( nVal, nNewRange );
}

/*************************************************************************
|*
|*	Setzen der Progressbar
|*
\************************************************************************/


IMPL_LINK_INLINE_START( FilterProgress, Update, GraphicFilter *, pGraphicFilter )
{
	if ( pGraphicFilter && mpProgress )
		mpProgress->SetState( pGraphicFilter->GetPercent() );

	return 0;
}
IMPL_LINK_INLINE_END( FilterProgress, Update, GraphicFilter *, pGraphicFilter )




