/*************************************************************************
 *
 *  $RCSfile: sw2block.cxx,v $
 *
 *  $Revision: 1.6 $
 *
 *  last change: $Author: vg $ $Date: 2003/06/12 10:05:47 $
 *
 *  The Contents of this file are made available subject to the terms of
 *  either of the following licenses
 *
 *         - GNU Lesser General Public License Version 2.1
 *         - Sun Industry Standards Source License Version 1.1
 *
 *  Sun Microsystems Inc., October, 2000
 *
 *  GNU Lesser General Public License Version 2.1
 *  =============================================
 *  Copyright 2000 by Sun Microsystems, Inc.
 *  901 San Antonio Road, Palo Alto, CA 94303, USA
 *
 *  This library is free software; you can redistribute it and/or
 *  modify it under the terms of the GNU Lesser General Public
 *  License version 2.1, as published by the Free Software Foundation.
 *
 *  This library is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 *  Lesser General Public License for more details.
 *
 *  You should have received a copy of the GNU Lesser General Public
 *  License along with this library; if not, write to the Free Software
 *  Foundation, Inc., 59 Temple Place, Suite 330, Boston,
 *  MA  02111-1307  USA
 *
 *
 *  Sun Industry Standards Source License Version 1.1
 *  =================================================
 *  The contents of this file are subject to the Sun Industry Standards
 *  Source License Version 1.1 (the "License"); You may not use this file
 *  except in compliance with the License. You may obtain a copy of the
 *  License at http://www.openoffice.org/license.html.
 *
 *  Software provided under this License is provided on an "AS IS" basis,
 *  WITHOUT WARRANTY OF ANY KIND, EITHER EXPRESSED OR IMPLIED, INCLUDING,
 *  WITHOUT LIMITATION, WARRANTIES THAT THE SOFTWARE IS FREE OF DEFECTS,
 *  MERCHANTABLE, FIT FOR A PARTICULAR PURPOSE, OR NON-INFRINGING.
 *  See the License for the specific provisions governing your rights and
 *  obligations concerning the Software.
 *
 *  The Initial Developer of the Original Code is: Sun Microsystems, Inc.
 *
 *  Copyright: 2000 by Sun Microsystems, Inc.
 *
 *  All Rights Reserved.
 *
 *  Contributor(s): _______________________________________
 *
 *
 ************************************************************************/


#pragma hdrstop

#ifndef _SVSTOR_HXX //autogen
#include <so3/svstor.hxx>
#endif
#ifndef _UNOTOOLS_CHARCLASS_HXX
#include <unotools/charclass.hxx>
#endif
#ifndef _SFXDOCFILE_HXX
#include <sfx2/docfile.hxx>
#endif

#ifndef _DOC_HXX
#include <doc.hxx>
#endif
#ifndef _PAM_HXX
#include <pam.hxx>
#endif
#ifndef _RDSWG_HXX
#include <rdswg.hxx>
#endif
#ifndef _SWBLOCKS_HXX
#include <swblocks.hxx>
#endif
#ifndef _MDIEXP_HXX
#include <mdiexp.hxx>		// Progress
#endif
#ifndef _STATSTR_HRC
#include <statstr.hrc>
#endif
#ifndef _SWGPAR_HXX
#include <swgpar.hxx>
#endif
#ifndef _SWSWERROR_H
#include <swerror.h>
#endif

// Die folgenden Daten werden durch SwSwgReader::Scan() (hier definiert)
// eingetragen und in die Instanz uebernommen

static struct {                     // Infos ueber den Contents-Block:
	long  nStart;                   // Anfang des Records (Laengenfeld)
	long  nSize;                    // Laenge des Records
	short nBlks;                    // Anzahl Elements im Record
} aBlockInfo;


//////////////////////////////////////////////////////////////////////////


//////////////////////////////////////////////////////////////////////////


Sw2TextBlocks::Sw2TextBlocks( const String& rFile )
	: SwImpBlocks( rFile, FALSE ),
	nColls( 0 ), nNamedFmts( 0 ),
	pText( 0 ), pRdr( 0 )
{
	pDoc = new SwDoc;

	pMed = new SfxMedium( rFile, STREAM_WRITE, FALSE );
	bReadOnly = 0 != pMed->GetInStream()->GetError();
	delete pMed;

	pMed = new SfxMedium( rFile, STREAM_READ, FALSE );
	// ein SvPersist mit einem Temp-Storage muss
	// fuer OLE-Objekte bereitstehen
	refPersist = new SvPersist;
	refPersist->DoOwnerLoad( new SvStorage( aEmptyStr ) );
	pDoc->SetPersist( refPersist );
	LoadDoc();
}


Sw2TextBlocks::~Sw2TextBlocks()
{
	delete pRdr;
	delete pMed;
	delete pDoc;
}


ULONG Sw2TextBlocks::Delete( USHORT )
{
	return ERR_SWG_OLD_GLOSSARY;
}


ULONG Sw2TextBlocks::Rename( USHORT, const String&, const String& )
{
	return ERR_SWG_OLD_GLOSSARY;
}

ULONG Sw2TextBlocks::CopyBlock( SwImpBlocks&, String&, const String&  )
{
	return ERR_SWG_OLD_GLOSSARY;
}


ULONG Sw2TextBlocks::MakeBlockList()
{
	return 0;
}


ULONG Sw2TextBlocks::GetDoc( USHORT nIdx )
{
	swistream& r = pRdr->r;
	r.seek( aNames[ nIdx ]->nPos );
	if( r.next() != SWG_TEXTBLOCK )
	{
		pRdr->r.setbad();
		return ERR_SWG_FILE_FORMAT_ERROR;
	}
	BYTE cFlag;
	r >> cFlag;
	// Fehler: Block ist leer
	if( !cFlag )
	{
		pRdr->r.setbad();
		return ERR_SWG_FILE_FORMAT_ERROR;
	}
	BYTE eCharSet = pRdr->aHdr.cCodeSet;
	if( cFlag & 0x02 ) r >> eCharSet;
	BYTE eOld = pRdr->aHdr.cCodeSet;
	pRdr->aHdr.cCodeSet = eCharSet;
	// Bookmark-Text ueberlesen
	r.next(); r.skipnext(); r.skip();
	if( pText ) *pText = pRdr->InContentsText( TRUE );
	else
	{
		pRdr->pPaM = MakePaM();
		USHORT nOldOptions = pRdr->nOptions;
		pRdr->nOptions = SWGRD_NORMAL;
		pRdr->InContents( TRUE, TRUE );
		pRdr->nOptions = nOldOptions;
		delete pRdr->pPaM;
		pRdr->pPaM = NULL;
	}
	pRdr->aHdr.cCodeSet = eOld;
	if( SVSTREAM_OK != pMed->GetInStream()->GetError() )
		return ERR_SWG_READ_ERROR;

	return pRdr->nErrno;
}


ULONG Sw2TextBlocks::PutDoc()
{
	return ERR_SWG_OLD_GLOSSARY;
}


ULONG Sw2TextBlocks::GetText( USHORT nIdx, String& rText )
{
	pText = &rText;
	ULONG nErr = GetDoc( nIdx );
	pText = NULL;
	if( nErr )
		rText.Erase();
	return nErr;
}


ULONG Sw2TextBlocks::PutText( const String&, const String&, const String& )
{
	return ERR_SWG_OLD_GLOSSARY;
}

// Initiales Laden der Doc-Datei. Es werden die Vorlagen
// und die Blocknamen geladen.


ULONG Sw2TextBlocks::LoadDoc()
{
	delete pRdr;
	pRdr = new SwSwgReader( pDoc, 0, *pMed->GetInStream(), aEmptyStr, TRUE );
	pRdr->LoadFileHeader();
	aBlockInfo.nStart = 0L;
	aBlockInfo.nSize  = 0L;
	aBlockInfo.nBlks  = 0;
	// Eine Textbausteindatei kann auch (initial) leer sein
	if( !pRdr->r.eof() )
	{
		if( pRdr->Scan( &aNames ) != 0 )
			pRdr->r.setbad();
	}
	nStart = aBlockInfo.nStart;
	nSize  = aBlockInfo.nSize;
	nBlks  = aBlockInfo.nBlks;
	// Doc-Start ist hinter dem Dateikopf und der Kennung SWG_DOCUMENT
	pRdr->r.seek( 0x20 );
	pRdr->r.next();
	nDocStart = pRdr->r.tell() - 3;
	nDocSize  = pRdr->r.size() + 3;
	pRdr->r.clear();
	nColls = pRdr->nColl;
	nNamedFmts = pRdr->nNamedFmt;
	if( pRdr->nErrno )
		ClearDoc();
	return pRdr->nErrno;
}


ULONG Sw2TextBlocks::OpenFile( BOOL bReadOnly )
{
	return bReadOnly ? 0 : ERR_SWG_OLD_GLOSSARY;
}


void Sw2TextBlocks::CloseFile()
{
}

//////////////////////////////////////////////////////////////////////////

// Eine Methode des Readers muss leider hier residieren:

// Scannen des (einzigen) Contents-Records nach Textbausteinen und Aufbau
// Der Tabelle der Bausteine. Der Header ist bereits eingelesen.


void SwSwgReader::ScanContents( SwBlockNames* pNames )
{
	// Speicherung der lokalen Daten:
	// Der Record-Header ist immer vier Bytes lang und bereits eingelesen
	// (siehe SwSwgReader::Scan() fuer Details)
	aBlockInfo.nSize  = r.size() + 3;
	aBlockInfo.nStart = r.tell() - 3;
	long nextrec = r.getskip();
	// Den Contents-Record nur scannen, wenn noch keine Bookmarks
	// eingelesen worden sind
	USHORT nCntId;	// ist immer IDX_NO_VALUE, da ohne LayoutInfos
	r >> nCntId >> aBlockInfo.nBlks;
	// Die Blockzahl kann falsch sein, also korrigieren
	aBlockInfo.nBlks = 0;
	// Kurznamen in Grossbuchstaben wandeln
	const CharClass& rCC = GetAppCharClass();
	BOOL bScanC = BOOL( pNames->Count() == 0 );
	long nNext;
	while( r.good() && r.tell() < nextrec )
	{
		long nPos = r.tell();
		switch( r.next() )
		{
			case SWG_TEXTBLOCK:
				nNext = r.getskip();
				if( bScanC )
				{
					BYTE cFlags;
					// Flag bits: 0x01 - used, 0x02 - charset follows
					r >> cFlags;
					if( cFlags )
					{
						BYTE eCharSet = (BYTE)gsl_getSystemTextEncoding();
						if( cFlags & 0x02 )
						  r >> eCharSet;
						BYTE eSave = aHdr.cCodeSet;
						aHdr.cCodeSet = eCharSet;
						// Textblock ist physikalisch vorhanden
						String aLong( GetText() );
						String aShort( GetText() );
						String s( rCC.upper( aShort ) );
						aHdr.cCodeSet = eSave;
						SwBlockName* pNew = new SwBlockName( s, aLong, nPos );
						pNames->C40_PTR_INSERT( SwBlockName, pNew );
					}
				}
				aBlockInfo.nBlks++;
				r.skip( nNext );
				break;
			case SWG_TEXTNODE:
			case SWG_GRFNODE:
			case SWG_OLENODE:
			case SWG_TABLE:
			case SWG_TOXGROUP:
				r.skip(); break;
			default:
				Error();
		}
	}
	r.next();
}



ULONG Sw2TextBlocks::BeginPutDoc( const String&, const String& )
{
	return ERR_SWG_OLD_GLOSSARY;
}


void Sw2TextBlocks::StatLineStartPercent()		// zum Anzeigen des Prozessbars
{
	SvStream* pFstrm = pMed->GetInStream();
	ULONG nPos = pFstrm->Tell(), nEnde = pFstrm->Seek( STREAM_SEEK_TO_END );
	pFstrm->Seek( nPos );
	pFstrm->ResetError();

	::StartProgress( STR_STATSTR_SWGREAD, nPos, nEnde, pDoc->GetDocShell() );
}

short Sw2TextBlocks::GetFileType ( void ) const
{
	return SWBLK_SW2;
}


