/*************************************************************************
 *
 *  $RCSfile: wizfx.cxx,v $
 *
 *  $Revision: 1.12 $
 *
 *  last change: $Author: vg $ $Date: 2003/04/17 16:01:00 $
 *
 *  The Contents of this file are made available subject to the terms of
 *  either of the following licenses
 *
 *         - GNU Lesser General Public License Version 2.1
 *         - Sun Industry Standards Source License Version 1.1
 *
 *  Sun Microsystems Inc., October, 2000
 *
 *  GNU Lesser General Public License Version 2.1
 *  =============================================
 *  Copyright 2000 by Sun Microsystems, Inc.
 *  901 San Antonio Road, Palo Alto, CA 94303, USA
 *
 *  This library is free software; you can redistribute it and/or
 *  modify it under the terms of the GNU Lesser General Public
 *  License version 2.1, as published by the Free Software Foundation.
 *
 *  This library is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 *  Lesser General Public License for more details.
 *
 *  You should have received a copy of the GNU Lesser General Public
 *  License along with this library; if not, write to the Free Software
 *  Foundation, Inc., 59 Temple Place, Suite 330, Boston,
 *  MA  02111-1307  USA
 *
 *
 *  Sun Industry Standards Source License Version 1.1
 *  =================================================
 *  The contents of this file are subject to the Sun Industry Standards
 *  Source License Version 1.1 (the "License"); You may not use this file
 *  except in compliance with the License. You may obtain a copy of the
 *  License at http://www.openoffice.org/license.html.
 *
 *  Software provided under this License is provided on an "AS IS" basis,
 *  WITHOUT WARRANTY OF ANY KIND, EITHER EXPRESSED OR IMPLIED, INCLUDING,
 *  WITHOUT LIMITATION, WARRANTIES THAT THE SOFTWARE IS FREE OF DEFECTS,
 *  MERCHANTABLE, FIT FOR A PARTICULAR PURPOSE, OR NON-INFRINGING.
 *  See the License for the specific provisions governing your rights and
 *  obligations concerning the Software.
 *
 *  The Initial Developer of the Original Code is: Sun Microsystems, Inc.
 *
 *  Copyright: 2000 by Sun Microsystems, Inc.
 *
 *  All Rights Reserved.
 *
 *  Contributor(s): _______________________________________
 *
 *
 ************************************************************************/


#pragma hdrstop

#ifndef _SFXAPP_HXX //autogen
#include <sfx2/app.hxx>
#endif
#ifndef _SVX_ADRITEM_HXX //autogen
#include <svx/adritem.hxx>
#endif


#ifndef _SWTYPES_HXX
#include <swtypes.hxx>
#endif
#ifndef _FLDBAS_HXX
#include <fldbas.hxx>  // TYP_FIXDATEFLD zum Fuellen der DateListbox
#endif
#ifndef _WIZFX_HXX
#include <wizfx.hxx>
#endif
#ifndef _WIZPAGE_HXX
#include <wizpage.hxx>
#endif
#ifndef _WIZDOKU_HXX
#include <wizdoku.hxx>
#endif
#ifndef _WIZARD_HRC
#include <wizard.hrc>
#endif
#ifndef _HELPID_H
#include <helpid.h>
#endif


#define FRAME_SPACE (5*EINHEIT)  /* vertikaler Abstand zwischen den Rahmen */

////////////////////////////////////////////////////////////////////////////////
//
// @@@@@ @@ @@ @@@@@ @@  @@ @@@@ @@  @@  @@@@  @@  @@ @@@@@  @@   @@@@@ @@@@@
// @@    @@ @@ @@    @@@ @@  @@  @@  @@ @@  @@ @@@ @@ @@  @@ @@   @@    @@  @@
// @@    @@ @@ @@    @@@@@@  @@  @@  @@ @@  @@ @@@@@@ @@  @@ @@   @@    @@  @@
// @@@@  @@@@@ @@@@  @@@@@@  @@  @@@@@@ @@@@@@ @@@@@@ @@  @@ @@   @@@@  @@@@@
// @@     @@@  @@    @@ @@@  @@  @@  @@ @@  @@ @@ @@@ @@  @@ @@   @@    @@  @@
// @@     @@@  @@    @@  @@  @@  @@  @@ @@  @@ @@  @@ @@  @@ @@   @@    @@  @@
// @@@@@   @   @@@@@ @@  @@  @@  @@  @@ @@  @@ @@  @@ @@@@@  @@@@ @@@@@ @@  @@
//
////////////////////////////////////////////////////////////////////////////////

IMPL_LINK( FaxDialog, TitelModifyHdl, Edit *, pEdt )
{
	aPage1.aTitl.SetStr(pEdt->GetText(),&aPrevWin);
	if (aPage1.aTitl.GetStr().Len()!=0) {
		aPage1.aTitl.Show(&aPrevWin);
	} else {
		aPage1.aTitl.Hide(&aPrevWin);
	}
	ArrangeObjects();
	return 0;
}

IMPL_LINK( FaxDialog, FormatSelectHdl, ListBox *, pLst )
{
	switch (pLst->GetSelectEntryPos()) {
		case 0: aPage1.SetDinA4(&aPrevWin); break;
		case 1: aPage1.SetDinA5Q(&aPrevWin); break;
	}
	aPage1.aFusz.KorregPgRand();
	ArrangeObjects();
	return 0;
}

////////////////////////////////////////////////////////////////////////////////
// Absn
////////////////////////////////////////////////////////////////////////////////

IMPL_LINK_INLINE_START( FaxDialog, AbsnBBtnHdl, Button *, pBtn )
{
	if (pBtn==&a3_BBtn_AbsnOL) aPage1.aAbsn.SetAlign(ALIGN_LiOb,&aPrevWin);
	if (pBtn==&a3_BBtn_AbsnOR) aPage1.aAbsn.SetAlign(ALIGN_ReOb,&aPrevWin);
	ArrangeObjects();
	return 0;
}
IMPL_LINK_INLINE_END( FaxDialog, AbsnBBtnHdl, Button *, pBtn )

IMPL_LINK_INLINE_START( FaxDialog, AbsnMFldHdl, MetricField *, pEdt )
{
	USHORT nVal=USHORT(pEdt->GetValue(FUNIT_CM));
	if (pEdt==&a3_MFld_AbsnWd) aPage1.aAbsn.SetWdt(nVal,&aPrevWin);
	if (pEdt==&a3_MFld_AbsnHg) aPage1.aAbsn.SetHgt(nVal,&aPrevWin);
	ArrangeObjects();
	return 0;
}
IMPL_LINK_INLINE_END( FaxDialog, AbsnMFldHdl, MetricField *, pEdt )

IMPL_LINK_INLINE_START( FaxDialog, ATeleModifyHdl, Edit *, pEdt )
{
	SetAbsnLineAnz();
	ArrangeObjects();
	return 0;
}
IMPL_LINK_INLINE_END( FaxDialog, ATeleModifyHdl, Edit *, pEdt )

IMPL_LINK_INLINE_START( FaxDialog, EditModifyHdl, Edit *, pEdt )
{
	String aStr(pEdt->GetText());
	if (pEdt==&a3_MEdt_AbsInp) aPage1.aAbsn.SetStr(aStr,&aPrevWin);
	ArrangeObjects();
	return 0;
}
IMPL_LINK_INLINE_END( FaxDialog, EditModifyHdl, Edit *, pEdt )

////////////////////////////////////////////////////////////////////////////////
// Elem
////////////////////////////////////////////////////////////////////////////////

IMPL_LINK_INLINE_START( FaxDialog, ElemDatmCheckHdl, Button *, pBtn )
{
	SetDatmLineAnz();
	FillDocInfoList();
	SetElemDisable();
	ArrangeObjects();
	return 0;
}
IMPL_LINK_INLINE_END( FaxDialog, ElemDatmCheckHdl, Button *, pBtn )

IMPL_LINK_INLINE_START( FaxDialog, ElemBetrCheckHdl, Button *, pBtn )
{
	SetBetrLineAnz();
	FillDocInfoList();
	SetElemDisable();
	ArrangeObjects();
	return 0;
}
IMPL_LINK_INLINE_END( FaxDialog, ElemBetrCheckHdl, Button *, pBtn )

IMPL_LINK( FaxDialog, ElemMiscCheckHdl, Button *, pBtn )
{
	if (pBtn==&a5_CBox_Elem1) aPage1.aElem.Show(0,&aPrevWin,a5_CBox_Elem1.IsChecked());
	if (pBtn==&a5_CBox_Elem2) aPage1.aElem.Show(1,&aPrevWin,a5_CBox_Elem2.IsChecked());
	if (pBtn==&a5_CBox_Elem3) aPage1.aElem.Show(2,&aPrevWin,a5_CBox_Elem3.IsChecked());
	if (pBtn==&a5_CBox_Elem4) aPage1.aElem.Show(3,&aPrevWin,a5_CBox_Elem4.IsChecked());
	FillDocInfoList();
	SetElemDisable();
	ArrangeObjects();
	return 0;
}

IMPL_LINK( FaxDialog, ElemModifyHdl, Edit *, pEdt )
{
	String aStr(pEdt->GetText());
	if (pEdt==&a5_Edit_Elem1)  aPage1.aElem.aBezeich[0].SetStr(aStr,&aPrevWin);
	if (pEdt==&a5_Edit_Elem2)  aPage1.aElem.aBezeich[1].SetStr(aStr,&aPrevWin);
	if (pEdt==&a5_Edit_Elem3)  aPage1.aElem.aBezeich[2].SetStr(aStr,&aPrevWin);
	if (pEdt==&a5_Edit_Elem4)  aPage1.aElem.aBezeich[3].SetStr(aStr,&aPrevWin);
	if (pEdt==&a5_Edit_Betref) aPage1.aBetr.SetStr(aStr,&aPrevWin);
	FillDocInfoList();
	return 0;
}

////////////////////////////////////////////////////////////////////////////////
// Logo - Abgefangene Handler von WizLogoDlg
////////////////////////////////////////////////////////////////////////////////

IMPL_LINK_INLINE_START( FaxDialog, LogoMFldHdl, MetricField *, pEdt )
{
	aLogo.MFldHdl(pEdt);
	ArrangeObjects();
	return 0;
}
IMPL_LINK_INLINE_END( FaxDialog, LogoMFldHdl, MetricField *, pEdt )

IMPL_LINK_INLINE_START( FaxDialog, LogoRBtnHdl, RadioButton *, pBtn )
{
	aLogo.RBtnHdl(pBtn);
	ArrangeObjects();
	return 0;
}
IMPL_LINK_INLINE_END( FaxDialog, LogoRBtnHdl, RadioButton *, pBtn )

////////////////////////////////////////////////////////////////////////////////
// Marg - Abgefangene Handler von WizFuszDlg
////////////////////////////////////////////////////////////////////////////////

IMPL_LINK_INLINE_START( FaxDialog, RandMetrcModifyHdl, MetricField *, pEdt )
{
	aMarg.MFldHdl(pEdt); // erstmal das Orginal rufen
	aPage1.aFusz.KorregWdt(&aPrevWin);
	return 0;
}
IMPL_LINK_INLINE_END( FaxDialog, RandMetrcModifyHdl, MetricField *, pEdt )


////////////////////////////////////////////////////////////////////////////////
// Empf - Abgefangene Handler von WizEmpfDlg
////////////////////////////////////////////////////////////////////////////////

IMPL_LINK_INLINE_START( FaxDialog, EmpfDBasListHdl, ListBox *, pLst )
{
	aEmpf.DBasListHdl(pLst);
	FillDocInfoList();
	SetEmpfLineAnz();
	ArrangeObjects();
	return 0;
}
IMPL_LINK_INLINE_END( FaxDialog, EmpfDBasListHdl, ListBox *, pLst )

IMPL_LINK_INLINE_START( FaxDialog, EmpfModifyHdl, MultiLineEdit *, pEdt )
{
	aEmpf.EmpfModfHdl(pEdt);
	ArrangeObjects();
	return 0;
}
IMPL_LINK_INLINE_END( FaxDialog, EmpfModifyHdl, MultiLineEdit *, pEdt )
IMPL_LINK( FaxDialog, UpdateAdressHdl, PushButton *, pButton)
{
	GetFromUsr();
	a3_MEdt_AbsInp.SetText(aPage1.aAbsn.GetStr());
	return 0;
}


IMPL_LINK_INLINE_START( FaxDialog, EmpfInsrPBtnHdl, PushButton *, pBtn )
{
	aEmpf.InsrPBtnHdl(pBtn);
	ArrangeObjects();
	return 0;
}
IMPL_LINK_INLINE_END( FaxDialog, EmpfInsrPBtnHdl, PushButton *, pBtn )

IMPL_LINK_INLINE_START( FaxDialog, EmpfNewLPBtnHdl, PushButton *, pBtn )
{
	aEmpf.NewLPBtnHdl(pBtn);
	SetEmpfLineAnz();
	ArrangeObjects();
	return 0;
}
IMPL_LINK_INLINE_END( FaxDialog, EmpfNewLPBtnHdl, PushButton *, pBtn )

IMPL_LINK_INLINE_START( FaxDialog, EmpfFeldListHdl, ListBox *, pLst )
{
	aEmpf.FeldListHdl(pLst);
	ArrangeObjects();
	return 0;
}
IMPL_LINK_INLINE_END( FaxDialog, EmpfFeldListHdl, ListBox *, pLst )

IMPL_LINK_INLINE_START( FaxDialog, ETeleSelectHdl, ListBox *, pLst )
{
	SetEmpfLineAnz();
	ArrangeObjects();
	return 0;
}
IMPL_LINK_INLINE_END( FaxDialog, ETeleSelectHdl, ListBox *, pLst )

IMPL_LINK_INLINE_START( FaxDialog, StyleClickHdl, RadioButton *, pBtn )
{
	BYTE nStyle=0;
	if (a1_RBtn_Stil1.IsChecked()) nStyle=0;
	else if (a1_RBtn_Stil2.IsChecked()) nStyle=1;
	else if (a1_RBtn_Stil3.IsChecked()) nStyle=2;
	return 0;
}
IMPL_LINK_INLINE_END( FaxDialog, StyleClickHdl, RadioButton *, pBtn )
////////////////////////////////////////////////////////////////////////////////
// FaxDialog
////////////////////////////////////////////////////////////////////////////////

FaxDialog::FaxDialog(Window* pParent)
	: WizardFaxDialog(pParent)
{
	Init();
	aPrevWin.SetPage(&aPage1);
	aLogo.SetPtr(&aPage1.aLogo);
	aEmpf.SetPtr(&aPage1.aEmpf);
	aMarg.SetPtr(&aPage1);
	aFusz.SetPtr(&aPage1.aFusz);
	pDoku->SetPtr(pOkayBtn);

	InitElemUI();

	GetFromDef();  // Harte Defaults setzen
	GetFromUsr();  // Defaults von Benutzereinstellungen holen
	GetFromIni();  // Defaults vom Inifile holen

	SetEventHandler();

	aLogo.ToUI();
	aEmpf.ToUI();
	aMarg.ToUI();
	aFusz.ToUI();
	pDoku->ToUI();
	FormToUI();
	AbsnToUI();
	TitlToUI();
	ElemToUI();
	SetElemDisable();
	FillDocInfoList();

	SetAbsnLineAnz();
	SetEmpfLineAnz();
	SetDatmLineAnz();
	SetBetrLineAnz();
	ArrangeObjects();

	Inc();
}

////////////////////////////////////////////////////////////////////////////////
//
//  @@@@  @@@@@ @@@@   @@@@@ @@@@   @@@@  @@   @@
// @@  @@ @@     @@    @@    @@ @@ @@  @@ @@@ @@@
// @@     @@     @@    @@    @@ @@ @@  @@ @@@@@@@
// @@ @@@ @@@@   @@    @@@@  @@@@  @@  @@ @@ @ @@
// @@  @@ @@     @@    @@    @@ @@ @@  @@ @@   @@
// @@  @@ @@     @@    @@    @@ @@ @@  @@ @@   @@  @@ @@ @@
//  @@@@@ @@@@@  @@    @@    @@ @@  @@@@  @@   @@  @@ @@ @@
//
////////////////////////////////////////////////////////////////////////////////

void FaxDialog::GetFromDef()
{
	//a1_List_Format.SelectEntryPos(0);
	aPage1.aTitl.SetStr(a1_CLst_FaxTit.GetText());
	a1_RBtn_Stil1.Check();
	// a5_List_Datum.SelectEntryPos(0);  // Datum Standard kurz
	// a5_List_Uhrzt.SelectEntryPos(0);  // Uhrzeit
}

void FaxDialog::GetFromUsr()
{
	String aLF( String::CreateFromAscii( RTL_CONSTASCII_STRINGPARAM(NEWLINE)));
	String sStr, sRow, sTmp, sToken, sPrevToken;
	String sAddrDef(SW_RES(STR_Fax_Usr_Address));

	SvxAddressItem aAddress;
	String sEmail(aAddress.GetToken(POS_EMAIL));

	USHORT nCnt = sAddrDef.GetTokenCount();

	for (USHORT i = 0; i < nCnt; i++)
	{
		sPrevToken = sToken;
		sToken = sAddrDef.GetToken(i);
		int nPos = -1;

		if (sToken.EqualsAscii( "COMPANY"))
			nPos = POS_COMPANY;
		else if (sToken.EqualsAscii( "PREFIX"))
			nPos = POS_TITLE;
		else if (sToken.EqualsAscii( "FIRSTNAME"))
		{
			sRow += aAddress.GetFirstName();
			continue;
		}
		else if (sToken.EqualsAscii( "LASTNAME"))
		{
			sRow += aAddress.GetName();
			continue;
		}
		else if (sToken.EqualsAscii( "TITLE"))
			nPos = POS_POSITION;
		else if (sToken.EqualsAscii( "ADDRESS"))
			nPos = POS_STREET;
		else if (sToken.EqualsAscii( "COUNTRY"))
			nPos = POS_COUNTRY;
		else if (sToken.EqualsAscii( "POSTALCODE"))
			nPos = POS_PLZ;
		else if (sToken.EqualsAscii( "CITY"))
			nPos = POS_CITY;
		else if (sToken.EqualsAscii( "EMAILPREFIX"))
		{
			if(sEmail.Len())
				sRow += SW_RESSTR(STR_Usr_ElektrMail);
			continue;
		}
		else if (sToken.EqualsAscii( "EMAIL"))
		{
			sRow += sEmail;
			continue;
		}
		else if (sToken.EqualsAscii( "STATEPROV"))
			nPos = POS_STATE;
		else if (sToken.EqualsAscii( "FAX"))
			nPos = POS_FAX;
		else if (sToken.EqualsAscii( "PHONEHOME"))
			nPos = POS_TEL_PRIVATE;
		else if (sToken.EqualsAscii( "PHONEWORK"))
			nPos = POS_TEL_COMPANY;
		else if (sToken.EqualsAscii( "CR"))
		{
			if (sRow.Len())
			{
				(sStr += sRow) += aLF;
				sRow.Erase();
			}
			sToken = aEmptyStr;
			continue;
		}

		if (nPos >= 0)
		{
			sToken = aAddress.GetToken(nPos);
			sRow += sToken;
			continue;
		}

		if (sPrevToken.Len())	// Trennzeichen nur einfuegen, wenn vorheriges Token existierte
			sRow += sToken;
	}
	if (sRow.Len())
		sStr += sRow;

	aPage1.aAbsn.SetStr( sStr );

	// Keine Privatnummer, wenn Dienst vorhanden
	if( !( sTmp = aAddress.GetToken( POS_TEL_COMPANY ) ).Len() )
		sTmp = aAddress.GetToken( POS_TEL_PRIVATE );
	a3_Edit_Telfon.SetText( sTmp );

	// FAX-Nummer setzen
	a3_Edit_Telfax.SetText( aAddress.GetToken( POS_FAX ) );
}

void FaxDialog::GetFromIni()
{
	if(!aConfig.HasValuesRead())
		return;
	switch(aConfig.nTemplateStylePreferredStyle)
	{
		case 0: a1_RBtn_Stil1.Check(TRUE);break;
		case 1: a1_RBtn_Stil2.Check(TRUE);break;
		default: a1_RBtn_Stil3.Check(TRUE);
	}
	StyleClickHdl(NULL);

    aPage1.SetWdt((USHORT)MM100_TO_TWIP(aConfig.nTemplateFormatWidth));
    aPage1.SetHgt((USHORT)MM100_TO_TWIP(aConfig.nTemplateFormatHeight));
	aPage1.aTitl.SetStr(aConfig.sTemplateTitle);
	aPage1.aLogo.SetModeGraf( 0, aConfig.bLogoIsGraphic );
    aPage1.aLogo.SetGraphic( aConfig.sLogoGraphicFileName, aConfig.sLogoGraphicFileFilter, aConfig.bLogoGraphicAsLink );
    aPage1.aLogo.SetPosX ( (USHORT)MM100_TO_TWIP(aConfig.nLogoPositionX));
    aPage1.aLogo.SetPosY ( (USHORT)MM100_TO_TWIP(aConfig.nLogoPositionY));
    aPage1.aLogo.SetWdt ( (USHORT)MM100_TO_TWIP(aConfig.nLogoSizeWidth));
    aPage1.aLogo.SetHgt ( (USHORT)MM100_TO_TWIP(aConfig.nLogoSizeHeight));
    aPage1.aLogo.SetRandL ( (USHORT)MM100_TO_TWIP(aConfig.nLogoAlignmentPositionLeft));
    aPage1.aLogo.SetRandR ( (USHORT)MM100_TO_TWIP(aConfig.nLogoAlignmentPositionRight));
    aPage1.aLogo.SetRandO ( (USHORT)MM100_TO_TWIP(aConfig.nLogoAlignmentPositionTop));
    aPage1.aLogo.SetRandU ( (USHORT)MM100_TO_TWIP(aConfig.nLogoAlignmentPositionBottom));
	aPage1.aLogo.SetAlign( (PageAlign) aConfig.nLogoAlignmentTypePosition);
	aPage1.aLogo.SetStr( aConfig.sLogoText );
	//it's not checked ?
	//aConfig.bLogoVisible;
    aPage1.aAbsn.SetPosX ( (USHORT)MM100_TO_TWIP(aConfig.nSenderPositionX));
    aPage1.aAbsn.SetPosY ( (USHORT)MM100_TO_TWIP(aConfig.nSenderPositionY));
    aPage1.aAbsn.SetWdt ( (USHORT)MM100_TO_TWIP(aConfig.nSenderSizeWidth));
    aPage1.aAbsn.SetHgt ( (USHORT)MM100_TO_TWIP(aConfig.nSenderSizeHeight));
    aPage1.aAbsn.SetRandL ( (USHORT)MM100_TO_TWIP(aConfig.nSenderAlignmentPositionLeft));
    aPage1.aAbsn.SetRandR ( (USHORT)MM100_TO_TWIP(aConfig.nSenderAlignmentPositionRight));
    aPage1.aAbsn.SetRandO ( (USHORT)MM100_TO_TWIP(aConfig.nSenderAlignmentPositionTop));
    aPage1.aAbsn.SetRandU ( (USHORT)MM100_TO_TWIP(aConfig.nSenderAlignmentPositionBottom));
	aPage1.aAbsn.SetAlign( (PageAlign) aConfig.nSenderAlignmentTypePosition);
	aPage1.aAbsn.SetStr( aConfig.sSenderContent );

	a3_Edit_Telfax.SetText(aConfig.sSenderFaxNumber);
	a3_Edit_Telfon.SetText(aConfig.sSenderTelNumber);
    USHORT nDBIndex = aEmpf.pE_List_DBase->GetEntryPos(String(aConfig.sRecipientDatabase));
    //select first time to fill the table ListBox
    aEmpf.SelectDBasList(nDBIndex);
    aEmpf.pE_List_DBTable->SelectEntry(aConfig.sRecipientDataTable);
    //select a second time
    aEmpf.SelectDBasList(nDBIndex);

    aEmpf.pE_List_Telfax->SelectEntry(aConfig.sRecipientFaxNumber);
	aEmpf.pE_List_Telfon->SelectEntry(aConfig.sRecipientTelNumber);

	aPage1.aEmpf.SetPosX ( MM100_TO_TWIP(aConfig.nRecipientPositionX));
	aPage1.aEmpf.SetPosY ( MM100_TO_TWIP(aConfig.nRecipientPositionY));
    aPage1.aEmpf.SetWdt ( (USHORT)MM100_TO_TWIP(aConfig.nRecipientSizeWidth));
    aPage1.aEmpf.SetHgt ( (USHORT)MM100_TO_TWIP(aConfig.nRecipientSizeHeight));
    aPage1.aEmpf.SetRandL ( (USHORT)MM100_TO_TWIP(aConfig.nRecipientAlignmentPositionLeft));
    aPage1.aEmpf.SetRandR ( (USHORT)MM100_TO_TWIP(aConfig.nRecipientAlignmentPositionRight));
    aPage1.aEmpf.SetRandO ( (USHORT)MM100_TO_TWIP(aConfig.nRecipientAlignmentPositionTop));
    aPage1.aEmpf.SetRandU ( (USHORT)MM100_TO_TWIP(aConfig.nRecipientAlignmentPositionBottom));
	aPage1.aEmpf.SetAlign( (PageAlign) aConfig.nRecipientAlignmentTypePosition);
	aPage1.aEmpf.SetStr( aConfig.sRecipientContent );

	a5_CBox_Datum.Check(aConfig.bElementsDateValueVisible);
    a5_List_Datum.SelectEntryPos((USHORT)aConfig.nElementsDateValueContent);
    a5_CBox_Uhrzt.Check(aConfig.bElementsTimeValueVisible);
    a5_List_Uhrzt.SelectEntryPos(aConfig.nElementsTimeValueContent);

	aPage1.aElem.Show(0,NULL,aConfig.bElementsElement1TextVisible);
	a5_Edit_Elem1.SetText(aConfig.sElementsElement1TextContent);
	aPage1.aElem.Show(1,NULL,aConfig.bElementsElement2TextVisible);
	a5_Edit_Elem2.SetText(aConfig.sElementsElement2TextContent);
	aPage1.aElem.Show(2,NULL,aConfig.bElementsElement3TextVisible);
	a5_Edit_Elem3.SetText(aConfig.sElementsElement3TextContent);
	aPage1.aElem.Show(3,NULL,aConfig.bElementsElement4TextVisible);
	a5_Edit_Elem4.SetText(aConfig.sElementsElement4TextContent);

	a5_CBox_Betref.Check(aConfig.bElementsSubjectValueVisible);
	a5_Edit_Betref.SetText(aConfig.sElementsSubjectValueContent);
	a5_CBox_KopiAn.Check(aConfig.bElementsCopy);

	aPage1.aFusz.Show(NULL,aConfig.bFooterEnable);
	aPage1.aFusz.SetTrennlinie(aConfig.bFooterSeparator);
	aPage1.aFusz.SetStr(aConfig.sFooterText);
    aPage1.SetRandL((USHORT)MM100_TO_TWIP(aConfig.nPageMarginLeft));
    aPage1.SetRandR((USHORT)MM100_TO_TWIP(aConfig.nPageMarginRight));

	FillDocInfoList();
	aConfig.ReadDocInfo(*pDoku);
}

void FaxDialog::WriteToIni()
{
	aConfig.nTemplateStylePreferredStyle = a1_RBtn_Stil1.IsChecked() ? 0 :
		a1_RBtn_Stil2.IsChecked() ? 1 : 2;

	aConfig.nTemplateFormatWidth = TWIP_TO_MM100(aPage1.GetWdt());
	aConfig.nTemplateFormatHeight = TWIP_TO_MM100(aPage1.GetHgt());
	aConfig.sTemplateTitle = aPage1.aTitl.GetStr();

	aConfig.bLogoVisible = aPage1.aLogo.IsVisible();
	aConfig.bLogoIsGraphic = aPage1.aLogo.IsGrafLogo();
	aConfig.sLogoText = aPage1.aLogo.GetStr();
	String sFile, sFilter;
    sal_Bool bAsLink;
    aPage1.aLogo.GetGraphic( sFile, sFilter, bAsLink );
	aConfig.sLogoGraphicFileName = sFile;
	aConfig.sLogoGraphicFileFilter = sFilter;
    aConfig.bLogoGraphicAsLink = bAsLink;
	aConfig.nLogoPositionX = TWIP_TO_MM100(aPage1.aLogo.GetPosX());
	aConfig.nLogoPositionY = TWIP_TO_MM100(aPage1.aLogo.GetPosY());
	aConfig.nLogoSizeWidth = TWIP_TO_MM100(aPage1.aLogo.GetWdt());
	aConfig.nLogoSizeHeight = TWIP_TO_MM100(aPage1.aLogo.GetHgt());
	aConfig.nLogoAlignmentTypePosition = aPage1.aLogo.GetAlign();
	aConfig.nLogoAlignmentPositionLeft = TWIP_TO_MM100(aPage1.aLogo.GetRandL());
	aConfig.nLogoAlignmentPositionRight = TWIP_TO_MM100(aPage1.aLogo.GetRandR());
	aConfig.nLogoAlignmentPositionTop = TWIP_TO_MM100(aPage1.aLogo.GetRandO());
	aConfig.nLogoAlignmentPositionBottom = TWIP_TO_MM100(aPage1.aLogo.GetRandU());

	aConfig.sSenderTelNumber = a3_Edit_Telfon.GetText();
	aConfig.sSenderFaxNumber = a3_Edit_Telfax.GetText();


	aConfig.sSenderContent = aPage1.aAbsn.GetStr();
	aConfig.nSenderPositionX = TWIP_TO_MM100(aPage1.aAbsn.GetPosX());
	aConfig.nSenderPositionY = TWIP_TO_MM100(aPage1.aAbsn.GetPosY());
	aConfig.nSenderSizeWidth = TWIP_TO_MM100(aPage1.aAbsn.GetWdt());
	aConfig.nSenderSizeHeight = TWIP_TO_MM100(aPage1.aAbsn.GetHgt());
	aConfig.nSenderAlignmentTypePosition = aPage1.aAbsn.GetAlign();
	aConfig.nSenderAlignmentPositionLeft = TWIP_TO_MM100(aPage1.aAbsn.GetRandL());
	aConfig.nSenderAlignmentPositionRight = TWIP_TO_MM100(aPage1.aAbsn.GetRandR());
	aConfig.nSenderAlignmentPositionTop = TWIP_TO_MM100(aPage1.aAbsn.GetRandO());
	aConfig.nSenderAlignmentPositionBottom = TWIP_TO_MM100(aPage1.aAbsn.GetRandU());

	aConfig.sRecipientDatabase = aEmpf.pE_List_DBase->GetSelectEntry();
    aConfig.sRecipientDataTable = aEmpf.pE_List_DBTable->GetSelectEntry();
    aConfig.sRecipientTelNumber = aEmpf.pE_List_Telfon->GetSelectEntry();
	aConfig.sRecipientFaxNumber = aEmpf.pE_List_Telfax->GetSelectEntry();

	aConfig.sRecipientContent = aPage1.aEmpf.GetStr();
	aConfig.nRecipientPositionX = TWIP_TO_MM100(aPage1.aEmpf.GetPosX());
	aConfig.nRecipientPositionY = TWIP_TO_MM100(aPage1.aEmpf.GetPosY());
	aConfig.nRecipientSizeWidth = TWIP_TO_MM100(aPage1.aEmpf.GetWdt());
	aConfig.nRecipientSizeHeight = TWIP_TO_MM100(aPage1.aEmpf.GetHgt());
	aConfig.nRecipientAlignmentTypePosition = aPage1.aEmpf.GetAlign();
	aConfig.nRecipientAlignmentPositionLeft = TWIP_TO_MM100(aPage1.aEmpf.GetRandL());
	aConfig.nRecipientAlignmentPositionRight = TWIP_TO_MM100(aPage1.aEmpf.GetRandR());
	aConfig.nRecipientAlignmentPositionTop = TWIP_TO_MM100(aPage1.aEmpf.GetRandO());
	aConfig.nRecipientAlignmentPositionBottom = TWIP_TO_MM100(aPage1.aEmpf.GetRandU());

	aConfig.bElementsElement1TextVisible = aPage1.aElem.IsVisible(0);
	aConfig.sElementsElement1TextContent = a5_Edit_Elem1.GetText();
	aConfig.bElementsElement2TextVisible = aPage1.aElem.IsVisible(1);
	aConfig.sElementsElement2TextContent = a5_Edit_Elem2.GetText();
	aConfig.bElementsElement3TextVisible = aPage1.aElem.IsVisible(2);
	aConfig.sElementsElement3TextContent = a5_Edit_Elem3.GetText();
	aConfig.bElementsElement4TextVisible = aPage1.aElem.IsVisible(3);
	aConfig.sElementsElement4TextContent = a5_Edit_Elem4.GetText();
	aConfig.bElementsDateValueVisible = a5_CBox_Datum.IsChecked();
	aConfig.nElementsDateValueContent = a5_List_Datum.GetSelectEntryPos();
	aConfig.bElementsTimeValueVisible = a5_CBox_Uhrzt.IsChecked();
	aConfig.nElementsTimeValueContent = a5_List_Uhrzt.GetSelectEntryPos();
	aConfig.bElementsSubjectValueVisible = a5_CBox_Betref.IsChecked();
	aConfig.sElementsSubjectValueContent = a5_Edit_Betref.GetText();
	aConfig.bElementsCopy = a5_CBox_KopiAn.IsChecked();

	aConfig.bFooterEnable =    aPage1.aFusz.IsVisible();
	aConfig.bFooterSeparator = aPage1.aFusz.IsTrennlinie();
	aConfig.sFooterText =      aPage1.aFusz.GetStr();

	aConfig.nPageMarginLeft =  TWIP_TO_MM100(aPage1.RandL);
	aConfig.nPageMarginRight = TWIP_TO_MM100(aPage1.RandR);

	aConfig.WriteDocInfo(*pDoku);
	aConfig.Commit();
}

////////////////////////////////////////////////////////////////////////////////
//
////////////////////////////////////////////////////////////////////////////////

void FaxDialog::ArrangeObjects()
{
	USHORT yPos=10*EINHEIT; // Defaultrand oben = 10mm
	USHORT nHgt;
	if (aPage1.aLogo.IsVisible()) {
		yPos=USHORT(aPage1.aLogo.GetPosY())+aPage1.aLogo.GetHgt();
		yPos+=FRAME_SPACE;  // Abstand zwischen Logo und Titel
	}

	nHgt=0;
	if (aPage1.aTitl.IsVisible()) {
		aPage1.aTitl.SetVer(yPos,&aPrevWin);
		nHgt=Max(nHgt,aPage1.aTitl.GetHgt());
	}
	if (aPage1.aDatm.IsVisible()) {
		aPage1.aDatm.SetVer(yPos,&aPrevWin);
		nHgt=Max(nHgt,aPage1.aDatm.GetHgt());
	}
	if (nHgt>0) yPos+=nHgt+FRAME_SPACE; // Abstand Titel und Empfaenger

	BOOL bUntern=aPage1.aAbsn.IsLks(); // Absender Links? -> Anordnung untereinander
	nHgt=0;
	if (aPage1.aAbsn.IsVisible()) {
		aPage1.aAbsn.SetVer(yPos,&aPrevWin);
		nHgt=Max(nHgt,aPage1.aAbsn.GetHgt());
		if (bUntern) {
			yPos+=nHgt+FRAME_SPACE; // Abstand Absender und Empfaenger
			nHgt=0;
		}
	}
	if (aPage1.aEmpf.IsVisible()) {
		aPage1.aEmpf.SetVer(yPos,&aPrevWin);
		nHgt=Max(nHgt,aPage1.aEmpf.GetHgt());
	}
	if (nHgt>0) yPos+=nHgt+FRAME_SPACE; // Abstand Empfaenger und Betreff

	if (aPage1.aBetr.IsVisible()) {
		aPage1.aBetr.SetPosY(yPos,&aPrevWin);
		nHgt=aPage1.aBetr.GetHgt();
		if (nHgt>0) yPos+=nHgt+FRAME_SPACE; // Abstand Betreff und Elemente
	}

	if (aPage1.aElem.IsAnyVisible()) {
		aPage1.aElem.SetPosY(yPos,&aPrevWin);
		nHgt=aPage1.aElem.GetHgt();
		if (nHgt>0) yPos+=nHgt+FRAME_SPACE; // Abstand Elemente und Bodytext
	}
	aPage1.SetRandO(yPos,&aPrevWin);
}

void FaxDialog::SetAbsnLineAnz()
{
	USHORT nDazu=0;
	if (a3_Edit_Telfon.GetText().Len()!=0) nDazu++;
	if (a3_Edit_Telfax.GetText().Len()!=0) nDazu++;
	aPage1.aAbsn.SetLnDazu(nDazu,&aPrevWin);
}

void FaxDialog::SetEmpfLineAnz()
{
	USHORT nDazu=0;
	if (aEmpf.pE_List_Telfon->GetSelectEntryPos()!=0) nDazu++;
	if (aEmpf.pE_List_Telfax->GetSelectEntryPos()!=0) nDazu++;
	aPage1.aEmpf.SetLnDazu(nDazu,&aPrevWin);
}

void FaxDialog::SetDatmLineAnz()
{
	USHORT LnAnz=1;  // Seitenanzahl ist immer da
	if (a5_CBox_Uhrzt.IsChecked()) LnAnz++;
	if (a5_CBox_Datum.IsChecked()) LnAnz++;
	aPage1.aDatm.SetLnDazu(USHORT(LnAnz-1),&aPrevWin); // Eine Zeile ist immer mind. da
}

void FaxDialog::SetBetrLineAnz()
{
	USHORT LnAnz=0;
	if (a5_CBox_Betref.IsChecked()) LnAnz++;
	if (a5_CBox_KopiAn.IsChecked()) LnAnz++;
	if (LnAnz!=0) {
		aPage1.aBetr.SetLnDazu(USHORT(LnAnz-1),&aPrevWin);
		aPage1.aBetr.Show(&aPrevWin);
	} else {
		aPage1.aBetr.Hide(&aPrevWin);
	}
}

////////////////////////////////////////////////////////////////////////////////
//
////////////////////////////////////////////////////////////////////////////////

void FaxDialog::FillDocInfoList()
{
	pDoku->MerkDocInfListSel();
	USHORT nAnz=aEmpf.GetDBFieldAnz();
	pDoku->SetDBFieldAnz(nAnz);
	USHORT i,j;
	String aStr;
	for (i=0; i<nAnz; i++) {
		aStr=aEmpf.GetDBFieldNam(i);
		pDoku->SetDBFieldNam(i,aStr);
	}
	nAnz=0;
	for (i=0; i<5; i++)
		if (GetDocInfStrOk(i)) nAnz++;
	pDoku->SetTxFieldAnz(nAnz);
	j=0;
	for (i=0; i<5; i++) {
		if (GetDocInfStrOk(i))  {
			aStr=GetDocInfStr(i);
			pDoku->SetTxFieldNam(j,aStr);
			j++;
		}
	}
	pDoku->RestDocInfListSel();
}

String FaxDialog::GetDocInfStr(USHORT nNum)
{
	Edit* pEd = 0;
	USHORT nRId;
	switch( nNum )
	{
	case 0: pEd = &a5_Edit_Elem1;	nRId = STR_Brf_DocInEl1; break;
	case 1: pEd = &a5_Edit_Elem2;	nRId = STR_Brf_DocInEl2; break;
	case 2: pEd = &a5_Edit_Elem3;	nRId = STR_Brf_DocInEl3; break;
	case 3: pEd = &a5_Edit_Elem4;	nRId = STR_Brf_DocInEl4; break;
	case 4: pEd = &a5_Edit_Betref;	nRId = STR_Brf_DocInBtr; break;
	}

	String aStr;
	if( pEd )
	{
		aStr = pEd->GetText();
		if( !aStr.Len() || !aStr.EraseTrailingChars().Len() )
			aStr = SW_RESSTR( nRId );
	}
	return aStr;
}

BOOL FaxDialog::GetDocInfStrOk(USHORT nNum)
{
	BOOL bVisi=FALSE;
//  BOOL bEmpt;
	if (nNum<4) bVisi=aPage1.aElem.IsVisible(nNum);
	if (nNum==4) bVisi=a5_CBox_Betref.IsChecked(); // aPage1.aBetr.IsVisible();
//  bEmpt=(GetDocInfStr(nNum).Len()==0);
	return bVisi /*&& !bEmpt*/;
}

BOOL FaxDialog::GetDocInfoGoDown(USHORT nNum)
{   // Achtung: nNum ist Index auf Doku.List_Info...
	BOOL bRet=FALSE;
	if (pDoku->IsDocInfoTxFeld(nNum)) {
		bRet=TRUE;
		if (GetDocInfStrOk(4)) {
			if (nNum==pDoku->GetTxFieldOfs()+pDoku->GetTxFieldAnz()-1) { // Betreff ist das letzte der Elemente
				bRet=FALSE; // nur bei Betreff kein GoDown
			}
		}
	}
	return bRet;
}

////////////////////////////////////////////////////////////////////////////////
//
// @@  @@ @@     @@@@@ @@  @@ @@@@@ @@    @@    @@  @@ @@  @@  @@@@
// @@  @@ @@     @@    @@  @@ @@    @@    @@    @@  @@ @@@ @@ @@  @@
// @@  @@ @@     @@    @@  @@ @@    @@    @@    @@  @@ @@@@@@ @@
// @@  @@ @@ @@@ @@@@  @@  @@ @@@@  @@    @@    @@  @@ @@@@@@ @@ @@@
// @@  @@ @@     @@    @@  @@ @@    @@    @@    @@  @@ @@ @@@ @@  @@
// @@  @@ @@     @@    @@  @@ @@    @@    @@    @@  @@ @@  @@ @@  @@
//  @@@@  @@     @@     @@@@  @@@@@ @@@@@ @@@@@  @@@@  @@  @@  @@@@@
//
////////////////////////////////////////////////////////////////////////////////

void FaxDialog::InitElemUI()
{
	// Datumslistbox fuellen
	FillFldListBox( a5_List_Datum, TYP_FIXDATEFLD );
	// Uhrzeitlistbox fuellen
	FillFldListBox( a5_List_Uhrzt, TYP_FIXTIMEFLD );
}

void FaxDialog::FormToUI()
{
	if (aPage1.IsDinA4()) a1_List_Format.SelectEntryPos(0);
	else if (aPage1.IsDinA5Q()) a1_List_Format.SelectEntryPos(1);
	else a1_List_Format.SetNoSelection();
}

void FaxDialog::AbsnToUI()
{
	a3_MFld_AbsnWd.SetValue(aPage1.aAbsn.GetWdt(), FUNIT_CM);
	a3_MFld_AbsnHg.SetValue(aPage1.aAbsn.GetHgt(), FUNIT_CM);
	a3_MEdt_AbsInp.SetText(aPage1.aAbsn.GetStr());
}

void FaxDialog::TitlToUI()
{
	a1_CLst_FaxTit.SetText(aPage1.aTitl.GetStr());
}

void FaxDialog::ElemToUI()
{
	a5_CBox_Elem1.Check(aPage1.aElem.IsVisible(0));
	a5_CBox_Elem2.Check(aPage1.aElem.IsVisible(1));
	a5_CBox_Elem3.Check(aPage1.aElem.IsVisible(2));
	a5_CBox_Elem4.Check(aPage1.aElem.IsVisible(3));
}

////////////////////////////////////////////////////////////////////////////////
// Disable
////////////////////////////////////////////////////////////////////////////////

void FaxDialog::SetElemDisable()
{
	a5_Edit_Elem1 .Enable(a5_CBox_Elem1 .IsChecked());
	a5_Edit_Elem2 .Enable(a5_CBox_Elem2 .IsChecked());
	a5_Edit_Elem3 .Enable(a5_CBox_Elem3 .IsChecked());
	a5_Edit_Elem4 .Enable(a5_CBox_Elem4 .IsChecked());
	a5_List_Datum .Enable(a5_CBox_Datum .IsChecked());
	a5_List_Uhrzt .Enable(a5_CBox_Uhrzt .IsChecked());
	a5_Edit_Betref.Enable(a5_CBox_Betref.IsChecked());
}

////////////////////////////////////////////////////////////////////////////////
//                                                                            //
////////////////////////////////////////////////////////////////////////////////

void FaxDialog::SetEventHandler()
{
	Link aLk = LINK(this,FaxDialog,StyleClickHdl);
	{
		a1_RBtn_Stil1.SetClickHdl( aLk );
		a1_RBtn_Stil2.SetClickHdl( aLk );
		a1_RBtn_Stil3.SetClickHdl( aLk );

		aLk = LINK(this,FaxDialog,LogoMFldHdl);
		aLogo.pL_MFld_LogoWd->SetModifyHdl( aLk );
		aLogo.pL_MFld_LogoHg->SetModifyHdl( aLk );
		aLogo.pL_MFld_LogoHo->SetModifyHdl( aLk );
		aLogo.pL_MFld_LogoVe->SetModifyHdl( aLk );

		aLk = LINK(this,FaxDialog,LogoRBtnHdl);
		aLogo.pL_RBtn_NoLogo->SetClickHdl( aLk );
		aLogo.pL_RBtn_GrLogo->SetClickHdl( aLk );
		aLogo.pL_RBtn_TxLogo->SetClickHdl( aLk );

		aLk = LINK(this,FaxDialog,AbsnBBtnHdl);
		a3_BBtn_AbsnOL.SetClickHdl( aLk );
		a3_BBtn_AbsnOR.SetClickHdl( aLk );

		aLk = LINK(this,FaxDialog,AbsnMFldHdl);
		a3_MFld_AbsnWd.SetModifyHdl( aLk );
		a3_MFld_AbsnHg.SetModifyHdl( aLk );
	}
	{
		a3_PBtn_LoadAdr.SetClickHdl(LINK(this,FaxDialog,UpdateAdressHdl));
		a3_MEdt_AbsInp.SetModifyHdl(LINK(this,FaxDialog,EditModifyHdl));
		a3_Edit_Telfon.SetModifyHdl(LINK(this,FaxDialog,ATeleModifyHdl));
		a3_Edit_Telfax.SetModifyHdl(LINK(this,FaxDialog,ATeleModifyHdl));
		a1_CLst_FaxTit.SetModifyHdl(LINK(this,FaxDialog,TitelModifyHdl));
		a1_List_Format.SetSelectHdl(LINK(this,FaxDialog,FormatSelectHdl));
		aMarg.pM_MFld_VonLks->SetModifyHdl(LINK(this,FaxDialog,RandMetrcModifyHdl));
		aMarg.pM_MFld_VonRts->SetModifyHdl(LINK(this,FaxDialog,RandMetrcModifyHdl));
	}
	{
		aEmpf.pE_List_DBase ->SetSelectHdl(LINK(this,FaxDialog,EmpfDBasListHdl)); // Meine eigenen Handler
		aEmpf.pE_MEdt_Adress->SetModifyHdl(LINK(this,FaxDialog,EmpfModifyHdl));  // Mein Handler vor WizEmpf
		aEmpf.pE_SBtn_Insert->SetClickHdl (LINK(this,FaxDialog,EmpfInsrPBtnHdl));
		aEmpf.pE_BBtn_NewLin->SetClickHdl (LINK(this,FaxDialog,EmpfNewLPBtnHdl));
		aEmpf.pE_List_Fields->SetDoubleClickHdl(LINK(this,FaxDialog,EmpfFeldListHdl));
		aEmpf.pE_List_Telfon->SetSelectHdl(LINK(this,FaxDialog,ETeleSelectHdl));
		aEmpf.pE_List_Telfax->SetSelectHdl(LINK(this,FaxDialog,ETeleSelectHdl));
	}
	{
		a5_CBox_Datum .SetClickHdl(LINK(this,FaxDialog,ElemDatmCheckHdl));
		a5_CBox_Uhrzt .SetClickHdl(LINK(this,FaxDialog,ElemDatmCheckHdl));

		a5_CBox_Betref.SetClickHdl(LINK(this,FaxDialog,ElemBetrCheckHdl));
		a5_CBox_KopiAn.SetClickHdl(LINK(this,FaxDialog,ElemBetrCheckHdl));
	}
	{
		aLk = LINK(this,FaxDialog,ElemMiscCheckHdl);
		a5_CBox_Elem1 .SetClickHdl( aLk );
		a5_CBox_Elem2 .SetClickHdl( aLk );
		a5_CBox_Elem3 .SetClickHdl( aLk );
		a5_CBox_Elem4 .SetClickHdl( aLk );

		aLk = LINK(this,FaxDialog,ElemModifyHdl);
		a5_Edit_Elem1 .SetModifyHdl( aLk );
		a5_Edit_Elem2 .SetModifyHdl( aLk );
		a5_Edit_Elem3 .SetModifyHdl( aLk );
		a5_Edit_Elem4 .SetModifyHdl( aLk );
		a5_Edit_Betref.SetModifyHdl( aLk );
	}
}

////////////////////////////////////////////////////////////////////////////////
//
// @@  @@ @@ @@@@@  @@@@@@ @@  @@ @@@@@ @@   @@
// @@  @@ @@ @@  @@   @@   @@  @@ @@    @@   @@
// @@  @@ @@ @@  @@   @@   @@  @@ @@    @@   @@
// @@@@@@ @@ @@@@@    @@   @@  @@ @@@@  @@   @@
//  @@@@  @@ @@  @@   @@   @@  @@ @@    @@   @@
//  @@@@  @@ @@  @@   @@   @@  @@ @@    @@   @@
//   @@   @@ @@  @@   @@    @@@@  @@@@@ @@@@ @@@@
//
////////////////////////////////////////////////////////////////////////////////

BOOL FaxDialog::Possible(USHORT StepNum)
{
	return(TRUE);
}

void FaxDialog::Enter(USHORT StepNum)
{
	if (StepNum==7) aPrevWin.Hide(); // Fuer die Fahne
}

void FaxDialog::Leave(USHORT StepNum)
{
	if (StepNum==7) aPrevWin.Show(); // Fuer die Fahne
}

void FaxDialog::Fill(USHORT StepNum, MultiOne& WinArr)
{
	switch (StepNum) {
		case 0: {
			WinArr.AddWin(&a1_Text_Stil  );
			WinArr.AddWin(&a1_RBtn_Stil1, TRUE );
			WinArr.AddWin(&a1_RBtn_Stil2, TRUE );
			WinArr.AddWin(&a1_RBtn_Stil3, TRUE );
			WinArr.AddWin(&a1_Text_FaxTit);
			WinArr.AddWin(&a1_CLst_FaxTit, TRUE);
			WinArr.AddWin(&a1_Text_Format);
			WinArr.AddWin(&a1_List_Format, TRUE);
			WinArr.SetHelpId( HID_FAX_PAGE1 );
		} break;
		case 1: {
			aLogo.Fill(WinArr);
			WinArr.SetHelpId( HID_FAX_PAGE2 );
		} break;
		case 2: {
			WinArr.AddWin(&a3_PBtn_LoadAdr);
			WinArr.AddWin(&a3_MEdt_AbsInp, TRUE);
			WinArr.AddWin(&a3_Text_Telfon);
			WinArr.AddWin(&a3_Edit_Telfon, TRUE);
			WinArr.AddWin(&a3_Text_Telfax);
			WinArr.AddWin(&a3_Edit_Telfax, TRUE);
            WinArr.AddWin(&a3_FL_AbsInp,FALSE,TRUE);
			WinArr.AddWin(&a3_BBtn_AbsnOL, TRUE);
			WinArr.AddWin(&a3_BBtn_AbsnOR, TRUE);
			WinArr.AddWin(&a3_Text_AbsnWd);
			WinArr.AddWin(&a3_MFld_AbsnWd, TRUE);
			WinArr.AddWin(&a3_Text_AbsnHg);
			WinArr.AddWin(&a3_MFld_AbsnHg, TRUE);
            WinArr.AddWin(&a3_FL_AbsPos,FALSE,TRUE);
			WinArr.SetHelpId( HID_FAX_PAGE3 );
		} break;
		case 3: {
			aEmpf.Fill(WinArr);
			WinArr.SetHelpId( HID_FAX_PAGE4 );
		} break;
		case 4: {
			WinArr.AddWin(&a5_Text_Welche);
			WinArr.AddWin(&a5_CBox_Datum, TRUE );
			WinArr.AddWin(&a5_List_Datum, TRUE );
			WinArr.AddWin(&a5_CBox_Uhrzt, TRUE );
			WinArr.AddWin(&a5_List_Uhrzt, TRUE );
			WinArr.AddWin(&a5_CBox_Betref, TRUE);
			WinArr.AddWin(&a5_Edit_Betref, TRUE);
			WinArr.AddWin(&a5_CBox_KopiAn, TRUE);
			WinArr.AddWin(&a5_CBox_Elem1, TRUE );
			WinArr.AddWin(&a5_Edit_Elem1, TRUE );
			WinArr.AddWin(&a5_CBox_Elem2, TRUE );
			WinArr.AddWin(&a5_Edit_Elem2, TRUE );
			WinArr.AddWin(&a5_CBox_Elem3, TRUE );
			WinArr.AddWin(&a5_Edit_Elem3, TRUE );
			WinArr.AddWin(&a5_CBox_Elem4, TRUE );
			WinArr.AddWin(&a5_Edit_Elem4, TRUE );
			WinArr.SetHelpId( HID_FAX_PAGE5 );
		} break;
		case 5: {
			aFusz.Fill(WinArr);
			aMarg.Fill(WinArr);
			WinArr.SetHelpId( HID_FAX_PAGE6 );
		} break;
		case 6: {
			pDoku->Fill(WinArr);
			WinArr.SetHelpId( HID_FAX_PAGE7 );
		} break;
		case 7: {
			WinArr.AddWin(&a8_BMap_Fahne, TRUE );
			WinArr.AddWin(&a8_Text_Final );
			WinArr.SetHelpId( HID_FAX_PAGE8 );
		} break;
		case 0xFFFF: {
			FillDefElems(WinArr); // Defaultelemente (Buttons, PrevWin)
		} break;
	}
}



