/*************************************************************************
 *
 *  OpenOffice.org - a multi-platform office productivity suite
 *
 *  $RCSfile: StreamDecompressor.java,v $
 *
 *  $Revision: 1.2 $
 *
 *  last change: $Author: rt $ $Date: 2005/09/09 16:50:19 $
 *
 *  The Contents of this file are made available subject to
 *  the terms of GNU Lesser General Public License Version 2.1.
 *
 *
 *    GNU Lesser General Public License Version 2.1
 *    =============================================
 *    Copyright 2005 by Sun Microsystems, Inc.
 *    901 San Antonio Road, Palo Alto, CA 94303, USA
 *
 *    This library is free software; you can redistribute it and/or
 *    modify it under the terms of the GNU Lesser General Public
 *    License version 2.1, as published by the Free Software Foundation.
 *
 *    This library is distributed in the hope that it will be useful,
 *    but WITHOUT ANY WARRANTY; without even the implied warranty of
 *    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 *    Lesser General Public License for more details.
 *
 *    You should have received a copy of the GNU Lesser General Public
 *    License along with this library; if not, write to the Free Software
 *    Foundation, Inc., 59 Temple Place, Suite 330, Boston,
 *    MA  02111-1307  USA
 *
 ************************************************************************/
package com.sun.xmlsearch.util;

import java.io.*;

public final class StreamDecompressor extends Decompressor {
  private InputStream _input;
  
  public StreamDecompressor(InputStream input) {
    initReading(input);
  }

  public void initReading(InputStream input) {
    _input = input;
    initReading();
  }
  
  public int getNextByte() throws java.io.IOException {
    return _input.read();
  }

  /*  main is for testing
  public static void main(String[] args) {
    try {
      FileInputStream file = new FileInputStream(args[0]);
      try {
	int k1 = file.read();
	long start = System.currentTimeMillis();
	System.out.println("k1 = " + k1);
	IntegerArray concepts = new IntegerArray();
	StreamDecompressor documents = new StreamDecompressor(file);
	try {
	  documents.ascDecode(k1, concepts);
	}
	catch (Exception e) {
	  System.err.println(e);
	}
	System.out.println("index1 = " + concepts.cardinality());
	int k2 = file.read();
	System.out.println("k2 = " + k2);
	IntegerArray offs = new IntegerArray(concepts.cardinality());
	StreamDecompressor offsets = new StreamDecompressor(file);
	try {
	  offsets.decode(k2, offs);
	}
	catch (Exception e) {
	  System.err.println(e);
	}
	System.out.println("index2 = " + offs.cardinality());
	System.out.println((System.currentTimeMillis() - start) + " msec");
	file.close();
      }
      catch (IOException e) {
	System.err.println(e);
      }
    }
    catch (FileNotFoundException e) {
      System.err.println(e);
    }
  }
  */
}
