/*************************************************************************
 *
 *  OpenOffice.org - a multi-platform office productivity suite
 *
 *  $RCSfile: factory.hxx,v $
 *
 *  $Revision: 1.3 $
 *
 *  last change: $Author: rt $ $Date: 2005/09/08 12:06:32 $
 *
 *  The Contents of this file are made available subject to
 *  the terms of GNU Lesser General Public License Version 2.1.
 *
 *
 *    GNU Lesser General Public License Version 2.1
 *    =============================================
 *    Copyright 2005 by Sun Microsystems, Inc.
 *    901 San Antonio Road, Palo Alto, CA 94303, USA
 *
 *    This library is free software; you can redistribute it and/or
 *    modify it under the terms of the GNU Lesser General Public
 *    License version 2.1, as published by the Free Software Foundation.
 *
 *    This library is distributed in the hope that it will be useful,
 *    but WITHOUT ANY WARRANTY; without even the implied warranty of
 *    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 *    Lesser General Public License for more details.
 *
 *    You should have received a copy of the GNU Lesser General Public
 *    License along with this library; if not, write to the Free Software
 *    Foundation, Inc., 59 Temple Place, Suite 330, Boston,
 *    MA  02111-1307  USA
 *
 ************************************************************************/
#include <rtl/strbuf.hxx>

namespace sax_test {
Reference< XInterface > SAL_CALL OSaxWriterTest_CreateInstance(
	const Reference< XMultiServiceFactory > & rSMgr ) throw ( Exception );
OUString    OSaxWriterTest_getServiceName( ) throw();
OUString 	OSaxWriterTest_getImplementationName( ) throw();
Sequence<OUString> OSaxWriterTest_getSupportedServiceNames( ) throw();
}
#define BUILD_ERROR(expr, Message)\
		{\
			m_seqErrors.realloc( m_seqErrors.getLength() + 1 ); \
		m_seqExceptions.realloc(  m_seqExceptions.getLength() + 1 ); \
		OStringBuffer str(128); \
		str.append( __FILE__ );\
		str.append( " " ); \
		str.append( "(" ); \
		str.append( OString::valueOf( (sal_Int32)__LINE__) );\
		str.append(")\n" );\
		str.append( "[ " ); \
		str.append( #expr ); \
		str.append( " ] : " ); \
		str.append( Message ); \
		m_seqErrors.getArray()[ m_seqErrors.getLength()-1] =\
                       OStringToOUString( str.makeStringAndClear() , RTL_TEXTENCODING_ASCII_US ); \
		}\
		((void)0)
		

#define WARNING_ASSERT(expr, Message) \
		if( ! (expr) ) { \
			m_seqWarnings.realloc( m_seqErrors.getLength() +1 ); \
			OStringBuffer str(128);\
			str.append( __FILE__);\
			str.append( " "); \
			str.append( "(" ); \
			str.append(OString::valueOf( (sal_Int32)__LINE__)) ;\
			str.append( ")\n");\
			str.append( "[ " ); \
			str.append( #expr ); \
			str.append( " ] : ") ; \
			str.append( Message); \
			m_seqWarnings.getArray()[ m_seqWarnings.getLength()-1] =\
                          OStringToOUString( str.makeStringAndClear() , RTL_TEXTENCODING_ASCII_US ); \
			return; \
		}\
		((void)0)

#define ERROR_ASSERT(expr, Message) \
		if( ! (expr) ) { \
			BUILD_ERROR(expr, Message );\
			return; \
		}\
		((void)0)

#define ERROR_EXCEPTION_ASSERT(expr, Message, Exception) \
	if( !(expr)) { \
		BUILD_ERROR(expr,Message);\
		m_seqExceptions.getArray()[ m_seqExceptions.getLength()-1] = Any( Exception );\
		return; \
	} \
	((void)0)

