/*************************************************************************
 *
 *  OpenOffice.org - a multi-platform office productivity suite
 *
 *  $RCSfile: applet.hxx,v $
 *
 *  $Revision: 1.5 $
 *
 *  last change: $Author: rt $ $Date: 2005/09/07 21:30:38 $
 *
 *  The Contents of this file are made available subject to
 *  the terms of GNU Lesser General Public License Version 2.1.
 *
 *
 *    GNU Lesser General Public License Version 2.1
 *    =============================================
 *    Copyright 2005 by Sun Microsystems, Inc.
 *    901 San Antonio Road, Palo Alto, CA 94303, USA
 *
 *    This library is free software; you can redistribute it and/or
 *    modify it under the terms of the GNU Lesser General Public
 *    License version 2.1, as published by the Free Software Foundation.
 *
 *    This library is distributed in the hope that it will be useful,
 *    but WITHOUT ANY WARRANTY; without even the implied warranty of
 *    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 *    Lesser General Public License for more details.
 *
 *    You should have received a copy of the GNU Lesser General Public
 *    License along with this library; if not, write to the Free Software
 *    Foundation, Inc., 59 Temple Place, Suite 330, Boston,
 *    MA  02111-1307  USA
 *
 ************************************************************************/

#ifndef _APPLET_HXX
#define _APPLET_HXX

#ifdef MAC
//#define MRJ_JAVA TRUE
class SdApplet_MRJ;
#endif

#include <ipobj.hxx>
#include <svtools/ownlist.hxx>

//=========================================================================
struct SvAppletData_Impl;
class INetURLObject;
class SjApplet;
class RmAppletObject;
class SvAppletObject : public SvInPlaceObject
/*	[Beschreibung]

	Die Klasse AppletObject ist die Abbildung eines InPlace-Objektes
	auf einen Applet-Server. Dieses Objekt kann nur InPlace- und
	nicht UI-Aktiviert werden.

	[Probleme]
	Es handelt sich bei diesem Objekt immer um einen Link. Dieser Link
	kann allerdings InPlace aktiviert werden.
*/
{
friend class SvAppletEnvironment;
	SvAppletData_Impl *	pImpl;

	void			DataChanged_Impl( BOOL bOnlyEmbedSource );
protected:
	BOOL			StartApplet();
	virtual void    FillClass( SvGlobalName * pClassName,
							   ULONG * pFormat,
							   String * pAppName,
							   String * pFullTypeName,
							   String * pShortTypeName,
                               long nFileFormat = SOFFICE_FILEFORMAT_CURRENT ) const;
					// Protokoll
	virtual void    Open( BOOL bOpen );
	virtual void    InPlaceActivate( BOOL );
	virtual ErrCode Verb( long, SvEmbeddedClient * pCallerClient,
						Window * pWin, const Rectangle * pWorkRectPixel );

					// Datenaustausch
	virtual void    SetVisArea( const Rectangle & rVisArea );
	virtual void    Draw( OutputDevice *,
						  const JobSetup & rSetup,
						  USHORT nAspect = ASPECT_CONTENT );

					// Laden speichern
	virtual BOOL    InitNew( SvStorage * );
	virtual BOOL    Load( SvStorage * );
	virtual BOOL    Save();
	virtual BOOL    SaveAs( SvStorage * );
	virtual void    HandsOff();
	virtual BOOL    SaveCompleted( SvStorage * );

					~SvAppletObject();
public:
					SO2_DECL_BASIC_CLASS_DLL(SvAppletObject,SOAPP)
					SvAppletObject();

	virtual ULONG	GetMiscStatus() const;
	virtual BOOL	IsLink() const;

#ifdef MRJ_JAVA
	SdApplet_MRJ *	GetApplet() const;
#elif defined( REMOTE_VERSION )
	RmAppletObject *GetApplet() const;
#else
	SjApplet *		GetApplet() const;
#endif

					// spezielle Internet Methoden
	void			SetCommandList( const SvCommandList & rList );
	const SvCommandList & GetCommandList() const;
	void			SetClass( const String & rClass );
	const String &	GetClass()const;
	void			SetName( const XubString & rClass );
	const XubString &GetName() const;
	void			SetDocBase( const INetURLObject & );
	void			SetCodeBase( const INetURLObject & );
	void			SetCodeBase( const XubString & );
	const XubString & GetCodeBase() const;
	void			SetMayScript( BOOL bMayScript );
	BOOL			IsMayScript() const;
};

SO2_DECL_IMPL_REF(SvAppletObject)


#endif // _Applet_HXX
