/*************************************************************************
 *
 *  OpenOffice.org - a multi-platform office productivity suite
 *
 *  $RCSfile: sc_undotab.cxx,v $
 *
 *  $Revision: 1.5 $
 *
 *  last change: $Author: rt $ $Date: 2005/09/07 21:08:28 $
 *
 *  The Contents of this file are made available subject to
 *  the terms of GNU Lesser General Public License Version 2.1.
 *
 *
 *    GNU Lesser General Public License Version 2.1
 *    =============================================
 *    Copyright 2005 by Sun Microsystems, Inc.
 *    901 San Antonio Road, Palo Alto, CA 94303, USA
 *
 *    This library is free software; you can redistribute it and/or
 *    modify it under the terms of the GNU Lesser General Public
 *    License version 2.1, as published by the Free Software Foundation.
 *
 *    This library is distributed in the hope that it will be useful,
 *    but WITHOUT ANY WARRANTY; without even the implied warranty of
 *    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 *    Lesser General Public License for more details.
 *
 *    You should have received a copy of the GNU Lesser General Public
 *    License along with this library; if not, write to the Free Software
 *    Foundation, Inc., 59 Temple Place, Suite 330, Boston,
 *    MA  02111-1307  USA
 *
 ************************************************************************/

#ifdef PCH
// auto strip #include "ui_pch.hxx"
#endif

#pragma hdrstop

//------------------------------------------------------------------

// ?#define _MACRODLG_HXX
// ? #define _BIGINT_HXX
// ? #define _SVDXOUT_HXX
// ? #define _SVDATTR_HXX
// ? #define _SVDSURO_HXX

// INCLUDE ---------------------------------------------------------------

// auto strip #include <bf_sfx2/app.hxx>
// auto strip #include <bf_sfx2/bindings.hxx>
// auto strip #include <bf_sfx2/dispatch.hxx>
// auto strip #include <svtools/smplhint.hxx>

#include "undotab.hxx"
// auto strip #include "document.hxx"
#include "docsh.hxx"
// auto strip #include "tabvwsh.hxx"
#include "globstr.hrc"
// auto strip #include "global.hxx"
#include "bf_sc.hrc"
#include "undoolk.hxx"
#include "target.hxx"
// auto strip #include "uiitems.hxx"
#include "prnsave.hxx"
// auto strip #include "printfun.hxx"
// auto strip #include "chgtrack.hxx"

// for ScUndoRenameObject - might me moved to another file later
// auto strip #include <bf_svx/svditer.hxx>
// auto strip #include <bf_svx/svdoole2.hxx>
// auto strip #include <bf_svx/svdpage.hxx>
// auto strip #include "drwlayer.hxx"
// auto strip #include "scresid.hxx"
namespace binfilter {

extern BOOL bDrawIsInUndo;			//! irgendwo als Member !!!

using namespace ::com::sun::star;

// STATIC DATA -----------------------------------------------------------

//STRIP001 TYPEINIT1(ScUndoInsertTab,		SfxUndoAction);
//STRIP001 TYPEINIT1(ScUndoInsertTables,	SfxUndoAction);
//STRIP001 TYPEINIT1(ScUndoDeleteTab,		SfxUndoAction);
//STRIP001 TYPEINIT1(ScUndoRenameTab,		SfxUndoAction);
//STRIP001 TYPEINIT1(ScUndoMoveTab,		SfxUndoAction);
//STRIP001 TYPEINIT1(ScUndoCopyTab,		SfxUndoAction);
//STRIP001 TYPEINIT1(ScUndoMakeScenario,	SfxUndoAction);
//STRIP001 TYPEINIT1(ScUndoImportTab,		SfxUndoAction);
//STRIP001 TYPEINIT1(ScUndoRemoveLink,		SfxUndoAction);
//STRIP001 TYPEINIT1(ScUndoShowHideTab,	SfxUndoAction);
//STRIP001 TYPEINIT1(ScUndoProtect,		SfxUndoAction);
//STRIP001 TYPEINIT1(ScUndoPrintRange,		SfxUndoAction);
//STRIP001 TYPEINIT1(ScUndoScenarioFlags,	SfxUndoAction);
//STRIP001 TYPEINIT1(ScUndoRenameObject,	SfxUndoAction);


// -----------------------------------------------------------------------
//
//		Tabelle einfuegen
//

/*N*/ ScUndoInsertTab::ScUndoInsertTab( ScDocShell* pNewDocShell,
/*N*/ 								  USHORT nTabNum,
/*N*/ 								  BOOL bApp,
/*N*/ 								  const String& rNewName) :
/*N*/ 	ScSimpleUndo( pNewDocShell ),
/*N*/ 	nTab( nTabNum ),
/*N*/ 	bAppend( bApp ),
/*N*/ 	sNewName( rNewName ),
/*N*/ 	pDrawUndo( NULL )
/*N*/ {
/*N*/ 	pDrawUndo = GetSdrUndoAction( pDocShell->GetDocument() );
/*N*/ 	SetChangeTrack();
/*N*/ }

/*N*/ __EXPORT ScUndoInsertTab::~ScUndoInsertTab()
/*N*/ {
/*N*/ 	DeleteSdrUndoAction( pDrawUndo );
/*N*/ }

/*N*/ String __EXPORT ScUndoInsertTab::GetComment() const
/*N*/ {
/*N*/ 	if (bAppend)
/*N*/ 		return ScGlobal::GetRscString( STR_UNDO_APPEND_TAB );
/*N*/ 	else
/*N*/ 		return ScGlobal::GetRscString( STR_UNDO_INSERT_TAB );
/*N*/ }

/*N*/ void ScUndoInsertTab::SetChangeTrack()
/*N*/ {
/*N*/ 	ScChangeTrack* pChangeTrack = pDocShell->GetDocument()->GetChangeTrack();
/*N*/ 	if ( pChangeTrack )
/*N*/ 	{
/*?*/ 		DBG_BF_ASSERT(0, "STRIP"); //STRIP001 ScRange aRange( 0, 0, nTab, MAXCOL, MAXROW, nTab );
//STRIP001 /*?*/ 		pChangeTrack->AppendInsert( aRange );
//STRIP001 /*?*/ 		nEndChangeAction = pChangeTrack->GetActionMax();
/*N*/ 	}
/*N*/ 	else
/*N*/ 		nEndChangeAction = 0;
/*N*/ }

//STRIP001 void __EXPORT ScUndoInsertTab::Undo()
//STRIP001 {
//STRIP001 	ScTabViewShell* pViewShell = ScTabViewShell::GetActiveViewShell();
//STRIP001 	pViewShell->SetTabNo(nTab);
//STRIP001 
//STRIP001 	pDocShell->SetInUndo( TRUE );				//! BeginUndo
//STRIP001 	bDrawIsInUndo = TRUE;
//STRIP001 	pViewShell->DeleteTable( nTab, FALSE );
//STRIP001 	bDrawIsInUndo = FALSE;
//STRIP001 	pDocShell->SetInUndo( FALSE );				//! EndUndo
//STRIP001 
//STRIP001 	if (pDrawUndo)
//STRIP001 		DoSdrUndoAction( pDrawUndo );
//STRIP001 
//STRIP001 	ScChangeTrack* pChangeTrack = pDocShell->GetDocument()->GetChangeTrack();
//STRIP001 	if ( pChangeTrack )
//STRIP001 		pChangeTrack->Undo( nEndChangeAction, nEndChangeAction );
//STRIP001 
//STRIP001 	//	SetTabNo(...,TRUE) for all views to sync with drawing layer pages
//STRIP001 	pDocShell->Broadcast( SfxSimpleHint( SC_HINT_FORCESETTAB ) );
//STRIP001 }

//STRIP001 void __EXPORT ScUndoInsertTab::Redo()
//STRIP001 {
//STRIP001 	ScTabViewShell* pViewShell = ScTabViewShell::GetActiveViewShell();
//STRIP001 
//STRIP001 	if (pDrawUndo)
//STRIP001 		RedoSdrUndoAction( pDrawUndo );			// Draw Redo vorneweg
//STRIP001 
//STRIP001 	pDocShell->SetInUndo( TRUE );				//! BeginRedo
//STRIP001 	bDrawIsInUndo = TRUE;
//STRIP001 	if (bAppend)
//STRIP001 		pViewShell->AppendTable( sNewName, FALSE );
//STRIP001 	else
//STRIP001 	{
//STRIP001 		pViewShell->SetTabNo(nTab);
//STRIP001 		pViewShell->InsertTable( sNewName, nTab, FALSE );
//STRIP001 	}
//STRIP001 	bDrawIsInUndo = FALSE;
//STRIP001 	pDocShell->SetInUndo( FALSE );				//! EndRedo
//STRIP001 
//STRIP001 	SetChangeTrack();
//STRIP001 }

//STRIP001 void __EXPORT ScUndoInsertTab::Repeat(SfxRepeatTarget& rTarget)
//STRIP001 {
//STRIP001 	if (rTarget.ISA(ScTabViewTarget))
//STRIP001 		((ScTabViewTarget&)rTarget).GetViewShell()->GetViewData()->GetDispatcher().
//STRIP001 			Execute(FID_INS_TABLE, SFX_CALLMODE_SLOT | SFX_CALLMODE_RECORD);
//STRIP001 }

/*N*/ BOOL __EXPORT ScUndoInsertTab::CanRepeat(SfxRepeatTarget& rTarget) const
/*N*/ {
/*N*/ 	return (rTarget.ISA(ScTabViewTarget));
/*N*/ }

// -----------------------------------------------------------------------
//
//		Tabellen einfuegen
//

//STRIP001 ScUndoInsertTables::ScUndoInsertTables( ScDocShell* pNewDocShell,
//STRIP001 										USHORT nTabNum,
//STRIP001 										BOOL bApp,SvStrings *pNewNameList) :
//STRIP001 	ScSimpleUndo( pNewDocShell ),
//STRIP001 	nTab( nTabNum ),
//STRIP001 	bAppend( bApp ),
//STRIP001 	pDrawUndo( NULL )
//STRIP001 {
//STRIP001 	pNameList =	pNewNameList;
//STRIP001 	pDrawUndo = GetSdrUndoAction( pDocShell->GetDocument() );
//STRIP001 
//STRIP001 	SetChangeTrack();
//STRIP001 }

//STRIP001 __EXPORT ScUndoInsertTables::~ScUndoInsertTables()
//STRIP001 {
//STRIP001 	String *pStr=NULL;
//STRIP001 	if(pNameList!=NULL)
//STRIP001 	{
//STRIP001 		for(int i=0;i<pNameList->Count();i++)
//STRIP001 		{
//STRIP001 			pStr=pNameList->GetObject(i);
//STRIP001 			delete pStr;
//STRIP001 		}
//STRIP001 		pNameList->Remove(0,pNameList->Count());
//STRIP001 		delete pNameList;
//STRIP001 	}
//STRIP001 	DeleteSdrUndoAction( pDrawUndo );
//STRIP001 }

//STRIP001 String __EXPORT ScUndoInsertTables::GetComment() const
//STRIP001 {
//STRIP001 	return ScGlobal::GetRscString( STR_UNDO_INSERT_TAB );
//STRIP001 }

//STRIP001 void ScUndoInsertTables::SetChangeTrack()
//STRIP001 {
//STRIP001 	ScChangeTrack* pChangeTrack = pDocShell->GetDocument()->GetChangeTrack();
//STRIP001 	if ( pChangeTrack )
//STRIP001 	{
//STRIP001 		nStartChangeAction = pChangeTrack->GetActionMax() + 1;
//STRIP001 		nEndChangeAction = 0;
//STRIP001 		ScRange aRange( 0, 0, nTab, MAXCOL, MAXROW, nTab );
//STRIP001 		for( int i = 0; i < pNameList->Count(); i++ )
//STRIP001 		{
//STRIP001 			aRange.aStart.SetTab( nTab + i );
//STRIP001 			aRange.aEnd.SetTab( nTab + i );
//STRIP001 			pChangeTrack->AppendInsert( aRange );
//STRIP001 			nEndChangeAction = pChangeTrack->GetActionMax();
//STRIP001 		}
//STRIP001 	}
//STRIP001 	else
//STRIP001 		nStartChangeAction = nEndChangeAction = 0;
//STRIP001 }

//STRIP001 void __EXPORT ScUndoInsertTables::Undo()
//STRIP001 {
//STRIP001 	ScTabViewShell* pViewShell = ScTabViewShell::GetActiveViewShell();
//STRIP001 	pViewShell->SetTabNo(nTab);
//STRIP001 
//STRIP001 	pDocShell->SetInUndo( TRUE );				//! BeginUndo
//STRIP001 	bDrawIsInUndo = TRUE;
//STRIP001 
//STRIP001 	SvUShorts TheTabs;
//STRIP001 	for(int i=0;i<pNameList->Count();i++)
//STRIP001 	{
//STRIP001 		TheTabs.Insert(nTab+i,TheTabs.Count());
//STRIP001 	}
//STRIP001 
//STRIP001 	pViewShell->DeleteTables( TheTabs, FALSE );
//STRIP001 	TheTabs.Remove(0,TheTabs.Count());
//STRIP001 
//STRIP001 	bDrawIsInUndo = FALSE;
//STRIP001 	pDocShell->SetInUndo( FALSE );				//! EndUndo
//STRIP001 
//STRIP001 	if (pDrawUndo)
//STRIP001 		DoSdrUndoAction( pDrawUndo );
//STRIP001 
//STRIP001 	ScChangeTrack* pChangeTrack = pDocShell->GetDocument()->GetChangeTrack();
//STRIP001 	if ( pChangeTrack )
//STRIP001 		pChangeTrack->Undo( nStartChangeAction, nEndChangeAction );
//STRIP001 
//STRIP001 	//	SetTabNo(...,TRUE) for all views to sync with drawing layer pages
//STRIP001 	pDocShell->Broadcast( SfxSimpleHint( SC_HINT_FORCESETTAB ) );
//STRIP001 }

//STRIP001 void __EXPORT ScUndoInsertTables::Redo()
//STRIP001 {
//STRIP001 	ScTabViewShell* pViewShell = ScTabViewShell::GetActiveViewShell();
//STRIP001 
//STRIP001 	if (pDrawUndo)
//STRIP001 		RedoSdrUndoAction( pDrawUndo );			// Draw Redo vorneweg
//STRIP001 
//STRIP001 	pDocShell->SetInUndo( TRUE );				//! BeginRedo
//STRIP001 	bDrawIsInUndo = TRUE;
//STRIP001 	pViewShell->SetTabNo(nTab);
//STRIP001 	pViewShell->InsertTables( pNameList, nTab,pNameList->Count(),FALSE );
//STRIP001 
//STRIP001 	bDrawIsInUndo = FALSE;
//STRIP001 	pDocShell->SetInUndo( FALSE );				//! EndRedo
//STRIP001 
//STRIP001 	SetChangeTrack();
//STRIP001 }

//STRIP001 void __EXPORT ScUndoInsertTables::Repeat(SfxRepeatTarget& rTarget)
//STRIP001 {
//STRIP001 	if (rTarget.ISA(ScTabViewTarget))
//STRIP001 		((ScTabViewTarget&)rTarget).GetViewShell()->GetViewData()->GetDispatcher().
//STRIP001 			Execute(FID_INS_TABLE, SFX_CALLMODE_SLOT | SFX_CALLMODE_RECORD);
//STRIP001 }

//STRIP001 BOOL __EXPORT ScUndoInsertTables::CanRepeat(SfxRepeatTarget& rTarget) const
//STRIP001 {
//STRIP001 	return (rTarget.ISA(ScTabViewTarget));
//STRIP001 }


//----------------------------------------------------------------------------------
//
//		Tabelle loeschen
//

//STRIP001 ScUndoDeleteTab::ScUndoDeleteTab( ScDocShell* pNewDocShell,const SvUShorts &aTab, //USHORT nNewTab,
//STRIP001 									ScDocument* pUndoDocument, ScRefUndoData* pRefData ) :
//STRIP001 	ScMoveUndo( pNewDocShell, pUndoDocument, pRefData, SC_UNDO_REFLAST )
//STRIP001 {
//STRIP001 		for(int i=0;i<aTab.Count();i++)
//STRIP001 			theTabs.Insert(aTab[i],theTabs.Count());
//STRIP001 
//STRIP001 		SetChangeTrack();
//STRIP001 }

//STRIP001 __EXPORT ScUndoDeleteTab::~ScUndoDeleteTab()
//STRIP001 {
//STRIP001 	theTabs.Remove(0,theTabs.Count());
//STRIP001 }

//STRIP001 String __EXPORT ScUndoDeleteTab::GetComment() const
//STRIP001 {
//STRIP001 	return ScGlobal::GetRscString( STR_UNDO_DELETE_TAB );
//STRIP001 }

//STRIP001 void ScUndoDeleteTab::SetChangeTrack()
//STRIP001 {
//STRIP001 	ScChangeTrack* pChangeTrack = pDocShell->GetDocument()->GetChangeTrack();
//STRIP001 	if ( pChangeTrack )
//STRIP001 	{
//STRIP001 		ULONG nTmpChangeAction;
//STRIP001 		nStartChangeAction = pChangeTrack->GetActionMax() + 1;
//STRIP001 		nEndChangeAction = 0;
//STRIP001 		ScRange aRange( 0, 0, 0, MAXCOL, MAXROW, 0 );
//STRIP001 		for ( int i = 0; i < theTabs.Count(); i++ )
//STRIP001 		{
//STRIP001 			aRange.aStart.SetTab( theTabs[i] );
//STRIP001 			aRange.aEnd.SetTab( theTabs[i] );
//STRIP001 			pChangeTrack->AppendDeleteRange( aRange, pRefUndoDoc,
//STRIP001 				nTmpChangeAction, nEndChangeAction, (short) i );
//STRIP001 		}
//STRIP001 	}
//STRIP001 	else
//STRIP001 		nStartChangeAction = nEndChangeAction = 0;
//STRIP001 }

//STRIP001 USHORT lcl_GetVisibleTabBefore( ScDocument& rDoc, USHORT nTab )
//STRIP001 {
//STRIP001 	while ( nTab > 0 && !rDoc.IsVisible( nTab ) )
//STRIP001 		--nTab;
//STRIP001 
//STRIP001 	return nTab;
//STRIP001 }

//STRIP001 void __EXPORT ScUndoDeleteTab::Undo()
//STRIP001 {
//STRIP001 	BeginUndo();
//STRIP001 	int i=0;
//STRIP001 	ScDocument* pDoc = pDocShell->GetDocument();
//STRIP001 
//STRIP001 	BOOL bLink = FALSE;
//STRIP001 	String aName;
//STRIP001 
//STRIP001 	for(i=0;i<theTabs.Count();i++)
//STRIP001 	{
//STRIP001 		pRefUndoDoc->GetName( theTabs[i], aName );
//STRIP001 
//STRIP001 		bDrawIsInUndo = TRUE;
//STRIP001 		BOOL bOk = pDoc->InsertTab( theTabs[i], aName );
//STRIP001 		bDrawIsInUndo = FALSE;
//STRIP001 		if (bOk)
//STRIP001 		{
//STRIP001 			//	Ref-Undo passiert in EndUndo
//STRIP001 	//		pUndoDoc->UndoToDocument(0,0,nTab, MAXCOL,MAXROW,nTab, IDF_ALL,FALSE, pDoc );
//STRIP001 			pRefUndoDoc->CopyToDocument(0,0,theTabs[i], MAXCOL,MAXROW,theTabs[i], IDF_ALL,FALSE, pDoc );
//STRIP001 
//STRIP001 			String aOldName;
//STRIP001 			pRefUndoDoc->GetName( theTabs[i], aOldName );
//STRIP001 			pDoc->RenameTab( theTabs[i], aOldName, FALSE );
//STRIP001 			if (pRefUndoDoc->IsLinked(theTabs[i]))
//STRIP001 			{
//STRIP001 				pDoc->SetLink( theTabs[i], pRefUndoDoc->GetLinkMode(theTabs[i]), pRefUndoDoc->GetLinkDoc(theTabs[i]),
//STRIP001 									pRefUndoDoc->GetLinkFlt(theTabs[i]), pRefUndoDoc->GetLinkOpt(theTabs[i]),
//STRIP001 									pRefUndoDoc->GetLinkTab(theTabs[i]), pRefUndoDoc->GetLinkRefreshDelay(theTabs[i]) );
//STRIP001 				bLink = TRUE;
//STRIP001 			}
//STRIP001 
//STRIP001 			if ( pRefUndoDoc->IsScenario(theTabs[i]) )
//STRIP001 			{
//STRIP001 				pDoc->SetScenario( theTabs[i], TRUE );
//STRIP001 				String aComment;
//STRIP001 				Color  aColor;
//STRIP001 				USHORT nScenFlags;
//STRIP001 				pRefUndoDoc->GetScenarioData( theTabs[i], aComment, aColor, nScenFlags );
//STRIP001 				pDoc->SetScenarioData( theTabs[i], aComment, aColor, nScenFlags );
//STRIP001 				BOOL bActive = pRefUndoDoc->IsActiveScenario( theTabs[i] );
//STRIP001 				pDoc->SetActiveScenario( theTabs[i], bActive );
//STRIP001 			}
//STRIP001 			pDoc->SetVisible( theTabs[i], pRefUndoDoc->IsVisible( theTabs[i] ) );
//STRIP001 
//STRIP001 			if ( pRefUndoDoc->IsTabProtected( theTabs[i] ) )
//STRIP001 				pDoc->SetTabProtection( theTabs[i], TRUE, pRefUndoDoc->GetTabPassword( theTabs[i] ) );
//STRIP001 
//STRIP001 			//	Drawing-Layer passiert beim MoveUndo::EndUndo
//STRIP001 	//		pDoc->TransferDrawPage(pRefUndoDoc, nTab,nTab);
//STRIP001 		}
//STRIP001 	}
//STRIP001 	if (bLink)
//STRIP001 	{
//STRIP001 		pDocShell->UpdateLinks();				// Link-Manager updaten
//STRIP001 	}
//STRIP001 
//STRIP001 	EndUndo();		// Draw-Undo muss vor dem Broadcast kommen!
//STRIP001 
//STRIP001 	ScChangeTrack* pChangeTrack = pDocShell->GetDocument()->GetChangeTrack();
//STRIP001 	if ( pChangeTrack )
//STRIP001 		pChangeTrack->Undo( nStartChangeAction, nEndChangeAction );
//STRIP001 
//STRIP001 	for(i=0;i<theTabs.Count();i++)
//STRIP001 	{
//STRIP001 		pDocShell->Broadcast( ScTablesHint( SC_TAB_INSERTED, theTabs[i]) );
//STRIP001 	}
//STRIP001 	SFX_APP()->Broadcast( SfxSimpleHint( SC_HINT_TABLES_CHANGED ) );	// Navigator
//STRIP001 
//STRIP001 	pDocShell->PostPaint(0,0,0, MAXCOL,MAXROW,MAXTAB, PAINT_ALL );	// incl. Extras
//STRIP001 
//STRIP001 	//	nicht ShowTable wegen SetTabNo(..., TRUE):
//STRIP001 	ScTabViewShell* pViewShell = ScTabViewShell::GetActiveViewShell();
//STRIP001 	if (pViewShell)
//STRIP001 		pViewShell->SetTabNo( lcl_GetVisibleTabBefore( *pDoc, theTabs[0] ), TRUE );
//STRIP001 
//STRIP001 //	EndUndo();
//STRIP001 }

//STRIP001 void __EXPORT ScUndoDeleteTab::Redo()
//STRIP001 {
//STRIP001 	ScTabViewShell* pViewShell = ScTabViewShell::GetActiveViewShell();
//STRIP001 	pViewShell->SetTabNo( lcl_GetVisibleTabBefore( *pDocShell->GetDocument(), theTabs[0] ) );
//STRIP001 
//STRIP001 	if (pDrawUndo)
//STRIP001 		RedoSdrUndoAction( pDrawUndo );			// Draw Redo vorneweg
//STRIP001 
//STRIP001 	pDocShell->SetInUndo( TRUE );				//! BeginRedo
//STRIP001 	bDrawIsInUndo = TRUE;
//STRIP001 	pViewShell->DeleteTables( theTabs, FALSE );
//STRIP001 	bDrawIsInUndo = FALSE;
//STRIP001 	pDocShell->SetInUndo( TRUE );				//! EndRedo
//STRIP001 
//STRIP001 	SetChangeTrack();
//STRIP001 
//STRIP001 	//	SetTabNo(...,TRUE) for all views to sync with drawing layer pages
//STRIP001 	pDocShell->Broadcast( SfxSimpleHint( SC_HINT_FORCESETTAB ) );
//STRIP001 }

//STRIP001 void __EXPORT ScUndoDeleteTab::Repeat(SfxRepeatTarget& rTarget)
//STRIP001 {
//STRIP001 	if (rTarget.ISA(ScTabViewTarget))
//STRIP001 	{
//STRIP001 		ScTabViewShell* pViewShell = ((ScTabViewTarget&)rTarget).GetViewShell();
//STRIP001 		pViewShell->DeleteTable( pViewShell->GetViewData()->GetTabNo(), TRUE );
//STRIP001 	}
//STRIP001 }

//STRIP001 BOOL __EXPORT ScUndoDeleteTab::CanRepeat(SfxRepeatTarget& rTarget) const
//STRIP001 {
//STRIP001 	return (rTarget.ISA(ScTabViewTarget));
//STRIP001 }


//---------------------------------------------------------------------------------
//
//		Tabelle umbenennen
//

/*N*/ ScUndoRenameTab::ScUndoRenameTab( ScDocShell* pNewDocShell,
/*N*/ 								  USHORT nT,
/*N*/ 								  const String& rOldName,
/*N*/ 								  const String& rNewName) :
/*N*/ 	ScSimpleUndo( pNewDocShell ),
/*N*/ 	nTab 	 ( nT )
/*N*/ {
/*N*/ 	sOldName = rOldName;
/*N*/ 	sNewName = rNewName;
/*N*/ }

/*N*/ __EXPORT ScUndoRenameTab::~ScUndoRenameTab()
/*N*/ {
/*N*/ }

/*N*/ String __EXPORT ScUndoRenameTab::GetComment() const
/*N*/ {
/*N*/ 	return ScGlobal::GetRscString( STR_UNDO_RENAME_TAB );
/*N*/ }

//STRIP001 void ScUndoRenameTab::DoChange( USHORT nTab, const String& rName ) const
//STRIP001 {
//STRIP001 	ScDocument* pDoc = pDocShell->GetDocument();
//STRIP001 	pDoc->RenameTab( nTab, rName );
//STRIP001 
//STRIP001 	SFX_APP()->Broadcast( SfxSimpleHint( SC_HINT_TABLES_CHANGED ) );	// Navigator
//STRIP001 
//STRIP001 	pDocShell->PostPaintGridAll();
//STRIP001 	pDocShell->PostPaintExtras();
//STRIP001 	pDocShell->PostDataChanged();
//STRIP001 
//STRIP001 	//	Der Tabellenname koennte in einer Formel vorkommen...
//STRIP001 	ScTabViewShell* pViewShell = ScTabViewShell::GetActiveViewShell();
//STRIP001 	if (pViewShell)
//STRIP001 		pViewShell->UpdateInputHandler();
//STRIP001 }

//STRIP001 void __EXPORT ScUndoRenameTab::Undo()
//STRIP001 {
//STRIP001 	DoChange(nTab, sOldName);
//STRIP001 }

//STRIP001 void __EXPORT ScUndoRenameTab::Redo()
//STRIP001 {
//STRIP001 	DoChange(nTab, sNewName);
//STRIP001 }

//STRIP001 void __EXPORT ScUndoRenameTab::Repeat(SfxRepeatTarget& rTarget)
//STRIP001 {
//STRIP001 	//	Repeat macht keinen Sinn
//STRIP001 }

/*N*/ BOOL __EXPORT ScUndoRenameTab::CanRepeat(SfxRepeatTarget& rTarget) const
/*N*/ {
/*N*/ 	return FALSE;
/*N*/ }


//----------------------------------------------------------------------------------
//
//		Tabelle verschieben
//

//STRIP001 ScUndoMoveTab::ScUndoMoveTab( ScDocShell* pNewDocShell,
//STRIP001 								  const SvUShorts &aOldTab,
//STRIP001 								  const SvUShorts &aNewTab) :
//STRIP001 	ScSimpleUndo( pNewDocShell )
//STRIP001 {
//STRIP001 	int i;
//STRIP001 	for(i=0;i<aOldTab.Count();i++)
//STRIP001 			theOldTabs.Insert(aOldTab[i],theOldTabs.Count());
//STRIP001 
//STRIP001 	for(i=0;i<aNewTab.Count();i++)
//STRIP001 			theNewTabs.Insert(aNewTab[i],theNewTabs.Count());
//STRIP001 }

//STRIP001 __EXPORT ScUndoMoveTab::~ScUndoMoveTab()
//STRIP001 {
//STRIP001 	theNewTabs.Remove(0,theNewTabs.Count());
//STRIP001 	theOldTabs.Remove(0,theOldTabs.Count());
//STRIP001 }

//STRIP001 String __EXPORT ScUndoMoveTab::GetComment() const
//STRIP001 {
//STRIP001 	return ScGlobal::GetRscString( STR_UNDO_MOVE_TAB );
//STRIP001 }

//STRIP001 void ScUndoMoveTab::DoChange( BOOL bUndo ) const
//STRIP001 {
//STRIP001 	ScDocument* pDoc = pDocShell->GetDocument();
//STRIP001 	ScTabViewShell* pViewShell = ScTabViewShell::GetActiveViewShell();
//STRIP001 
//STRIP001 	if (bUndo)										// UnDo
//STRIP001 	{
//STRIP001 		for(int i=theNewTabs.Count()-1;i>=0;i--)
//STRIP001 		{
//STRIP001 			USHORT nDestTab = theNewTabs[i];
//STRIP001 			USHORT nNewTab = theNewTabs[i];
//STRIP001 			USHORT nOldTab = theOldTabs[i];
//STRIP001 			if (nDestTab > MAXCOL)							// angehaengt ?
//STRIP001 				nDestTab = pDoc->GetTableCount() - 1;
//STRIP001 
//STRIP001 			pDoc->MoveTab( nDestTab, nOldTab );
//STRIP001 			pViewShell->GetViewData()->MoveTab( nDestTab, nOldTab );
//STRIP001 			pViewShell->SetTabNo( nOldTab, TRUE );
//STRIP001 		}
//STRIP001 	}
//STRIP001 	else
//STRIP001 	{
//STRIP001 		for(int i=0;i<theNewTabs.Count();i++)
//STRIP001 		{
//STRIP001 			USHORT nDestTab = theNewTabs[i];
//STRIP001 			USHORT nNewTab = theNewTabs[i];
//STRIP001 			USHORT nOldTab = theOldTabs[i];
//STRIP001 			if (nDestTab > MAXCOL)							// angehaengt ?
//STRIP001 				nDestTab = pDoc->GetTableCount() - 1;
//STRIP001 
//STRIP001 			pDoc->MoveTab( nOldTab, nNewTab );
//STRIP001 			pViewShell->GetViewData()->MoveTab( nOldTab, nNewTab );
//STRIP001 			pViewShell->SetTabNo( nDestTab, TRUE );
//STRIP001 		}
//STRIP001 	}
//STRIP001 
//STRIP001 	SFX_APP()->Broadcast( SfxSimpleHint( SC_HINT_TABLES_CHANGED ) );	// Navigator
//STRIP001 
//STRIP001 	pDocShell->PostPaintGridAll();
//STRIP001 	pDocShell->PostPaintExtras();
//STRIP001 	pDocShell->PostDataChanged();
//STRIP001 }

//STRIP001 void __EXPORT ScUndoMoveTab::Undo()
//STRIP001 {
//STRIP001 	DoChange( TRUE );
//STRIP001 }

//STRIP001 void __EXPORT ScUndoMoveTab::Redo()
//STRIP001 {
//STRIP001 	DoChange( FALSE );
//STRIP001 }

//STRIP001 void __EXPORT ScUndoMoveTab::Repeat(SfxRepeatTarget& rTarget)
//STRIP001 {
//STRIP001 		// kein Repeat ! ? !
//STRIP001 }

//STRIP001 BOOL __EXPORT ScUndoMoveTab::CanRepeat(SfxRepeatTarget& rTarget) const
//STRIP001 {
//STRIP001 	return FALSE;
//STRIP001 }


//----------------------------------------------------------------------------------
//
//		Tabelle kopieren
//

//STRIP001 ScUndoCopyTab::ScUndoCopyTab( ScDocShell* pNewDocShell,
//STRIP001 								  const SvUShorts &aOldTab,
//STRIP001 								  const SvUShorts &aNewTab) :
//STRIP001 	ScSimpleUndo( pNewDocShell ),
//STRIP001 	pDrawUndo( NULL )
//STRIP001 {
//STRIP001 	pDrawUndo = GetSdrUndoAction( pDocShell->GetDocument() );
//STRIP001 
//STRIP001 	int i;
//STRIP001 	for(i=0;i<aOldTab.Count();i++)
//STRIP001 			theOldTabs.Insert(aOldTab[i],theOldTabs.Count());
//STRIP001 
//STRIP001 	for(i=0;i<aNewTab.Count();i++)
//STRIP001 			theNewTabs.Insert(aNewTab[i],theNewTabs.Count());
//STRIP001 }

//STRIP001 __EXPORT ScUndoCopyTab::~ScUndoCopyTab()
//STRIP001 {
//STRIP001 	DeleteSdrUndoAction( pDrawUndo );
//STRIP001 }

//STRIP001 String __EXPORT ScUndoCopyTab::GetComment() const
//STRIP001 {
//STRIP001 	return ScGlobal::GetRscString( STR_UNDO_COPY_TAB );
//STRIP001 }

//STRIP001 void ScUndoCopyTab::DoChange() const
//STRIP001 {
//STRIP001 	ScTabViewShell* pViewShell = ScTabViewShell::GetActiveViewShell();
//STRIP001 
//STRIP001 	if (pViewShell)
//STRIP001 		pViewShell->SetTabNo(theOldTabs[0],TRUE);
//STRIP001 
//STRIP001 	SFX_APP()->Broadcast( SfxSimpleHint( SC_HINT_TABLES_CHANGED ) );	// Navigator
//STRIP001 
//STRIP001 	pDocShell->PostPaintGridAll();
//STRIP001 	pDocShell->PostPaintExtras();
//STRIP001 	pDocShell->PostDataChanged();
//STRIP001 }

//STRIP001 void __EXPORT ScUndoCopyTab::Undo()
//STRIP001 {
//STRIP001 	ScDocument* pDoc = pDocShell->GetDocument();
//STRIP001 
//STRIP001 	if (pDrawUndo)
//STRIP001 		DoSdrUndoAction( pDrawUndo );					// before the sheets are deleted
//STRIP001 
//STRIP001 	int i;
//STRIP001 	for(i=theNewTabs.Count()-1;i>=0;i--)
//STRIP001 	{
//STRIP001 		USHORT nDestTab = theNewTabs[i];
//STRIP001 		if (nDestTab > MAXTAB)							// append?
//STRIP001 			nDestTab = pDoc->GetTableCount() - 1;
//STRIP001 
//STRIP001 		bDrawIsInUndo = TRUE;
//STRIP001 		pDoc->DeleteTab(nDestTab);
//STRIP001 		bDrawIsInUndo = FALSE;
//STRIP001 	}
//STRIP001 
//STRIP001 	//	ScTablesHint broadcasts after all sheets have been deleted,
//STRIP001 	//	so sheets and draw pages are in sync!
//STRIP001 
//STRIP001 	for(i=theNewTabs.Count()-1;i>=0;i--)
//STRIP001 	{
//STRIP001 		USHORT nDestTab = theNewTabs[i];
//STRIP001 		if (nDestTab > MAXTAB)							// append?
//STRIP001 			nDestTab = pDoc->GetTableCount() - 1;
//STRIP001 
//STRIP001 		pDocShell->Broadcast( ScTablesHint( SC_TAB_DELETED, nDestTab ) );
//STRIP001 	}
//STRIP001 
//STRIP001 	DoChange();
//STRIP001 }

//STRIP001 void __EXPORT ScUndoCopyTab::Redo()
//STRIP001 {
//STRIP001 	ScDocument* pDoc = pDocShell->GetDocument();
//STRIP001 	ScTabViewShell* pViewShell = ScTabViewShell::GetActiveViewShell();
//STRIP001 
//STRIP001 	USHORT nDestTab = 0;
//STRIP001 	for(int i=0;i<theNewTabs.Count();i++)
//STRIP001 	{
//STRIP001 		nDestTab = theNewTabs[i];
//STRIP001 		USHORT nNewTab = theNewTabs[i];
//STRIP001 		USHORT nOldTab = theOldTabs[i];
//STRIP001 		if (nDestTab > MAXCOL)							// angehaengt ?
//STRIP001 			nDestTab = pDoc->GetTableCount() - 1;
//STRIP001 
//STRIP001 		bDrawIsInUndo = TRUE;
//STRIP001 		pDoc->CopyTab( nOldTab, nNewTab );
//STRIP001 		bDrawIsInUndo = FALSE;
//STRIP001 
//STRIP001 		pViewShell->GetViewData()->MoveTab( nOldTab, nNewTab );
//STRIP001 
//STRIP001 		USHORT nAdjSource = nOldTab;
//STRIP001 		if ( nNewTab <= nOldTab )
//STRIP001 			++nAdjSource;				// new position of source table after CopyTab
//STRIP001 
//STRIP001 		if ( pDoc->IsScenario(nAdjSource) )
//STRIP001 		{
//STRIP001 			pDoc->SetScenario(nNewTab, TRUE );
//STRIP001 			String aComment;
//STRIP001 			Color  aColor;
//STRIP001 			USHORT nScenFlags;
//STRIP001 			pDoc->GetScenarioData(nAdjSource, aComment, aColor, nScenFlags );
//STRIP001 			pDoc->SetScenarioData(nNewTab, aComment, aColor, nScenFlags );
//STRIP001 			BOOL bActive = pDoc->IsActiveScenario(nAdjSource);
//STRIP001 			pDoc->SetActiveScenario(nNewTab, bActive );
//STRIP001 			BOOL bVisible=pDoc->IsVisible(nAdjSource);
//STRIP001 			pDoc->SetVisible(nNewTab,bVisible );
//STRIP001 		}
//STRIP001 
//STRIP001 		if ( pDoc->IsTabProtected( nAdjSource ) )
//STRIP001 			pDoc->SetTabProtection( nNewTab, TRUE, pDoc->GetTabPassword( nAdjSource ) );
//STRIP001 	}
//STRIP001 
//STRIP001 	if (pDrawUndo)
//STRIP001 		RedoSdrUndoAction( pDrawUndo );			// after the sheets are inserted
//STRIP001 
//STRIP001 	pViewShell->SetTabNo( nDestTab, TRUE );		// after draw-undo
//STRIP001 
//STRIP001 	DoChange();
//STRIP001 
//STRIP001 }

//STRIP001 void __EXPORT ScUndoCopyTab::Repeat(SfxRepeatTarget& rTarget)
//STRIP001 {
//STRIP001 		// kein Repeat ! ? !
//STRIP001 }

//STRIP001 BOOL __EXPORT ScUndoCopyTab::CanRepeat(SfxRepeatTarget& rTarget) const
//STRIP001 {
//STRIP001 	return FALSE;
//STRIP001 }


// -----------------------------------------------------------------------
//
//		Szenario anlegen
//

//STRIP001 ScUndoMakeScenario::ScUndoMakeScenario( ScDocShell* pNewDocShell,
//STRIP001 						USHORT nSrc, USHORT nDest, ScDocument* pUndo,
//STRIP001 						const String& rN, const String& rC,
//STRIP001 						const Color& rCol, USHORT nF,
//STRIP001 						const ScMarkData& rMark ) :
//STRIP001 	ScSimpleUndo( pNewDocShell ),
//STRIP001 	nSrcTab( nSrc ),
//STRIP001 	nDestTab( nDest ),
//STRIP001 	pUndoDoc( pUndo ),
//STRIP001 	aName( rN ),
//STRIP001 	aComment( rC ),
//STRIP001 	aColor( rCol ),
//STRIP001 	nFlags( nF ),
//STRIP001 	aMarkData( rMark )
//STRIP001 {
//STRIP001 }

//STRIP001 __EXPORT ScUndoMakeScenario::~ScUndoMakeScenario()
//STRIP001 {
//STRIP001 	delete pUndoDoc;
//STRIP001 }

//STRIP001 String __EXPORT ScUndoMakeScenario::GetComment() const
//STRIP001 {
//STRIP001 	return ScGlobal::GetRscString( STR_UNDO_MAKESCENARIO );
//STRIP001 }

//STRIP001 void __EXPORT ScUndoMakeScenario::Undo()
//STRIP001 {
//STRIP001 	ScDocument* pDoc = pDocShell->GetDocument();
//STRIP001 	pDoc->DeleteTab( nDestTab );
//STRIP001 	pDocShell->PostPaint(0,0,nDestTab,MAXCOL,MAXROW,MAXTAB, PAINT_ALL);
//STRIP001 	pDocShell->PostDataChanged();
//STRIP001 
//STRIP001 	ScTabViewShell* pViewShell = ScTabViewShell::GetActiveViewShell();
//STRIP001 	if (pViewShell)
//STRIP001 		pViewShell->SetTabNo( nSrcTab, TRUE );
//STRIP001 
//STRIP001 	SFX_APP()->Broadcast( SfxSimpleHint( SC_HINT_TABLES_CHANGED ) );
//STRIP001 }

//STRIP001 void __EXPORT ScUndoMakeScenario::Redo()
//STRIP001 {
//STRIP001 	ScTabViewShell* pViewShell = ScTabViewShell::GetActiveViewShell();
//STRIP001 	if (pViewShell)
//STRIP001 	{
//STRIP001 		pViewShell->DoneBlockMode();
//STRIP001 		pViewShell->InitOwnBlockMode();
//STRIP001 		pViewShell->GetViewData()->GetMarkData() = aMarkData;	// CopyMarksTo
//STRIP001 	}
//STRIP001 
//STRIP001 	pDocShell->MakeScenario( nSrcTab, aName, aComment, aColor, nFlags, aMarkData, FALSE );
//STRIP001 
//STRIP001 	if (pViewShell)
//STRIP001 		pViewShell->SetTabNo( nDestTab, TRUE );
//STRIP001 
//STRIP001 	SFX_APP()->Broadcast( SfxSimpleHint( SC_HINT_TABLES_CHANGED ) );
//STRIP001 }

//STRIP001 void __EXPORT ScUndoMakeScenario::Repeat(SfxRepeatTarget& rTarget)
//STRIP001 {
//STRIP001 	if (rTarget.ISA(ScTabViewTarget))
//STRIP001 	{
//STRIP001 		((ScTabViewTarget&)rTarget).GetViewShell()->MakeScenario( aName, aComment, aColor, nFlags );
//STRIP001 	}
//STRIP001 }

//STRIP001 BOOL __EXPORT ScUndoMakeScenario::CanRepeat(SfxRepeatTarget& rTarget) const
//STRIP001 {
//STRIP001 	return (rTarget.ISA(ScTabViewTarget));
//STRIP001 }


// -----------------------------------------------------------------------
//
//		Tabelle einfuegen
//

//STRIP001 ScUndoImportTab::ScUndoImportTab( ScDocShell* pShell,
//STRIP001 						USHORT nNewTab, USHORT nNewCount, BOOL bNewLink ) :
//STRIP001 	ScSimpleUndo( pShell ),
//STRIP001 	nTab( nNewTab ),
//STRIP001 	nCount( nNewCount ),
//STRIP001 	bLink( bNewLink ),
//STRIP001 	pRedoDoc( NULL ),
//STRIP001 	pDrawUndo( NULL )
//STRIP001 {
//STRIP001 	pDrawUndo = GetSdrUndoAction( pDocShell->GetDocument() );
//STRIP001 }

//STRIP001 __EXPORT ScUndoImportTab::~ScUndoImportTab()
//STRIP001 {
//STRIP001 	delete pRedoDoc;
//STRIP001 	DeleteSdrUndoAction( pDrawUndo );
//STRIP001 }

//STRIP001 String __EXPORT ScUndoImportTab::GetComment() const
//STRIP001 {
//STRIP001 	return ScGlobal::GetRscString( STR_UNDO_INSERT_TAB );
//STRIP001 }

//STRIP001 void ScUndoImportTab::DoChange() const
//STRIP001 {
//STRIP001 	ScTabViewShell* pViewShell = ScTabViewShell::GetActiveViewShell();
//STRIP001 	ScDocument* pDoc = pDocShell->GetDocument();
//STRIP001 	USHORT nCount = pDoc->GetTableCount();
//STRIP001 	if (pViewShell)
//STRIP001 	{
//STRIP001 		if(nTab<nCount)
//STRIP001 		{
//STRIP001 			pViewShell->SetTabNo(nTab,TRUE);
//STRIP001 		}
//STRIP001 		else
//STRIP001 		{
//STRIP001 			pViewShell->SetTabNo(nTab-1,TRUE);
//STRIP001 		}
//STRIP001 	}
//STRIP001 
//STRIP001 	SFX_APP()->Broadcast( SfxSimpleHint( SC_HINT_TABLES_CHANGED ) );	// Navigator
//STRIP001 	pDocShell->PostPaint( 0,0,0, MAXCOL,MAXROW,MAXTAB,
//STRIP001 								PAINT_GRID | PAINT_TOP | PAINT_LEFT | PAINT_EXTRAS );
//STRIP001 }

//STRIP001 void __EXPORT ScUndoImportTab::Undo()
//STRIP001 {
//STRIP001 	//!	eingefuegte Bereichsnamen etc.
//STRIP001 
//STRIP001 	USHORT i;
//STRIP001 	ScDocument* pDoc = pDocShell->GetDocument();
//STRIP001 	BOOL bMakeRedo = !pRedoDoc;
//STRIP001 	if (bMakeRedo)
//STRIP001 	{
//STRIP001 		pRedoDoc = new ScDocument( SCDOCMODE_UNDO );
//STRIP001 		pRedoDoc->InitUndo( pDoc, nTab,nTab+nCount-1, TRUE,TRUE );
//STRIP001 
//STRIP001 		String aOldName;
//STRIP001 		for (i=0; i<nCount; i++)
//STRIP001 		{
//STRIP001 			USHORT nTabPos=nTab+i;
//STRIP001 
//STRIP001 			pDoc->CopyToDocument(0,0,nTabPos, MAXCOL,MAXROW,nTabPos, IDF_ALL,FALSE, pRedoDoc );
//STRIP001 			pDoc->GetName( nTabPos, aOldName );
//STRIP001 			pRedoDoc->RenameTab( nTabPos, aOldName, FALSE );
//STRIP001 
//STRIP001 			if ( pDoc->IsScenario(nTabPos) )
//STRIP001 			{
//STRIP001 				pRedoDoc->SetScenario(nTabPos, TRUE );
//STRIP001 				String aComment;
//STRIP001 				Color  aColor;
//STRIP001 				USHORT nScenFlags;
//STRIP001 				pDoc->GetScenarioData(nTabPos, aComment, aColor, nScenFlags );
//STRIP001 				pRedoDoc->SetScenarioData(nTabPos, aComment, aColor, nScenFlags );
//STRIP001 				BOOL bActive = pDoc->IsActiveScenario(nTabPos);
//STRIP001 				pRedoDoc->SetActiveScenario(nTabPos, bActive );
//STRIP001 				BOOL bVisible=pDoc->IsVisible(nTabPos);
//STRIP001 				pRedoDoc->SetVisible(nTabPos,bVisible );
//STRIP001 			}
//STRIP001 
//STRIP001 			if ( pDoc->IsTabProtected( nTabPos ) )
//STRIP001 				pRedoDoc->SetTabProtection( nTabPos, TRUE, pDoc->GetTabPassword( nTabPos ) );
//STRIP001 		}
//STRIP001 
//STRIP001 	}
//STRIP001 
//STRIP001 	if (pDrawUndo)
//STRIP001 		DoSdrUndoAction( pDrawUndo );					// before the sheets are deleted
//STRIP001 
//STRIP001 	bDrawIsInUndo = TRUE;
//STRIP001 	for (i=0; i<nCount; i++)
//STRIP001 		pDoc->DeleteTab( nTab );
//STRIP001 	bDrawIsInUndo = FALSE;
//STRIP001 
//STRIP001 	DoChange();
//STRIP001 }

//STRIP001 void __EXPORT ScUndoImportTab::Redo()
//STRIP001 {
//STRIP001 	if (!pRedoDoc)
//STRIP001 	{
//STRIP001 		DBG_ERROR("wo ist mein Redo-Document?");
//STRIP001 		return;
//STRIP001 	}
//STRIP001 
//STRIP001 	ScDocument* pDoc = pDocShell->GetDocument();
//STRIP001 	String aName;
//STRIP001 	USHORT i;
//STRIP001 	for (i=0; i<nCount; i++)				// first insert all sheets (#63304#)
//STRIP001 	{
//STRIP001 		USHORT nTabPos=nTab+i;
//STRIP001 		pRedoDoc->GetName(nTabPos,aName);
//STRIP001 		bDrawIsInUndo = TRUE;
//STRIP001 		pDoc->InsertTab(nTabPos,aName);
//STRIP001 		bDrawIsInUndo = FALSE;
//STRIP001 	}
//STRIP001 	for (i=0; i<nCount; i++)				// then copy into inserted sheets
//STRIP001 	{
//STRIP001 		USHORT nTabPos=nTab+i;
//STRIP001 		pRedoDoc->CopyToDocument(0,0,nTabPos, MAXCOL,MAXROW,nTabPos, IDF_ALL,FALSE, pDoc );
//STRIP001 
//STRIP001 		if ( pRedoDoc->IsScenario(nTabPos) )
//STRIP001 		{
//STRIP001 			pDoc->SetScenario(nTabPos, TRUE );
//STRIP001 			String aComment;
//STRIP001 			Color  aColor;
//STRIP001 			USHORT nScenFlags;
//STRIP001 			pRedoDoc->GetScenarioData(nTabPos, aComment, aColor, nScenFlags );
//STRIP001 			pDoc->SetScenarioData(nTabPos, aComment, aColor, nScenFlags );
//STRIP001 			BOOL bActive = pRedoDoc->IsActiveScenario(nTabPos);
//STRIP001 			pDoc->SetActiveScenario(nTabPos, bActive );
//STRIP001 			BOOL bVisible=pRedoDoc->IsVisible(nTabPos);
//STRIP001 			pDoc->SetVisible(nTabPos,bVisible );
//STRIP001 		}
//STRIP001 
//STRIP001 		if ( pRedoDoc->IsTabProtected( nTabPos ) )
//STRIP001 			pDoc->SetTabProtection( nTabPos, TRUE, pRedoDoc->GetTabPassword( nTabPos ) );
//STRIP001 	}
//STRIP001 
//STRIP001 	if (pDrawUndo)
//STRIP001 		RedoSdrUndoAction( pDrawUndo );		// after the sheets are inserted
//STRIP001 
//STRIP001 	DoChange();
//STRIP001 }

//STRIP001 void __EXPORT ScUndoImportTab::Repeat(SfxRepeatTarget& rTarget)
//STRIP001 {
//STRIP001 	if (rTarget.ISA(ScTabViewTarget))
//STRIP001 		((ScTabViewTarget&)rTarget).GetViewShell()->GetViewData()->GetDispatcher().
//STRIP001 			Execute(FID_INS_TABLE, SFX_CALLMODE_SLOT | SFX_CALLMODE_RECORD);
//STRIP001 }

//STRIP001 BOOL __EXPORT ScUndoImportTab::CanRepeat(SfxRepeatTarget& rTarget) const
//STRIP001 {
//STRIP001 	return (rTarget.ISA(ScTabViewTarget));
//STRIP001 }


// -----------------------------------------------------------------------
//
//		Tabellen-Verknuepfung aufheben
//

//STRIP001 ScUndoRemoveLink::ScUndoRemoveLink( ScDocShell* pShell, const String& rDoc ) :
//STRIP001 	ScSimpleUndo( pShell ),
//STRIP001 	aDocName( rDoc ),
//STRIP001 	nCount( 0 )
//STRIP001 {
//STRIP001 	ScDocument* pDoc = pDocShell->GetDocument();
//STRIP001 	USHORT nTabCount = pDoc->GetTableCount();
//STRIP001 	pTabs	  = new USHORT[nTabCount];
//STRIP001 	pModes	  = new BYTE[nTabCount];
//STRIP001 	pTabNames = new String[nTabCount];
//STRIP001 
//STRIP001 	for (USHORT i=0; i<nTabCount; i++)
//STRIP001 	{
//STRIP001 		BYTE nMode = pDoc->GetLinkMode(i);
//STRIP001 		if (nMode)
//STRIP001 			if (pDoc->GetLinkDoc(i) == aDocName)
//STRIP001 			{
//STRIP001 				if (!nCount)
//STRIP001 				{
//STRIP001 					aFltName = pDoc->GetLinkFlt(i);
//STRIP001 					aOptions = pDoc->GetLinkOpt(i);
//STRIP001 					nRefreshDelay = pDoc->GetLinkRefreshDelay(i);
//STRIP001 				}
//STRIP001 				else
//STRIP001 					DBG_ASSERT(aFltName == pDoc->GetLinkFlt(i) &&
//STRIP001 							   aOptions == pDoc->GetLinkOpt(i),
//STRIP001 									"verschiedene Filter fuer ein Dokument?");
//STRIP001 				pTabs[nCount] = i;
//STRIP001 				pModes[nCount] = nMode;
//STRIP001 				pTabNames[nCount] = pDoc->GetLinkTab(i);
//STRIP001 				++nCount;
//STRIP001 			}
//STRIP001 	}
//STRIP001 }

//STRIP001 __EXPORT ScUndoRemoveLink::~ScUndoRemoveLink()
//STRIP001 {
//STRIP001 	delete pTabs;
//STRIP001 	delete pModes;
//STRIP001 	delete[] pTabNames;
//STRIP001 }

//STRIP001 String __EXPORT ScUndoRemoveLink::GetComment() const
//STRIP001 {
//STRIP001 	return ScGlobal::GetRscString( STR_UNDO_REMOVELINK );
//STRIP001 }

//STRIP001 void ScUndoRemoveLink::DoChange( BOOL bLink ) const
//STRIP001 {
//STRIP001 	ScDocument* pDoc = pDocShell->GetDocument();
//STRIP001 	String aEmpty;
//STRIP001 	for (USHORT i=0; i<nCount; i++)
//STRIP001 		if (bLink)		// establish link
//STRIP001 			pDoc->SetLink( pTabs[i], pModes[i], aDocName, aFltName, aOptions, pTabNames[i], nRefreshDelay );
//STRIP001 		else			// remove link
//STRIP001 			pDoc->SetLink( pTabs[i], SC_LINK_NONE, aEmpty, aEmpty, aEmpty, aEmpty, 0 );
//STRIP001 	pDocShell->UpdateLinks();
//STRIP001 }

//STRIP001 void __EXPORT ScUndoRemoveLink::Undo()
//STRIP001 {
//STRIP001 	DoChange( TRUE );
//STRIP001 }

//STRIP001 void __EXPORT ScUndoRemoveLink::Redo()
//STRIP001 {
//STRIP001 	DoChange( FALSE );
//STRIP001 }

//STRIP001 void __EXPORT ScUndoRemoveLink::Repeat(SfxRepeatTarget& rTarget)
//STRIP001 {
//STRIP001 	//	gippsnich
//STRIP001 }

//STRIP001 BOOL __EXPORT ScUndoRemoveLink::CanRepeat(SfxRepeatTarget& rTarget) const
//STRIP001 {
//STRIP001 	return FALSE;
//STRIP001 }


// -----------------------------------------------------------------------
//
//		Tabellen ein-/ausblenden
//

/*N*/ ScUndoShowHideTab::ScUndoShowHideTab( ScDocShell* pShell, USHORT nNewTab, BOOL bNewShow ) :
/*N*/ 	ScSimpleUndo( pShell ),
/*N*/ 	nTab( nNewTab ),
/*N*/ 	bShow( bNewShow )
/*N*/ {
/*N*/ }

/*N*/ __EXPORT ScUndoShowHideTab::~ScUndoShowHideTab()
/*N*/ {
/*N*/ }

//STRIP001 void ScUndoShowHideTab::DoChange( BOOL bShow ) const
//STRIP001 {
//STRIP001 	ScDocument* pDoc = pDocShell->GetDocument();
//STRIP001 	pDoc->SetVisible( nTab, bShow );
//STRIP001 
//STRIP001 	ScTabViewShell* pViewShell = ScTabViewShell::GetActiveViewShell();
//STRIP001 	if (pViewShell)
//STRIP001 		pViewShell->SetTabNo(nTab,TRUE);
//STRIP001 
//STRIP001 	SFX_APP()->Broadcast( SfxSimpleHint( SC_HINT_TABLES_CHANGED ) );
//STRIP001 	pDocShell->SetDocumentModified();
//STRIP001 }

//STRIP001 void __EXPORT ScUndoShowHideTab::Undo()
//STRIP001 {
//STRIP001 	DoChange(!bShow);
//STRIP001 }

//STRIP001 void __EXPORT ScUndoShowHideTab::Redo()
//STRIP001 {
//STRIP001 	DoChange(bShow);
//STRIP001 }

//STRIP001 void __EXPORT ScUndoShowHideTab::Repeat(SfxRepeatTarget& rTarget)
//STRIP001 {
//STRIP001 	if (rTarget.ISA(ScTabViewTarget))
//STRIP001 		((ScTabViewTarget&)rTarget).GetViewShell()->GetViewData()->GetDispatcher().
//STRIP001 			Execute( bShow ? FID_TABLE_SHOW : FID_TABLE_HIDE,
//STRIP001 								SFX_CALLMODE_SLOT | SFX_CALLMODE_RECORD);
//STRIP001 }

/*N*/ BOOL __EXPORT ScUndoShowHideTab::CanRepeat(SfxRepeatTarget& rTarget) const
/*N*/ {
/*N*/ 	return (rTarget.ISA(ScTabViewTarget));
/*N*/ }

/*N*/ String __EXPORT ScUndoShowHideTab::GetComment() const
/*N*/ {
/*N*/ 	USHORT nId = bShow ? STR_UNDO_SHOWTAB : STR_UNDO_HIDETAB;
/*N*/ 	return ScGlobal::GetRscString( nId );
/*N*/ }

// -----------------------------------------------------------------------
//
//		Tabelle/Dokument schuetzen oder Schutz aufheben
//

//STRIP001 ScUndoProtect::ScUndoProtect( ScDocShell* pShell, USHORT nNewTab,
//STRIP001 							BOOL bNewProtect, const uno::Sequence<sal_Int8>& rNewPassword ) :
//STRIP001 	ScSimpleUndo( pShell ),
//STRIP001 	nTab( nNewTab ),
//STRIP001 	bProtect( bNewProtect ),
//STRIP001 	aPassword( rNewPassword )
//STRIP001 {
//STRIP001 }

//STRIP001 __EXPORT ScUndoProtect::~ScUndoProtect()
//STRIP001 {
//STRIP001 }

//STRIP001 void ScUndoProtect::DoProtect( BOOL bDo )
//STRIP001 {
//STRIP001 	ScDocument* pDoc = pDocShell->GetDocument();
//STRIP001 
//STRIP001 	if (bDo)
//STRIP001 	{
//STRIP001 		if ( nTab == TABLEID_DOC )
//STRIP001 			pDoc->SetDocProtection( TRUE, aPassword );
//STRIP001 		else
//STRIP001 			pDoc->SetTabProtection( nTab, TRUE, aPassword );
//STRIP001 	}
//STRIP001 	else
//STRIP001 	{
//STRIP001 		uno::Sequence<sal_Int8> aEmptyPass;
//STRIP001 		if ( nTab == TABLEID_DOC )
//STRIP001 			pDoc->SetDocProtection( FALSE, aEmptyPass );
//STRIP001 		else
//STRIP001 			pDoc->SetTabProtection( nTab, FALSE, aEmptyPass );
//STRIP001 	}
//STRIP001 
//STRIP001 	ScTabViewShell* pViewShell = ScTabViewShell::GetActiveViewShell();
//STRIP001 	if (pViewShell)
//STRIP001 	{
//STRIP001 		pViewShell->UpdateLayerLocks();
//STRIP001 		pViewShell->UpdateInputHandler(TRUE);	// damit sofort wieder eingegeben werden kann
//STRIP001 	}
//STRIP001 
//STRIP001 	pDocShell->PostPaintGridAll();
//STRIP001 }

//STRIP001 void __EXPORT ScUndoProtect::Undo()
//STRIP001 {
//STRIP001 	BeginUndo();
//STRIP001 	DoProtect( !bProtect );
//STRIP001 	EndUndo();
//STRIP001 }

//STRIP001 void __EXPORT ScUndoProtect::Redo()
//STRIP001 {
//STRIP001 	BeginRedo();
//STRIP001 	DoProtect( bProtect );
//STRIP001 	EndRedo();
//STRIP001 }

//STRIP001 void __EXPORT ScUndoProtect::Repeat(SfxRepeatTarget& rTarget)
//STRIP001 {
//STRIP001 	//	gippsnich
//STRIP001 }

//STRIP001 BOOL __EXPORT ScUndoProtect::CanRepeat(SfxRepeatTarget& rTarget) const
//STRIP001 {
//STRIP001 	return FALSE;		// gippsnich
//STRIP001 }

//STRIP001 String __EXPORT ScUndoProtect::GetComment() const
//STRIP001 {
//STRIP001 	USHORT nId;
//STRIP001 	if ( nTab == TABLEID_DOC )
//STRIP001 		nId = bProtect ? STR_UNDO_PROTECT_DOC : STR_UNDO_UNPROTECT_DOC;
//STRIP001 	else
//STRIP001 		nId = bProtect ? STR_UNDO_PROTECT_TAB : STR_UNDO_UNPROTECT_TAB;
//STRIP001 	return ScGlobal::GetRscString( nId );
//STRIP001 }

// -----------------------------------------------------------------------
//
//		Druck-/Wiederholungsbereiche aendern
//

/*N*/ ScUndoPrintRange::ScUndoPrintRange( ScDocShell* pShell, USHORT nNewTab,
/*N*/ 									ScPrintRangeSaver* pOld, ScPrintRangeSaver* pNew ) :
/*N*/ 	ScSimpleUndo( pShell ),
/*N*/ 	nTab( nNewTab ),
/*N*/ 	pOldRanges( pOld ),
/*N*/ 	pNewRanges( pNew )
/*N*/ {
/*N*/ }

/*N*/ __EXPORT ScUndoPrintRange::~ScUndoPrintRange()
/*N*/ {
/*N*/ 	delete pOldRanges;
/*N*/ 	delete pNewRanges;
/*N*/ }

//STRIP001 void ScUndoPrintRange::DoChange(BOOL bUndo)
//STRIP001 {
//STRIP001 	ScDocument* pDoc = pDocShell->GetDocument();
//STRIP001 	if (bUndo)
//STRIP001 		pDoc->RestorePrintRanges( *pOldRanges );
//STRIP001 	else
//STRIP001 		pDoc->RestorePrintRanges( *pNewRanges );
//STRIP001 
//STRIP001 	ScTabViewShell* pViewShell = ScTabViewShell::GetActiveViewShell();
//STRIP001 	if (pViewShell)
//STRIP001 		pViewShell->SetTabNo( nTab );
//STRIP001 
//STRIP001 	ScPrintFunc( pDocShell, pDocShell->GetPrinter(), nTab ).UpdatePages();
//STRIP001 
//STRIP001 	pDocShell->PostPaint( ScRange(0,0,nTab,MAXCOL,MAXROW,nTab), PAINT_GRID );
//STRIP001 }

//STRIP001 void __EXPORT ScUndoPrintRange::Undo()
//STRIP001 {
//STRIP001 	BeginUndo();
//STRIP001 	DoChange( TRUE );
//STRIP001 	EndUndo();
//STRIP001 }

//STRIP001 void __EXPORT ScUndoPrintRange::Redo()
//STRIP001 {
//STRIP001 	BeginRedo();
//STRIP001 	DoChange( FALSE );
//STRIP001 	EndRedo();
//STRIP001 }

//STRIP001 void __EXPORT ScUndoPrintRange::Repeat(SfxRepeatTarget& rTarget)
//STRIP001 {
//STRIP001 	//	gippsnich
//STRIP001 }

//STRIP001 BOOL __EXPORT ScUndoPrintRange::CanRepeat(SfxRepeatTarget& rTarget) const
//STRIP001 {
//STRIP001 	return FALSE;		// gippsnich
//STRIP001 }

//STRIP001 String __EXPORT ScUndoPrintRange::GetComment() const
//STRIP001 {
//STRIP001 	return ScGlobal::GetRscString( STR_UNDO_PRINTRANGES );
//STRIP001 }


//------------------------------------------------------------------------

//---------------------------------------------------------------------------------
//
//		Szenario-Flags
//

//STRIP001 ScUndoScenarioFlags::ScUndoScenarioFlags( ScDocShell* pNewDocShell, USHORT nT,
//STRIP001 					const String& rON, const String& rNN, const String& rOC, const String& rNC,
//STRIP001 					const Color& rOCol, const Color& rNCol, USHORT nOF, USHORT nNF ) :
//STRIP001 	ScSimpleUndo( pNewDocShell ),
//STRIP001 	nTab		( nT ),
//STRIP001 	aOldName	( rON ),
//STRIP001 	aNewName	( rNN ),
//STRIP001 	aOldComment	( rOC ),
//STRIP001 	aNewComment	( rNC ),
//STRIP001 	aOldColor	( rOCol ),
//STRIP001 	aNewColor	( rNCol ),
//STRIP001 	nOldFlags	( nOF ),
//STRIP001 	nNewFlags	( nNF )
//STRIP001 {
//STRIP001 }

//STRIP001 __EXPORT ScUndoScenarioFlags::~ScUndoScenarioFlags()
//STRIP001 {
//STRIP001 }

//STRIP001 String __EXPORT ScUndoScenarioFlags::GetComment() const
//STRIP001 {
//STRIP001 	return ScGlobal::GetRscString( STR_UNDO_EDITSCENARIO );
//STRIP001 }

//STRIP001 void __EXPORT ScUndoScenarioFlags::Undo()
//STRIP001 {
//STRIP001 	ScDocument* pDoc = pDocShell->GetDocument();
//STRIP001 
//STRIP001 	pDoc->RenameTab( nTab, aOldName );
//STRIP001 	pDoc->SetScenarioData( nTab, aOldComment, aOldColor, nOldFlags );
//STRIP001 
//STRIP001 	pDocShell->PostPaintGridAll();
//STRIP001 	//	Der Tabellenname koennte in einer Formel vorkommen...
//STRIP001 	ScTabViewShell* pViewShell = ScTabViewShell::GetActiveViewShell();
//STRIP001 	if (pViewShell)
//STRIP001 		pViewShell->UpdateInputHandler();
//STRIP001 
//STRIP001 	if ( aOldName != aNewName )
//STRIP001 		SFX_APP()->Broadcast( SfxSimpleHint( SC_HINT_TABLES_CHANGED ) );
//STRIP001 }

//STRIP001 void __EXPORT ScUndoScenarioFlags::Redo()
//STRIP001 {
//STRIP001 	ScDocument* pDoc = pDocShell->GetDocument();
//STRIP001 
//STRIP001 	pDoc->RenameTab( nTab, aNewName );
//STRIP001 	pDoc->SetScenarioData( nTab, aNewComment, aNewColor, nNewFlags );
//STRIP001 
//STRIP001 	pDocShell->PostPaintGridAll();
//STRIP001 	//	Der Tabellenname koennte in einer Formel vorkommen...
//STRIP001 	ScTabViewShell* pViewShell = ScTabViewShell::GetActiveViewShell();
//STRIP001 	if (pViewShell)
//STRIP001 		pViewShell->UpdateInputHandler();
//STRIP001 
//STRIP001 	if ( aOldName != aNewName )
//STRIP001 		SFX_APP()->Broadcast( SfxSimpleHint( SC_HINT_TABLES_CHANGED ) );
//STRIP001 }

//STRIP001 void __EXPORT ScUndoScenarioFlags::Repeat(SfxRepeatTarget& rTarget)
//STRIP001 {
//STRIP001 	//	Repeat macht keinen Sinn
//STRIP001 }

//STRIP001 BOOL __EXPORT ScUndoScenarioFlags::CanRepeat(SfxRepeatTarget& rTarget) const
//STRIP001 {
//STRIP001 	return FALSE;
//STRIP001 }


//---------------------------------------------------------------------------------
//
//		rename object
//		(move to different file?)
//

//STRIP001 ScUndoRenameObject::ScUndoRenameObject( ScDocShell* pNewDocShell, const String& rPN,
//STRIP001 										const String& rON, const String& rNN ) :
//STRIP001 	ScSimpleUndo( pNewDocShell ),
//STRIP001 	aPersistName( rPN ),
//STRIP001 	aOldName	( rON ),
//STRIP001 	aNewName	( rNN )
//STRIP001 {
//STRIP001 }

//STRIP001 ScUndoRenameObject::~ScUndoRenameObject()
//STRIP001 {
//STRIP001 }

//STRIP001 String ScUndoRenameObject::GetComment() const
//STRIP001 {
//STRIP001 	//	string resource shared with title for dialog
//STRIP001 	return String( ScResId(SCSTR_RENAMEOBJECT) );
//STRIP001 }

//STRIP001 SdrObject* ScUndoRenameObject::GetObject()
//STRIP001 {
//STRIP001 	ScDocument* pDoc = pDocShell->GetDocument();
//STRIP001 	ScDrawLayer* pDrawLayer = pDoc->GetDrawLayer();
//STRIP001 	if ( pDrawLayer )
//STRIP001 	{
//STRIP001 		USHORT nCount = pDrawLayer->GetPageCount();
//STRIP001 		for (USHORT nTab=0; nTab<nCount; nTab++)
//STRIP001 		{
//STRIP001 			SdrPage* pPage = pDrawLayer->GetPage(nTab);
//STRIP001 			DBG_ASSERT(pPage,"Page ?");
//STRIP001 
//STRIP001 			SdrObjListIter aIter( *pPage, IM_DEEPNOGROUPS );
//STRIP001 			SdrObject* pObject = aIter.Next();
//STRIP001 			while (pObject)
//STRIP001 			{
//STRIP001 				if ( pObject->GetObjIdentifier() == OBJ_OLE2 &&
//STRIP001 						((SdrOle2Obj*)pObject)->GetPersistName() == aPersistName )
//STRIP001 				{
//STRIP001 					return pObject;
//STRIP001 				}
//STRIP001 
//STRIP001 				pObject = aIter.Next();
//STRIP001 			}
//STRIP001 		}
//STRIP001 	}
//STRIP001 	DBG_ERROR("Object not found");
//STRIP001 	return NULL;
//STRIP001 }

//STRIP001 void ScUndoRenameObject::Undo()
//STRIP001 {
//STRIP001 	BeginUndo();
//STRIP001 	SdrObject* pObj = GetObject();
//STRIP001 	if ( pObj )
//STRIP001 		pObj->SetName( aOldName );
//STRIP001 	EndUndo();
//STRIP001 }

//STRIP001 void ScUndoRenameObject::Redo()
//STRIP001 {
//STRIP001 	BeginRedo();
//STRIP001 	SdrObject* pObj = GetObject();
//STRIP001 	if ( pObj )
//STRIP001 		pObj->SetName( aNewName );
//STRIP001 	EndRedo();
//STRIP001 }

//STRIP001 void ScUndoRenameObject::Repeat(SfxRepeatTarget& rTarget)
//STRIP001 {
//STRIP001 }

//STRIP001 BOOL ScUndoRenameObject::CanRepeat(SfxRepeatTarget& rTarget) const
//STRIP001 {
//STRIP001 	return FALSE;
//STRIP001 }





}
